/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.jakarta.data.jdql.injector;

import com.intellij.javaee.jakarta.data.repository.JakartaDataRepositoryUtil;
import com.intellij.jpa.ql.frameworks.domain.FrameworksDataDomainClassQLAttribute;
import com.intellij.jpa.ql.frameworks.domain.FrameworksDataDomainClassQLEntity;
import com.intellij.jpa.ql.model.QlAttribute;
import com.intellij.jpa.ql.model.QlEntity;
import com.intellij.jpa.ql.model.QlExternalContextEntityProvider;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.persistence.model.PersistentObject;
import com.intellij.persistence.model.helpers.PersistentObjectModelHelper;
import com.intellij.persistence.roles.PersistenceClassRole;
import com.intellij.persistence.roles.PersistenceClassRoleEnum;
import com.intellij.persistence.util.PersistenceCommonUtil;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiUtil;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UastUtils;

public class JakartaDataQueryAnnotationExternalContextEntityProvider
implements QlExternalContextEntityProvider {
    @Nullable
    public QlEntity getEntity(UElement uElement) {
        UAnnotation uAnnotation = (UAnnotation)UastUtils.getParentOfType((UElement)uElement, UAnnotation.class);
        if (uAnnotation != null && "jakarta.data.repository.Query".equals(uAnnotation.getQualifiedName())) {
            Pair<PsiClass, ? extends PsiType> repositoryTypes;
            PsiClass entityClass;
            UMethod uMethod = (UMethod)UastUtils.getParentOfType((UElement)uElement, UMethod.class);
            if (uMethod != null && (entityClass = JakartaDataQueryAnnotationExternalContextEntityProvider.getEntityClassByMethodReturnType(uMethod.getReturnType())) != null) {
                return JakartaDataQueryAnnotationExternalContextEntityProvider.getQlEntity(entityClass);
            }
            UClass uClass = (UClass)UastUtils.getParentOfType((UElement)uElement, UClass.class);
            if (uClass != null && (repositoryTypes = JakartaDataRepositoryUtil.substituteRepositoryTypes(uClass.getJavaPsi())) != null) {
                return JakartaDataQueryAnnotationExternalContextEntityProvider.getQlEntity((PsiClass)repositoryTypes.first);
            }
        }
        return null;
    }

    @Nullable
    private static PsiClass getEntityClassByMethodReturnType(@Nullable PsiType returnType) {
        PsiType componentType;
        if (returnType == null) {
            return null;
        }
        PsiClass psiClass = JakartaDataQueryAnnotationExternalContextEntityProvider.substituteFirstParameter(returnType, "java.util.Collection", "java.util.stream.Stream", "java.util.Optional");
        if (psiClass != null) {
            return psiClass;
        }
        if (returnType instanceof PsiArrayType && (componentType = ((PsiArrayType)returnType).getComponentType()) instanceof PsiClassType) {
            return ((PsiClassType)componentType).resolve();
        }
        if (returnType instanceof PsiClassType) {
            return ((PsiClassType)returnType).resolve();
        }
        return null;
    }

    private static PsiClass substituteFirstParameter(@Nullable PsiType type, String ... classes) {
        for (String aClass : classes) {
            PsiType psiType = PsiUtil.substituteTypeParameter((PsiType)type, (String)aClass, (int)0, (boolean)false);
            if (!(psiType instanceof PsiClassType)) continue;
            return ((PsiClassType)psiType).resolve();
        }
        return null;
    }

    @Nullable
    public static FrameworksDataDomainClassQLEntity getQlEntity(@Nullable PsiClass entityClass) {
        if (entityClass == null) {
            return null;
        }
        String qualifiedName = entityClass.getQualifiedName();
        if (qualifiedName == null || StringUtil.getPackageName((String)qualifiedName).equals("java.lang")) {
            return null;
        }
        return new FrameworksDataDomainClassQLEntity(entityClass){

            public List<QlAttribute> getAttributes() {
                PersistentObject entity = JakartaDataQueryAnnotationExternalContextEntityProvider.getPersistenceObject(this.getPsiElement());
                if (entity != null) {
                    PersistentObjectModelHelper helper = entity.getObjectModelHelper();
                    return helper.getAttributes().stream().map(attribute -> {
                        String value = attribute.getName().getStringValue();
                        PsiMember member = attribute.getPsiMember();
                        if (value == null || member == null) {
                            return null;
                        }
                        return new FrameworksDataDomainClassQLAttribute(value, member);
                    }).filter(Objects::nonNull).collect(Collectors.toList());
                }
                return super.getAttributes();
            }
        };
    }

    public static PersistentObject getPersistenceObject(@NotNull PsiClass entityClass) {
        if (entityClass == null) {
            JakartaDataQueryAnnotationExternalContextEntityProvider.$$$reportNull$$$0(0);
        }
        for (PersistenceClassRole role : PersistenceCommonUtil.getPersistenceRoles((PsiClass)entityClass)) {
            if (role.getType() != PersistenceClassRoleEnum.ENTITY && role.getType() != PersistenceClassRoleEnum.EMBEDDABLE) continue;
            return role.getPersistentObject();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entityClass", "com/intellij/javaee/jakarta/data/jdql/injector/JakartaDataQueryAnnotationExternalContextEntityProvider", "getPersistenceObject"));
    }
}

