/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.jakarta.data.repository;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.jam.JamService;
import com.intellij.jam.reflect.JamMemberMeta;
import com.intellij.java.library.JavaLibraryUtil;
import com.intellij.javaee.jakarta.data.repository.JakartaDataParserContext;
import com.intellij.javaee.jakarta.data.repository.jam.JakartaDataRepository;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JakartaDataRepositoryUtil {
    public static boolean hasJakartaDataRepository(Project project) {
        return JavaLibraryUtil.hasLibraryClass((Project)project, (String)"jakarta.data.repository.DataRepository");
    }

    public static boolean hasJakartaDataRepository(Module module) {
        return JavaLibraryUtil.hasLibraryClass((Module)module, (String)"jakarta.data.repository.DataRepository");
    }

    public static List<JakartaDataRepository> getJakartaDataRepositories(@NotNull Module module) {
        if (module == null) {
            JakartaDataRepositoryUtil.$$$reportNull$$$0(0);
        }
        return JamService.getJamService((Project)module.getProject()).getJamClassElements(JakartaDataRepository.META, "jakarta.data.repository.Repository", GlobalSearchScope.moduleRuntimeScope((Module)module, (boolean)true));
    }

    public static boolean isQueryMethod(@NotNull PsiMethod psiMethod) {
        if (psiMethod == null) {
            JakartaDataRepositoryUtil.$$$reportNull$$$0(1);
        }
        return JakartaDataParserContext.create().prefixTemplates()[0].matcher(psiMethod.getName()).find() && !JakartaDataRepositoryUtil.isDefaultMethod(psiMethod);
    }

    public static boolean isDefaultMethod(@NotNull PsiMethod psiMethod) {
        if (psiMethod == null) {
            JakartaDataRepositoryUtil.$$$reportNull$$$0(2);
        }
        return psiMethod.getModifierList().hasModifierProperty("default");
    }

    public static boolean isRepository(@Nullable PsiClass psiClass) {
        return psiClass != null && (InheritanceUtil.isInheritor((PsiClass)psiClass, (String)"jakarta.data.repository.DataRepository") || JakartaDataRepositoryUtil.getJakartaDataRepository(psiClass) != null);
    }

    @Nullable
    public static JakartaDataRepository getJakartaDataRepository(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            JakartaDataRepositoryUtil.$$$reportNull$$$0(3);
        }
        return (JakartaDataRepository)JamService.getJamService((Project)psiClass.getProject()).getJamElement((PsiElement)psiClass, new JamMemberMeta[]{JakartaDataRepository.META});
    }

    @Nullable
    public static Pair<PsiClass, ? extends PsiType> substituteRepositoryTypes(@NotNull PsiClass repositoryClass) {
        Project project;
        PsiClassType psiClassType;
        PsiType psiType;
        if (repositoryClass == null) {
            JakartaDataRepositoryUtil.$$$reportNull$$$0(4);
        }
        if ((psiType = PsiUtil.substituteTypeParameter((PsiType)(psiClassType = JavaPsiFacade.getInstance((Project)(project = repositoryClass.getProject())).getElementFactory().createType(repositoryClass)), (String)"jakarta.data.repository.DataRepository", (int)0, (boolean)false)) instanceof PsiClassType) {
            PsiType idPsiType = PsiUtil.substituteTypeParameter((PsiType)psiClassType, (String)"jakarta.data.repository.DataRepository", (int)1, (boolean)false);
            PsiClass psiClass = ((PsiClassType)psiType).resolve();
            return psiClass == null || idPsiType == null ? null : Pair.create((Object)psiClass, (Object)idPsiType);
        }
        return null;
    }

    public static boolean hasQueryAnnotation(@NotNull PsiMethod psiMethod) {
        if (psiMethod == null) {
            JakartaDataRepositoryUtil.$$$reportNull$$$0(5);
        }
        return AnnotationUtil.isAnnotated((PsiModifierListOwner)psiMethod, (String)"jakarta.data.repository.Query", (int)0);
    }

    @NotNull
    public static List<PsiMethod> getRepositoryMethods(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            JakartaDataRepositoryUtil.$$$reportNull$$$0(6);
        }
        List list = ContainerUtil.filter((Object[])psiClass.getMethods(), method -> JakartaDataRepositoryUtil.isQueryMethod(method));
        if (list == null) {
            JakartaDataRepositoryUtil.$$$reportNull$$$0(7);
        }
        return list;
    }

    public static Set<String> getProperties(@NotNull PsiClass domainClass) {
        String qualifiedName;
        if (domainClass == null) {
            JakartaDataRepositoryUtil.$$$reportNull$$$0(8);
        }
        if ((qualifiedName = domainClass.getQualifiedName()) == null || qualifiedName.startsWith("java.lang")) {
            return Collections.emptySet();
        }
        HashSet<String> all = new HashSet<String>();
        for (PsiField field : domainClass.getAllFields()) {
            all.add(field.getName());
        }
        return all;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiMethod";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositoryClass";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javaee/jakarta/data/repository/JakartaDataRepositoryUtil";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "domainClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javaee/jakarta/data/repository/JakartaDataRepositoryUtil";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getRepositoryMethods";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getJakartaDataRepositories";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isQueryMethod";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isDefaultMethod";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getJakartaDataRepository";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "substituteRepositoryTypes";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "hasQueryAnnotation";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getRepositoryMethods";
                break;
            }
            case 7: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getProperties";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7 -> new IllegalStateException(string);
        };
    }
}

