/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.jakarta.data.repository.inspections;

import com.intellij.codeInspection.AbstractBaseUastLocalInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.jam.JamStringAttributeElement;
import com.intellij.javaee.jakarta.data.JakartaDataBundle;
import com.intellij.javaee.jakarta.data.repository.JakartaDataRepositoryUtil;
import com.intellij.jpa.ql.model.QlAttribute;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UMethod;

public abstract class JakartaDataRepositoryInspection
extends AbstractBaseUastLocalInspectionTool {
    protected JakartaDataRepositoryInspection() {
        super(new Class[]{UClass.class});
    }

    @NotNull
    public final PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Module module;
        if (holder == null) {
            JakartaDataRepositoryInspection.$$$reportNull$$$0(0);
        }
        if ((module = ModuleUtilCore.findModuleForFile((PsiFile)holder.getFile())) == null || !JakartaDataRepositoryUtil.hasJakartaDataRepository(module)) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                JakartaDataRepositoryInspection.$$$reportNull$$$0(1);
            }
            return psiElementVisitor;
        }
        PsiElementVisitor psiElementVisitor = super.buildVisitor(holder, isOnTheFly);
        if (psiElementVisitor == null) {
            JakartaDataRepositoryInspection.$$$reportNull$$$0(2);
        }
        return psiElementVisitor;
    }

    public ProblemDescriptor @Nullable [] checkClass(@NotNull UClass aClass, @NotNull InspectionManager manager, boolean isOnTheFly) {
        PsiElement sourcePsi;
        if (aClass == null) {
            JakartaDataRepositoryInspection.$$$reportNull$$$0(3);
        }
        if (manager == null) {
            JakartaDataRepositoryInspection.$$$reportNull$$$0(4);
        }
        if ((sourcePsi = aClass.getSourcePsi()) == null) {
            return null;
        }
        if (!JakartaDataRepositoryUtil.isRepository(aClass.getJavaPsi())) {
            return null;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)sourcePsi);
        if (module == null) {
            return null;
        }
        ProblemsHolder holder = new ProblemsHolder(manager, sourcePsi.getContainingFile(), isOnTheFly);
        Pair<PsiClass, ? extends PsiType> typePair = JakartaDataRepositoryUtil.substituteRepositoryTypes(aClass.getJavaPsi());
        if (typePair != null) {
            for (UMethod psiMethod : aClass.getMethods()) {
                this.checkRepositoryMethod(holder, aClass, psiMethod, module, typePair);
            }
        }
        return holder.getResultsArray();
    }

    protected void checkRepositoryMethod(@NotNull ProblemsHolder holder, UClass repositoryClass, @NotNull UMethod psiMethod, @NotNull Module module, @NotNull Pair<PsiClass, ? extends PsiType> typePair) {
        if (holder == null) {
            JakartaDataRepositoryInspection.$$$reportNull$$$0(5);
        }
        if (psiMethod == null) {
            JakartaDataRepositoryInspection.$$$reportNull$$$0(6);
        }
        if (module == null) {
            JakartaDataRepositoryInspection.$$$reportNull$$$0(7);
        }
        if (typePair == null) {
            JakartaDataRepositoryInspection.$$$reportNull$$$0(8);
        }
    }

    protected static void checkQlAttributeResolve(@NotNull ProblemsHolder holder, JamStringAttributeElement<QlAttribute> attr) {
        QlAttribute value;
        if (holder == null) {
            JakartaDataRepositoryInspection.$$$reportNull$$$0(9);
        }
        if ((value = (QlAttribute)attr.getValue()) == null) {
            JakartaDataRepositoryInspection.registerBadResolve(holder, attr);
        }
    }

    protected static void registerBadResolve(@NotNull ProblemsHolder holder, JamStringAttributeElement<QlAttribute> attr) {
        PsiAnnotationMemberValue memberValue;
        if (holder == null) {
            JakartaDataRepositoryInspection.$$$reportNull$$$0(10);
        }
        if ((memberValue = attr.getPsiElement()) != null) {
            holder.registerProblem((PsiElement)memberValue, JakartaDataBundle.message("entity.attribute.not.found.error.message", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javaee/jakarta/data/repository/inspections/JakartaDataRepositoryInspection";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiMethod";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typePair";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javaee/jakarta/data/repository/inspections/JakartaDataRepositoryInspection";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "checkClass";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "checkRepositoryMethod";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "checkQlAttributeResolve";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "registerBadResolve";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }
}

