/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger;

import com.intellij.javascript.nodejs.library.node_modules.NodeModulesDirectoryManager;
import com.intellij.lang.javascript.JSMinifiedFileUtil;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.SimilarityIndex;
import com.intellij.openapi.util.text.SimilarityIndexKt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.PathUtil;
import com.intellij.util.PathUtilRt;
import com.intellij.util.Url;
import com.intellij.xml.util.HtmlUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000F\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\u001a\"\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r\u001a\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\u000fH\u0002\u001a*\u0010\u0010\u001a\u0004\u0018\u00010\u00072\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00070\u00122\u0006\u0010\u0013\u001a\u00020\u000f2\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u001a\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0007\u001a\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u0007H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0018\u0010\u0002\u001a\n \u0004*\u0004\u0018\u00010\u00030\u0003X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0005\u00a8\u0006\u0019"}, d2={"RENAME_SCORE", "", "MODULE_NAME_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "Ljava/util/regex/Pattern;", "resolveFileBySourceUrl", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "url", "Lcom/intellij/util/Url;", "sourceContent", "", "cutOffWebpackFooter", "", "selectMostSimilarFile", "files", "", "source", "isVueFile", "", "file", "getScriptTagContent", "", "intellij.javascript.debugger"})
@SourceDebugExtension(value={"SMAP\nfileResolverByContent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 fileResolverByContent.kt\ncom/intellij/javascript/debugger/FileResolverByContentKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 SimilarityIndex.kt\ncom/intellij/openapi/util/text/SimilarityIndexKt\n*L\n1#1,160:1\n1611#2,9:161\n1863#2:170\n1864#2:172\n1620#2:173\n774#2:180\n865#2,2:181\n1#3:171\n72#4,6:174\n*S KotlinDebug\n*F\n+ 1 fileResolverByContent.kt\ncom/intellij/javascript/debugger/FileResolverByContentKt\n*L\n42#1:161,9\n42#1:170\n42#1:172\n42#1:173\n151#1:180\n151#1:181,2\n42#1:171\n120#1:174,6\n*E\n"})
public final class FileResolverByContentKt {
    private static final int RENAME_SCORE = 60;
    private static final Pattern MODULE_NAME_PATTERN = Pattern.compile("[\\\\/]node_modules[\\\\/](.+)$");

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final VirtualFile resolveFileBySourceUrl(@NotNull Project project, @NotNull Url url, @Nullable String sourceContent) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        CharSequence charSequence = sourceContent;
        if ((charSequence == null || charSequence.length() == 0) && (Intrinsics.areEqual((Object)url.getScheme(), (Object)"http") || Intrinsics.areEqual((Object)url.getScheme(), (Object)"https"))) {
            return null;
        }
        String string = PathUtilRt.getFileName((String)url.getPath());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFileName(...)");
        String fileName = string;
        if (((CharSequence)fileName).length() > 0) {
            String pathInNodeModules;
            GlobalSearchScope globalSearchScope = ProjectScope.getAllScope((Project)project);
            Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"getAllScope(...)");
            GlobalSearchScope scope = globalSearchScope;
            Collection files2 = CollectionsKt.emptyList();
            Matcher matcher = MODULE_NAME_PATTERN.matcher(url.getPath());
            if (matcher.find() && matcher.groupCount() >= 1 && (pathInNodeModules = matcher.group(1)) != null) {
                void $this$mapNotNullTo$iv$iv;
                List list = NodeModulesDirectoryManager.getInstance((Project)project).getNodeModulesDirs();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getNodeModulesDirs(...)");
                Iterable $this$mapNotNull$iv = list;
                boolean $i$f$mapNotNull = false;
                Iterable iterable = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    VirtualFile it$iv$iv;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl = false;
                    VirtualFile it = (VirtualFile)element$iv$iv;
                    boolean bl2 = false;
                    if (it.findFileByRelativePath(pathInNodeModules) == null) continue;
                    boolean bl3 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                files2 = (List)destination$iv$iv;
            }
            if (files2.isEmpty()) {
                files2 = (Collection)ReadAction.nonBlocking(() -> FileResolverByContentKt.resolveFileBySourceUrl$lambda$1(fileName, scope)).inSmartMode(project).executeSynchronously();
            }
            if (files2.isEmpty() && PathUtil.getFileExtension((String)fileName) == null) {
                files2 = (Collection)ReadAction.nonBlocking(() -> FileResolverByContentKt.resolveFileBySourceUrl$lambda$2(fileName, scope)).inSmartMode(project).executeSynchronously();
            }
            if (!files2.isEmpty()) {
                CharSequence charSequence2 = sourceContent;
                if (!(charSequence2 == null || charSequence2.length() == 0)) {
                    charSequence2 = FileResolverByContentKt.selectMostSimilarFile(files2, sourceContent, project);
                    if (charSequence2 != null) {
                        CharSequence it = charSequence2;
                        boolean bl = false;
                        return it;
                    }
                } else if (files2.size() == 1) {
                    return (VirtualFile)CollectionsKt.first((Iterable)files2);
                }
            }
        }
        return null;
    }

    private static final CharSequence cutOffWebpackFooter(CharSequence sourceContent) {
        int footerIndex = StringsKt.indexOf$default((CharSequence)sourceContent, (String)"WEBPACK FOOTER", (int)Math.max(0, sourceContent.length() - 300), (boolean)false, (int)4, null);
        if (footerIndex >= 0) {
            int lastNonSpaceIndex = -1;
            for (int i = footerIndex - 1; i > 0; --i) {
                char c = sourceContent.charAt(i);
                if (c == '/' || c == '*') {
                    lastNonSpaceIndex = i;
                    continue;
                }
                if (!CharsKt.isWhitespace((char)c)) break;
            }
            if (lastNonSpaceIndex > 0) {
                return sourceContent.subSequence(0, lastNonSpaceIndex);
            }
        }
        return sourceContent;
    }

    @Nullable
    public static final VirtualFile selectMostSimilarFile(@NotNull Collection<? extends VirtualFile> files2, @NotNull CharSequence source, @Nullable Project project) {
        Intrinsics.checkNotNullParameter(files2, (String)"files");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        String string = ((Object)FileResolverByContentKt.cutOffWebpackFooter(source)).toString();
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        byte[] sourceBytes = byArray;
        Ref.ObjectRef sourceIndex = new Ref.ObjectRef();
        Ref.ObjectRef matchedFile = new Ref.ObjectRef();
        Ref.IntRef lastMatchedScore = new Ref.IntRef();
        lastMatchedScore.element = 60;
        for (VirtualFile virtualFile : files2) {
            if (virtualFile.isDirectory()) continue;
            if (project != null && FileResolverByContentKt.isVueFile(virtualFile)) {
                FileResolverByContentKt.selectMostSimilarFile$compare(sourceBytes, project, lastMatchedScore, (Ref.ObjectRef<VirtualFile>)matchedFile, virtualFile, (Ref.ObjectRef<SimilarityIndex>)sourceIndex, FileResolverByContentKt.getScriptTagContent(project, virtualFile));
            }
            byte[] byArray2 = virtualFile.contentsToByteArray();
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"contentsToByteArray(...)");
            FileResolverByContentKt.selectMostSimilarFile$compare(sourceBytes, project, lastMatchedScore, (Ref.ObjectRef<VirtualFile>)matchedFile, virtualFile, (Ref.ObjectRef<SimilarityIndex>)sourceIndex, byArray2);
        }
        return (VirtualFile)matchedFile.element;
    }

    public static /* synthetic */ VirtualFile selectMostSimilarFile$default(Collection collection, CharSequence charSequence, Project project, int n, Object object) {
        if ((n & 4) != 0) {
            project = null;
        }
        return FileResolverByContentKt.selectMostSimilarFile(collection, charSequence, project);
    }

    public static final boolean isVueFile(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return Intrinsics.areEqual((Object)file.getFileType().getDefaultExtension(), (Object)"vue");
    }

    private static final byte[] getScriptTagContent(Project project, VirtualFile file) {
        Object object = ReadAction.nonBlocking(() -> FileResolverByContentKt.getScriptTagContent$lambda$7(project, file)).inSmartMode(project).executeSynchronously();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"executeSynchronously(...)");
        return (byte[])object;
    }

    private static final Collection resolveFileBySourceUrl$lambda$1(String $fileName, GlobalSearchScope $scope) {
        return FilenameIndex.getVirtualFilesByName((String)$fileName, (GlobalSearchScope)$scope);
    }

    private static final Collection resolveFileBySourceUrl$lambda$2(String $fileName, GlobalSearchScope $scope) {
        return FilenameIndex.getVirtualFilesByName((String)($fileName + ".js"), (GlobalSearchScope)$scope);
    }

    private static final Boolean selectMostSimilarFile$compare$lambda$4(VirtualFile $file, Project $project) {
        return JSMinifiedFileUtil.isFileMinified((VirtualFile)$file, (Project)$project);
    }

    private static final void selectMostSimilarFile$compare(byte[] sourceBytes, Project $project, Ref.IntRef lastMatchedScore, Ref.ObjectRef<VirtualFile> matchedFile, VirtualFile file, Ref.ObjectRef<SimilarityIndex> sourceIndex, byte[] fileScriptContent) {
        int n;
        int max = Math.max(sourceBytes.length, fileScriptContent.length);
        int min = Math.min(sourceBytes.length, fileScriptContent.length);
        if (min * 100 / max < 60) {
            return;
        }
        if ($project != null && ((Boolean)ReadAction.nonBlocking(() -> FileResolverByContentKt.selectMostSimilarFile$compare$lambda$4(file, $project)).inSmartMode($project).executeSynchronously()).booleanValue()) {
            return;
        }
        int maxScore$iv = 10000;
        boolean $i$f$similarityScore = false;
        if (Arrays.equals(sourceBytes, fileScriptContent)) {
            n = maxScore$iv;
        } else {
            boolean bl = false;
            if (sourceIndex.element == null) {
                sourceIndex.element = SimilarityIndexKt.SimilarityIndex(sourceBytes);
            }
            Object object = sourceIndex.element;
            Intrinsics.checkNotNull((Object)object);
            n = SimilarityIndex.score$default((SimilarityIndex)object, SimilarityIndexKt.SimilarityIndex(fileScriptContent), 0, 2, null);
        }
        int contentScore = n;
        int score = (contentScore * 99 + 100) / 10000;
        if (score > lastMatchedScore.element) {
            matchedFile.element = file;
            lastMatchedScore.element = score;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final byte[] getScriptTagContent$lambda$7(Project $project, VirtualFile $file) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        PsiFile psiFile = PsiManager.getInstance((Project)$project).findFile($file);
        if (!(psiFile instanceof XmlFile)) {
            return $file.contentsToByteArray();
        }
        Collection collection = PsiTreeUtil.findChildrenOfType((PsiElement)((PsiElement)psiFile), XmlTag.class);
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"findChildrenOfType(...)");
        Object object = collection;
        boolean $i$f$filter = false;
        void var6_5 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            XmlTag it = (XmlTag)element$iv$iv;
            boolean bl = false;
            if (!HtmlUtil.isScriptTag((XmlTag)it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List scriptTag = (List)destination$iv$iv;
        if (scriptTag.size() != 1) {
            return $file.contentsToByteArray();
        }
        String string = ((XmlTag)scriptTag.get(0)).getValue().getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        object = string;
        byte[] byArray = ((String)object).getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        return byArray;
    }
}

