/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.scripts;

import com.google.common.base.CharMatcher;
import com.google.common.base.Splitter;
import com.intellij.icons.AllIcons;
import com.intellij.javascript.debugger.scripts.FileInfo;
import com.intellij.javascript.debugger.scripts.ScriptDirectoryInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PlatformIcons;
import com.intellij.util.SmartList;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.intellij.util.containers.ContainerUtil;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.Script;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000@\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\u001a\u001a\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002\u001a*\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0000\u001a\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\t\u001a\u00020\nH\u0002\"\u0018\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0003\"\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"PATH_SPLITTER", "Lcom/google/common/base/Splitter;", "kotlin.jvm.PlatformType", "Lcom/google/common/base/Splitter;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "removeEntry", "", "url", "Lcom/intellij/util/Url;", "directoryInfo", "Lcom/intellij/javascript/debugger/scripts/ScriptDirectoryInfo;", "addEntry", "script", "Lorg/jetbrains/debugger/Script;", "parentInfo", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "splitUrl", "", "", "intellij.javascript.debugger"})
public final class ScriptDirectoryInfoKt {
    private static final Splitter PATH_SPLITTER = Splitter.on((CharMatcher)CharMatcher.anyOf((CharSequence)"/\\")).omitEmptyStrings();
    @NotNull
    private static final Logger LOG;

    private static final void removeEntry(Url url, ScriptDirectoryInfo directoryInfo) {
        ScriptDirectoryInfo child = directoryInfo;
        List<String> path = ScriptDirectoryInfoKt.splitUrl(url);
        int childIndex = 0;
        SmartList parents = new SmartList();
        while (true) {
            String name = path.get(childIndex++);
            if (path.size() == childIndex) {
                Object object = child;
                if (object != null && (object = ((ScriptDirectoryInfo)object).getChildNameToInfo()) != null) {
                    FileInfo cfr_ignored_0 = (FileInfo)object.remove(name);
                }
                break;
            }
            Object object = child;
            FileInfo fileInfo = object != null && (object = ((ScriptDirectoryInfo)object).getChildNameToInfo()) != null ? (FileInfo)object.get(name) : null;
            ScriptDirectoryInfo scriptDirectoryInfo = child = fileInfo instanceof ScriptDirectoryInfo ? (ScriptDirectoryInfo)fileInfo : null;
            if (child == null) {
                return;
            }
            parents.add((Object)child);
        }
        for (int i = parents.size() - 1; 0 < i; --i) {
            ScriptDirectoryInfo parent = (ScriptDirectoryInfo)parents.get(i);
            if (parent.hasChildren()) continue;
            ((ScriptDirectoryInfo)parents.get(i - 1)).getChildNameToInfo().remove(parent.getName());
        }
    }

    public static final void addEntry(@NotNull Script script, @NotNull Url url, @NotNull ScriptDirectoryInfo parentInfo, @Nullable VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)script, (String)"script");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)parentInfo, (String)"parentInfo");
        ScriptDirectoryInfo parent = parentInfo;
        Icon directoryIcon = parent.getIcon() == PlatformIcons.LIBRARY_ICON || parent.getIcon() == AllIcons.Nodes.PpLibFolder ? AllIcons.Nodes.PpLibFolder : PlatformIcons.FOLDER_ICON;
        List<String> path = ScriptDirectoryInfoKt.splitUrl(url);
        if (path.isEmpty()) {
            return;
        }
        boolean prependSlash = false;
        StringBuilder urlBuilder = new StringBuilder();
        int i = 0;
        while (true) {
            ScriptDirectoryInfo child;
            FileInfo fileInfo;
            Object name = path.get(i);
            if (prependSlash) {
                urlBuilder.append('/');
            } else {
                prependSlash = true;
            }
            if (path.size() - 1 == i) {
                Object object;
                if (script.getLine() > 0 && Intrinsics.areEqual((Object)script.getUrl(), (Object)url)) {
                    name = (String)name + ":" + (script.getLine() + 1) + ":" + (script.getColumn() + 1);
                }
                if ((fileInfo = parent.getChildNameToInfo().get(name)) == null) {
                    fileInfo = new FileInfo((String)name, url, (List)new SmartList((Object)script));
                    if (file != null) {
                        fileInfo.set_icon$intellij_javascript_debugger(file.getFileType().getIcon());
                    }
                    object = parent.getChildNameToInfo().put((String)name, fileInfo);
                    break;
                }
                if (!Intrinsics.areEqual((Object)fileInfo.getUrl().trimParameters(), (Object)url.trimParameters())) {
                    LOG.error("fileInfo.url: " + fileInfo.getUrl() + ", url: " + url);
                }
                if (fileInfo instanceof ScriptDirectoryInfo) {
                    object = ((ScriptDirectoryInfo)fileInfo).getChildNameToInfo().put(((ScriptDirectoryInfo)fileInfo).getName(), new FileInfo(((ScriptDirectoryInfo)fileInfo).getName(), ((ScriptDirectoryInfo)fileInfo).getUrl(), (List)new SmartList((Object)script)));
                    break;
                }
                fileInfo.addScript$intellij_javascript_debugger(script);
                object = Unit.INSTANCE;
                break;
            }
            urlBuilder.append((String)name);
            fileInfo = parent.getChildNameToInfo().get(name);
            ScriptDirectoryInfo scriptDirectoryInfo = child = fileInfo instanceof ScriptDirectoryInfo ? (ScriptDirectoryInfo)fileInfo : null;
            if (child == null) {
                Url url2 = Urls.newFromIdea((CharSequence)urlBuilder);
                Intrinsics.checkNotNull((Object)directoryIcon);
                child = new ScriptDirectoryInfo((String)name, url2, directoryIcon);
                if (fileInfo != null) {
                    child.getChildNameToInfo().put((String)name, fileInfo);
                }
                parent.getChildNameToInfo().put((String)name, child);
            }
            parent = child;
            ++i;
        }
    }

    private static final List<String> splitUrl(Url url) {
        String string = url.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        String path = string;
        List result = null;
        if (Intrinsics.areEqual((Object)path, (Object)"/")) {
            result = new ArrayList();
            ArrayList arrayList = (ArrayList)result;
            String string2 = url.getScheme();
            Intrinsics.checkNotNull((Object)string2);
            arrayList.add(string2 + "://" + url.getAuthority());
        } else {
            Iterable strings = PATH_SPLITTER.split((CharSequence)path);
            if (url.getAuthority() == null) {
                result = ContainerUtil.newArrayList((Iterable)strings);
                if (((ArrayList)result).isEmpty()) {
                    LOG.warn("url: " + url.toExternalForm() + ", path: " + path);
                }
                if (url.getScheme() != null) {
                    ArrayList arrayList = (ArrayList)result;
                    String string3 = url.getScheme();
                    Intrinsics.checkNotNull((Object)string3);
                    arrayList.set(0, string3 + ":" + ((ArrayList)result).get(0));
                } else if (url.isInLocalFileSystem() && StringUtil.startsWithChar((CharSequence)path, (char)'/')) {
                    ((ArrayList)result).set(0, "/" + ((ArrayList)result).get(0));
                }
            } else {
                result = new ArrayList();
                ArrayList arrayList = (ArrayList)result;
                String string4 = url.getScheme();
                Intrinsics.checkNotNull((Object)string4);
                arrayList.add(string4 + "://" + url.getAuthority());
                ContainerUtil.addAll((Collection)result, (Iterable)strings);
            }
        }
        if (StringsKt.endsWith$default((CharSequence)path, (char)'/', (boolean)false, (int)2, null) && url.getParameters() == null) {
            ((ArrayList)result).add("(program)");
        }
        if (url.getParameters() != null && !StringsKt.endsWith$default((String)path, (String)".js", (boolean)false, (int)2, null) && !StringsKt.endsWith$default((String)path, (String)".dart", (boolean)false, (int)2, null)) {
            int lastIndex = ((ArrayList)result).size() - 1;
            if (lastIndex == 0 && url.getAuthority() != null) {
                ArrayList arrayList = (ArrayList)result;
                String string5 = url.getParameters();
                Intrinsics.checkNotNull((Object)string5);
                arrayList.add(string5);
            } else {
                ArrayList arrayList = (ArrayList)result;
                Object e = ((ArrayList)result).get(lastIndex);
                String string6 = url.getParameters();
                Intrinsics.checkNotNull((Object)string6);
                CallSite callSite = arrayList.set(lastIndex, e + string6);
                Intrinsics.checkNotNull((Object)callSite);
            }
        }
        return result;
    }

    public static final /* synthetic */ void access$removeEntry(Url url, ScriptDirectoryInfo directoryInfo) {
        ScriptDirectoryInfoKt.removeEntry(url, directoryInfo);
    }

    static {
        Logger logger = Logger.getInstance(ScriptDirectoryInfo.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

