/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.jpb.model.backend.ed;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterables;
import com.intellij.jpa.jpb.model.backend.ed.indexing.EntitySearch;
import com.intellij.jpa.jpb.model.ed.AttrColumnInfo;
import com.intellij.jpa.jpb.model.model.AttributeOverride;
import com.intellij.jpa.jpb.model.model.CachedEntityAttributeModel;
import com.intellij.jpa.jpb.model.model.Datatype;
import com.intellij.jpa.jpb.model.model.DbIdentifierHelper;
import com.intellij.jpa.jpb.model.model.Entity;
import com.intellij.jpa.jpb.model.model.EntityAttribute;
import com.intellij.jpa.jpb.model.model.EntityAttributePsi;
import com.intellij.jpa.jpb.model.model.EntityPsi;
import com.intellij.jpa.jpb.model.model.EnumType;
import com.intellij.jpa.jpb.model.model.Method;
import com.intellij.jpa.jpb.model.model.SoftDeleteModel;
import com.intellij.jpa.jpb.model.model.audit.AuditEntity;
import com.intellij.jpa.jpb.model.util.EntityUtil;
import com.intellij.jpa.jpb.model.util.JpaUtils;
import com.intellij.jpa.jpb.model.util.QueryUtil;
import com.intellij.jpa.jpb.model.util.annotation.JoinTable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.util.FilteredQuery;
import com.intellij.util.Query;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class EntityDesignHelper {
    protected static final Logger log = Logger.getInstance(EntityDesignHelper.class);
    public static final Pattern PATTERN_SPECIAL_SYMBOLS = Pattern.compile("[^\\w]");
    public static final String INDEX_PREFIX = "IDX_";
    public static final String CONSTRAINT_PREFIX = "UC_";
    protected final Project project;

    public EntityDesignHelper(Project project) {
        this.project = project;
    }

    public static EntityDesignHelper getInstance(Project project) {
        return (EntityDesignHelper)project.getService(EntityDesignHelper.class);
    }

    @Nullable
    public abstract String generateEntityName(@NotNull String var1);

    public boolean entityNameNotUnique(String entityName, String className) {
        PsiClass entityByName = EntitySearch.getInstance(this.project).findByName(entityName);
        return entityByName != null && !Objects.equals(entityByName.getName(), className);
    }

    public static boolean existPersistentChild(Entity entity, Project project) {
        Collection<PsiClass> childProjectEntities = EntitySearch.getInstance(project).getChildProjectEntities(entity.getFqn(), true);
        return childProjectEntities.stream().anyMatch(childEntityClass -> {
            EntityPsi childEntity = EntityPsi.getInstance(childEntityClass);
            return !Objects.equals(entity.getFqn(), childEntity.getFqn()) && ((Entity)childEntity).isPersistentEntity() && EntityDesignHelper.getPersistentParent(childEntity) != null;
        });
    }

    public static void addEqualsAndHasCodeMethods(Entity entity) {
        Method equalsMethod = new Method();
        equalsMethod.setName("equals");
        LinkedHashSet<String> annotations = new LinkedHashSet<String>();
        annotations.add("Override");
        equalsMethod.setAnnotations(annotations);
        equalsMethod.setModifiers("public");
        equalsMethod.setSignature(new String[]{"Object"});
        equalsMethod.setParamNames(new String[]{"o"});
        entity.getMethods().add(equalsMethod);
        Method hashCodeMethod = new Method();
        hashCodeMethod.setName("hashCode");
        annotations = new LinkedHashSet();
        annotations.add("Override");
        hashCodeMethod.setAnnotations(annotations);
        hashCodeMethod.setModifiers("public");
        hashCodeMethod.setType("int");
        entity.getMethods().add(hashCodeMethod);
    }

    @Nullable
    public static Entity getParentWithStrategy(Entity entity) {
        if (entity == null) {
            return null;
        }
        Entity persistentParent = EntityDesignHelper.getPersistentParent(entity);
        while (persistentParent != null && persistentParent.getInheritanceType() == null && !persistentParent.equals(entity)) {
            persistentParent = EntityDesignHelper.getPersistentParent(persistentParent);
        }
        return persistentParent;
    }

    @Nullable
    public String generateAttributeColumnName(EntityAttribute attr) {
        return this.generateAttributeColumnName(attr.getName(), attr.getMappingType(), attr.getCardinality(), attr.getType(), attr.isOwner());
    }

    @Nullable
    public String generateAttributeColumnName(String attributeName, EntityAttribute.MappingType mappingType, EntityAttribute.Cardinality cardinality, Datatype attrType, boolean isOwner) {
        return this.generateAttributeColumnName(new AttrColumnInfo(attributeName, mappingType, cardinality, attrType, isOwner).withConverter(this.creteDefaultAttrColumnConverter()));
    }

    @NlsSafe
    @Nullable
    public abstract String generateAttributeColumnName(AttrColumnInfo var1);

    public abstract Function<String, String> creteDefaultAttrColumnConverter();

    @NlsContexts.StatusText
    @Nullable
    public String generateAttributeColumnNameWithoutUnderscore(String attributeName, EntityAttribute.MappingType mappingType, EntityAttribute.Cardinality cardinality, Datatype attrType, boolean isOwner) {
        return this.generateAttributeColumnName(new AttrColumnInfo(attributeName, mappingType, cardinality, attrType, isOwner).withConverter(String::toUpperCase));
    }

    public static boolean isPersistent(Entity entity) {
        return entity.isPersistentEntity() || entity.isEmbeddable() || entity.isMappedSuperclass();
    }

    @Nullable
    public static Datatype getIdDataType(@Nullable Entity entity) {
        if (entity == null) {
            return null;
        }
        EntityAttribute idAttr = entity.getIdAttributeOrNull();
        return idAttr == null ? null : idAttr.getType();
    }

    @Nullable
    public static EntityAttribute getAttributeByColumn(@Nullable Entity entity, String columnName, Collection<EntityAttribute> attributes) {
        Set allAttributeOverrides;
        Set<Object> set = allAttributeOverrides = entity == null ? Collections.emptySet() : entity.getAllAttributeOverrides();
        if (entity == null || allAttributeOverrides.isEmpty()) {
            return StreamEx.of(attributes).findFirst(it -> it != null && it.compareColumn(columnName)).orElse(null);
        }
        return StreamEx.of(attributes).nonNull().findFirst(it -> {
            AttributeOverride attrOverride = StreamEx.of((Collection)allAttributeOverrides).findFirst(attributeOverride -> StringUtil.isNotEmpty((String)attributeOverride.getColumn()) && Objects.equals(it.getName(), attributeOverride.getName())).orElse(null);
            if (attrOverride == null) {
                return it.compareColumn(columnName);
            }
            return DbIdentifierHelper.compareIdentifier(columnName, attrOverride.getColumn());
        }).orElse(null);
    }

    public static boolean isValidAttribute(EntityAttribute attribute) {
        Datatype attrType = attribute.getType();
        if (attrType instanceof Entity) {
            return ((Entity)attrType).isValid();
        }
        if (attrType instanceof EnumType) {
            return ((EnumType)attrType).isValid();
        }
        return true;
    }

    @Nullable
    public static Entity getPersistentParent(Entity entity) {
        if (!entity.isValid()) {
            return null;
        }
        Entity parent = entity.getParent();
        if (parent == null) {
            return null;
        }
        if (parent.isValid() && parent.isPersistentEntity()) {
            return parent;
        }
        return (Entity)RecursionManager.doPreventingRecursion((Object)entity, (boolean)false, () -> EntityDesignHelper.getPersistentParent(parent));
    }

    @Contract(pure=true)
    @NotNull
    public static Entity.InheritanceType getInheritanceType(Entity entity) {
        Entity.InheritanceType inheritanceType = entity.getInheritanceType();
        if (inheritanceType != null) {
            Entity.InheritanceType inheritanceType2 = inheritanceType;
            if (inheritanceType2 == null) {
                EntityDesignHelper.$$$reportNull$$$0(0);
            }
            return inheritanceType2;
        }
        Entity parentEntity = entity.getParent();
        if (parentEntity != null) {
            Entity.InheritanceType result = (Entity.InheritanceType)((Object)RecursionManager.doPreventingRecursion((Object)entity, (boolean)false, () -> EntityDesignHelper.getInheritanceType(parentEntity)));
            Entity.InheritanceType inheritanceType3 = result == null ? Entity.InheritanceType.SINGLE_TABLE : result;
            if (inheritanceType3 == null) {
                EntityDesignHelper.$$$reportNull$$$0(1);
            }
            return inheritanceType3;
        }
        Entity.InheritanceType inheritanceType4 = Entity.InheritanceType.SINGLE_TABLE;
        if (inheritanceType4 == null) {
            EntityDesignHelper.$$$reportNull$$$0(2);
        }
        return inheritanceType4;
    }

    @Nullable
    public abstract String generateTableName(@NotNull String var1);

    public abstract String generateInverseJoinColumnName(EntityAttribute var1, String var2);

    public String generateIndexName(Entity entity, List<String> columns, boolean isUnique) {
        return EntityUtil.calculateIndexName(INDEX_PREFIX, entity, columns, isUnique);
    }

    public String generateConstraintName(Entity entity, List<String> columns) {
        return EntityUtil.calculateIndexName(CONSTRAINT_PREFIX, entity, columns, false);
    }

    public static boolean tableNameNotUnique(Project project, String tableName, String className) {
        GlobalSearchScope globalScope = GlobalSearchScope.allScope((Project)project);
        EntitySearch entitySearch = EntitySearch.getInstance(project);
        return (Boolean)EntityUtil.ra(() -> entitySearch.getEntities(globalScope).stream().anyMatch(entityPsi -> !Objects.equals(entityPsi.getName(), className) && Objects.equals(EntityUtil.getTable(entityPsi), tableName)));
    }

    @Nullable
    public static Entity getHierarchyRoot(Entity entity) {
        if (entity == null) {
            return null;
        }
        Entity previous = entity;
        Entity parent = entity.getParent();
        if (parent == null || !parent.isValid()) {
            return previous;
        }
        ArrayList<Entity> hierarchy = new ArrayList<Entity>();
        hierarchy.add(entity);
        hierarchy.add(parent);
        while (parent != null && parent.isValid() && parent.isPersistentEntity() && !parent.equals(entity)) {
            previous = parent;
            if (hierarchy.contains(parent = parent.getParent())) {
                hierarchy.add(parent);
                throw new IllegalStateException("Cyclic inheritance: " + hierarchy);
            }
            hierarchy.add(parent);
        }
        if (parent != null && parent.isMappedSuperclass()) {
            if (!EntityDesignHelper.hasPersistentAncestor(parent)) {
                return previous;
            }
            return EntityDesignHelper.getHierarchyRoot(parent);
        }
        return previous;
    }

    private static boolean hasPersistentAncestor(Entity entity) {
        for (Entity parent = entity.getParent(); parent != null && parent.isValid(); parent = parent.getParent()) {
            if (!parent.isPersistentEntity()) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static EntityAttribute getInverseAttribute(Entity entity, Entity attributeType, String mappedBy) {
        for (EntityAttribute attribute : entity.getAttributes()) {
            Datatype currAttrType = attribute.getType();
            if (!attributeType.getFqn().equals(currAttrType.getFqn()) || !mappedBy.equals(attribute.getMappedBy())) continue;
            return attribute;
        }
        return null;
    }

    @Nullable
    public static EntityAttribute getRelatedAttr(Entity entity, EntityAttribute attr, EntityAttribute.Cardinality cardinality) {
        return EntityDesignHelper.getRelatedAttr(entity, attr, cardinality, false);
    }

    @Nullable
    public static EntityAttribute getRelatedAttr(Entity entity, EntityAttribute attr, EntityAttribute.Cardinality cardinality, boolean ignoreMappedBy) {
        Datatype datatype = attr.getType();
        if (!(datatype instanceof Entity)) {
            return null;
        }
        Entity type = (Entity)datatype;
        for (EntityAttribute relatedAttr : type.getAttributes()) {
            Datatype relatedAttrType = relatedAttr.getType();
            if (!entity.getFqn().equals(relatedAttrType.getFqn()) || relatedAttr.getCardinality() != cardinality) continue;
            if (cardinality != EntityAttribute.Cardinality.MANY_TO_MANY) {
                return relatedAttr;
            }
            boolean attrOwner = attr.isOwner();
            boolean relatedOwner = relatedAttr.isOwner();
            JoinTable attrJt = attr.getJoinTable();
            JoinTable relatedJt = relatedAttr.getJoinTable();
            if (!(relatedOwner && attrOwner && Objects.equals(relatedJt.getName(), attrJt.getName()) || (relatedOwner && !attrOwner || attrOwner && attrJt.isEmpty() && relatedOwner) && (ignoreMappedBy || Objects.equals(relatedAttr.getName(), attr.getMappedBy()))) && (relatedOwner || !attrOwner || !ignoreMappedBy && !Objects.equals(relatedAttr.getMappedBy(), attr.getName()))) continue;
            return relatedAttr;
        }
        return null;
    }

    public abstract String generateJoinTableName(String var1, String var2);

    public abstract String generateJoinColumnName(Entity var1, String var2);

    @NotNull
    public static String getTableName(@Nullable Entity entity) {
        if (entity != null) {
            if (!Strings.isNullOrEmpty((String)entity.getTable())) {
                String string = entity.getTable();
                if (string == null) {
                    EntityDesignHelper.$$$reportNull$$$0(3);
                }
                return string;
            }
            String name = (String)RecursionManager.doPreventingRecursion((Object)entity, (boolean)false, () -> EntityDesignHelper.getTableName(entity.getParent()));
            String string = name == null ? "" : name;
            if (string == null) {
                EntityDesignHelper.$$$reportNull$$$0(4);
            }
            return string;
        }
        return "";
    }

    public static boolean mustHaveDiscriminator(Entity entity, Project project) {
        if (entity instanceof AuditEntity) {
            return EntityDesignHelper.mustHaveDiscriminator(((AuditEntity)entity).getAuditedEntity(), project);
        }
        Entity root = EntityDesignHelper.getHierarchyRoot(entity);
        Entity.InheritanceType entityInheritanceType = EntityDesignHelper.getInheritanceType(entity);
        return EntityDesignHelper.mustHaveDiscriminator(entity, root, entityInheritanceType, project);
    }

    public static boolean mustHaveDiscriminator(Entity entity, Entity root, Entity.InheritanceType inheritanceType, Project project) {
        boolean isExistDiscrColumn = StringUtils.isNotBlank((CharSequence)entity.getDiscriminatorColumnName());
        return root == entity && (inheritanceType == Entity.InheritanceType.JOINED && (isExistDiscrColumn || !JpaUtils.isHibernateProject(project)) || inheritanceType == Entity.InheritanceType.SINGLE_TABLE && (isExistDiscrColumn || EntityDesignHelper.existPersistentChild(entity, project)));
    }

    private static Collection<EntityAttribute> getEmbeddedAttributes(Entity entity) {
        return Collections2.filter(entity.getAttributes(), input -> input != null && input.isEmbedded());
    }

    public Map<String, AttributeOverrideStore> fetchEmbeddedAttributes(Entity entity) {
        LinkedHashMap<String, AttributeOverrideStore> attributes = new LinkedHashMap<String, AttributeOverrideStore>();
        for (EntityAttribute attr : EntityDesignHelper.getEmbeddedAttributes(entity)) {
            attributes.putAll(this.fetchEmbeddedAttributes(attr));
        }
        return attributes;
    }

    public static List<EntityAttribute> fetchCompKeyAttributes(Entity entity) {
        ArrayList<EntityAttribute> attributes = new ArrayList<EntityAttribute>();
        for (EntityAttribute attr : entity.getAttributes()) {
            EntityAttribute.Cardinality cardinality = attr.getCardinality();
            if (!attr.isCompKeyType() || cardinality != null && cardinality.isMany() || attr.getMappedBy() != null) continue;
            attributes.addAll(EntityDesignHelper.fetchCompKeyAttributes(attr));
        }
        return attributes;
    }

    public static List<EntityAttribute> fetchCompKeyAttributes(EntityAttribute attribute) {
        LinkedHashMap<String, String> attrJoinColumns = attribute.getJoinColumns();
        if (!attribute.isCompKeyType() || attrJoinColumns.isEmpty()) {
            return Collections.emptyList();
        }
        boolean noReferenceColumnNames = ContainerUtil.and(attrJoinColumns.values(), it -> StringUtil.isEmpty((String)it));
        Entity attributeType = (Entity)attribute.getType();
        List<EntityAttribute> compKeyIdAttrs = attributeType.getCompKeyIdAttrs();
        if (compKeyIdAttrs.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<EntityAttribute> result = new ArrayList<EntityAttribute>();
        for (int i = 0; i < compKeyIdAttrs.size(); ++i) {
            String columnName;
            EntityAttribute embAttr = compKeyIdAttrs.get(i);
            String embAttrColumnName = EntityDesignHelper.getEmbeddedAttrColumnName(attributeType, embAttr);
            if (embAttrColumnName == null) continue;
            String columnNameTmp = JpaUtils.getKeyFromValue(attrJoinColumns, embAttrColumnName);
            if (columnNameTmp == null && noReferenceColumnNames) {
                columnNameTmp = (String)attrJoinColumns.keySet().stream().toList().get(i);
            }
            if (!StringUtils.isNotBlank((CharSequence)(columnName = columnNameTmp)) || ContainerUtil.exists(result, a -> columnName.equalsIgnoreCase(a.getColumn()))) continue;
            CachedEntityAttributeModel copyAttribute = new CachedEntityAttributeModel();
            copyAttribute.copyFromWithMemberReference(embAttr);
            copyAttribute.setColumn(columnName);
            copyAttribute.setMandatory(attribute.isMandatory());
            copyAttribute.setId(false);
            result.add(copyAttribute);
        }
        return result;
    }

    @Nullable
    public static String getEmbeddedAttrColumnName(Entity attributeRefType, EntityAttribute embAttr) {
        AttributeOverride attributeOverride;
        String embAttrColumnName = embAttr.getDdlManipulationColumn();
        if (embAttr.isTransient() || StringUtils.isBlank((CharSequence)embAttrColumnName)) {
            return null;
        }
        EntityAttribute typeIdAttr = attributeRefType.getIdAttributeOrNull();
        AttributeOverride attributeOverride2 = attributeOverride = typeIdAttr == null ? null : typeIdAttr.getAttributeOverride(embAttr.getName());
        if (attributeOverride != null && StringUtil.isNotEmpty((String)attributeOverride.getColumn())) {
            embAttrColumnName = attributeOverride.getColumn();
        }
        return embAttrColumnName;
    }

    public Map<String, AttributeOverrideStore> fetchEmbeddedAttributes(EntityAttribute attribute) {
        return this.resolveEmbeddedAttributes(attribute, new LinkedList<EntityAttribute>());
    }

    public static Entity getEmbeddedEntity(EntityAttribute embeddedAttribute) {
        Datatype embeddedAttributeType = embeddedAttribute.getType();
        if (!(embeddedAttribute.isEmbedded() || embeddedAttribute.getMappingType() == EntityAttribute.MappingType.ELEMENT_COLLECTION && embeddedAttributeType instanceof Entity)) {
            throw new IllegalArgumentException("Attribute is not embedded: " + embeddedAttribute.getName());
        }
        if (!(embeddedAttributeType instanceof Entity)) {
            throw new IllegalStateException("Cannot find embeddable entity, FQN: " + embeddedAttributeType.getFqn());
        }
        return (Entity)embeddedAttributeType;
    }

    @Nullable
    private static AttributeOverride getAttributeOverride(LinkedList<EntityAttribute> embeddedHirerachy, EntityAttribute attr) {
        AttributeOverride result = null;
        Object attrName = attr.getName();
        for (EntityAttribute curr : embeddedHirerachy) {
            AttributeOverride attributeOverride = curr.getAttributeOverride((String)attrName);
            if (attributeOverride != null) {
                result = attributeOverride;
            }
            attrName = curr.getName() + "." + (String)attrName;
        }
        return result;
    }

    public Map<String, AttributeOverrideStore> resolveEmbeddedAttributes(EntityAttribute attribute, LinkedList<EntityAttribute> embeddedHirerachy) {
        LinkedHashMap<String, AttributeOverrideStore> attributes = new LinkedHashMap<String, AttributeOverrideStore>();
        Entity embedded = EntityDesignHelper.getEmbeddedEntity(attribute);
        embeddedHirerachy.addFirst(attribute);
        for (EntityAttribute attrOfEmbedded : embedded.getAllAttributes()) {
            if (!attrOfEmbedded.isEmbedded()) {
                String attributeOverrideColumnName;
                if (!attrOfEmbedded.isPersistent()) continue;
                boolean isNaturalId = attribute.isNaturalId();
                AttributeOverride attributeOverride = EntityDesignHelper.getAttributeOverride(embeddedHirerachy, attrOfEmbedded);
                if (attributeOverride != null) {
                    if (StringUtil.isEmpty((String)attributeOverride.getColumn()) && StringUtil.isNotEmpty((String)(attributeOverrideColumnName = this.getAttributeOverrideColumnName(embedded, attrOfEmbedded)))) {
                        attributeOverride.setColumn(attributeOverrideColumnName);
                    }
                    if (!StringUtil.isNotEmpty((String)attributeOverride.getColumn())) continue;
                    attributes.put(attributeOverride.getColumn(), new AttributeOverrideStore(attrOfEmbedded, attributeOverride, isNaturalId));
                    continue;
                }
                attributeOverrideColumnName = this.getAttributeOverrideColumnName(embedded, attrOfEmbedded);
                if (!StringUtil.isNotEmpty((String)attributeOverrideColumnName)) continue;
                attributes.put(attributeOverrideColumnName, new AttributeOverrideStore(attrOfEmbedded, null, isNaturalId));
                continue;
            }
            if (embeddedHirerachy.contains(attrOfEmbedded)) continue;
            attributes.putAll(this.resolveEmbeddedAttributes(attrOfEmbedded, new LinkedList<EntityAttribute>(embeddedHirerachy)));
        }
        return EntityDesignHelper.processEmbeddedColumnNameByMapsId(attribute, attributes);
    }

    @Nullable
    private String getAttributeOverrideColumnName(Entity embedded, EntityAttribute attr) {
        if (!Strings.isNullOrEmpty((String)attr.getDdlManipulationColumn())) {
            return attr.getDdlManipulationColumn();
        }
        String attrColumnName = this.generateAttributeColumnName(attr);
        if (attrColumnName == null) {
            log.debug("Studio cannot resolve embedded attribute '" + attr.getName() + "' of entity '" + embedded.getClassName() + "'");
            return null;
        }
        return attrColumnName;
    }

    private static Map<String, AttributeOverrideStore> processEmbeddedColumnNameByMapsId(EntityAttribute ownerAttribute, Map<String, AttributeOverrideStore> attributes) {
        if (!ownerAttribute.isId() || !(ownerAttribute instanceof EntityAttributePsi) || !((EntityAttributePsi)ownerAttribute).isValid() || attributes.isEmpty()) {
            return attributes;
        }
        EntityPsi ownerEntity = ((EntityAttributePsi)ownerAttribute).getEntity();
        List mapsIdAttrs = ((StreamEx)StreamEx.of(ownerEntity.getAttributes()).filter(attr -> StringUtil.isNotEmpty((String)attr.getMapsIdValue()))).toList();
        if (mapsIdAttrs.isEmpty()) {
            return attributes;
        }
        LinkedHashMap<String, AttributeOverrideStore> result = new LinkedHashMap<String, AttributeOverrideStore>();
        for (Map.Entry<String, AttributeOverrideStore> entry : attributes.entrySet()) {
            AttributeOverrideStore embedAttr = entry.getValue();
            EntityAttribute foundMapsIdAttr = StreamEx.of((Collection)mapsIdAttrs).findFirst(attr -> Objects.equals(attr.getMapsIdValue(), embedAttr.attribute.getName())).orElse(null);
            if (foundMapsIdAttr == null) {
                result.put(entry.getKey(), embedAttr);
                continue;
            }
            result.put(foundMapsIdAttr.getColumn(), embedAttr);
        }
        return result;
    }

    public static List<EntityAttribute> getAttributesUseFromTablePerClass(Entity entity) {
        if (!entity.isValid()) {
            return Collections.emptyList();
        }
        Entity root = EntityDesignHelper.getHierarchyRoot(entity);
        Preconditions.checkNotNull((Object)root, (Object)("Not found root entity for " + entity.getFqn()));
        Entity closestParentWithStrategy = EntityDesignHelper.getParentWithStrategy(entity);
        Entity persistentParent = EntityDesignHelper.getPersistentParent(entity);
        List<EntityAttribute> attributes = persistentParent != null && root.getInheritanceType() == Entity.InheritanceType.TABLE_PER_CLASS && root == closestParentWithStrategy && entity.getInheritanceType() == null || persistentParent != null && entity.getInheritanceType() == Entity.InheritanceType.TABLE_PER_CLASS || closestParentWithStrategy != null && root != closestParentWithStrategy && closestParentWithStrategy.getInheritanceType() == Entity.InheritanceType.TABLE_PER_CLASS ? entity.getAllAttributes() : new ArrayList<EntityAttribute>(entity.getAttributes());
        return attributes;
    }

    public static List<String> getPrimaryKeyJoinColumnName(Entity entity) {
        if (!entity.getPrimaryKeyJoinColumnNames().isEmpty()) {
            return entity.getPrimaryKeyJoinColumnNames();
        }
        EntityAttribute id = entity.getIdAttribute();
        return id.getColumn() == null ? List.of() : List.of(id.getColumn());
    }

    public static List<EntityAttribute> getMappedSuperClassAttributes(Entity entity) {
        ArrayList<EntityAttribute> entityAttributes = new ArrayList<EntityAttribute>();
        Entity parent = entity.getParent();
        if (parent != null && parent.isMappedSuperclass()) {
            if (entity instanceof AuditEntity) {
                entityAttributes.addAll(entity.getInheritedAttributes());
            } else {
                SoftDeleteModel softDeleteModel = parent.getSoftDelete();
                if (softDeleteModel != null) {
                    entityAttributes.add(0, EntityDesignHelper.softDeleteAttribute(softDeleteModel));
                }
                entityAttributes.addAll(parent.getAttributes());
                entityAttributes.addAll(EntityDesignHelper.getMappedSuperClassAttributes(parent));
            }
        }
        return entityAttributes;
    }

    public List<Entity> getChildEntitiesSingleTableStrategy(Entity entity) {
        if (EntityDesignHelper.getInheritanceType(entity) != Entity.InheritanceType.SINGLE_TABLE) {
            return Collections.emptyList();
        }
        if (entity instanceof AuditEntity) {
            return this.getChildEntitiesSingleTableStrategy(((AuditEntity)entity).getAuditedEntity()).stream().filter(it -> it instanceof EntityPsi).map(it -> AuditEntity.Companion.getInstance((EntityPsi)it)).filter(Objects::nonNull).collect(Collectors.toList());
        }
        GlobalSearchScope scope = GlobalSearchScope.allScope((Project)this.project);
        PsiClass entityClass = entity instanceof EntityPsi && entity.isValid() ? ((EntityPsi)entity).getPsiClass() : JavaPsiFacade.getInstance((Project)this.project).findClass(entity.getFqn(), scope);
        if (entityClass == null) {
            return Collections.emptyList();
        }
        ArrayList<Entity> result = new ArrayList<Entity>();
        Query baseQuery = ClassInheritorsSearch.search((PsiClass)entityClass, (SearchScope)scope, (boolean)true, (boolean)true, (boolean)false);
        new FilteredQuery(QueryUtil.uniqueByFqn((Query<PsiClass>)baseQuery), EntityUtil::isEntity).forEach(psiClass -> result.add(EntityPsi.getInstance(psiClass)));
        return result;
    }

    public static void updateColumnInIndex(String prevColumn, String currColumn, Entity entity) {
        ((StreamEx)StreamEx.of(entity.getIndexes()).append(entity.getUniqueConstraints()).filter(index -> index.getAttributes().contains(prevColumn))).forEach(index -> {
            LinkedHashSet updatedAttrs = (LinkedHashSet)StreamEx.of(index.getAttributes()).map(attr -> Objects.equals(prevColumn, attr) ? StringUtil.nullize((String)currColumn, (boolean)true) : attr).nonNull().collect(Collectors.toCollection(LinkedHashSet::new));
            index.setAttributes(updatedAttrs);
        });
    }

    public static EntityAttribute.Cardinality getCardinalityForMappedBy(EntityAttribute.Cardinality cardinality) {
        if (cardinality == null) {
            return null;
        }
        return switch (cardinality) {
            default -> throw new IncompatibleClassChangeError();
            case EntityAttribute.Cardinality.ONE_TO_ONE -> EntityAttribute.Cardinality.ONE_TO_ONE;
            case EntityAttribute.Cardinality.ONE_TO_MANY -> EntityAttribute.Cardinality.MANY_TO_ONE;
            case EntityAttribute.Cardinality.MANY_TO_ONE -> EntityAttribute.Cardinality.ONE_TO_MANY;
            case EntityAttribute.Cardinality.MANY_TO_MANY -> EntityAttribute.Cardinality.MANY_TO_MANY;
        };
    }

    public static List<String> getMappedByAttributes(Entity relatedEntity, Entity referenceAttrType, @Nullable String parentAttrPath, EntityAttribute.Cardinality relatedCardinality) {
        List<EntityAttribute> attributes = referenceAttrType.getAllAttributes();
        ArrayList<String> newValues = new ArrayList<String>();
        for (EntityAttribute attr : attributes) {
            EntityAttribute.Cardinality currCardinality = attr.getCardinality();
            Datatype attrType = attr.getType();
            if (relatedEntity.getFqn().equals(attrType.getFqn()) && currCardinality != null && currCardinality.equals((Object)relatedCardinality)) {
                newValues.add(EntityDesignHelper.calculateAttributePath(parentAttrPath, attr));
            }
            if (attr.getMappingType() != EntityAttribute.MappingType.EMBEDDED || !(attrType instanceof Entity)) continue;
            String embeddedAttrPath = EntityDesignHelper.calculateAttributePath(parentAttrPath, attr);
            newValues.addAll(EntityDesignHelper.getMappedByAttributes(relatedEntity, (Entity)attrType, embeddedAttrPath, relatedCardinality));
        }
        return newValues;
    }

    public static EntityAttribute softDeleteAttribute(SoftDeleteModel softDeleteModel) {
        CachedEntityAttributeModel result = new CachedEntityAttributeModel(softDeleteModel.getColumnName(), softDeleteModel.getType(), EntityAttribute.MappingType.DATATYPE, softDeleteModel.getColumnName());
        result.setMandatory(true);
        return result;
    }

    private static String calculateAttributePath(String parentAttrPath, EntityAttribute attribute) {
        return (String)(parentAttrPath == null ? "" : parentAttrPath + ".") + attribute.getName();
    }

    @Nullable
    public static Pair<EntityAttribute, String> getOverriddenIdAttrColumnNameViaMapsId(List<EntityAttribute> attributes) {
        EntityAttribute idAttr = (EntityAttribute)Iterables.find(attributes, (Predicate)new Entity.IdPredicate(), null);
        if (idAttr == null) {
            return null;
        }
        EntityAttribute oneToOneMapsId = StreamEx.of(attributes).findFirst(attr -> attr.isMapsId() && attr.getCardinality() == EntityAttribute.Cardinality.ONE_TO_ONE).orElse(null);
        if (oneToOneMapsId == null) {
            return null;
        }
        String columnName = oneToOneMapsId.getColumn();
        if (StringUtil.isEmpty((String)columnName)) {
            return null;
        }
        return Pair.create((Object)idAttr, (Object)columnName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/jpa/jpb/model/backend/ed/EntityDesignHelper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInheritanceType";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTableName";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    public static class AttributeOverrideStore {
        private final EntityAttribute attribute;
        private final AttributeOverride attributeOverride;
        private final boolean isNaturalId;

        public AttributeOverrideStore(@NotNull EntityAttribute attribute, @Nullable AttributeOverride attributeOverride, boolean isNaturalId) {
            if (attribute == null) {
                AttributeOverrideStore.$$$reportNull$$$0(0);
            }
            this.attribute = attribute;
            this.attributeOverride = attributeOverride;
            this.isNaturalId = isNaturalId;
        }

        @NotNull
        public EntityAttribute getAttribute() {
            EntityAttribute entityAttribute = this.attribute;
            if (entityAttribute == null) {
                AttributeOverrideStore.$$$reportNull$$$0(1);
            }
            return entityAttribute;
        }

        @Nullable
        public AttributeOverride getAttributeOverride() {
            return this.attributeOverride;
        }

        public boolean isNaturalId() {
            return this.isNaturalId;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "attribute";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/jpa/jpb/model/backend/ed/EntityDesignHelper$AttributeOverrideStore";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/jpa/jpb/model/backend/ed/EntityDesignHelper$AttributeOverrideStore";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAttribute";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

