/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.jpb.model.backend.ed;

import com.intellij.jpa.jpb.model.backend.ed.annotation.Annotation;
import com.intellij.jpa.jpb.model.model.Datatypes;
import com.intellij.jpa.jpb.model.model.EntityAttribute;
import com.intellij.jpa.jpb.model.model.Index;
import com.intellij.jpa.jpb.model.model.NamedQuery;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import java.util.Iterator;
import java.util.List;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;

public class EntityWriterUtils {
    public static String convertUniqueConstraint(List<Index> constraints, Annotation.GenerationStrategy generationStrategy, Project project) {
        StringBuilder result = new StringBuilder(generationStrategy.getStartArrayToken() + "\n");
        Iterator<Index> uniqueConstraintIterator = constraints.iterator();
        while (uniqueConstraintIterator.hasNext()) {
            Index uc = uniqueConstraintIterator.next();
            result.append(uc.toAnnotation(generationStrategy, project));
            Iterator attrIterator = uc.getAttributes().iterator();
            while (attrIterator.hasNext()) {
                String columnName = (String)attrIterator.next();
                result.append("\"").append(columnName).append("\"");
                if (!attrIterator.hasNext()) continue;
                result.append(", ");
            }
            result.append(generationStrategy.getEndArrayToken()).append(")");
            if (!uniqueConstraintIterator.hasNext()) continue;
            result.append(",\n");
        }
        if (generationStrategy == Annotation.GenerationStrategy.JAVA) {
            result.append("\n}");
        } else {
            result.append("\n]");
        }
        return result.toString();
    }

    public static String convertIndex(List<Index> indexes, Annotation.GenerationStrategy generationStrategy, Project project) {
        StringBuilder result = new StringBuilder(generationStrategy.getStartArrayToken() + "\n");
        Iterator<Index> indexIterator = indexes.iterator();
        while (indexIterator.hasNext()) {
            Index idx = indexIterator.next();
            result.append(idx.toAnnotation(generationStrategy, project));
            if (!indexIterator.hasNext()) continue;
            result.append(",\n");
        }
        result.append("\n").append(generationStrategy.getEndArrayToken());
        return result.toString();
    }

    public static String convertNamedQueries(@NotNull Project project, Module module, List<NamedQuery> namedQueries, List<String> existNamedQueries, Annotation.GenerationStrategy generationStrategy) {
        if (project == null) {
            EntityWriterUtils.$$$reportNull$$$0(0);
        }
        String result = generationStrategy.getStartArrayToken() + "\n" + StreamEx.of(existNamedQueries).map(s -> s.startsWith(" ") ? s : "    " + s).joining((CharSequence)",\n");
        if (!existNamedQueries.isEmpty()) {
            result = result + ",\n";
        }
        return result + StreamEx.of(namedQueries).map(namedQuery -> namedQuery.toAnnotation(project, module, generationStrategy)).joining((CharSequence)",\n") + "\n" + generationStrategy.getEndArrayToken();
    }

    public static String getTypeFqn(EntityAttribute attribute, boolean allowCached) {
        if (attribute.isSqlType()) {
            if (attribute.getTemporalType() == EntityAttribute.TemporalType.TIME) {
                return Datatypes.BasicDatatype.SqlTime.getFqn();
            }
            if (attribute.getTemporalType() == EntityAttribute.TemporalType.DATE) {
                return Datatypes.BasicDatatype.SqlDate.getFqn();
            }
        }
        return attribute.getType().getFqn();
    }

    public static String getTypeFqn(EntityAttribute attribute) {
        return EntityWriterUtils.getTypeFqn(attribute, false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/jpa/jpb/model/backend/ed/EntityWriterUtils", "convertNamedQueries"));
    }
}

