/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.jpb.model.backend.ed;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.actions.OptimizeImportsProcessor;
import com.intellij.codeInsight.generation.GenerateMembersUtil;
import com.intellij.codeInsight.generation.PsiGenerationInfo;
import com.intellij.diff.comparison.ComparisonPolicy;
import com.intellij.diff.comparison.ComparisonUtil;
import com.intellij.jpa.jpb.model.backend.ed.EntityConstantWriter;
import com.intellij.jpa.jpb.model.backend.ed.EntityDesignHelper;
import com.intellij.jpa.jpb.model.backend.ed.EntityFieldGenerationInfo;
import com.intellij.jpa.jpb.model.backend.ed.EntityWriter;
import com.intellij.jpa.jpb.model.backend.ed.EntityWriterUtils;
import com.intellij.jpa.jpb.model.backend.ed.FqnResolverManagerKt;
import com.intellij.jpa.jpb.model.backend.ed.MethodImpl;
import com.intellij.jpa.jpb.model.backend.ed.annotation.Annotation;
import com.intellij.jpa.jpb.model.backend.ed.annotation.AnnotationAppender;
import com.intellij.jpa.jpb.model.backend.ed.annotation.AnnotationHelper;
import com.intellij.jpa.jpb.model.backend.ed.annotation.AnnotationWithConstants;
import com.intellij.jpa.jpb.model.backend.ed.annotation.attr.AbstractConstraintAnnotation;
import com.intellij.jpa.jpb.model.backend.ed.annotation.attr.AssociationOverridesAnnotation;
import com.intellij.jpa.jpb.model.backend.ed.annotation.attr.AttributeOverridesAnnotation;
import com.intellij.jpa.jpb.model.backend.ed.annotation.attr.JoinColumnsAnnotation;
import com.intellij.jpa.jpb.model.backend.ed.annotation.attr.JpaAttributeAnnotation;
import com.intellij.jpa.jpb.model.backend.ed.annotation.attr.JpaEntityAnnotation;
import com.intellij.jpa.jpb.model.backend.ed.annotation.attr.JpaEnum;
import com.intellij.jpa.jpb.model.backend.ed.indexing.EntitySearch;
import com.intellij.jpa.jpb.model.backend.ed.indexing.HibernateCustomTypeModel;
import com.intellij.jpa.jpb.model.backend.ed.indexing.LombokService;
import com.intellij.jpa.jpb.model.config.FieldAccessModifier;
import com.intellij.jpa.jpb.model.config.JpaPluginProjectConfig;
import com.intellij.jpa.jpb.model.config.ProjectState;
import com.intellij.jpa.jpb.model.core.backend.PsiClassModificationHelper;
import com.intellij.jpa.jpb.model.core.backend.ed.annotation.AnnotationModel;
import com.intellij.jpa.jpb.model.core.backend.ed.annotation.AnnotationParameter;
import com.intellij.jpa.jpb.model.core.backend.ed.annotation.AnnotationRenderer;
import com.intellij.jpa.jpb.model.core.backend.ed.annotation.ArrayParameter;
import com.intellij.jpa.jpb.model.core.backend.ed.annotation.JavaAnnotationRenderer;
import com.intellij.jpa.jpb.model.core.backend.ed.annotation.RenderOptions;
import com.intellij.jpa.jpb.model.core.backend.ed.annotation.StringParameter;
import com.intellij.jpa.jpb.model.core.msg.JpaModelBundle;
import com.intellij.jpa.jpb.model.liquibase.ns.SpringImplicitNamingStrategy;
import com.intellij.jpa.jpb.model.model.AttributeOverride;
import com.intellij.jpa.jpb.model.model.Datatype;
import com.intellij.jpa.jpb.model.model.Datatypes;
import com.intellij.jpa.jpb.model.model.Entity;
import com.intellij.jpa.jpb.model.model.EntityAttribute;
import com.intellij.jpa.jpb.model.model.EntityAttributeModel;
import com.intellij.jpa.jpb.model.model.EntityModel;
import com.intellij.jpa.jpb.model.model.EntityPsi;
import com.intellij.jpa.jpb.model.model.EnumType;
import com.intellij.jpa.jpb.model.model.Method;
import com.intellij.jpa.jpb.model.model.NamedQuery;
import com.intellij.jpa.jpb.model.model.SequenceGenerator;
import com.intellij.jpa.jpb.model.reference.TemplateHelper;
import com.intellij.jpa.jpb.model.util.AttributeUtil;
import com.intellij.jpa.jpb.model.util.EntityUtil;
import com.intellij.jpa.jpb.model.util.HProjectUtils;
import com.intellij.jpa.jpb.model.util.JpaUtils;
import com.intellij.jpa.jpb.model.util.StudioAnnotationUtil;
import com.intellij.jpa.jpb.model.util.StudioPropertyUtil;
import com.intellij.jpa.jpb.model.util.annotation.JoinColumn;
import com.intellij.jpa.jpb.model.util.annotation.JoinTable;
import com.intellij.lang.java.beans.PropertyKind;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiParserFacade;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.impl.light.LightElement;
import com.intellij.psi.impl.source.PsiMethodImpl;
import com.intellij.psi.impl.source.tree.java.PsiLiteralExpressionImpl;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.fixes.SerialVersionUIDBuilder;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JavaEntityWriter
implements EntityWriter {
    protected final AnnotationRenderer annotationRenderer = new JavaAnnotationRenderer();
    protected final AnnotationRenderer shortNamesAnnotationRenderer = new JavaAnnotationRenderer(new RenderOptions(true));
    public static final String GETTER_TEMPLATE = "public %3$s get%1$s() { return %2$s; }";
    public static final String SETTER_TEMPLATE = "public void set%1$s(%3$s %2$s) { this.%2$s = %2$s; }";
    public static final String FLUENT_SETTER_TEMPLATE = "public %4$s set%1$s(%3$s %2$s) { this.%2$s = %2$s; return this; }";
    protected static final String EQUALS_TEMPLATE = "@Override\n    public boolean equals(Object o) {\n        if (this == o) return true;\n        if (o == null || %4$s) return false;\n        %1$s %2$s = (%1$s) o;\n        return %3$s\n    }";
    public static final String HASH_CODE_TEMPLATE = "@Override\n    public int hashCode() {\n        return java.util.Objects.hash(%1$s);\n    }";
    public static final Logger log = Logger.getInstance(JavaEntityWriter.class);
    protected final Project project;
    protected final PsiElementFactory elementFactory;
    protected final JavaCodeStyleManager javaCodeStyleManager;
    protected final EntitySearch entitySearch;
    protected final PsiClassModificationHelper psiClassModificationHelper;

    public static String getSetterImpl(Project project, String propertyName, String propertyType, String currentClassName) {
        ProjectState state = JpaPluginProjectConfig.getInstance(project).getState();
        String upped = StringUtil.capitalize((String)propertyName);
        if (state.useBuilderSetters) {
            return String.format(FLUENT_SETTER_TEMPLATE, upped, propertyName, propertyType, currentClassName);
        }
        return String.format(SETTER_TEMPLATE, upped, propertyName, propertyType);
    }

    public JavaEntityWriter(Project project) {
        this.project = project;
        this.elementFactory = PsiElementFactory.getInstance((Project)project);
        this.javaCodeStyleManager = JavaCodeStyleManager.getInstance((Project)project);
        this.entitySearch = EntitySearch.getInstance(project);
        this.psiClassModificationHelper = PsiClassModificationHelper.getInstance(project);
    }

    protected Map<String, Annotation> getAttrAnnotations() {
        return AnnotationHelper.getAttrAnnotations(this.project);
    }

    @Override
    public void commitEntityToPsi(Entity entity, PsiClass entityClass) {
        this.commitEntityToPsi(entity, entityClass, true);
    }

    @Override
    public void commitEntityToPsiWithoutAttribute(@NotNull Entity entity, @NotNull PsiClass entityClass) {
        if (entity == null) {
            JavaEntityWriter.$$$reportNull$$$0(0);
        }
        if (entityClass == null) {
            JavaEntityWriter.$$$reportNull$$$0(1);
        }
        PsiFile[] psiFileArray = new PsiFile[1];
        psiFileArray[0] = (PsiFile)EntityUtil.ra(() -> ((PsiClass)entityClass).getContainingFile());
        WriteCommandAction.writeCommandAction((Project)this.project, (PsiFile[])psiFileArray).withGroupId("Studio entity properties editor's write action").run(() -> {
            PsiModifierList modifierList = entityClass.getModifierList();
            if (modifierList == null) {
                return;
            }
            this.entityAnnotationsToPsi(entity, entityClass, modifierList);
            this.parentToSource(entity, entityClass);
            this.afterCommitEntityToPsi(entity, entityClass);
        });
    }

    @Override
    public void commitEntityToPsi(Entity entity, PsiClass entityClass, boolean toOptimizeImports) {
        PsiFile[] psiFileArray = new PsiFile[1];
        psiFileArray[0] = (PsiFile)EntityUtil.ra(() -> ((PsiClass)entityClass).getContainingFile());
        WriteCommandAction.writeCommandAction((Project)this.project, (PsiFile[])psiFileArray).withGroupId("Studio entity properties editor's write action").run(() -> {
            PsiModifierList modifierList = entityClass.getModifierList();
            if (modifierList == null) {
                return;
            }
            this.entityAnnotationsToPsi(entity, entityClass, modifierList);
            this.deleteUnusedFields(entity, entityClass);
            this.methodBasedAttributesToSource(entity, entityClass);
            this.fieldsToPsi(entity, entityClass);
            this.methodsToSource(entity, entityClass);
            this.parentToSource(entity, entityClass);
            this.addCommentJavaDoc((PsiElement)entityClass, entity.getComment());
            this.afterCommitEntityToPsi(entity, entityClass);
            if (toOptimizeImports) {
                new OptimizeImportsProcessor(this.project, entityClass.getContainingFile()).run();
            }
        });
    }

    protected void afterCommitEntityToPsi(Entity entity, PsiClass entityClass) {
    }

    @Override
    public void addSerialVersionUID(PsiClass entityClass) {
        long serialVersionUID = SerialVersionUIDBuilder.computeDefaultSUID((PsiClass)entityClass);
        PsiField field = this.elementFactory.createFieldFromText("private static final long serialVersionUID = " + serialVersionUID + "L;", (PsiElement)entityClass);
        entityClass.add((PsiElement)field);
    }

    @Override
    public void addSerializableParentIfNeeded(@NotNull PsiClass entityClass) {
        PsiElement psiElement;
        if (entityClass == null) {
            JavaEntityWriter.$$$reportNull$$$0(2);
        }
        if ((psiElement = this.psiClassModificationHelper.addInterface(entityClass, Serializable.class.getName())) == null) {
            return;
        }
        TemplateHelper templateHelper = (TemplateHelper)TemplateHelper.Companion.getInstance(psiElement);
        if (templateHelper == null) {
            return;
        }
        templateHelper.shortenReferences(psiElement);
    }

    public void insertFields(Entity entity, PsiClass entityClass, Map<String, String> fieldsImpl, Map<String, EntityAttribute> fields) {
        LinkedList<String> toInsert = new LinkedList<String>();
        for (Map.Entry<String, String> entry : fieldsImpl.entrySet()) {
            if (entityClass.findFieldByName(entry.getKey(), true) != null) continue;
            toInsert.add(entry.getValue());
            EntityAttribute addingAtt = fields.get(entry.getKey());
            if (addingAtt == null) continue;
            entity.getAttributes().add(addingAtt);
        }
        for (String fieldSource : toInsert) {
            PsiField createdField = this.elementFactory.createFieldFromText(fieldSource.trim(), entityClass.getContext());
            this.javaCodeStyleManager.shortenClassReferences(entityClass.add((PsiElement)createdField));
        }
        JavaEntityWriter.sortAttributes(entity, entityClass);
    }

    protected void parentToSource(Entity entity, PsiClass entityClass) {
        PsiReferenceList classExtendsList = entityClass.getExtendsList();
        if (entity.getParent() == null) {
            if (classExtendsList != null) {
                classExtendsList.delete();
            }
            return;
        }
        Entity parent = entity.getParent();
        Entity compKeyType = entity.getCompKeyType();
        PsiClass newParentClass = this.entitySearch.findEntityPsiClass(parent);
        if (newParentClass == null || classExtendsList == null) {
            log.warn("PsiClass not found for: " + parent.getFqn());
            return;
        }
        PsiJavaCodeReferenceElement[] referenceElements = classExtendsList.getReferenceElements();
        if (referenceElements.length == 1) {
            PsiJavaCodeReferenceElement referenceElement = referenceElements[0];
            if (!Objects.equals(referenceElement.getQualifiedName(), newParentClass.getQualifiedName())) {
                PsiJavaCodeReferenceElement newRef = this.elementFactory.createClassReferenceElement(newParentClass);
                referenceElement.replace((PsiElement)newRef);
            }
        } else if (referenceElements.length == 0) {
            classExtendsList.add((PsiElement)this.elementFactory.createClassReferenceElement(newParentClass));
        }
    }

    protected void methodsToSource(Entity entity, PsiClass entityClass) {
        if (!entity.hasEqualsAndHashCode()) {
            return;
        }
        Set<String> attrNames = entity.getAttributes().stream().filter(attribute -> !attribute.isTransient() && attribute.isCreateField()).map(EntityAttribute::getName).collect(Collectors.toSet());
        if (attrNames.isEmpty()) {
            return;
        }
        PsiMethod[] equalsMethods = entityClass.findMethodsByName("equals", false);
        PsiMethod[] hashCodeMethods = entityClass.findMethodsByName("hashCode", false);
        if (equalsMethods.length != 0 || hashCodeMethods.length != 0) {
            return;
        }
        List<String> methodsToInsert = JavaEntityWriter.generateEqualsAndHashCodeMethods(ClassEqualsType.getInstance(this.project), entity.getClassName(), attrNames);
        if (!methodsToInsert.isEmpty()) {
            this.insertMethods(entityClass, methodsToInsert, MethodInsertPosition.AFTER_METHODS);
        }
    }

    @NotNull
    public static List<String> generateEqualsAndHashCodeMethods(ClassEqualsType equalsType, String className, Set<String> attrNames) {
        LinkedList<String> methodsToInsert = new LinkedList<String>();
        String varName = "entity";
        StringBuilder returnImpl = new StringBuilder();
        Iterator<String> iterator = attrNames.iterator();
        while (iterator.hasNext()) {
            if (!returnImpl.isEmpty()) {
                returnImpl.append("                ");
            }
            String attrName = iterator.next();
            returnImpl.append("java.util.Objects.equals(").append("this.").append(attrName).append(", ").append(varName).append(".").append(attrName).append(")");
            if (iterator.hasNext()) {
                returnImpl.append(" &&\n");
                continue;
            }
            returnImpl.append(";");
        }
        methodsToInsert.add(String.format(EQUALS_TEMPLATE, className, varName, returnImpl, JavaEntityWriter.completeEqualsCheckParameterExpr(equalsType)));
        methodsToInsert.add(String.format(HASH_CODE_TEMPLATE, Joiner.on((String)", ").join(attrNames)));
        LinkedList<String> linkedList = methodsToInsert;
        if (linkedList == null) {
            JavaEntityWriter.$$$reportNull$$$0(3);
        }
        return linkedList;
    }

    public static String completeEqualsCheckParameterExpr(ClassEqualsType equalsType) {
        if (equalsType == ClassEqualsType.HIBERNATE) {
            return "org.hibernate.Hibernate.getClass(this) != org.hibernate.Hibernate.getClass(o)";
        }
        if (equalsType == ClassEqualsType.SPRING_BOOT) {
            return "org.springframework.data.util.ProxyUtils.getUserClass(this) != org.springframework.data.util.ProxyUtils.getUserClass(o)";
        }
        return "getClass() != o.getClass()";
    }

    protected void methodBasedAttributesToSource(Entity entity, PsiClass entityClass) {
        ArrayList<PsiMethod> getterMethods = new ArrayList<PsiMethod>();
        for (PsiMethod psiMethod2 : entityClass.getMethods()) {
            String propertyName;
            PsiField propertyField;
            if (!this.isEntityAttributeMethod(psiMethod2) || (propertyField = PropertyUtilBase.findPropertyField((PsiClass)entityClass, (String)(propertyName = PropertyUtilBase.getPropertyNameByGetter((PsiMethod)psiMethod2)), (boolean)false)) != null && !AttributeUtil.isPersistent(propertyField)) continue;
            getterMethods.add(psiMethod2);
        }
        List methodBasedAttributes = ContainerUtil.filter(entity.getAttributes(), entityAttribute -> entityAttribute.isTransient() && !entityAttribute.isCreateField());
        if (getterMethods.isEmpty() && methodBasedAttributes.isEmpty()) {
            return;
        }
        LinkedHashMap<String, PsiMethod> nameToNodeMap = new LinkedHashMap<String, PsiMethod>();
        getterMethods.forEach(getterMethod -> nameToNodeMap.put(PropertyUtilBase.getPropertyName((PsiMethod)getterMethod), (PsiMethod)getterMethod));
        Map<String, EntityAttribute> nameToAttributeMap = methodBasedAttributes.stream().collect(Collectors.toMap(EntityAttribute::getName, attribute -> attribute));
        LinkedHashMap<EntityAttribute, PsiMethod> toModify = new LinkedHashMap<EntityAttribute, PsiMethod>();
        nameToNodeMap.forEach((attrName, method) -> {
            if (nameToAttributeMap.containsKey(attrName)) {
                toModify.put((EntityAttribute)nameToAttributeMap.get(attrName), (PsiMethod)method);
            }
        });
        toModify.forEach((entityAttribute, psiMethod) -> this.modifyMethodBasedAttribute(entity, (EntityAttribute)entityAttribute, (PsiMethod)psiMethod));
        LinkedList<String> methodsToInsert = new LinkedList<String>();
        for (String attrName2 : nameToAttributeMap.keySet()) {
            if (nameToNodeMap.containsKey(attrName2)) continue;
            EntityAttribute entityAttribute2 = nameToAttributeMap.get(attrName2);
            MethodImpl getter = this.generateGetter(entityAttribute2, ModuleUtilCore.findModuleForPsiElement((PsiElement)entityClass));
            Method method2 = getter.getMethod();
            if (!entity.getMethods().contains(method2)) {
                entity.getMethods().add(method2);
            }
            methodsToInsert.add(getter.getImplementation());
        }
        this.insertMethods(entityClass, (List<String>)methodsToInsert);
    }

    protected boolean isEntityAttributeMethod(PsiMethod psiMethod) {
        return StringUtils.startsWith((CharSequence)psiMethod.getName(), (CharSequence)"get") && !psiMethod.hasModifierProperty("static") && !psiMethod.hasModifierProperty("private");
    }

    protected boolean isEntityAttributeMethod(Method method) {
        return (method.getParamNames() == null || method.getParamNames().length == 0) && !method.getModifiers().contains("static") && !method.getModifiers().contains("private");
    }

    protected void modifyMethodBasedAttribute(Entity entity, EntityAttribute attribute, PsiMethod method) {
        String newType;
        String newName;
        PsiType returnType = method.getReturnType();
        if (attribute.isUnknownType() || returnType == null) {
            return;
        }
        String oldType = returnType.getPresentableText();
        String oldName = method.getName();
        if (!oldName.equals(newName = PropertyKind.GETTER.prefix + StringUtil.capitalizeWithJavaBeanConvention((String)StringUtil.sanitizeJavaIdentifier((String)attribute.getName())))) {
            method.setName(newName);
        }
        if (!oldType.equals(newType = JavaEntityWriter.generateAttributeType(attribute, false))) {
            PsiTypeElement typeElement = method.getReturnTypeElement();
            log.assertTrue(typeElement != null, method.getClass());
            PsiTypeElement newTypeElement = this.elementFactory.createTypeElementFromText(newType, method.getContext());
            typeElement.replace((PsiElement)newTypeElement);
        }
        this.modifyExistingAnnotations(entity, attribute, (PsiModifierListOwner)method);
        this.addNewAnnotations(entity, attribute, (PsiModifierListOwner)method);
    }

    protected static String generateAttributeType(EntityAttribute attribute, boolean isField) {
        String attrTypeFqn = EntityWriterUtils.getTypeFqn(attribute);
        String collectionTypeFqn = JavaEntityWriter.getCollectionTypeFqn(attribute);
        if (collectionTypeFqn != null) {
            return collectionTypeFqn + "<" + attrTypeFqn + ">";
        }
        return attrTypeFqn;
    }

    private static String getCollectionTypeFqn(EntityAttribute attribute) {
        Datatypes.CollectionDatatype collectionType = attribute.getCollectionType();
        return collectionType != null ? collectionType.getFqn() : attribute.getCollectionTypeFqn();
    }

    @Nullable
    protected EntityFieldGenerationInfo generateField(PsiClass entityClass, Entity entity, EntityAttribute fieldToInsert, boolean isShortenClassReferences) {
        Method method;
        if (!fieldToInsert.isCreateField()) {
            return null;
        }
        EntityFieldGenerationInfo generationInfo = new EntityFieldGenerationInfo();
        if (fieldToInsert.getFetchType() == EntityAttribute.FetchType.LAZY && fieldToInsert instanceof EntityAttributeModel) {
            ((EntityAttributeModel)fieldToInsert).setLombokToStringInclude(false);
        }
        String field = this.generateNewAttribute(fieldToInsert);
        PsiField generatedField = this.elementFactory.createFieldFromText(field, entityClass.getContext());
        if (isShortenClassReferences) {
            this.javaCodeStyleManager.shortenClassReferences((PsiElement)generatedField);
        }
        generationInfo.setField(generatedField);
        List<String> newAttributeAnnotations = this.generateNewAttributeAnnotations(fieldToInsert, entity, entityClass);
        generationInfo.getGeneratedAnnotations().put(generatedField.getName(), newAttributeAnnotations);
        if (this.isGenerateGetters(entity) && !fieldToInsert.isLombokGetter()) {
            MethodImpl getter = this.generateGetter(fieldToInsert, ModuleUtilCore.findModuleForPsiElement((PsiElement)entityClass));
            method = getter.getMethod();
            if (!entity.getMethods().contains(method)) {
                entity.getMethods().add(method);
            }
            generationInfo.getMethodsToInsert().add(getter.getImplementation());
        }
        if (!fieldToInsert.isReadOnly() && this.isGenerateSetters(entity) && !fieldToInsert.isLombokSetter()) {
            MethodImpl setter = JavaEntityWriter.generateSetter(entity, fieldToInsert, this.project);
            method = setter.getMethod();
            if (!entity.getMethods().contains(method)) {
                entity.getMethods().add(method);
            }
            generationInfo.getMethodsToInsert().add(setter.getImplementation());
        }
        return generationInfo;
    }

    @Override
    public void commitAttributeToPsi(@NotNull EntityPsi entity, @NotNull EntityAttribute attribute, @NotNull PsiMember member, boolean isCommitUnknownType) {
        if (entity == null) {
            JavaEntityWriter.$$$reportNull$$$0(4);
        }
        if (attribute == null) {
            JavaEntityWriter.$$$reportNull$$$0(5);
        }
        if (member == null) {
            JavaEntityWriter.$$$reportNull$$$0(6);
        }
        PsiClass entityClass = entity.getPsiClass();
        PsiFile containingFile = entityClass.getContainingFile();
        WriteCommandAction.writeCommandAction((Project)this.project, (PsiFile[])new PsiFile[]{containingFile}).withName(JpaModelBundle.message("command.name.update.entity.attribute", attribute.getName())).withGroupId("Studio entity properties editor's write action").run(() -> {
            if (!(member instanceof PsiField)) {
                return;
            }
            this.modifyAttribute(entity, entityClass, attribute, (PsiField)member, isCommitUnknownType);
        });
    }

    @Override
    public void commitAttributeToPsi(@NotNull EntityPsi entity, @NotNull EntityAttribute attribute, @NotNull PsiMember member) {
        if (entity == null) {
            JavaEntityWriter.$$$reportNull$$$0(7);
        }
        if (attribute == null) {
            JavaEntityWriter.$$$reportNull$$$0(8);
        }
        if (member == null) {
            JavaEntityWriter.$$$reportNull$$$0(9);
        }
        this.commitAttributeToPsi(entity, attribute, member, true);
    }

    private void fieldsToPsi(Entity entity, PsiClass entityClass) {
        String fieldName;
        LinkedHashMap<EntityAttribute, PsiField> existingFields = JavaEntityWriter.getExistingFields(entity.getAttributes(), entityClass);
        long start = System.currentTimeMillis();
        for (Map.Entry<EntityAttribute, PsiField> entry : existingFields.entrySet()) {
            this.modifyAttribute(entity, entityClass, entry.getKey(), entry.getValue(), false);
        }
        log.debug("[perf] EntitySourceParser.modifyAttribute(all attributes). Size: " + existingFields.size() + ". Time: " + (System.currentTimeMillis() - start) + " ms");
        List<EntityAttribute> fieldsToInsert = JavaEntityWriter.getFieldsToInsert(entity, existingFields);
        LinkedList<String> methodsToInsert = new LinkedList<String>();
        LinkedList<PsiField> generatedFields = new LinkedList<PsiField>();
        ArrayList<EntityAttribute> commentAttributes = new ArrayList<EntityAttribute>();
        HashMap<String, List<String>> generatedAnnotations = new HashMap<String, List<String>>();
        for (EntityAttribute fieldToInsert : fieldsToInsert) {
            EntityFieldGenerationInfo generationInfo = this.generateField(entityClass, entity, fieldToInsert, true);
            if (generationInfo == null) continue;
            PsiField attrField = generationInfo.getField();
            generatedFields.add(attrField);
            generatedAnnotations.putAll(generationInfo.getGeneratedAnnotations());
            if (fieldToInsert.isTodoComment()) {
                commentAttributes.add(fieldToInsert);
            } else {
                methodsToInsert.addAll(generationInfo.getMethodsToInsert());
            }
            this.addCommentJavaDoc((PsiElement)attrField, fieldToInsert.getComment());
        }
        for (PsiField generatedField : generatedFields) {
            EntityAttribute commentAttr;
            if (!this.isGenerateJpaOnGetter(generatedField, entityClass)) {
                fieldName = generatedField.getName();
                List newAnnotations = (List)generatedAnnotations.get(fieldName);
                for (String newAnnotation : newAnnotations) {
                    PsiAnnotation createdAnnotation = this.elementFactory.createAnnotationFromText(newAnnotation, generatedField.getContext());
                    PsiModifierList modifierList = generatedField.getModifierList();
                    if (modifierList == null) continue;
                    this.addAnnotation(modifierList, createdAnnotation, true);
                }
            }
            if ((commentAttr = (EntityAttribute)StreamEx.of(commentAttributes).findFirst(entityAttribute -> Objects.equals(entityAttribute.getName(), generatedField.getName())).orElse(null)) == null) {
                PsiField processedEntityField = (PsiField)this.javaCodeStyleManager.shortenClassReferences(entityClass.add((PsiElement)generatedField));
                this.addNewLinesIfNeed(processedEntityField);
                continue;
            }
            this.addCommentAttribute(entityClass, commentAttr, generatedField);
        }
        this.insertMethods(entityClass, (List<String>)methodsToInsert);
        for (PsiField newField : generatedFields) {
            PsiMethod getterMethod;
            if (!this.isGenerateJpaOnGetter(newField, entityClass) || (getterMethod = (PsiMethod)StreamEx.of((Collection)PropertyUtilBase.getGetters((PsiClass)entityClass, (String)(fieldName = newField.getName()))).select(PsiMethodImpl.class).findFirst().orElse(null)) == null) continue;
            List newAnnotations = (List)generatedAnnotations.get(fieldName);
            this.addAnnotationsToTargetMember(newAnnotations, (PsiModifierListOwner)getterMethod, true);
        }
        start = System.currentTimeMillis();
        JavaEntityWriter.sortAttributes(entity, entityClass);
        log.debug("[perf] EntitySourceParser.sortAttributes " + (System.currentTimeMillis() - start) + " ms");
    }

    @Override
    public void doAddAttributes(@NotNull Entity entity, @NotNull PsiClass entityClass, List<EntityAttribute> attributes) {
        if (entity == null) {
            JavaEntityWriter.$$$reportNull$$$0(10);
        }
        if (entityClass == null) {
            JavaEntityWriter.$$$reportNull$$$0(11);
        }
        if (attributes.isEmpty()) {
            return;
        }
        StringBuilder tempEntitySource = new StringBuilder();
        ArrayList<String> methodsToInsert = new ArrayList<String>();
        Iterator<EntityAttribute> iterator = attributes.iterator();
        while (iterator.hasNext()) {
            EntityAttribute attribute;
            EntityFieldGenerationInfo generationInfo = this.generateField(entityClass, entity, attribute, !(attribute = iterator.next()).isTodoComment());
            if (generationInfo == null) {
                MethodImpl getter = this.generateGetter(attribute, ModuleUtilCore.findModuleForPsiElement((PsiElement)entityClass));
                methodsToInsert.add(getter.getImplementation());
                continue;
            }
            PsiField newField = generationInfo.getField();
            this.addAnnotationsToTargetMember(generationInfo, newField, (PsiModifierListOwner)newField, false);
            if (attribute.isTodoComment()) {
                PsiElement reformattedField = CodeStyleManager.getInstance((Project)this.project).reformat((PsiElement)newField);
                String commentText = this.calculateCommentText(attribute, reformattedField.getText());
                tempEntitySource.append(commentText).append("\n");
                continue;
            }
            tempEntitySource.append(newField.getText()).append("\n\n");
            methodsToInsert.addAll(generationInfo.getMethodsToInsert());
        }
        JavaEntityWriter.insertMethods(tempEntitySource, methodsToInsert);
        PsiClass tempEntityClass = this.elementFactory.createClassFromText(tempEntitySource.toString(), entityClass.getContext());
        ArrayList allMembers = new ArrayList();
        Collections.addAll(allMembers, tempEntityClass.getFields());
        Collections.addAll(allMembers, tempEntityClass.getMethods());
        if (allMembers.isEmpty()) {
            return;
        }
        PsiField[] fields = entityClass.getFields();
        PsiField anchorElement = null;
        if (fields.length != 0) {
            anchorElement = fields[fields.length - 1];
        }
        if (allMembers.size() > 1) {
            entityClass.addRangeAfter((PsiElement)allMembers.get(0), (PsiElement)allMembers.get(allMembers.size() - 1), (PsiElement)anchorElement);
        } else {
            entityClass.addAfter((PsiElement)allMembers.get(0), (PsiElement)anchorElement);
        }
        this.javaCodeStyleManager.shortenClassReferences((PsiElement)entityClass);
    }

    private static void insertMethods(StringBuilder entitySource, List<String> methods) {
        for (String method : methods) {
            entitySource.append(method.trim());
            entitySource.append("\n");
        }
    }

    @Override
    public PsiElement doAddAttribute(Entity entity, PsiClass entityClass, EntityAttribute attribute, int offsetPosition) {
        boolean isShortenClassReferences;
        EntityFieldGenerationInfo generationInfo;
        PsiElement elementAt = entityClass.getContainingFile().findElementAt(offsetPosition);
        SmartPsiElementPointer pointer = null;
        if (elementAt != null) {
            pointer = SmartPointerManager.createPointer((PsiElement)elementAt);
        }
        if ((generationInfo = this.generateField(entityClass, entity, attribute, isShortenClassReferences = !attribute.isTodoComment())) == null) {
            MethodImpl getter = this.generateGetter(attribute, ModuleUtilCore.findModuleForPsiElement((PsiElement)entityClass));
            this.insertMethods(entityClass, Collections.singletonList(getter.getImplementation()));
            return null;
        }
        PsiField newField = generationInfo.getField();
        if (!this.isGenerateJpaOnGetter(newField, entityClass)) {
            this.addAnnotationsToTargetMember(generationInfo, newField, (PsiModifierListOwner)newField, isShortenClassReferences);
        }
        if (attribute.isTodoComment()) {
            return this.addCommentAttribute(entityClass, attribute, newField);
        }
        if (offsetPosition >= 0) {
            PsiGenerationInfo prototype = new PsiGenerationInfo((PsiMember)newField);
            offsetPosition = pointer.getElement() != null ? pointer.getElement().getTextOffset() : offsetPosition;
            List generationResult = GenerateMembersUtil.insertMembersAtOffset((PsiClass)entityClass, (int)offsetPosition, Collections.singletonList(prototype));
            if (!generationResult.isEmpty()) {
                newField = (PsiField)((PsiGenerationInfo)generationResult.get(0)).getPsiMember();
            }
        } else {
            newField = (PsiField)entityClass.add((PsiElement)newField);
        }
        if (newField != null) {
            PsiMethod getter;
            newField = (PsiField)this.javaCodeStyleManager.shortenClassReferences((PsiElement)newField);
            this.insertMethods(entityClass, generationInfo.getMethodsToInsert());
            if (this.isGenerateJpaOnGetter(newField, entityClass) && (getter = (PsiMethod)StreamEx.of((Collection)PropertyUtilBase.getGetters((PsiClass)entityClass, (String)newField.getName())).select(PsiMethodImpl.class).findFirst().orElse(null)) != null) {
                this.addAnnotationsToTargetMember(generationInfo, newField, (PsiModifierListOwner)getter, true);
            }
            this.addNewLinesIfNeed(newField);
        }
        return newField;
    }

    private PsiElement addCommentAttribute(PsiClass entityClass, EntityAttribute attribute, PsiField newField) {
        PsiElement reformattedField = CodeStyleManager.getInstance((Project)this.project).reformat((PsiElement)newField);
        String commentText = this.calculateCommentText(attribute, reformattedField.getText());
        PsiComment commentElement = this.elementFactory.createCommentFromText(commentText, (PsiElement)entityClass);
        PsiElement rBrace = entityClass.getRBrace();
        PsiElement whiteSpaceFromText = PsiParserFacade.getInstance((Project)this.project).createWhiteSpaceFromText("\n");
        entityClass.addBefore(whiteSpaceFromText, rBrace);
        return entityClass.addBefore((PsiElement)commentElement, rBrace);
    }

    protected boolean isGenerateJpaOnGetter(PsiField psiField, PsiClass psiClass) {
        return false;
    }

    protected boolean isGenerateGetters(Entity entity) {
        return true;
    }

    protected boolean isGenerateSetters(Entity entity) {
        return true;
    }

    @Override
    public void addNewLinesIfNeed(@NotNull PsiField createdField) {
        if (createdField == null) {
            JavaEntityWriter.$$$reportNull$$$0(12);
        }
        this.addNewLineIfNeed(createdField, createdField.getPrevSibling(), true);
        this.addNewLineIfNeed(createdField, createdField.getNextSibling(), false);
    }

    private void addNewLineIfNeed(@NotNull PsiField createdField, @Nullable PsiElement sibling, boolean isPrev) {
        String additionalWhiteSpaceText;
        if (createdField == null) {
            JavaEntityWriter.$$$reportNull$$$0(13);
        }
        if (sibling == null) {
            return;
        }
        PsiParserFacade parserFacade = PsiParserFacade.getInstance((Project)this.project);
        if (!(sibling instanceof PsiWhiteSpace)) {
            PsiElement newWhiteSpaceElem = parserFacade.createWhiteSpaceFromText("\n\n");
            if (isPrev) {
                sibling.getParent().addBefore(newWhiteSpaceElem, (PsiElement)createdField);
            } else {
                sibling.getParent().addAfter(newWhiteSpaceElem, (PsiElement)createdField);
            }
            return;
        }
        if (isPrev && !(sibling.getPrevSibling() instanceof PsiField)) {
            return;
        }
        String whiteSpaceText = sibling.getText();
        int countNewLine = StringUtil.countNewLines((CharSequence)whiteSpaceText);
        String string = countNewLine == 0 ? "\n\n" : (additionalWhiteSpaceText = countNewLine == 1 ? "\n" : null);
        if (additionalWhiteSpaceText != null) {
            PsiElement newWhiteSpaceElem = parserFacade.createWhiteSpaceFromText(whiteSpaceText + additionalWhiteSpaceText);
            sibling.replace(newWhiteSpaceElem);
        }
    }

    private void addAnnotationsToTargetMember(EntityFieldGenerationInfo generationInfo, PsiField newField, PsiModifierListOwner targetMember, boolean isShortenClassReferences) {
        Map<String, List<String>> generatedAnnotations = generationInfo.generatedAnnotations;
        this.addAnnotationsToTargetMember((Collection<String>)generatedAnnotations.get(newField.getName()), targetMember, isShortenClassReferences);
    }

    private void addAnnotationsToTargetMember(Collection<String> annotations, PsiModifierListOwner targetMember, boolean isShortenClassReferences) {
        for (String newAnnotation : annotations) {
            PsiAnnotation createdAnnotation = this.elementFactory.createAnnotationFromText(newAnnotation, targetMember.getContext());
            PsiModifierList modifierList = targetMember.getModifierList();
            if (modifierList == null) continue;
            this.addAnnotation(modifierList, createdAnnotation, true, isShortenClassReferences);
        }
    }

    @Override
    public void openEntityClass(PsiClass entityClass) {
        PsiModifierList modifierList = entityClass.getModifierList();
        if (modifierList != null) {
            modifierList.setModifierProperty("final", false);
        }
    }

    @Override
    public void setTableName(EntityPsi entityPsi, String name) {
        PsiClass psiClass = entityPsi.getPsiClass();
        PsiFile[] psiFileArray = new PsiFile[1];
        psiFileArray[0] = (PsiFile)EntityUtil.ra(() -> ((PsiClass)psiClass).getContainingFile());
        WriteCommandAction.writeCommandAction((Project)this.project, (PsiFile[])psiFileArray).withGroupId("Studio entity properties editor's write action").run(() -> {
            EntityModel entityModel = entityPsi.getModel();
            entityModel.setTable(name);
            this.checkTableAnnotation(entityModel, psiClass, Collections.emptyList());
        });
    }

    @Override
    public void setEntityName(EntityPsi entityPsi, String name) {
        PsiClass psiClass = entityPsi.getPsiClass();
        PsiFile[] psiFileArray = new PsiFile[1];
        psiFileArray[0] = (PsiFile)EntityUtil.ra(() -> ((PsiClass)psiClass).getContainingFile());
        WriteCommandAction.writeCommandAction((Project)this.project, (PsiFile[])psiFileArray).withGroupId("Studio entity properties editor's write action").run(() -> {
            EntityModel entityModel = entityPsi.getModel();
            entityModel.setName(name);
            this.checkEntityAnnotation(entityModel, entityPsi.getPsiClass(), Collections.emptyList());
        });
    }

    @Override
    public boolean isCommentedAttr(@NotNull PsiClass entityClass, @NotNull EntityAttributeModel attribute) {
        if (entityClass == null) {
            JavaEntityWriter.$$$reportNull$$$0(14);
        }
        if (attribute == null) {
            JavaEntityWriter.$$$reportNull$$$0(15);
        }
        StreamEx comments = StreamEx.of((Object[])entityClass.getChildren()).select(PsiComment.class);
        return comments.anyMatch(psiComment -> this.isCommentedAttr(psiComment.getText(), attribute));
    }

    private static void sortAttributes(Entity entity, PsiClass entityClass) {
        List<EntityAttribute> entityAttrs = entity.getAttributesWithField();
        List<PsiField> classAttrs = JavaEntityWriter.getAttributeFields(entityClass);
        for (int i = 0; i < entityAttrs.size(); ++i) {
            EntityAttribute entityAttr = entityAttrs.get(i);
            int sourceAttrIndex = JavaEntityWriter.attributeFieldIndex(classAttrs, entityAttr.getName());
            if (sourceAttrIndex == i || sourceAttrIndex < 0 || i >= classAttrs.size()) continue;
            PsiField classAttr = classAttrs.get(sourceAttrIndex);
            PsiField fieldToInsertBefore = classAttrs.get(i);
            JavaEntityWriter.moveFieldOfClass(entityClass, classAttr, fieldToInsertBefore);
            classAttrs = JavaEntityWriter.getAttributeFields(entityClass);
        }
    }

    private static void moveFieldOfClass(PsiClass entityClass, PsiField movingField, PsiField fieldToInsertBefore) {
        PsiElement copyField = movingField.copy();
        movingField.delete();
        entityClass.addBefore(copyField, (PsiElement)fieldToInsertBefore);
    }

    private static List<PsiField> getAttributeFields(PsiClass entityClass) {
        return Arrays.stream(entityClass.getFields()).filter(field -> !field.hasModifierProperty("static") && !field.hasModifierProperty("final")).collect(Collectors.toList());
    }

    private static int attributeFieldIndex(List<PsiField> attributes, String attributeName) {
        int i = 0;
        for (PsiField field : attributes) {
            if (attributeName.equals(field.getName())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected MethodImpl generateGetter(EntityAttribute attribute, Module module) {
        String name = attribute.getName();
        String upped = StringUtil.capitalize((String)name);
        String className = EntityWriterUtils.getTypeFqn(attribute);
        String collectionTypeFqn = JavaEntityWriter.getCollectionTypeFqn(attribute);
        String type = collectionTypeFqn != null ? collectionTypeFqn + "<" + className + ">" : className;
        Object impl = "";
        if (attribute.isTransient() && !attribute.isCreateField()) {
            String transientFqn = JpaAttributeAnnotation.Transient.getFqn(this.project, module);
            impl = (String)impl + "    @" + transientFqn + "\n";
            impl = (String)impl + String.format(GETTER_TEMPLATE, upped, null, type);
        } else {
            impl = (String)impl + String.format(GETTER_TEMPLATE, upped, name, type);
        }
        Method method = new Method();
        method.setType(type);
        method.setModifiers("public");
        method.setName("get" + upped);
        if (attribute.isTransient() && !attribute.isCreateField()) {
            method.getAnnotations().add(JpaAttributeAnnotation.Transient.name());
        }
        return new MethodImpl(method, (String)impl);
    }

    protected static MethodImpl generateSetter(Entity entity, EntityAttribute attribute, Project project) {
        String name = attribute.getName();
        String upped = StringUtil.capitalize((String)name);
        Object impl = "";
        String className = EntityWriterUtils.getTypeFqn(attribute);
        String collectionTypeFqn = JavaEntityWriter.getCollectionTypeFqn(attribute);
        ProjectState state = JpaPluginProjectConfig.getInstance(project).getState();
        String returnType = state.useBuilderSetters ? entity.getClassName() : "void";
        String type = collectionTypeFqn != null ? collectionTypeFqn + "<" + className + ">" : className;
        impl = (String)impl + JavaEntityWriter.getSetterImpl(project, name, type, entity.getClassName());
        Method method = new Method();
        method.setType(returnType);
        method.setName("set" + upped);
        method.setModifiers("public");
        method.setParamNames(new String[]{name});
        method.setSignature(new String[]{type});
        return new MethodImpl(method, (String)impl);
    }

    private String generateNewAttribute(EntityAttribute attribute) {
        StringBuilder result = new StringBuilder();
        String accessModifier = this.getAccessModifier() == FieldAccessModifier.PROTECTED ? "protected" : "private";
        Datatypes.CollectionDatatype collectionType = attribute.getCollectionType();
        if (!(attribute.isClass() && collectionType != null || attribute.isElementCollection())) {
            String type = !attribute.isEnum() ? EntityWriterUtils.getTypeFqn(attribute) : this.getTypeForEnumAttribute(attribute);
            if (attribute.getType() == Datatypes.BasicDatatype.Boolean && attribute.isMandatory()) {
                result.insert(0, String.format("%s %s %s = %s;", accessModifier, type, attribute.getName(), "false"));
            } else {
                result.insert(0, String.format("%s %s %s;", accessModifier, type, attribute.getName()));
            }
        } else if (collectionType != null) {
            result.insert(0, String.format("%s %s<%s> %s = %s;", accessModifier, collectionType.getFqn(), EntityWriterUtils.getTypeFqn(attribute), attribute.getName(), JavaEntityWriter.getCollectionInitializer(collectionType)));
        }
        return result.toString();
    }

    protected String getTypeForEnumAttribute(EntityAttribute attribute) {
        if (attribute.getType() instanceof EnumType) {
            return attribute.getType().getFqn();
        }
        throw new IllegalStateException("Entity attribute of the Enum type should have enum datatype");
    }

    protected abstract FieldAccessModifier getAccessModifier();

    protected List<String> generateNewAttributeAnnotations(EntityAttribute attr, Entity entity, PsiClass entityClass) {
        LinkedList<String> annotations = new LinkedList<String>();
        for (Annotation attrAnnotation : this.getAttrAnnotations().values()) {
            if (!attrAnnotation.isInsert(attr, entity)) continue;
            AnnotationModel annotationModel = attrAnnotation.generateModel(attr, entity, this.project);
            this.createConstants(attr, entity, annotationModel, entityClass);
            annotations.add(this.annotationRenderer.render(annotationModel));
        }
        if (!attr.getUnknownAnnotations().isEmpty()) {
            ArrayList<String> unknownAnnotations = new ArrayList<String>(attr.getUnknownAnnotations().values());
            Collections.reverse(unknownAnnotations);
            annotations.addAll(unknownAnnotations);
        }
        return annotations;
    }

    private static List<EntityAttribute> getFieldsToInsert(Entity entity, LinkedHashMap<EntityAttribute, PsiField> fieldsToModify) {
        ArrayList<EntityAttribute> fields = new ArrayList<EntityAttribute>();
        for (EntityAttribute attribute : entity.getAttributes()) {
            if (fieldsToModify.containsKey(attribute)) continue;
            fields.add(attribute);
        }
        return fields;
    }

    protected void modifyAttribute(Entity entity, PsiClass entityClass, EntityAttribute attribute, PsiField attrField, boolean isCommitUnknownType) {
        String newType;
        String oldName = attrField.getName();
        if (!isCommitUnknownType && attribute.isUnknownType() || !EntityDesignHelper.isValidAttribute(attribute)) {
            return;
        }
        PsiType attrType = attrField.getType();
        String oldType = attrType.getCanonicalText();
        this.modifyValue(attribute, oldType, attrField);
        String newName = attribute.getName();
        boolean methodsSignatureChanged = false;
        if (!oldName.equals(newName)) {
            methodsSignatureChanged = true;
            attrField.setName(newName);
        }
        if (!oldType.equals(newType = JavaEntityWriter.generateAttributeType(attribute, true))) {
            methodsSignatureChanged = true;
            PsiTypeElement typeElement = attrField.getTypeElement();
            log.assertTrue(typeElement != null, attrField.getClass());
            PsiTypeElement newTypeElement = this.elementFactory.createTypeElementFromText(newType, attrField.getContext());
            PsiElement replacedElement = typeElement.replace((PsiElement)newTypeElement);
            this.javaCodeStyleManager.shortenClassReferences(replacedElement);
        }
        if (!methodsSignatureChanged && (attribute.isEnum() || attribute.isDatatype())) {
            String getterName = "get" + StringUtil.capitalize((String)oldName);
            Method getterMethod = null;
            for (Method method : entity.getMethods()) {
                if (!getterName.equals(method.getName())) continue;
                getterMethod = method;
                break;
            }
            if (getterMethod != null && !EntityWriterUtils.getTypeFqn(attribute).equals(getterMethod.getType())) {
                methodsSignatureChanged = true;
            }
        }
        this.modifyExistingAnnotations(entity, attribute, (PsiModifierListOwner)attrField);
        this.addNewAnnotations(entity, attribute, (PsiModifierListOwner)attrField);
        if (methodsSignatureChanged) {
            StudioPropertyUtil.removeGetterMethods(entityClass, newName);
            StudioPropertyUtil.removeSetterMethods(entityClass, newName);
            this.generateGetterAndSetter(entity, entityClass, attribute, !attribute.isLombokGetter() && !entity.isLombokGetter(), !attribute.isLombokSetter() && !entity.isLombokSetter());
        } else {
            List<PsiMethod> getters = StudioPropertyUtil.getGetters(entityClass, newName);
            List<PsiMethod> setters = StudioPropertyUtil.getSetters(entityClass, newName);
            this.generateGetterAndSetter(entity, entityClass, attribute, getters.isEmpty() && !attribute.isLombokGetter() && !entity.isLombokGetter(), setters.isEmpty() && !attribute.isLombokSetter() && !entity.isLombokSetter());
        }
        if (attribute.isReadOnly() && !methodsSignatureChanged) {
            StudioPropertyUtil.removeSetterMethods(entityClass, attribute.getName());
        }
        if (!attribute.isReadOnly() && !methodsSignatureChanged && StudioPropertyUtil.getSetters(entityClass, attribute.getName()).isEmpty()) {
            ArrayList<MethodImpl> methods = new ArrayList<MethodImpl>();
            if (!attribute.isLombokSetter() && this.isGenerateSetters(entity)) {
                methods.add(JavaEntityWriter.generateSetter(entity, attribute, this.project));
            }
            this.insertMethods(entityClass, (Collection<MethodImpl>)methods);
        }
    }

    private void generateGetterAndSetter(Entity entity, PsiClass entityClass, EntityAttribute attribute, boolean generateGetter, boolean generateSetter) {
        LinkedList<String> newMethods = new LinkedList<String>();
        if (generateGetter) {
            MethodImpl getter = this.generateGetter(attribute, ModuleUtilCore.findModuleForPsiElement((PsiElement)entityClass));
            newMethods.add(getter.getImplementation());
            if (entity instanceof EntityModel) {
                entity.getMethods().add(getter.getMethod());
            }
        }
        if (generateSetter && !attribute.isReadOnly()) {
            MethodImpl setter = JavaEntityWriter.generateSetter(entity, attribute, this.project);
            newMethods.add(setter.getImplementation());
            if (entity instanceof EntityModel) {
                entity.getMethods().add(setter.getMethod());
            }
        }
        if (!newMethods.isEmpty()) {
            this.insertMethods(entityClass, (List<String>)newMethods);
        }
    }

    protected void insertMethods(PsiClass entityClass, Collection<MethodImpl> methods) {
        PsiField[] fields = entityClass.getFields();
        if (fields.length == 0) {
            return;
        }
        LinkedHashSet<String> toInsert = new LinkedHashSet<String>();
        for (MethodImpl methodImpl : methods) {
            if (entityClass.findMethodsByName(methodImpl.getMethod().getName(), false).length != 0) continue;
            toInsert.add(methodImpl.getImplementation());
        }
        for (String string : toInsert) {
            PsiMethod createdMethod = this.elementFactory.createMethodFromText(string.trim(), entityClass.getContext());
            entityClass.addAfter((PsiElement)createdMethod, (PsiElement)fields[fields.length - 1]);
        }
    }

    protected void insertMethods(PsiClass entityClass, List<String> newMethods, MethodInsertPosition position) {
        PsiField anchorMember = null;
        PsiField[] members = position == MethodInsertPosition.AFTER_FIELDS ? entityClass.getFields() : entityClass.getMethods();
        for (int i = members.length - 1; i >= 0; --i) {
            PsiField member = members[i];
            if (member instanceof LightElement) continue;
            anchorMember = member;
            break;
        }
        if (anchorMember == null && position == MethodInsertPosition.AFTER_METHODS) {
            this.insertMethods(entityClass, newMethods, MethodInsertPosition.AFTER_FIELDS);
            return;
        }
        for (String newMethod : newMethods) {
            PsiMethod createdMethod = this.elementFactory.createMethodFromText(newMethod.trim(), entityClass.getContext());
            PsiElement insertedMethod = entityClass.addAfter((PsiElement)createdMethod, (PsiElement)anchorMember);
            anchorMember = this.javaCodeStyleManager.shortenClassReferences(insertedMethod);
        }
    }

    public void insertMethods(PsiClass entityClass, List<String> newMethods) {
        this.insertMethods(entityClass, newMethods, MethodInsertPosition.AFTER_FIELDS);
    }

    @Override
    public List<String> getValidationAnnotationsText(Entity entity, EntityAttribute attr) {
        ArrayList<String> annotations = new ArrayList<String>();
        for (Annotation attrAnnotation : this.getAttrAnnotations().values()) {
            if (!(attrAnnotation instanceof AbstractConstraintAnnotation) || !attrAnnotation.isInsert(attr, entity)) continue;
            AnnotationModel annotationModel = attrAnnotation.generateModel(attr, entity, this.project);
            this.createConstants(attr, entity, annotationModel, entity.getPsiClass());
            annotations.add(this.annotationRenderer.render(annotationModel));
        }
        return annotations;
    }

    private void addNewAnnotations(Entity entity, EntityAttribute attr, PsiModifierListOwner modifierListOwner) {
        PsiModifierList modifierList = modifierListOwner.getModifierList();
        if (modifierList == null) {
            return;
        }
        ArrayList<String> annotations = new ArrayList<String>();
        for (Annotation attrAnnotation : this.getAttrAnnotations().values()) {
            String annotationName = attrAnnotation.getName();
            PsiAnnotation fieldAnn = StudioAnnotationUtil.findAnnotationBySimpleName(modifierListOwner, annotationName);
            if (fieldAnn != null || !attrAnnotation.isInsert(attr, entity)) continue;
            AnnotationModel annotationModel = attrAnnotation.generateModel(attr, entity, this.project);
            this.createConstants(attr, entity, annotationModel, entity.getPsiClass());
            annotations.add(this.annotationRenderer.render(annotationModel));
        }
        for (String annotation : annotations) {
            PsiAnnotation createdAnnotation = this.elementFactory.createAnnotationFromText(annotation, modifierListOwner.getContext());
            PsiAnnotation psiElement = this.addAnnotation(modifierList, createdAnnotation, true);
            this.javaCodeStyleManager.shortenClassReferences((PsiElement)psiElement);
        }
    }

    private void modifyExistingAnnotations(Entity entity, EntityAttribute attribute, PsiModifierListOwner modifierListOwner) {
        ArrayList<PsiField> modifiedConstants = new ArrayList<PsiField>();
        for (PsiAnnotation annotation : modifierListOwner.getAnnotations()) {
            String qualifiedName = annotation.getQualifiedName();
            if (qualifiedName == null) continue;
            String identifier = ClassUtil.extractClassName((String)qualifiedName);
            this.processingModifyExistingAnnotations(entity, attribute, annotation, identifier, modifiedConstants);
            this.additionalProcessingModifyExistingAnnotations(entity, attribute, annotation, identifier, modifiedConstants);
        }
    }

    private void additionalProcessingModifyExistingAnnotations(Entity entity, EntityAttribute attribute, PsiAnnotation annotation, String identifier, List<PsiField> modifiedConstants) {
        switch (identifier) {
            case "ReadOnly": {
                if (attribute.isReadOnly()) break;
                annotation.delete();
                break;
            }
            case "AttributeOverrides": {
                this.modifyAttributeOverrides(attribute, annotation);
                break;
            }
            case "AssociationOverrides": {
                this.modifyAssociationOverride(attribute, annotation);
                break;
            }
            case "JoinColumns": {
                this.modifyJoinColumns(attribute, annotation);
                break;
            }
            case "JoinTable": {
                if (attribute.getCardinality() != EntityAttribute.Cardinality.MANY_TO_MANY && attribute.getCardinality() != EntityAttribute.Cardinality.ONE_TO_MANY || attribute.getJoinTable() == JoinTable.NULL_ANNOTATION) {
                    annotation.delete();
                    break;
                }
                if (attribute.getCardinality() != EntityAttribute.Cardinality.MANY_TO_MANY || !attribute.isOwner()) break;
                this.modifyJoinTableAnnotation(entity, attribute, annotation, modifiedConstants);
            }
        }
    }

    private void modifyJoinTableAnnotation(Entity entityModel, EntityAttribute attribute, PsiAnnotation joinTableAnnotation, List<PsiField> modifiedConstants) {
        PsiClass entityClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)joinTableAnnotation, PsiClass.class);
        Entity entity = entityClass == null ? entityModel : EntityPsi.getInstance(entityClass);
        JoinTable jt = attribute.getJoinTable();
        if (attribute.getCardinality() != EntityAttribute.Cardinality.MANY_TO_MANY || jt == JoinTable.NULL_ANNOTATION) {
            joinTableAnnotation.delete();
        } else {
            JoinColumn defaultJoinColumn;
            JoinColumn defaultJoinColumn2;
            JoinColumn joinColumn;
            PsiAnnotation joinColumnAnn;
            Module module;
            Collection<PsiAnnotation> joinColumns;
            SpringImplicitNamingStrategy implicitNameStrategy = SpringImplicitNamingStrategy.getInstance(this.project);
            String defaultJoinTableName = implicitNameStrategy.determineJoinTableName(entity, attribute);
            if (jt.getName() != null && !jt.getName().equals(defaultJoinTableName) || joinTableAnnotation.findDeclaredAttributeValue("name") != null) {
                this.setAnnotationParameterValue(joinTableAnnotation, "name", jt.getName(), modifiedConstants);
            }
            if ((joinColumns = StudioAnnotationUtil.getArrayValueAnnotations(joinTableAnnotation, "inverseJoinColumns", JpaAttributeAnnotation.JoinColumn.getFqn(this.project, module = ModuleUtilCore.findModuleForPsiElement((PsiElement)joinTableAnnotation)))).size() > 1) {
                log.debug("Using several JoinColumn annotations is not supported yet");
                return;
            }
            if (joinColumns.size() == 1) {
                joinColumnAnn = joinColumns.iterator().next();
                joinColumn = jt.getFirstInverseJoinColumn();
                defaultJoinColumn2 = implicitNameStrategy.determineInverseJoinColumn(entity, attribute).get(0);
                this.modifyJoinColumn(joinColumnAnn, joinColumn, defaultJoinColumn2, modifiedConstants);
            } else {
                defaultJoinColumn = implicitNameStrategy.determineInverseJoinColumn(entity, attribute).get(0);
                joinColumn = jt.getFirstInverseJoinColumn();
                if (!(joinColumn.getName().isEmpty() || Objects.equals(joinColumn.getName(), JoinColumn.NULL_ANNOTATION.getName()) || Objects.equals(joinColumn.getName(), defaultJoinColumn.getName()))) {
                    this.addJoinColumnParameter("inverseJoinColumns", joinColumn.getName(), (PsiElement)joinTableAnnotation);
                }
            }
            joinColumns = StudioAnnotationUtil.getArrayValueAnnotations(joinTableAnnotation, "joinColumns", JpaAttributeAnnotation.JoinColumn.getFqn(this.project, module));
            if (joinColumns.size() > 1) {
                log.debug("Using several JoinColumn annotations is not supported yet");
            } else if (joinColumns.size() == 1) {
                joinColumnAnn = joinColumns.iterator().next();
                joinColumn = jt.getFirstJoinColumn();
                defaultJoinColumn2 = implicitNameStrategy.determineJoinColumnName(entity, attribute).get(0);
                this.modifyJoinColumn(joinColumnAnn, joinColumn, defaultJoinColumn2, modifiedConstants);
            } else {
                defaultJoinColumn = implicitNameStrategy.determineJoinColumnName(entity, attribute).get(0);
                joinColumn = jt.getFirstJoinColumn();
                if (!(joinColumn.getName().isEmpty() || Objects.equals(joinColumn.getName(), JoinColumn.NULL_ANNOTATION.getName()) || Objects.equals(joinColumn.getName(), defaultJoinColumn.getName()))) {
                    this.addJoinColumnParameter("joinColumns", joinColumn.getName(), (PsiElement)joinTableAnnotation);
                }
            }
        }
    }

    private void addJoinColumnParameter(String paramName, String joinColumnName, PsiElement mainAnnotation) {
        AnnotationModel annotationModel = AnnotationModel.builder(FqnResolverManagerKt.getJpaFqn(this.project, ModuleUtilCore.findModuleForPsiElement((PsiElement)mainAnnotation), JpaAttributeAnnotation.JoinColumn)).add("name", joinColumnName).build();
        AnnotationAppender annotationAppender = (AnnotationAppender)AnnotationAppender.Companion.getInstance(mainAnnotation);
        if (annotationAppender != null) {
            annotationAppender.addAnnotationParameterValue(mainAnnotation, paramName, annotationModel.toString());
        }
    }

    private void modifyJoinColumn(PsiAnnotation joinColumnAnn, JoinColumn joinColumn, JoinColumn defaultJoinColumn, List<PsiField> modifiedConstants) {
        String referencedColumnAttributeName = "referencedColumnName";
        String nameAttributeName = "name";
        if (joinColumnAnn.findDeclaredAttributeValue(referencedColumnAttributeName) != null && !Strings.isNullOrEmpty((String)joinColumn.getReferencedColumnName())) {
            this.setAnnotationParameterValue(joinColumnAnn, referencedColumnAttributeName, joinColumn.getReferencedColumnName(), modifiedConstants);
        } else {
            joinColumnAnn.setDeclaredAttributeValue(referencedColumnAttributeName, null);
        }
        if (!(Strings.isNullOrEmpty((String)joinColumn.getName()) || joinColumnAnn.findDeclaredAttributeValue(nameAttributeName) == null && StringUtils.equals((CharSequence)defaultJoinColumn.getName(), (CharSequence)joinColumn.getName()))) {
            this.setAnnotationParameterValue(joinColumnAnn, nameAttributeName, joinColumn.getName(), modifiedConstants);
        } else {
            joinColumnAnn.setDeclaredAttributeValue(nameAttributeName, null);
        }
    }

    private void modifyJoinColumns(EntityAttribute attribute, PsiAnnotation annotation) {
        List<PsiAnnotation> joinColumnAnnotations;
        if (!(attribute.getType() instanceof Entity) || !(EntityDesignHelper.getIdDataType((Entity)attribute.getType()) instanceof Entity) || attribute.getJoinColumns().isEmpty()) {
            annotation.delete();
            return;
        }
        List<JoinColumn> sourceJoinColumns = AttributeUtil.getJoinColumnModels(annotation, "value");
        LinkedHashMap<String, String> actualJoinColumns = attribute.getJoinColumns();
        LinkedHashMap<String, Object> toCreate = new LinkedHashMap<String, Object>();
        LinkedHashMap<String, String> toModify = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> toRemove = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> checked = new LinkedHashMap<String, String>();
        boolean isModifyNullable = attribute.isMandatory() != sourceJoinColumns.stream().anyMatch(joinColumn -> !joinColumn.isNullable());
        for (JoinColumn joinColumn2 : sourceJoinColumns) {
            String referencedName = joinColumn2.getReferencedColumnName();
            String name = joinColumn2.getName();
            if (!actualJoinColumns.containsValue(referencedName)) {
                toRemove.put(name, referencedName);
                continue;
            }
            if (!Strings.nullToEmpty((String)JpaUtils.getKeyFromValue(actualJoinColumns, referencedName)).equals(name) || isModifyNullable) {
                toModify.put(name, referencedName);
                continue;
            }
            checked.put(name, referencedName);
        }
        for (Object referencedColumnName : actualJoinColumns.values()) {
            if (checked.containsValue(referencedColumnName) || toModify.containsValue(referencedColumnName) || toRemove.containsValue(referencedColumnName)) continue;
            toCreate.put(JpaUtils.getKeyFromValue(actualJoinColumns, (String)referencedColumnName), referencedColumnName);
        }
        if (!toRemove.isEmpty()) {
            joinColumnAnnotations = this.getJoinColumnNodes(annotation, toRemove.values());
            for (PsiAnnotation joinColumnAnn : joinColumnAnnotations) {
                joinColumnAnn.delete();
            }
        }
        if (!toCreate.isEmpty()) {
            PsiArrayInitializerMemberValue arrayInitializer = null;
            PsiAnnotationMemberValue annValue = annotation.findAttributeValue("value");
            if (annValue instanceof PsiArrayInitializerMemberValue) {
                arrayInitializer = (PsiArrayInitializerMemberValue)annValue;
            }
            if (arrayInitializer != null) {
                PsiElement[] children = arrayInitializer.getChildren();
                for (Map.Entry entry : toCreate.entrySet()) {
                    String joinColumnSource = this.annotationRenderer.render(JoinColumnsAnnotation.generateJoinColumnAnnotationModel((String)entry.getKey(), (String)entry.getValue(), attribute.isMandatory(), this.project, ModuleUtilCore.findModuleForPsiElement((PsiElement)annotation)));
                    PsiAnnotation createdAnn = this.elementFactory.createAnnotationFromText(joinColumnSource, annotation.getContext());
                    PsiAnnotationMemberValue[] initializers = arrayInitializer.getInitializers();
                    PsiElement anchor = children.length > 1 ? children[1] : null;
                    arrayInitializer.addAfter((PsiElement)createdAnn, (PsiElement)(initializers.length > 0 ? initializers[initializers.length - 1] : anchor));
                }
            }
        }
        if (!toModify.isEmpty()) {
            joinColumnAnnotations = this.getJoinColumnNodes(annotation, toModify.values());
            for (PsiAnnotation joinColumn3 : joinColumnAnnotations) {
                String referencedColumnName = AnnotationUtil.getStringAttributeValue((PsiAnnotation)joinColumn3, (String)"referencedColumnName");
                String string = AnnotationHelper.wrap(JpaUtils.getKeyFromValue(actualJoinColumns, referencedColumnName));
                joinColumn3.setDeclaredAttributeValue("name", (PsiAnnotationMemberValue)this.elementFactory.createExpressionFromText(string, joinColumn3.getContext()));
                joinColumn3.setDeclaredAttributeValue("nullable", attribute.isMandatory() ? this.elementFactory.createExpressionFromText("false", joinColumn3.getContext()) : null);
            }
        }
    }

    private List<PsiAnnotation> getJoinColumnNodes(PsiAnnotation annotation, Collection<String> referencedColumnNames) {
        LinkedList<PsiAnnotation> joinColumnNodes = new LinkedList<PsiAnnotation>();
        Collection<PsiAnnotation> joinColumns = StudioAnnotationUtil.getArrayValueAnnotations(annotation, "value", JpaAttributeAnnotation.JoinColumn.getFqn(this.project, ModuleUtilCore.findModuleForPsiElement((PsiElement)annotation)));
        for (PsiAnnotation joinColumnAnn : joinColumns) {
            String name = AnnotationUtil.getStringAttributeValue((PsiAnnotation)joinColumnAnn, (String)"referencedColumnName");
            if (!referencedColumnNames.contains(name)) continue;
            joinColumnNodes.add(joinColumnAnn);
        }
        return joinColumnNodes;
    }

    private void modifyAssociationOverride(EntityAttribute attribute, PsiAnnotation annotation) {
        if (attribute.getMappingType() != EntityAttribute.MappingType.EMBEDDED || attribute.getAttributeOverrides(true).isEmpty()) {
            annotation.delete();
        } else {
            this.modifyAttributeOrAssociationOverrides(attribute, annotation, true);
        }
    }

    private void modifyAttributeOverrides(EntityAttribute attribute, PsiAnnotation annotation) {
        if (attribute.getMappingType() != EntityAttribute.MappingType.EMBEDDED || attribute.getAttributeOverrides(false).isEmpty()) {
            annotation.delete();
        } else {
            this.modifyAttributeOrAssociationOverrides(attribute, annotation, false);
        }
    }

    private void modifyAttributeOrAssociationOverrides(EntityAttribute attribute, PsiAnnotation annotation, boolean isAssociation) {
        List<PsiAnnotation> attributeOverrideAnnotations;
        Map<String, String> sourceOverrides = EntityUtil.getAttributeOverrides(annotation, isAssociation);
        Map<String, String> actualOverrides = attribute.getAttributeOverrides(isAssociation).stream().collect(Collectors.toMap(a -> a.getName(), a -> a.getColumn()));
        LinkedHashMap<String, String> toCreate = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> toRemove = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> toModify = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> checked = new LinkedHashMap<String, String>();
        for (Map.Entry<String, String> entry : sourceOverrides.entrySet()) {
            if (!actualOverrides.containsKey(entry.getKey())) {
                toRemove.put(entry.getKey(), entry.getValue());
                continue;
            }
            if (!Strings.nullToEmpty((String)actualOverrides.get(entry.getKey())).equals(entry.getValue())) {
                toModify.put(entry.getKey(), entry.getValue());
                continue;
            }
            checked.put(entry.getKey(), entry.getValue());
        }
        for (String string : actualOverrides.keySet()) {
            if (checked.containsKey(string) || toModify.containsKey(string) || toRemove.containsKey(string)) continue;
            toCreate.put(string, actualOverrides.get(string));
        }
        if (!toRemove.isEmpty()) {
            attributeOverrideAnnotations = this.getAttributeOverrideNodes(annotation, toRemove.keySet(), isAssociation);
            for (PsiAnnotation attributeOverrideAnn : attributeOverrideAnnotations) {
                attributeOverrideAnn.delete();
            }
        }
        if (!toCreate.isEmpty()) {
            PsiArrayInitializerMemberValue arrayInitializer = null;
            PsiAnnotationMemberValue psiAnnotationMemberValue = annotation.findAttributeValue("value");
            if (psiAnnotationMemberValue instanceof PsiArrayInitializerMemberValue) {
                arrayInitializer = (PsiArrayInitializerMemberValue)psiAnnotationMemberValue;
            }
            if (arrayInitializer != null) {
                Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)annotation);
                for (Map.Entry e : toCreate.entrySet()) {
                    AnnotationModel model2 = isAssociation ? AssociationOverridesAnnotation.generateAssociationOverrideModel((String)e.getKey(), (String)e.getValue(), this.project, module) : AttributeOverridesAnnotation.generateAttributeOverrideModel((String)e.getKey(), (String)e.getValue(), this.project, module);
                    PsiAnnotation createdAnn = this.elementFactory.createAnnotationFromText(this.annotationRenderer.render(model2), annotation.getContext());
                    PsiAnnotationMemberValue[] initializers = arrayInitializer.getInitializers();
                    PsiElement anchor = initializers.length > 0 ? initializers[initializers.length - 1] : arrayInitializer.getFirstChild();
                    arrayInitializer.addAfter((PsiElement)createdAnn, anchor);
                }
            }
        }
        if (!toModify.isEmpty()) {
            attributeOverrideAnnotations = this.getAttributeOverrideNodes(annotation, toModify.keySet(), isAssociation);
            for (PsiAnnotation attributeOverrideAnn : attributeOverrideAnnotations) {
                String columnIdent;
                PsiAnnotationMemberValue columnAnn = attributeOverrideAnn.findAttributeValue(columnIdent = isAssociation ? "joinColumns" : "column");
                if (!(columnAnn instanceof PsiAnnotation)) continue;
                String name = AnnotationUtil.getStringAttributeValue((PsiAnnotation)attributeOverrideAnn, (String)"name");
                String columnName = actualOverrides.get(name);
                ((PsiAnnotation)columnAnn).setDeclaredAttributeValue("name", (PsiAnnotationMemberValue)this.elementFactory.createExpressionFromText(AnnotationHelper.wrap(columnName), attributeOverrideAnn.getContext()));
            }
        }
    }

    private List<PsiAnnotation> getAttributeOverrideNodes(PsiAnnotation annotation, Set<String> names, boolean isAssociation) {
        LinkedList<PsiAnnotation> attributeOverrideNodes = new LinkedList<PsiAnnotation>();
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)annotation);
        String annFqn = isAssociation ? JpaAttributeAnnotation.AssociationOverride.getFqn(this.project, module) : JpaAttributeAnnotation.AttributeOverride.getFqn(this.project, module);
        Collection<PsiAnnotation> overrides = StudioAnnotationUtil.getArrayValueAnnotations(annotation, "value", annFqn);
        for (PsiAnnotation overrideAnn : overrides) {
            String name = AnnotationUtil.getStringAttributeValue((PsiAnnotation)overrideAnn, (String)"name");
            if (!names.contains(name)) continue;
            attributeOverrideNodes.add(overrideAnn);
        }
        return attributeOverrideNodes;
    }

    private void processingModifyExistingAnnotations(Entity entity, EntityAttribute attribute, PsiAnnotation annotation, String identifier, List<PsiField> modifiedConstants) {
        Annotation currAnnotation = this.getAttrAnnotations().get(identifier);
        if (currAnnotation == null || !currAnnotation.isModify()) {
            return;
        }
        if (currAnnotation.isInsert(attribute, entity)) {
            LinkedHashMap<String, String> existingParams = JavaEntityWriter.getExistingParams(annotation);
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)annotation);
            AnnotationModel model2 = currAnnotation.generateModel(attribute, entity, this.project);
            JavaEntityWriter.updateConstants(annotation, attribute, currAnnotation, modifiedConstants, model2);
            this.createConstants(attribute, entity, model2, (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)annotation, PsiClass.class));
            LinkedHashMap<String, String> generateParams = JavaEntityWriter.getAnnotationParams(attribute, currAnnotation, this.shortNamesAnnotationRenderer, model2);
            if (!currAnnotation.isChangeParams(attribute, existingParams, generateParams, module)) {
                return;
            }
            String code = this.annotationRenderer.render(currAnnotation.generateModel(attribute, entity, JavaEntityWriter.getAnnotationParams(attribute, currAnnotation, this.annotationRenderer, model2), this.project));
            PsiAnnotation newAnnotation = this.elementFactory.createAnnotationFromText(code, annotation.getContext());
            annotation.replace((PsiElement)newAnnotation);
        } else {
            annotation.delete();
        }
    }

    private static LinkedHashMap<String, String> getAnnotationParams(EntityAttribute attribute, Annotation currAnnotation, AnnotationRenderer annotationRenderer, AnnotationModel model2) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        for (Map.Entry<String, AnnotationParameter> parameterEntry : model2.getParameters().entrySet()) {
            StringBuilder builder = new StringBuilder();
            annotationRenderer.renderParameter(builder, parameterEntry.getValue(), model2.getParameters().size() == 1);
            result.put(parameterEntry.getKey(), builder.toString());
        }
        Map<String, String> unknownParams = attribute.getAnnotationUnknownParams(currAnnotation.getName());
        result.putAll(unknownParams);
        return result;
    }

    private static void updateConstants(PsiAnnotation annotation, EntityAttribute attribute, Annotation currAnnotation, List<PsiField> modifiedConstants, AnnotationModel model2) {
        if (currAnnotation instanceof AnnotationWithConstants) {
            AnnotationWithConstants annotationWithConstants = (AnnotationWithConstants)currAnnotation;
            PsiField field = (PsiField)PsiTreeUtil.getParentOfType((PsiElement)annotation, PsiField.class);
            model2.getConstantsToUpdate().forEach(ctu -> {
                String newValue;
                PsiLiteralExpressionImpl literalExpression;
                if (field != null && !modifiedConstants.contains(field) && annotationWithConstants.isConstantValueChanged(ctu.getAttributeName(), attribute, field) && (literalExpression = (PsiLiteralExpressionImpl)PsiTreeUtil.getChildOfType((PsiElement)ctu.getConstantElement(), PsiLiteralExpressionImpl.class)) != null && (newValue = annotationWithConstants.getConstantValue(ctu.getAttributeName(), attribute)) != null) {
                    literalExpression.updateText("\"" + newValue + "\"");
                    modifiedConstants.add(field);
                }
            });
        }
    }

    private void createConstants(EntityAttribute attribute, Entity entity, AnnotationModel annotationModel, PsiClass entityClass) {
        this.createConstants(attribute, entity, annotationModel, entityClass, null);
    }

    private void createConstants(EntityAttribute attribute, Entity entity, AnnotationModel annotationModel, PsiClass entityClass, String prefix) {
        if (!annotationModel.getConstantsToCreate().isEmpty()) {
            annotationModel.getConstantsToCreate().forEach(cta -> {
                String attributeName = cta.getAttributeName();
                AnnotationParameter annotationParameter = annotationModel.getParameters().get(attributeName);
                if (annotationParameter instanceof StringParameter) {
                    PsiClass containingClass;
                    PsiField psiField;
                    String newValue = ((StringParameter)annotationParameter).getValue();
                    if (!((StringParameter)annotationParameter).getNeedWrap()) {
                        newValue = newValue.substring(1, newValue.length() - 1);
                    }
                    Object annotationName = StringUtil.substringAfterLast((String)annotationModel.getFqn(), (String)".");
                    if (prefix != null) {
                        annotationName = prefix + "_" + (String)annotationName;
                    }
                    if ((psiField = EntityConstantWriter.getInstance(this.project).addAttributeConstant((String)annotationName, attributeName, attribute, newValue, entity)) != null && (containingClass = psiField.getContainingClass()) != null) {
                        String name = containingClass.equals(entityClass) ? psiField.getName() : containingClass.getQualifiedName() + "." + psiField.getName();
                        annotationModel.getParameters().put(attributeName, new StringParameter(name, false));
                    }
                }
            });
        }
        for (Map.Entry<String, AnnotationParameter> entry : annotationModel.getParameters().entrySet()) {
            AnnotationParameter value = entry.getValue();
            if (value instanceof ArrayParameter) {
                StreamEx.of(((ArrayParameter)value).getValue()).select(AnnotationModel.class).forEach(arrayParam -> this.createConstants(attribute, entity, (AnnotationModel)arrayParam, entityClass, (String)entry.getKey()));
                continue;
            }
            if (!(value instanceof AnnotationModel)) continue;
            this.createConstants(attribute, entity, (AnnotationModel)value, entityClass);
        }
    }

    private static LinkedHashMap<String, String> getExistingParams(PsiAnnotation annotation) {
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        for (PsiNameValuePair valuePair : annotation.getParameterList().getAttributes()) {
            PsiAnnotationMemberValue value = valuePair.getValue();
            if (value == null) continue;
            params.put(valuePair.getName(), value.getText());
        }
        return params;
    }

    private void modifyValue(EntityAttribute attribute, String oldSimpleType, PsiField field) {
        Datatype type = attribute.getType();
        if (type == Datatypes.BasicDatatype.Boolean && attribute.isMandatory()) {
            this.insertAttributeValue("false", field);
        } else {
            if (attribute.getCollectionTypeFqn() == null) {
                JavaEntityWriter.checkOldCollectionType(field);
            }
            if (type != Datatypes.BasicDatatype.Boolean && Datatypes.BasicDatatype.Boolean.getFqn().equals(oldSimpleType)) {
                JavaEntityWriter.removeAttributeValue(field);
            }
        }
    }

    private static void checkOldCollectionType(PsiField field) {
        PsiType type;
        PsiExpression initializer = field.getInitializer();
        if (initializer != null && (type = initializer.getType()) != null && type.getCanonicalText().contains("<")) {
            JavaEntityWriter.removeAttributeValue(field);
        }
    }

    private static void removeAttributeValue(PsiField field) {
        PsiExpression initializer = field.getInitializer();
        if (initializer != null) {
            field.setInitializer(null);
        }
    }

    private void insertCollectionValue(Datatypes.CollectionDatatype datatype, PsiField psiField) {
        this.insertAttributeValue(JavaEntityWriter.getCollectionInitializer(datatype), psiField, true);
    }

    private static String getCollectionInitializer(Datatypes.CollectionDatatype datatype) {
        Object value = "new ";
        switch (datatype) {
            case Collection: 
            case List: {
                value = (String)value + "java.util.ArrayList<>()";
                break;
            }
            case Set: 
            case LinkedHashSet: {
                value = (String)value + "java.util.LinkedHashSet<>()";
                break;
            }
            case Map: {
                value = (String)value + "java.util.HashMap<>()";
            }
        }
        return value;
    }

    private void insertAttributeValue(String value, PsiField field) {
        this.insertAttributeValue(value, field, false);
    }

    private void insertAttributeValue(String value, PsiField field, Boolean override) {
        PsiExpression initializer;
        if (!Strings.isNullOrEmpty((String)value) && ((initializer = field.getInitializer()) == null || override.booleanValue())) {
            PsiExpression expressionFromText = this.elementFactory.createExpressionFromText(value, null);
            field.setInitializer(expressionFromText);
        }
    }

    private static LinkedHashMap<EntityAttribute, PsiField> getExistingFields(List<EntityAttribute> entityAttributes, PsiClass entityClass) {
        PsiField[] fields = entityClass.getFields();
        LinkedHashMap<EntityAttribute, PsiField> fieldMap = new LinkedHashMap<EntityAttribute, PsiField>(fields.length);
        for (int i = fields.length - 1; i >= 0; --i) {
            PsiField field = fields[i];
            String fieldName = field.getName();
            if (StringUtils.isBlank((CharSequence)fieldName)) continue;
            StreamEx.of(entityAttributes).findFirst(attribute -> attribute.getName().equals(fieldName)).ifPresent(attr -> fieldMap.put((EntityAttribute)attr, field));
        }
        return fieldMap;
    }

    private void deleteUnusedFields(Entity entity, PsiClass entityClass) {
        for (PsiField field : entityClass.getFields()) {
            if (this.shouldNotBeDeleted(field, entity)) continue;
            JavaEntityWriter.removeFieldAndRelatedMethods(entity, entityClass, field);
        }
    }

    private static void removeFieldAndRelatedMethods(Entity entity, PsiClass entityClass, PsiField field) {
        String fieldName = field.getName();
        if (StringUtils.isBlank((CharSequence)fieldName)) {
            return;
        }
        if (!entity.hasAttribute(fieldName)) {
            StudioPropertyUtil.removeGetterMethods(entityClass, fieldName);
            StudioPropertyUtil.removeSetterMethods(entityClass, fieldName);
            field.delete();
        }
    }

    protected boolean shouldNotBeDeleted(PsiField field, Entity entity) {
        PsiAnnotation[] annotations = field.getAnnotations();
        return JavaEntityWriter.isStatic(field) || JavaEntityWriter.isFinal(field) || JavaEntityWriter.isTransient(field) || annotations.length == 1 && EntityUtil.hasAnnotation((PsiModifierListOwner)field, JpaAttributeAnnotation.Transient.getFqn(this.project, ModuleUtilCore.findModuleForPsiElement((PsiElement)field)));
    }

    private static boolean isStatic(PsiField field) {
        return field.hasModifierProperty("static");
    }

    private static boolean isFinal(PsiField field) {
        return field.hasModifierProperty("final");
    }

    private static boolean isTransient(PsiField field) {
        return field.hasModifierProperty("transient");
    }

    protected void entityAnnotationsToPsi(Entity entity, PsiClass psiClass, @NotNull PsiModifierList modifierList) {
        if (modifierList == null) {
            JavaEntityWriter.$$$reportNull$$$0(16);
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiClass);
        ArrayList<PsiField> modifiedConstants = new ArrayList<PsiField>();
        this.checkEntityAnnotation(entity, psiClass, modifiedConstants);
        this.checkMappedSuperclassAnnotation(entity, psiClass, module);
        this.checkImmutableAnnotation(entity, psiClass);
        this.checkTableAnnotation(entity, psiClass, modifiedConstants);
        this.checkTypeDefAnnotation(entity, psiClass);
        this.checkDiscriminatorAnnotation(entity, psiClass, modifierList, module);
        this.checkEmbeddableAnnotation(entity, psiClass, modifierList, module);
        this.checkInheritanceAnnotations(entity, psiClass);
        this.checkAttributeOverrideAnnotation(entity, psiClass, module);
        this.checkNamedQueriesAnnotation(entity, psiClass, module);
        this.updateSequenceGeneratorAnnotation(entity.getSequenceGenerator(), psiClass, module);
        this.checkHibernateEnversAuditedAnnotation(entity, psiClass);
        this.addCommentAnnotation(entity, psiClass);
        this.setIdClass(psiClass, entity.getIdClassFqn());
    }

    @Override
    public void setAttributeLength(@NotNull PsiMember member, @Nullable String length) {
        PsiModifierList modifierList;
        if (member == null) {
            JavaEntityWriter.$$$reportNull$$$0(17);
        }
        if ((modifierList = member.getModifierList()) == null) {
            return;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)member);
        PsiAnnotation columnAnnotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)member, (String[])new String[]{JpaAttributeAnnotation.Column.getFqn(this.project, module)});
        PsiAnnotation lobAnnotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)member, (String[])new String[]{JpaAttributeAnnotation.Lob.getFqn(this.project, module)});
        if (StringUtil.isEmpty((String)length)) {
            if (columnAnnotation != null) {
                this.setAnnotationValue(columnAnnotation, "length", null);
            }
            if (lobAnnotation == null) {
                this.addAnnotation(modifierList, JpaAttributeAnnotation.Lob.getFqn(this.project, module));
            }
        } else {
            if (lobAnnotation != null) {
                lobAnnotation.delete();
            }
            if (columnAnnotation == null) {
                columnAnnotation = this.addAnnotation(modifierList, JpaAttributeAnnotation.Lob.getFqn(this.project, module));
            }
            this.setAnnotationValue(columnAnnotation, "length", length);
        }
    }

    protected void checkAttributeOverrideAnnotation(Entity entity, PsiClass entityClass, Module module) {
        if (entity.getAttributeOverrides().isEmpty()) {
            return;
        }
        PsiAnnotation ann = AnnotationUtil.findAnnotation((PsiModifierListOwner)entityClass, (String[])new String[]{JpaAttributeAnnotation.AttributeOverrides.getFqn(this.project, module)});
        if (ann == null) {
            List<PsiAnnotation> annotations = Arrays.asList(AnnotationUtil.findAnnotations((PsiModifierListOwner)entityClass, Collections.singleton(JpaAttributeAnnotation.AttributeOverride.getFqn(this.project, module))));
            annotations.forEach(PsiElement::delete);
            ann = this.elementFactory.createAnnotationFromText(this.generateAttributeOverridesAnnotation(entity, module), entityClass.getContext());
            this.addAnnotation((PsiModifierListOwner)entityClass, ann);
        }
    }

    private String generateAttributeOverridesAnnotation(Entity entity, Module module) {
        ArrayList<AnnotationModel> overrides = new ArrayList<AnnotationModel>();
        for (AttributeOverride attributeOverride : entity.getAttributeOverrides()) {
            AnnotationModel annotationModel = AttributeOverridesAnnotation.generateAttributeOverrideModel(attributeOverride, this.project, module);
            overrides.add(annotationModel);
        }
        AnnotationModel model2 = AnnotationModel.builder(JpaAttributeAnnotation.AttributeOverrides.getFqn(this.project, module)).add("value", new ArrayParameter(overrides).multiline()).build();
        return this.annotationRenderer.render(model2);
    }

    protected void checkInheritanceAnnotations(Entity entity, PsiClass entityClass) {
        HashSet<String> annotations = new HashSet<String>();
        this.checkInheritanceAnnotation(entity, entityClass, annotations);
        this.checkDiscriminatorColumnAnnotation(entity, entityClass, annotations);
        this.checkPrimaryKeyAnnotation(entity, entityClass, annotations);
        for (String annotation : annotations) {
            PsiAnnotation cratedAnn = this.elementFactory.createAnnotationFromText(annotation, entityClass.getContext());
            this.javaCodeStyleManager.shortenClassReferences((PsiElement)this.addAnnotation((PsiModifierListOwner)entityClass, cratedAnn));
        }
    }

    private void checkPrimaryKeyAnnotation(Entity entity, PsiClass entityClass, Set<String> annotations) {
        Project project = entityClass.getProject();
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)entityClass);
        PsiAnnotation primaryKeyAnn = AnnotationUtil.findAnnotation((PsiModifierListOwner)entityClass, (String[])new String[]{JpaEntityAnnotation.PrimaryKeyJoinColumn.getFqn(project, module)});
        if (primaryKeyAnn != null) {
            boolean unused = true;
            if (!Strings.isNullOrEmpty((String)entity.getPrimaryKeyJoinColumnName())) {
                unused = false;
                this.setAnnotationStringValue(primaryKeyAnn, "name", entity.getPrimaryKeyJoinColumnName());
            } else {
                primaryKeyAnn.setDeclaredAttributeValue("name", null);
            }
            if (!Strings.isNullOrEmpty((String)entity.getPrimaryKeyReferencedColumnName())) {
                unused = false;
                this.setAnnotationStringValue(primaryKeyAnn, "referencedColumnName", entity.getPrimaryKeyReferencedColumnName());
            } else {
                primaryKeyAnn.setDeclaredAttributeValue("referencedColumnName", null);
            }
            if (!Strings.isNullOrEmpty((String)entity.getPrimaryKeyColumnDefinition())) {
                unused = false;
                this.setAnnotationStringValue(primaryKeyAnn, "columnDefinition", entity.getPrimaryKeyColumnDefinition());
            } else {
                primaryKeyAnn.setDeclaredAttributeValue("columnDefinition", null);
            }
            if (unused) {
                primaryKeyAnn.delete();
            }
        } else {
            LinkedList<Object> params = new LinkedList<Object>();
            if (!Strings.isNullOrEmpty((String)entity.getPrimaryKeyJoinColumnName())) {
                params.add("name");
                params.add("\"" + entity.getPrimaryKeyJoinColumnName() + "\"");
            }
            if (!Strings.isNullOrEmpty((String)entity.getPrimaryKeyReferencedColumnName())) {
                params.add("referencedColumnName");
                params.add("\"" + entity.getPrimaryKeyReferencedColumnName() + "\"");
            }
            if (!params.isEmpty()) {
                annotations.add(AnnotationHelper.formatAnnotation(JpaEntityAnnotation.PrimaryKeyJoinColumn.getFqn(project, module), params.toArray()));
            }
        }
    }

    protected void checkDiscriminatorColumnAnnotation(Entity entity, PsiClass entityClass, Set<String> annotations) {
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)entityClass);
        PsiAnnotation discColumnAnn = AnnotationUtil.findAnnotation((PsiModifierListOwner)entityClass, (String[])new String[]{JpaEntityAnnotation.DiscriminatorColumn.getFqn(this.project, module)});
        String discriminatorColumnName = entity.getDiscriminatorColumnName();
        Entity.DiscriminatorType discriminatorType = entity.getDiscriminatorType();
        String discriminatorLength = entity.getDiscriminatorLength();
        if (discColumnAnn != null) {
            boolean unused = true;
            if (!Strings.isNullOrEmpty((String)discriminatorColumnName) && !discriminatorColumnName.equals("DTYPE")) {
                unused = false;
                this.setAnnotationStringValue(discColumnAnn, "name", discriminatorColumnName);
            } else {
                discColumnAnn.setDeclaredAttributeValue("name", null);
            }
            if (!discriminatorLength.equals("31")) {
                unused = false;
            }
            if (discriminatorType != null) {
                if (discriminatorType != Entity.DiscriminatorType.getDefault()) {
                    unused = false;
                    this.setAnnotationValue(discColumnAnn, "discriminatorType", JpaEnum.DiscriminatorType.getEnumEntryFqn(this.project, module, discriminatorType.toString()), true);
                }
            } else if (!unused) {
                this.setAnnotationValue(discColumnAnn, "discriminatorType", null, true);
            }
            if (unused) {
                discColumnAnn.delete();
            } else if (!"31".equals(discriminatorLength)) {
                this.setAnnotationValue(discColumnAnn, "length", discriminatorLength);
            } else {
                discColumnAnn.setDeclaredAttributeValue("length", null);
            }
        } else {
            LinkedList<Object> params = new LinkedList<Object>();
            if (!Strings.isNullOrEmpty((String)discriminatorColumnName) && !discriminatorColumnName.equals("DTYPE")) {
                params.add("name");
                params.add("\"" + discriminatorColumnName + "\"");
            }
            if (discriminatorType != null && discriminatorType != Entity.DiscriminatorType.STRING) {
                params.add("discriminatorType");
                params.add(JpaEnum.DiscriminatorType.getEnumEntryFqn(this.project, module, entity.getDiscriminatorType().toString()));
            }
            if (!discriminatorLength.equals("31")) {
                params.add("length");
                params.add(discriminatorLength);
            }
            if (!params.isEmpty()) {
                annotations.add(AnnotationHelper.formatAnnotation(JpaEntityAnnotation.DiscriminatorColumn.getFqn(this.project, module), params.toArray()));
            }
        }
    }

    private void checkInheritanceAnnotation(Entity entity, PsiClass entityClass, Set<String> annotations) {
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)entityClass);
        PsiAnnotation inheritanceAnn = AnnotationUtil.findAnnotation((PsiModifierListOwner)entityClass, (String[])new String[]{JpaEntityAnnotation.Inheritance.getFqn(this.project, module)});
        if (inheritanceAnn != null) {
            if (entity.getInheritanceType() != null) {
                this.setAnnotationValue(inheritanceAnn, "strategy", JpaEnum.InheritanceType.getEnumEntryFqn(this.project, module, entity.getInheritanceType().name()));
            } else {
                inheritanceAnn.delete();
            }
        } else if (entity.getInheritanceType() != null) {
            annotations.add(AnnotationHelper.formatAnnotation(JpaEntityAnnotation.Inheritance.getFqn(this.project, module), "strategy", JpaEnum.InheritanceType.getEnumEntryFqn(this.project, module, entity.getInheritanceType().name())));
        }
    }

    protected boolean checkAttributeConstant(PsiAnnotation annotation, String attributeName) {
        PsiAnnotationMemberValue attributeValue = annotation.findAttributeValue(attributeName);
        return this.checkAttributeConstant(attributeValue);
    }

    protected boolean checkAttributeConstant(PsiAnnotationMemberValue attributeValue) {
        PsiElement psiElement;
        return attributeValue instanceof PsiReferenceExpression && (psiElement = ((PsiReferenceExpression)attributeValue).resolve()) instanceof PsiField && ((PsiField)psiElement).getType().equalsToText("java.lang.String");
    }

    protected void setAttributeConstantValue(PsiAnnotationMemberValue attributeValue, String text, List<PsiField> modifiedConstants) {
        PsiElement field;
        if (attributeValue != null && text != null && attributeValue instanceof PsiReferenceExpression && !text.equals(AnnotationUtil.getStringAttributeValue((PsiAnnotationMemberValue)attributeValue)) && (field = ((PsiReferenceExpression)attributeValue).resolve()) instanceof PsiField && !modifiedConstants.contains(field) && field.getContainingFile().isWritable()) {
            modifiedConstants.add((PsiField)field);
            PsiLiteralExpressionImpl literalExpression = (PsiLiteralExpressionImpl)PsiTreeUtil.getChildOfType((PsiElement)field, PsiLiteralExpressionImpl.class);
            if (literalExpression != null) {
                literalExpression.updateText("\"" + text + "\"");
            }
        }
    }

    protected void setAnnotationParameterValue(PsiAnnotation annotation, String attributeName, String text, List<PsiField> modifiedConstants) {
        PsiAnnotationMemberValue attributeValue = annotation.findAttributeValue(attributeName);
        if (attributeValue instanceof PsiReferenceExpression) {
            this.setAttributeConstantValue(attributeValue, text, modifiedConstants);
        } else {
            annotation.setDeclaredAttributeValue(attributeName, (PsiAnnotationMemberValue)this.elementFactory.createExpressionFromText(AnnotationHelper.wrap(text), annotation.getContext()));
        }
    }

    protected void checkEmbeddableAnnotation(Entity entity, PsiClass entityClass, PsiModifierList entityModifierList, Module module) {
        PsiAnnotation embeddAnn = AnnotationUtil.findAnnotation((PsiModifierListOwner)entityClass, (String[])new String[]{JpaEntityAnnotation.Embeddable.getFqn(this.project, module)});
        if (embeddAnn == null) {
            if (!entity.isEmbeddable()) {
                return;
            }
            this.javaCodeStyleManager.shortenClassReferences((PsiElement)this.addAnnotation(entityModifierList, JpaEntityAnnotation.Embeddable.getFqn(this.project, module)));
        } else if (!entity.isEmbeddable()) {
            embeddAnn.delete();
        }
    }

    protected void checkDiscriminatorAnnotation(Entity entity, PsiClass entityClass, PsiModifierList modifierList, Module module) {
        PsiAnnotation discriminatorValueAnn = AnnotationUtil.findAnnotation((PsiModifierListOwner)entityClass, (String[])new String[]{JpaEntityAnnotation.DiscriminatorValue.getFqn(this.project, module)});
        if (discriminatorValueAnn == null) {
            if (Strings.isNullOrEmpty((String)entity.getDiscriminator())) {
                return;
            }
            discriminatorValueAnn = this.elementFactory.createAnnotationFromText(String.format("@%s(\"%s\")\n", JpaEntityAnnotation.DiscriminatorValue.getFqn(this.project, module), entity.getDiscriminator()), entityClass.getContext());
            PsiAnnotation addedAnnotation = this.addAnnotation(modifierList, discriminatorValueAnn, false);
            this.javaCodeStyleManager.shortenClassReferences((PsiElement)addedAnnotation);
        } else if (Strings.isNullOrEmpty((String)entity.getDiscriminator())) {
            discriminatorValueAnn.delete();
        } else {
            this.setAnnotationStringValue(discriminatorValueAnn, "value", entity.getDiscriminator());
        }
    }

    private void checkNamedQueriesAnnotation(Entity entity, PsiClass entityClass, Module module) {
        PsiModifierList modifierList = entityClass.getModifierList();
        if (modifierList == null) {
            return;
        }
        List<NamedQuery> prevQueries = EntityUtil.getNamedQueries(entityClass);
        List<NamedQuery> currQueries = entity.getNamedQueries();
        List newQueries = ((StreamEx)StreamEx.of(currQueries).filter(currNq -> !ContainerUtil.exists((Iterable)prevQueries, prevNq -> Objects.equals(prevNq.getName(), currNq.getName())))).toList();
        if (newQueries.isEmpty()) {
            return;
        }
        AnnotationUtil.findAllAnnotations((PsiModifierListOwner)entityClass, Collections.singletonList(JpaEntityAnnotation.NamedQuery.getFqn(this.project, module)), (boolean)false).forEach(PsiElement::delete);
        PsiAnnotation namedQueriesAnn = AnnotationUtil.findAnnotation((PsiModifierListOwner)entityClass, (String[])new String[]{JpaEntityAnnotation.NamedQueries.getFqn(this.project, module)});
        if (namedQueriesAnn == null) {
            namedQueriesAnn = this.createNamedQueriesAnn(entityClass, newQueries, Collections.emptyList());
            PsiAnnotation addedAnnotation = this.addAnnotation((PsiModifierListOwner)entityClass, namedQueriesAnn);
            this.javaCodeStyleManager.shortenClassReferences((PsiElement)addedAnnotation);
        } else {
            Collection<PsiAnnotation> namedQueryAnnotations = StudioAnnotationUtil.getArrayValueAnnotations(namedQueriesAnn, "value");
            PsiAnnotation generatedAnn = this.createNamedQueriesAnn(entityClass, newQueries, namedQueryAnnotations);
            if (!ComparisonUtil.isEquals((CharSequence)namedQueriesAnn.getText(), (CharSequence)generatedAnn.getText(), (ComparisonPolicy)ComparisonPolicy.IGNORE_WHITESPACES)) {
                PsiElement replacedAnnotation = namedQueriesAnn.replace((PsiElement)generatedAnn);
                this.javaCodeStyleManager.shortenClassReferences(replacedAnnotation);
            }
        }
    }

    private PsiAnnotation createNamedQueriesAnn(PsiClass entityClass, List<NamedQuery> newQueries, Collection<PsiAnnotation> existNamedQueryAnnotations) {
        String queriesString = EntityWriterUtils.convertNamedQueries(entityClass.getProject(), ModuleUtilCore.findModuleForPsiElement((PsiElement)entityClass), newQueries, ContainerUtil.map(existNamedQueryAnnotations, PsiElement::getText), Annotation.GenerationStrategy.JAVA);
        return this.elementFactory.createAnnotationFromText(String.format("@%s(%s)\n", JpaEntityAnnotation.NamedQueries.getFqn(this.project, ModuleUtilCore.findModuleForPsiElement((PsiElement)entityClass)), queriesString), entityClass.getContext());
    }

    protected void checkTableAnnotation(Entity entity, PsiClass entityClass, List<PsiField> modifiedConstants) {
        boolean delete;
        PsiModifierList modifierList = entityClass.getModifierList();
        if (modifierList == null) {
            return;
        }
        boolean isNew = entity instanceof EntityModel && ((EntityModel)entity).isNew();
        PsiAnnotation tableAnn = AnnotationUtil.findAnnotation((PsiModifierListOwner)entityClass, (String[])new String[]{JpaEntityAnnotation.Table.getFqn(this.project, ModuleUtilCore.findModuleForPsiElement((PsiElement)entityClass))});
        String table = EntityPsi.getInstance(entityClass).getTable();
        boolean bl = delete = entity.isMappedSuperclass() || entity.isEmbeddable() || entity.getParent() != null && entity.getParent().isPersistentEntity() && Arrays.asList(Entity.InheritanceType.SINGLE_TABLE, null).contains((Object)entity.getParent().getInheritanceType()) || !isNew && entity.getIndexes().isEmpty() && entity.getUniqueConstraints().isEmpty() && Strings.isNullOrEmpty((String)entity.getCatalog()) && Strings.isNullOrEmpty((String)entity.getSchema()) && (tableAnn == null && (Objects.equals(table, entity.getTable()) || Objects.equals(entity.getName(), entity.getTable())) || Strings.isNullOrEmpty((String)entity.getTable()));
        if (tableAnn == null) {
            if (delete) {
                return;
            }
            tableAnn = this.createTableAnnotation(entity, entityClass, null, modifiedConstants);
            PsiAnnotation addedAnnotation = this.addAnnotation(modifierList, tableAnn, false);
            this.javaCodeStyleManager.shortenClassReferences((PsiElement)addedAnnotation);
        } else if (delete) {
            tableAnn.delete();
        } else {
            PsiAnnotation generated = this.createTableAnnotation(entity, entityClass, tableAnn, modifiedConstants);
            if (!ComparisonUtil.isEquals((CharSequence)tableAnn.getText(), (CharSequence)generated.getText(), (ComparisonPolicy)ComparisonPolicy.IGNORE_WHITESPACES)) {
                PsiElement replacedAnnotation = tableAnn.replace((PsiElement)generated);
                this.javaCodeStyleManager.shortenClassReferences(replacedAnnotation);
            }
        }
    }

    protected void checkTypeDefAnnotation(Entity entity, PsiClass entityClass) {
        PsiModifierList modifierList = entityClass.getModifierList();
        if (modifierList == null) {
            return;
        }
        PsiAnnotation typeDefs = AnnotationUtil.findAnnotation((PsiModifierListOwner)entityClass, (String[])new String[]{"org.hibernate.annotations.TypeDefs"});
        List<PsiAnnotation> typeDefAnnotations = Arrays.asList(AnnotationUtil.findAnnotations((PsiModifierListOwner)entityClass, Collections.singleton("org.hibernate.annotations.TypeDef")));
        List<HibernateCustomTypeModel> hibernateTypes = entity.getHibernateTypes();
        if (typeDefs == null && typeDefAnnotations.isEmpty()) {
            if (hibernateTypes.isEmpty()) {
                return;
            }
            typeDefs = this.createTypeDefAnnotation(entity, entityClass);
            if (typeDefs != null) {
                PsiAnnotation addedAnnotation = this.addAnnotation(modifierList, typeDefs, false);
                this.javaCodeStyleManager.shortenClassReferences((PsiElement)addedAnnotation);
            }
        } else if (hibernateTypes.isEmpty()) {
            if (typeDefs != null) {
                typeDefs.delete();
            }
            typeDefAnnotations.forEach(PsiElement::delete);
        } else {
            PsiAnnotation annotation;
            PsiAnnotation generated = this.createTypeDefAnnotation(entity, entityClass);
            PsiAnnotation psiAnnotation = annotation = typeDefAnnotations.isEmpty() ? typeDefs : typeDefAnnotations.get(0);
            if (generated != null && !ComparisonUtil.isEquals((CharSequence)annotation.getText(), (CharSequence)generated.getText(), (ComparisonPolicy)ComparisonPolicy.IGNORE_WHITESPACES)) {
                typeDefAnnotations.forEach(PsiElement::delete);
                if (typeDefs != null) {
                    typeDefs.delete();
                }
                this.javaCodeStyleManager.shortenClassReferences((PsiElement)this.addAnnotation(modifierList, generated, false));
            }
        }
    }

    protected PsiAnnotation createTableAnnotation(@NotNull Entity entity, @NotNull PsiClass entityClass, @Nullable PsiAnnotation tableAnn, List<PsiField> modifiedConstants) {
        if (entity == null) {
            JavaEntityWriter.$$$reportNull$$$0(18);
        }
        if (entityClass == null) {
            JavaEntityWriter.$$$reportNull$$$0(19);
        }
        Object indexesString = "";
        Object uniqueConstraintsString = "";
        Object schemaString = "";
        Object catalogString = "";
        Object nameString = "";
        boolean needComma = false;
        String table = EntityPsi.getInstance(entityClass).getTable();
        if (!(entity.getTable() == null || table != null && table.equals(entity.getTable()) && table.equals(entity.getName()))) {
            needComma = true;
            if (tableAnn == null || !this.checkAttributeConstant(tableAnn, "name")) {
                nameString = "name = \"" + entity.getTable() + "\"";
            } else {
                PsiAnnotationMemberValue attributeValue = tableAnn.findAttributeValue("name");
                if (attributeValue != null) {
                    this.setAttributeConstantValue(attributeValue, entity.getTable(), modifiedConstants);
                    nameString = "name =  " + attributeValue.getText();
                }
            }
        }
        if (!StringUtils.isBlank((CharSequence)entity.getSchema())) {
            if (needComma) {
                schemaString = (String)schemaString + ",";
            }
            schemaString = (String)schemaString + " schema = \"" + entity.getSchema() + "\"";
            needComma = true;
        }
        if (!StringUtils.isBlank((CharSequence)entity.getCatalog())) {
            if (needComma) {
                catalogString = (String)catalogString + ",";
            }
            catalogString = (String)catalogString + " catalog = \"" + entity.getCatalog() + "\"";
            needComma = true;
        }
        if (!entity.getIndexes().isEmpty()) {
            if (needComma) {
                indexesString = (String)indexesString + ",";
            }
            indexesString = (String)indexesString + " indexes = " + EntityWriterUtils.convertIndex(entity.getIndexes(), Annotation.GenerationStrategy.JAVA, this.project);
            needComma = true;
        }
        if (!entity.getUniqueConstraints().isEmpty()) {
            if (needComma) {
                uniqueConstraintsString = (String)uniqueConstraintsString + ",";
            }
            uniqueConstraintsString = (String)uniqueConstraintsString + " uniqueConstraints = " + EntityWriterUtils.convertUniqueConstraint(entity.getUniqueConstraints(), Annotation.GenerationStrategy.JAVA, this.project);
        }
        return this.elementFactory.createAnnotationFromText(String.format("@%s(%s%s%s%s%s)\n", JpaEntityAnnotation.Table.getFqn(this.project, ModuleUtilCore.findModuleForPsiElement((PsiElement)entityClass)), nameString, schemaString, catalogString, indexesString, uniqueConstraintsString), entityClass.getContext());
    }

    private PsiAnnotation createTypeDefAnnotation(@NotNull Entity entity, @NotNull PsiClass entityClass) {
        List<HibernateCustomTypeModel> hibernateTypes;
        if (entity == null) {
            JavaEntityWriter.$$$reportNull$$$0(20);
        }
        if (entityClass == null) {
            JavaEntityWriter.$$$reportNull$$$0(21);
        }
        if ((hibernateTypes = entity.getHibernateTypes()).isEmpty()) {
            return null;
        }
        String typesStr = StreamEx.of(hibernateTypes).map(HibernateCustomTypeModel::toAnnotation).joining((CharSequence)",\n");
        String annotationString = hibernateTypes.size() > 1 ? String.format("@org.hibernate.annotations.TypeDefs({\n%s\n})\n", typesStr) : hibernateTypes.get(0).toAnnotation();
        return this.elementFactory.createAnnotationFromText(annotationString, entityClass.getContext());
    }

    protected void checkMappedSuperclassAnnotation(Entity entity, PsiClass entityClass, Module module) {
        PsiAnnotation mappedSuperClassAnnotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)entityClass, (String[])new String[]{JpaEntityAnnotation.MappedSuperclass.getFqn(this.project, module)});
        if (mappedSuperClassAnnotation == null) {
            if (!entity.isMappedSuperclass()) {
                return;
            }
            PsiModifierList modifierList = entityClass.getModifierList();
            if (modifierList == null) {
                return;
            }
            this.addAnnotation(modifierList, JpaEntityAnnotation.MappedSuperclass.getFqn(this.project, module));
        } else if (!entity.isMappedSuperclass()) {
            mappedSuperClassAnnotation.delete();
        }
    }

    private void checkImmutableAnnotation(Entity entity, PsiClass entityClass) {
        PsiAnnotation immutableAnnotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)entityClass, (String[])new String[]{"org.hibernate.annotations.Immutable"});
        if (immutableAnnotation == null) {
            if (!entity.isImmutable()) {
                return;
            }
            PsiModifierList modifierList = entityClass.getModifierList();
            if (modifierList == null) {
                return;
            }
            if (HProjectUtils.isClassAvailableInLibraries(this.project, "org.hibernate.annotations.Immutable")) {
                this.addAnnotation(modifierList, "org.hibernate.annotations.Immutable");
                this.addProtectedEmptyConstructor(entity, entityClass);
            }
        } else if (!entity.isImmutable()) {
            immutableAnnotation.delete();
        }
    }

    private void addProtectedEmptyConstructor(Entity entity, PsiClass entityClass) {
        Object[] constructors = entityClass.getConstructors();
        if (ContainerUtil.exists((Object[])constructors, psiMethod -> !psiMethod.hasParameters())) {
            return;
        }
        PsiModifierList modifierList = entityClass.getModifierList();
        if (entity.isLombokGetter() && modifierList != null && LombokService.Companion.getInstance(this.project).isLombokProject()) {
            PsiAnnotation noArgsConstructorAnn = this.elementFactory.createAnnotationFromText("@lombok.NoArgsConstructor(access = lombok.AccessLevel.PROTECTED)", (PsiElement)modifierList);
            this.addAnnotation(modifierList, noArgsConstructorAnn, true);
        } else {
            PsiMethod emptyConstructor = this.elementFactory.createMethodFromText("protected " + entityClass.getName() + "() {}", (PsiElement)entityClass);
            entityClass.add((PsiElement)emptyConstructor);
        }
    }

    protected PsiAnnotation checkEntityAnnotation(Entity entity, PsiClass entityClass, List<PsiField> modifiedConstants) {
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)entityClass);
        PsiAnnotation entityAnn = AnnotationUtil.findAnnotation((PsiModifierListOwner)entityClass, (String[])new String[]{JpaEntityAnnotation.Entity.getFqn(this.project, module)});
        if (entityAnn == null) {
            if (!entity.isPersistentEntity()) {
                return null;
            }
            PsiModifierList modifierList = entityClass.getModifierList();
            if (modifierList == null) {
                return null;
            }
            entityAnn = this.addAnnotation(modifierList, JpaEntityAnnotation.Entity.getFqn(this.project, module));
            this.setAnnotationStringValue(entityAnn, "name", entity.getName());
        } else {
            if (!entity.isPersistentEntity()) {
                entityAnn.delete();
                return null;
            }
            if (!this.checkAttributeConstant(entityAnn, "name")) {
                this.setAnnotationStringValue(entityAnn, "name", entity.getName());
            } else {
                PsiAnnotationMemberValue attributeValue = entityAnn.findAttributeValue("name");
                if (attributeValue != null) {
                    this.setAttributeConstantValue(attributeValue, entity.getName(), modifiedConstants);
                }
            }
        }
        return entityAnn;
    }

    @Override
    public void updateSequenceGeneratorAnnotation(SequenceGenerator sequenceGenerator, PsiClass entityClass, Module module) {
        String sequenceGeneratorFqn = JpaAttributeAnnotation.SequenceGenerator.getFqn(this.project, module);
        PsiAnnotation generatorAnn = AnnotationUtil.findAnnotation((PsiModifierListOwner)entityClass, (String[])new String[]{sequenceGeneratorFqn});
        if (generatorAnn == null) {
            if (sequenceGenerator == null) {
                return;
            }
            PsiModifierList modifierList = entityClass.getModifierList();
            if (modifierList == null) {
                return;
            }
            generatorAnn = this.addAnnotation(modifierList, sequenceGeneratorFqn);
            this.setAnnotationStringValue(generatorAnn, "name", sequenceGenerator.getName());
            this.setAnnotationStringValue(generatorAnn, "sequenceName", sequenceGenerator.getSequenceName());
            this.setAnnotationValue(generatorAnn, "allocationSize", "" + sequenceGenerator.getAllocationSize());
            if (sequenceGenerator.getInitialValue() != 1) {
                this.setAnnotationValue(generatorAnn, "initialValue", "" + sequenceGenerator.getInitialValue());
            }
        } else if (sequenceGenerator == null) {
            generatorAnn.delete();
        } else {
            this.setAnnotationStringValue(generatorAnn, "name", sequenceGenerator.getName());
            this.setAnnotationStringValue(generatorAnn, "sequenceName", sequenceGenerator.getSequenceName());
            this.setAnnotationValue(generatorAnn, "allocationSize", "" + sequenceGenerator.getAllocationSize());
            this.setAnnotationValue(generatorAnn, "initialValue", "" + sequenceGenerator.getInitialValue());
        }
    }

    private PsiAnnotation checkHibernateEnversAuditedAnnotation(Entity entity, PsiClass psiClass) {
        PsiAnnotation auditedAnnotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)psiClass, (String[])new String[]{"org.hibernate.envers.Audited"});
        if (auditedAnnotation == null) {
            if (!entity.isAudited()) {
                return null;
            }
            PsiModifierList modifierList = psiClass.getModifierList();
            if (modifierList == null) {
                return null;
            }
            auditedAnnotation = this.addAnnotation(modifierList, "org.hibernate.envers.Audited");
            this.setAnnotationStringValue(auditedAnnotation, "name", entity.getName());
        } else if (!entity.isAudited()) {
            auditedAnnotation.delete();
        }
        return auditedAnnotation;
    }

    private void addCommentAnnotation(Entity entity, PsiClass psiClass) {
        PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)psiClass, (String[])new String[]{"org.hibernate.annotations.Comment"});
        if (annotation == null && entity.getComment() != null && JpaPluginProjectConfig.getInstance((Project)this.project).getState().commentSavingStrategy == ProjectState.CommentSavingStrategy.ANNOTATION && HProjectUtils.isClassAvailableInLibraries(this.project, ModuleUtilCore.findModuleForPsiElement((PsiElement)psiClass), "org.hibernate.annotations.Comment")) {
            annotation = this.addAnnotation(psiClass.getModifierList(), "org.hibernate.annotations.Comment");
            this.setAnnotationStringValue(annotation, "value", entity.getComment());
        }
    }

    @Override
    public void setIdClass(PsiClass psiClass, String idClassFqn) {
        if (idClassFqn == null) {
            return;
        }
        String annotationFqn = JpaEntityAnnotation.IdClass.getFqn(this.project, ModuleUtilCore.findModuleForPsiElement((PsiElement)psiClass));
        PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)psiClass, (String[])new String[]{annotationFqn});
        if (annotation == null) {
            annotation = this.elementFactory.createAnnotationFromText("@" + annotationFqn + "(" + idClassFqn + ".class)", (PsiElement)psiClass);
            this.addAnnotation((PsiModifierListOwner)psiClass, annotation);
        }
    }

    protected PsiAnnotation addAnnotation(PsiModifierListOwner modifierListOwner, PsiAnnotation targetAnn) {
        String annFqn = targetAnn.getQualifiedName();
        if (annFqn == null) {
            return null;
        }
        PsiModifierList modifierList = modifierListOwner.getModifierList();
        if (modifierList == null) {
            return null;
        }
        PsiAnnotation annotation = this.addAnnotation(modifierList, targetAnn, false);
        return (PsiAnnotation)this.javaCodeStyleManager.shortenClassReferences((PsiElement)annotation);
    }

    protected PsiAnnotation addAnnotation(PsiModifierList modifierList, String annFqn) {
        PsiAnnotation psiAnnotation = PsiElementFactory.getInstance((Project)this.project).createAnnotationFromText("@" + annFqn, (PsiElement)modifierList);
        PsiAnnotation createdAnn = (PsiAnnotation)modifierList.addAfter((PsiElement)psiAnnotation, null);
        this.javaCodeStyleManager.shortenClassReferences((PsiElement)createdAnn);
        return createdAnn;
    }

    protected PsiAnnotation addAnnotation(PsiModifierList modifierList, PsiAnnotation psiAnnotation, Boolean isAttribute) {
        return this.addAnnotation(modifierList, psiAnnotation, isAttribute, true);
    }

    protected PsiAnnotation addAnnotation(PsiModifierList modifierList, PsiAnnotation psiAnnotation, Boolean isAttribute, boolean isShortenClassReferences) {
        PsiAnnotation anchor = StreamEx.of((Object[])modifierList.getChildren()).select(PsiAnnotation.class).reduce((f, s) -> s).orElse(null);
        PsiElement createdAnn = anchor != null ? modifierList.addAfter((PsiElement)psiAnnotation, (PsiElement)anchor) : modifierList.addBefore((PsiElement)psiAnnotation, null);
        if (isShortenClassReferences) {
            createdAnn = this.javaCodeStyleManager.shortenClassReferences(createdAnn);
        }
        return (PsiAnnotation)createdAnn;
    }

    protected void setAnnotationValue(@NotNull PsiAnnotation annotation, @NotNull String attrName, @Nullable String attrValue) {
        if (annotation == null) {
            JavaEntityWriter.$$$reportNull$$$0(22);
        }
        if (attrName == null) {
            JavaEntityWriter.$$$reportNull$$$0(23);
        }
        this.setAnnotationValue(annotation, attrName, attrValue, false);
    }

    @Override
    public void setAnnotationValue(@NotNull PsiAnnotation annotation, @NotNull String attrName, @Nullable String attrValue, boolean isEnum) {
        String currAttrValue;
        if (annotation == null) {
            JavaEntityWriter.$$$reportNull$$$0(24);
        }
        if (attrName == null) {
            JavaEntityWriter.$$$reportNull$$$0(25);
        }
        if (!annotation.getContainingFile().isValid()) {
            return;
        }
        String string = currAttrValue = isEnum ? StudioAnnotationUtil.getDeclaredEnumFqnValue(annotation, attrName) : AnnotationUtil.getStringAttributeValue((PsiAnnotation)annotation, (String)attrName);
        if (Objects.equals(currAttrValue, attrValue)) {
            return;
        }
        PsiExpression expression = attrValue == null ? null : this.elementFactory.createExpressionFromText(attrValue, null);
        annotation.setDeclaredAttributeValue(attrName, (PsiAnnotationMemberValue)expression);
    }

    protected void setAnnotationStringValue(@NotNull PsiAnnotation annotation, @NotNull String attrName, @Nullable String attrValue) {
        if (annotation == null) {
            JavaEntityWriter.$$$reportNull$$$0(26);
        }
        if (attrName == null) {
            JavaEntityWriter.$$$reportNull$$$0(27);
        }
        this.setAnnotationStringValue(annotation, attrName, true, attrValue);
    }

    protected void setAnnotationStringValue(@NotNull PsiAnnotation annotation, @NotNull String attrName, @NotNull boolean needWrap, @Nullable String attrValue) {
        String currAttrValue;
        if (annotation == null) {
            JavaEntityWriter.$$$reportNull$$$0(28);
        }
        if (attrName == null) {
            JavaEntityWriter.$$$reportNull$$$0(29);
        }
        if (Objects.equals(currAttrValue = AnnotationUtil.getStringAttributeValue((PsiAnnotation)annotation, (String)attrName), attrValue)) {
            return;
        }
        String strValue = null;
        if (attrValue != null) {
            strValue = needWrap ? AnnotationHelper.wrap(StringUtil.escapeStringCharacters((String)attrValue)) : StringUtil.escapeStringCharacters((String)attrValue);
        }
        PsiExpression expression = attrValue == null || StringUtil.isEmptyOrSpaces((String)attrValue) ? null : this.elementFactory.createExpressionFromText(strValue, null);
        annotation.setDeclaredAttributeValue(attrName, expression);
        if (annotation.getParameterList().getAttributes().length == 0) {
            StreamEx.of((Object[])annotation.getParameterList().getChildren()).forEach(PsiElement::delete);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entity";
                break;
            }
            case 1: 
            case 2: 
            case 11: 
            case 14: 
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entityClass";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jpa/jpb/model/backend/ed/JavaEntityWriter";
                break;
            }
            case 5: 
            case 8: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attribute";
                break;
            }
            case 6: 
            case 9: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "createdField";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifierList";
                break;
            }
            case 22: 
            case 24: 
            case 26: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
            case 23: 
            case 25: 
            case 27: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attrName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jpa/jpb/model/backend/ed/JavaEntityWriter";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "generateEqualsAndHashCodeMethods";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "commitEntityToPsiWithoutAttribute";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addSerializableParentIfNeeded";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "commitAttributeToPsi";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "doAddAttributes";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addNewLinesIfNeed";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "addNewLineIfNeed";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isCommentedAttr";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "entityAnnotationsToPsi";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "setAttributeLength";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createTableAnnotation";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "createTypeDefAnnotation";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "setAnnotationValue";
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "setAnnotationStringValue";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }

    public static enum ClassEqualsType {
        HIBERNATE,
        SPRING_BOOT,
        SIMPLE;


        public static ClassEqualsType getInstance(Project project) {
            if (JpaUtils.isHibernateProject(project)) {
                return HIBERNATE;
            }
            if (JpaUtils.isSpringBootProject(project)) {
                return SPRING_BOOT;
            }
            return SIMPLE;
        }
    }

    public static enum MethodInsertPosition {
        AFTER_FIELDS,
        AFTER_METHODS;

    }
}

