/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.jpb.model.backend.ed.annotation.attr;

import com.intellij.jpa.jpb.model.backend.ed.annotation.attr.AbstractDynamicAttributeAnnotation;
import com.intellij.jpa.jpb.model.backend.ed.annotation.attr.JpaAttributeAnnotation;
import com.intellij.jpa.jpb.model.backend.ed.indexing.CustomTypeModel;
import com.intellij.jpa.jpb.model.backend.ed.indexing.JpaConverterModel;
import com.intellij.jpa.jpb.model.backend.ed.indexing.JpaConverterService;
import com.intellij.jpa.jpb.model.core.backend.ed.annotation.AnnotationModel;
import com.intellij.jpa.jpb.model.core.backend.ed.annotation.AnnotationModelBuilder;
import com.intellij.jpa.jpb.model.core.backend.ed.annotation.BooleanParameter;
import com.intellij.jpa.jpb.model.core.backend.ed.annotation.ClassParameter;
import com.intellij.jpa.jpb.model.model.Entity;
import com.intellij.jpa.jpb.model.model.EntityAttribute;
import com.intellij.jpa.jpb.model.util.EntityUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J \u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0002\u001a\u00020\u0003H\u0016J\u0018\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0018"}, d2={"Lcom/intellij/jpa/jpb/model/backend/ed/annotation/attr/ConvertAnnotation;", "Lcom/intellij/jpa/jpb/model/backend/ed/annotation/attr/AbstractDynamicAttributeAnnotation;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "jpaConverterService", "Lcom/intellij/jpa/jpb/model/backend/ed/indexing/JpaConverterService;", "getJpaConverterService", "()Lcom/intellij/jpa/jpb/model/backend/ed/indexing/JpaConverterService;", "isInsert", "", "attribute", "Lcom/intellij/jpa/jpb/model/model/EntityAttribute;", "entity", "Lcom/intellij/jpa/jpb/model/model/Entity;", "generateModel", "Lcom/intellij/jpa/jpb/model/core/backend/ed/annotation/AnnotationModel;", "attr", "knownAttributes", "", "", "intellij.javaee.jpa.jpb.model"})
@SourceDebugExtension(value={"SMAP\nConvertAnnotation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConvertAnnotation.kt\ncom/intellij/jpa/jpb/model/backend/ed/annotation/attr/ConvertAnnotation\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,43:1\n1755#2,3:44\n*S KotlinDebug\n*F\n+ 1 ConvertAnnotation.kt\ncom/intellij/jpa/jpb/model/backend/ed/annotation/attr/ConvertAnnotation\n*L\n21#1:44,3\n*E\n"})
public final class ConvertAnnotation
extends AbstractDynamicAttributeAnnotation {
    @NotNull
    private final Project project;
    @NotNull
    private final JpaConverterService jpaConverterService;

    public ConvertAnnotation(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(JpaAttributeAnnotation.Convert);
        this.project = project;
        this.jpaConverterService = JpaConverterService.Companion.getInstance(this.project);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final JpaConverterService getJpaConverterService() {
        return this.jpaConverterService;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isInsert(@NotNull EntityAttribute attribute, @NotNull Entity entity) {
        Intrinsics.checkNotNullParameter((Object)attribute, (String)"attribute");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        if (attribute.getConverter() == null) {
            boolean bl;
            void $this$any$iv;
            PsiClass psiClass = EntityUtil.getPsiClass(entity, this.project);
            if (psiClass == null) {
                return false;
            }
            PsiClass psiClass2 = psiClass;
            String string = attribute.getType().getFqn();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFqn(...)");
            Iterable iterable = JpaConverterService.getConvertersForEntityType$default(this.jpaConverterService, string, psiClass2, false, 4, null);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                return false;
            }
            Iterator iterator = $this$any$iv.iterator();
            do {
                if (!iterator.hasNext()) return false;
                Object element$iv = iterator.next();
                JpaConverterModel it = (JpaConverterModel)element$iv;
                boolean bl2 = false;
                if (it.getAutoApply() && Intrinsics.areEqual((Object)it.getEntityTypeFqn(), (Object)attribute.getType().getFqn())) {
                    return true;
                }
                bl = false;
            } while (!bl);
            return true;
        }
        if (!(attribute.getConverter() instanceof JpaConverterModel)) return false;
        CustomTypeModel customTypeModel = attribute.getConverter();
        Intrinsics.checkNotNull((Object)customTypeModel, (String)"null cannot be cast to non-null type com.intellij.jpa.jpb.model.backend.ed.indexing.JpaConverterModel");
        if (((JpaConverterModel)customTypeModel).getAutoApply()) return false;
        return true;
    }

    @Override
    @NotNull
    public AnnotationModel generateModel(@NotNull EntityAttribute attr, @NotNull Entity entity, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)attr, (String)"attr");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        CustomTypeModel converter = attr.getConverter();
        AnnotationModelBuilder builder = new AnnotationModelBuilder(((JpaAttributeAnnotation)this.getDescriptor()).getFqn(project, entity.getModule()));
        if (converter == null) {
            builder.add("disableConversion", new BooleanParameter(true));
        } else {
            String qualifiedName;
            PsiClass psiClass = converter.getTypeClass();
            String string = qualifiedName = psiClass != null ? psiClass.getQualifiedName() : null;
            if (qualifiedName != null) {
                builder.add("converter", new ClassParameter(qualifiedName));
            }
        }
        return builder.build();
    }

    @Override
    @NotNull
    public List<String> knownAttributes(@Nullable EntityAttribute attribute) {
        Object[] objectArray = new String[]{"converter", "disableConversion"};
        return CollectionsKt.mutableListOf((Object[])objectArray);
    }
}

