/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.jpb.model.backend.ed.annotation.attr;

import com.intellij.jpa.jpb.model.backend.ed.annotation.AnnotationHelper;
import com.intellij.jpa.jpb.model.backend.ed.annotation.attr.JpaAbstractColumnAnnotation;
import com.intellij.jpa.jpb.model.backend.ed.annotation.attr.JpaAttributeAnnotation;
import com.intellij.jpa.jpb.model.backend.ed.annotation.attr.constraint.AbstractColumnAnnotation;
import com.intellij.jpa.jpb.model.model.AssociationType;
import com.intellij.jpa.jpb.model.model.Entity;
import com.intellij.jpa.jpb.model.model.EntityAttribute;
import com.intellij.jpa.jpb.model.util.annotation.JoinTable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J6\u0010\f\u001a\u001e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0\rj\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e`\u000f2\u0006\u0010\b\u001a\u00020\t2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016J\u0018\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00132\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0016\u00a8\u0006\u0014"}, d2={"Lcom/intellij/jpa/jpb/model/backend/ed/annotation/attr/JpaJoinColumnAnnotation;", "Lcom/intellij/jpa/jpb/model/backend/ed/annotation/attr/JpaAbstractColumnAnnotation;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "isInsert", "", "attribute", "Lcom/intellij/jpa/jpb/model/model/EntityAttribute;", "entity", "Lcom/intellij/jpa/jpb/model/model/Entity;", "getParams", "Ljava/util/LinkedHashMap;", "", "Lkotlin/collections/LinkedHashMap;", "module", "Lcom/intellij/openapi/module/Module;", "knownAttributes", "", "intellij.javaee.jpa.jpb.model"})
public final class JpaJoinColumnAnnotation
extends JpaAbstractColumnAnnotation {
    public JpaJoinColumnAnnotation(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project, JpaAttributeAnnotation.JoinColumn);
    }

    @Override
    public boolean isInsert(@NotNull EntityAttribute attribute, @NotNull Entity entity) {
        block5: {
            block4: {
                Intrinsics.checkNotNullParameter((Object)attribute, (String)"attribute");
                Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
                if (!Intrinsics.areEqual((Object)attribute.getJoinTable(), (Object)JoinTable.NULL_ANNOTATION)) break block4;
                LinkedHashMap<String, String> linkedHashMap = attribute.getJoinColumns();
                boolean bl = linkedHashMap != null ? !((Map)linkedHashMap).isEmpty() : false;
                if (!bl && attribute.getAssociationType() != AssociationType.WithoutJoinColumnOtM) break block5;
            }
            return false;
        }
        if (!(AbstractColumnAnnotation.insertCondition(attribute, entity) && AnnotationHelper.isEntity(attribute) && attribute.getType() instanceof Entity)) {
            return false;
        }
        EntityAttribute.Cardinality cardinality = attribute.getCardinality();
        return cardinality == EntityAttribute.Cardinality.MANY_TO_ONE || attribute.isOwner() && (cardinality == EntityAttribute.Cardinality.ONE_TO_ONE || cardinality == EntityAttribute.Cardinality.ONE_TO_MANY);
    }

    @Override
    @NotNull
    public LinkedHashMap<String, String> getParams(@NotNull EntityAttribute attribute, @Nullable Module module) {
        Intrinsics.checkNotNullParameter((Object)attribute, (String)"attribute");
        LinkedHashMap<String, String> params = super.getParams(attribute, module);
        String referencedColumnName = attribute.getReferencedColumnName();
        CharSequence charSequence = referencedColumnName;
        if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
            ((Map)params).put("referencedColumnName", AnnotationHelper.wrap(referencedColumnName));
        }
        return params;
    }

    @Override
    @NotNull
    public List<String> knownAttributes(@Nullable EntityAttribute attribute) {
        List attrs = new ArrayList();
        List<String> list = super.knownAttributes(attribute);
        attrs.addAll(list != null ? (Collection)list : (Collection)CollectionsKt.emptyList());
        attrs.add("referencedColumnName");
        return attrs;
    }
}

