/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.jpb.model.backend.props;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.jpa.jpb.model.backend.config.SpringConfigurationSearch;
import com.intellij.jpa.jpb.model.backend.ds.SpringDataSourceServiceEP;
import com.intellij.jpa.jpb.model.properties.PropertySource;
import com.intellij.jpa.jpb.model.properties.PropertySourceFactory;
import com.intellij.jpa.jpb.model.properties.impl.PropertiesFileSource;
import com.intellij.jpa.jpb.model.util.SearchHelper;
import com.intellij.lang.Language;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.util.Processor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.apache.commons.compress.utils.FileNameUtils;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010#\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 %2\u00020\u0001:\u0001%B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010J\u001c\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014J\u001e\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00110\u00192\u0006\u0010\u001a\u001a\u00020\u0014H\u0002J&\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u001d2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00110\u00192\u0006\u0010\u001a\u001a\u00020\u0014H\u0002J\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u000e\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0013\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000e\u00a8\u0006&"}, d2={"Lcom/intellij/jpa/jpb/model/backend/props/SpringPropertiesConfiguration;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "psiManager", "Lcom/intellij/psi/PsiManager;", "Lorg/jetbrains/annotations/NotNull;", "searchHelper", "Lcom/intellij/jpa/jpb/model/util/SearchHelper;", "kotlin.jvm.PlatformType", "Lcom/intellij/jpa/jpb/model/util/SearchHelper;", "loadAllPropertySources", "", "Lcom/intellij/jpa/jpb/model/properties/PropertySource;", "loadPropertySourcesFromScope", "applicationPropertiesScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "configurationClassesScope", "findAllPropertySourcesInConfigurations", "", "sources", "", "scope", "findApplicationFiles", "propertiesFileType", "Lcom/intellij/openapi/fileTypes/FileType;", "findPropertiesFileType", "languageId", "", "isPropertyFile", "", "file", "Lcom/intellij/psi/PsiFile;", "Companion", "intellij.javaee.jpa.jpb.model"})
@SourceDebugExtension(value={"SMAP\nSpringPropertiesConfiguration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpringPropertiesConfiguration.kt\ncom/intellij/jpa/jpb/model/backend/props/SpringPropertiesConfiguration\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,143:1\n3829#2:144\n4344#2,2:145\n1611#3,9:147\n1863#3:156\n1864#3:158\n1620#3:159\n1611#3,9:160\n1863#3:169\n1864#3:171\n1620#3:172\n1628#3,3:173\n1#4:157\n1#4:170\n14#5:176\n*S KotlinDebug\n*F\n+ 1 SpringPropertiesConfiguration.kt\ncom/intellij/jpa/jpb/model/backend/props/SpringPropertiesConfiguration\n*L\n67#1:144\n67#1:145,2\n69#1:147,9\n69#1:156\n69#1:158\n69#1:159\n73#1:160,9\n73#1:169\n73#1:171\n73#1:172\n86#1:173,3\n69#1:157\n73#1:170\n29#1:176\n*E\n"})
public final class SpringPropertiesConfiguration {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final PsiManager psiManager;
    private final SearchHelper searchHelper;
    @NotNull
    private static final Logger log;

    public SpringPropertiesConfiguration(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        PsiManager psiManager = PsiManager.getInstance((Project)this.project);
        Intrinsics.checkNotNullExpressionValue((Object)psiManager, (String)"getInstance(...)");
        this.psiManager = psiManager;
        this.searchHelper = SearchHelper.getInstance(this.project);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final List<PropertySource> loadAllPropertySources() {
        GlobalSearchScope globalSearchScope = GlobalSearchScope.projectScope((Project)this.project);
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"projectScope(...)");
        GlobalSearchScope globalSearchScope2 = GlobalSearchScopesCore.projectProductionScope((Project)this.project);
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope2, (String)"projectProductionScope(...)");
        return this.loadPropertySourcesFromScope(globalSearchScope, globalSearchScope2);
    }

    @NotNull
    public final List<PropertySource> loadPropertySourcesFromScope(@NotNull GlobalSearchScope applicationPropertiesScope, @NotNull GlobalSearchScope configurationClassesScope) {
        Intrinsics.checkNotNullParameter((Object)applicationPropertiesScope, (String)"applicationPropertiesScope");
        Intrinsics.checkNotNullParameter((Object)configurationClassesScope, (String)"configurationClassesScope");
        FileType fileType = this.findPropertiesFileType("Properties");
        if (fileType == null) {
            return CollectionsKt.emptyList();
        }
        FileType propertiesFileType = fileType;
        FileType fileType2 = this.findPropertiesFileType("yaml");
        if (fileType2 == null) {
            return CollectionsKt.emptyList();
        }
        FileType yamlFileType = fileType2;
        Set sources = new LinkedHashSet();
        this.findApplicationFiles(propertiesFileType, sources, applicationPropertiesScope);
        this.findApplicationFiles(yamlFileType, sources, applicationPropertiesScope);
        this.findAllPropertySourcesInConfigurations(sources, configurationClassesScope);
        return CollectionsKt.toList((Iterable)sources);
    }

    private final void findAllPropertySourcesInConfigurations(Set<PropertySource> sources, GlobalSearchScope scope) {
        SpringConfigurationSearch configurationSearch = SpringConfigurationSearch.Companion.getInstance(this.project);
        configurationSearch.walkConfigurationClasses(scope, (Processor<PsiClass>)((Processor)arg_0 -> SpringPropertiesConfiguration.findAllPropertySourcesInConfigurations$lambda$4(sources, this, arg_0)));
    }

    private final void findApplicationFiles(FileType propertiesFileType, Set<PropertySource> sources, GlobalSearchScope scope) {
        FileTypeIndex.processFiles((FileType)propertiesFileType, arg_0 -> SpringPropertiesConfiguration.findApplicationFiles$lambda$6(this, sources, arg_0), (GlobalSearchScope)scope);
    }

    private final FileType findPropertiesFileType(String languageId) {
        Language lang = Language.findLanguageByID((String)languageId);
        if (lang == null) {
            log.info(languageId + " language not found");
            return null;
        }
        LanguageFileType fileType = lang.getAssociatedFileType();
        if (fileType == null) {
            log.info(languageId + " file type not found");
        }
        return (FileType)fileType;
    }

    public final boolean isPropertyFile(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        String fileName = FileNameUtils.getBaseName((String)file.getName());
        Intrinsics.checkNotNull((Object)fileName);
        return StringsKt.contains$default((CharSequence)fileName, (CharSequence)"application", (boolean)false, (int)2, null) && SpringDataSourceServiceEP.Companion.extensionForFile(file) != null;
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean findAllPropertySourcesInConfigurations$lambda$4(Set $sources, SpringPropertiesConfiguration this$0, PsiClass configurationClass) {
        boolean bl;
        String it$iv$iv;
        Object it;
        boolean bl2;
        Object element$iv$iv$iv;
        Iterable $this$mapNotNullTo$iv$iv;
        Iterable $this$filterTo$iv$iv;
        PsiAnnotation[] psiAnnotationArray = configurationClass.getAnnotations();
        Intrinsics.checkNotNullExpressionValue((Object)psiAnnotationArray, (String)"getAnnotations(...)");
        Object[] $this$filter$iv = psiAnnotationArray;
        boolean $i$f$filter = false;
        Object[] objectArray = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (void element$iv$iv : $this$filterTo$iv$iv) {
            PsiAnnotation it2 = (PsiAnnotation)element$iv$iv;
            boolean bl3 = false;
            if (!Intrinsics.areEqual((Object)it2.getQualifiedName(), (Object)"org.springframework.context.annotation.PropertySource")) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$filterTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        Iterable $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String string;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            bl2 = false;
            it = (PsiAnnotation)element$iv$iv;
            boolean bl4 = false;
            String string2 = AnnotationUtil.getDeclaredStringAttributeValue((PsiAnnotation)it, (String)"value");
            if (string2 == null && (string2 = AnnotationUtil.getDeclaredStringAttributeValue((PsiAnnotation)it, null)) == null) {
                string = null;
            } else {
                String value = string2;
                string = StringsKt.removePrefix((String)value, (CharSequence)"classpath:");
            }
            if (string == null) continue;
            it$iv$iv = string;
            bl = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        $i$f$mapNotNull = false;
        $this$mapNotNullTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        $i$f$mapNotNullTo = false;
        $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        $i$f$forEach = false;
        iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            PsiFile psiFile;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            bl2 = false;
            it = (String)element$iv$iv;
            boolean bl5 = false;
            if ((StringsKt.endsWith$default((String)it, (String)".properties", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)it, (String)".yaml", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)it, (String)".yml", (boolean)false, (int)2, null) ? ((psiFile = this$0.searchHelper.findFile((String)it, PsiFile.class, configurationClass.getResolveScope())) instanceof PropertiesFile ? (PropertiesFile)psiFile : null) : null) == null) continue;
            it$iv$iv = it$iv$iv;
            bl = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$mapTo$iv = (List)destination$iv$iv;
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it3;
            PropertiesFile $i$f$mapNotNullTo2 = (PropertiesFile)item$iv;
            Collection collection = $sources;
            boolean bl6 = false;
            collection.add(PropertiesFileSource.Companion.invoke((PropertiesFile)it3));
        }
        return true;
    }

    private static final boolean findApplicationFiles$lambda$6(SpringPropertiesConfiguration this$0, Set $sources, VirtualFile it) {
        block1: {
            PsiFile foundPsiFile;
            String string = it.getNameWithoutExtension();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getNameWithoutExtension(...)");
            String fileName = string;
            if (!Intrinsics.areEqual((Object)fileName, (Object)"application") && !StringsKt.startsWith$default((String)fileName, (String)"application-", (boolean)false, (int)2, null) || (foundPsiFile = this$0.psiManager.findFile(it)) == null) break block1;
            Object object = PropertySourceFactory.Companion.getInstance(this$0.project, foundPsiFile);
            if (object != null && (object = object.getPropertySources(foundPsiFile)) != null) {
                Object it2 = object;
                boolean bl = false;
                $sources.addAll((Collection)it2);
            }
        }
        return true;
    }

    @JvmStatic
    @NotNull
    public static final SpringPropertiesConfiguration getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(SpringPropertiesConfiguration.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        log = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/jpa/jpb/model/backend/props/SpringPropertiesConfiguration$Companion;", "", "<init>", "()V", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "getInstance", "Lcom/intellij/jpa/jpb/model/backend/props/SpringPropertiesConfiguration;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.javaee.jpa.jpb.model"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final SpringPropertiesConfiguration getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Object object = project.getService(SpringPropertiesConfiguration.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
            return (SpringPropertiesConfiguration)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

