/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.jpb.model.core.http.request;

import com.intellij.jpa.jpb.model.core.http.request.ApiContentHelper;
import com.intellij.jpa.jpb.model.core.http.request.ApiResponse;
import com.intellij.jpa.jpb.model.core.http.request.Request;
import com.intellij.jpa.jpb.model.core.http.response.ErrorDescriptionResponse;
import com.intellij.jpa.jpb.model.core.http.response.StoreApiResponseEntity;
import com.intellij.jpa.jpb.model.core.util.ApiJsonException;
import com.intellij.jpa.jpb.model.core.util.AuthenticationException;
import com.intellij.jpa.jpb.model.core.util.BadUserCredentialsException;
import com.intellij.jpa.jpb.model.core.util.InvalidTokenException;
import com.intellij.jpa.jpb.model.core.util.UnknownApiException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.util.ThrowableConvertor;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.io.RequestBuilder;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.Base64;
import java.util.function.Supplier;
import java.util.zip.GZIPInputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \u001e2\u00020\u0001:\u0004\u001e\u001f !B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003J-\u0010\u0004\u001a\u0002H\u0005\"\u0004\b\u0000\u0010\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00050\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\tH&\u00a2\u0006\u0002\u0010\nJ\u0014\u0010\u000b\u001a\u00020\f2\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007H\u0004J/\u0010\u0004\u001a\u0002H\u0005\"\u0004\b\u0000\u0010\u0005*\u00020\f2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00050\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0004\u00a2\u0006\u0002\u0010\rJ\u0012\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u0002J\u001a\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0006\u001a\u00020\u00132\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0002J\u0010\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u0016H\u0002J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002R\u0018\u0010\u0014\u001a\u00020\u0015*\u00020\u00168BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0017\u0082\u0001\u0003\"#$\u00a8\u0006%"}, d2={"Lcom/intellij/jpa/jpb/model/core/http/request/RequestExecutor;", "", "<init>", "()V", "execute", "R", "request", "Lcom/intellij/jpa/jpb/model/core/http/request/Request;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "(Lcom/intellij/jpa/jpb/model/core/http/request/Request;Lcom/intellij/openapi/progress/ProgressIndicator;)Ljava/lang/Object;", "createRequestBuilder", "Lcom/intellij/util/io/RequestBuilder;", "(Lcom/intellij/util/io/RequestBuilder;Lcom/intellij/jpa/jpb/model/core/http/request/Request;Lcom/intellij/openapi/progress/ProgressIndicator;)Ljava/lang/Object;", "checkResponseError", "", "response", "createResponse", "Lcom/intellij/jpa/jpb/model/core/http/request/ApiResponse;", "Lcom/intellij/util/io/HttpRequests$Request;", "isJsonContentType", "", "Ljava/net/HttpURLConnection;", "(Ljava/net/HttpURLConnection;)Z", "checkResponseCode", "connection", "getJsonError", "Lcom/intellij/jpa/jpb/model/core/http/response/ErrorDescriptionResponse;", "text", "", "Companion", "WithBasicAuth", "WithTokenAuth", "WithNoAuth", "Lcom/intellij/jpa/jpb/model/core/http/request/RequestExecutor$WithBasicAuth;", "Lcom/intellij/jpa/jpb/model/core/http/request/RequestExecutor$WithNoAuth;", "Lcom/intellij/jpa/jpb/model/core/http/request/RequestExecutor$WithTokenAuth;", "intellij.javaee.jpa.jpb.model.core"})
@SourceDebugExtension(value={"SMAP\nRequestExecutor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RequestExecutor.kt\ncom/intellij/jpa/jpb/model/core/http/request/RequestExecutor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 ApiContentHelper.kt\ncom/intellij/jpa/jpb/model/core/http/request/ApiContentHelper\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,184:1\n1#2:185\n41#3:186\n14#4:187\n*S KotlinDebug\n*F\n+ 1 RequestExecutor.kt\ncom/intellij/jpa/jpb/model/core/http/request/RequestExecutor\n*L\n141#1:186\n28#1:187\n*E\n"})
public abstract class RequestExecutor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger LOG;

    private RequestExecutor() {
    }

    public abstract <R> R execute(@NotNull Request<? extends R> var1, @Nullable ProgressIndicator var2);

    public static /* synthetic */ Object execute$default(RequestExecutor requestExecutor, Request request, ProgressIndicator progressIndicator, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: execute");
        }
        if ((n & 2) != 0) {
            progressIndicator = null;
        }
        return requestExecutor.execute(request, progressIndicator);
    }

    @NotNull
    protected final RequestBuilder createRequestBuilder(@NotNull Request<?> request) {
        RequestBuilder requestBuilder;
        Intrinsics.checkNotNullParameter(request, (String)"request");
        Request<?> request2 = request;
        if (request2 instanceof Request.Get) {
            requestBuilder = HttpRequests.request((String)((Request.Get)request).getUrl());
        } else if (request2 instanceof Request.Post) {
            requestBuilder = HttpRequests.post((String)((Request.Post)request).getUrl(), (String)((Request.Post)request).getBodyMimeType());
        } else {
            throw new UnsupportedOperationException(request.getClass() + " is not supported");
        }
        RequestBuilder requestBuilder2 = requestBuilder.connectTimeout(5000).userAgent("Studio").throwStatusCodeException(false).accept(request.getAcceptMimeType());
        Intrinsics.checkNotNullExpressionValue((Object)requestBuilder2, (String)"accept(...)");
        return requestBuilder2;
    }

    protected final <R> R execute(@NotNull RequestBuilder $this$execute, @NotNull Request<? extends R> request, @Nullable ProgressIndicator indicator) {
        Intrinsics.checkNotNullParameter((Object)$this$execute, (String)"<this>");
        Intrinsics.checkNotNullParameter(request, (String)"request");
        ProgressIndicator progressIndicator = indicator;
        if (progressIndicator != null) {
            progressIndicator.checkCanceled();
        }
        LOG.debug("Request: " + request.getUrl() + " " + request.getOperationName() + " : Connecting");
        return (R)$this$execute.connect(arg_0 -> RequestExecutor.execute$lambda$1(request, this, indicator, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private final void checkResponseError(Object response) {
        CharSequence charSequence;
        if (response instanceof StoreApiResponseEntity && !((charSequence = (CharSequence)((StoreApiResponseEntity)response).getError()) == null || StringsKt.isBlank((CharSequence)charSequence))) {
            Throwable throwable;
            if (((StoreApiResponseEntity)response).isInvalidToken()) {
                throwable = new InvalidTokenException();
            } else if (((StoreApiResponseEntity)response).isInvalidGrant()) {
                throwable = new BadUserCredentialsException();
            } else {
                String string;
                String string2 = ((StoreApiResponseEntity)response).getError();
                String string3 = ((StoreApiResponseEntity)response).getError_description();
                if (string3 != null) {
                    void it;
                    String string4 = string3;
                    String string5 = string2;
                    boolean bl = false;
                    string = " (" + (String)it + ")";
                    string2 = string5;
                } else {
                    string = null;
                }
                String string6 = string2 + string;
                throwable = new UnknownApiException(string6);
            }
            throw throwable;
        }
    }

    private final ApiResponse createResponse(HttpRequests.Request request, ProgressIndicator indicator) {
        return new ApiResponse(request, indicator){
            final /* synthetic */ HttpRequests.Request $request;
            final /* synthetic */ ProgressIndicator $indicator;
            {
                this.$request = $request;
                this.$indicator = $indicator;
            }

            public String findHeader(String headerName) {
                Intrinsics.checkNotNullParameter((Object)headerName, (String)"headerName");
                return this.$request.getConnection().getHeaderField(headerName);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public <T> T readBody(ThrowableConvertor<Reader, T, IOException> converter) {
                Object object;
                Intrinsics.checkNotNullParameter(converter, (String)"converter");
                Closeable closeable = this.$request.getReader(this.$indicator);
                Throwable throwable = null;
                try {
                    BufferedReader it = (BufferedReader)closeable;
                    boolean bl = false;
                    object = converter.convert((Object)it);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                return (T)object;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public <T> T handleBody(ThrowableConvertor<InputStream, T, IOException> converter) {
                Object object;
                Intrinsics.checkNotNullParameter(converter, (String)"converter");
                Closeable closeable = this.$request.getInputStream();
                Throwable throwable = null;
                try {
                    InputStream it = (InputStream)closeable;
                    boolean bl = false;
                    object = converter.convert((Object)it);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                return (T)object;
            }
        };
    }

    private final boolean isJsonContentType(HttpURLConnection $this$isJsonContentType) {
        String string = $this$isJsonContentType.getContentType();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getContentType(...)");
        return StringsKt.startsWith$default((String)string, (String)"application/json", (boolean)false, (int)2, null);
    }

    private final void checkResponseCode(HttpURLConnection connection) throws IOException {
        if (connection.getResponseCode() < 400) {
            return;
        }
        String statusLine = String.valueOf(connection.getResponseCode());
        String connectionErrorText = RequestExecutor.checkResponseCode$getErrorText(connection);
        LOG.debug("Request: " + connection.getRequestMethod() + " " + connection.getURL() + " : Error " + statusLine + " body:\n" + connectionErrorText);
        ErrorDescriptionResponse errorDescriptionResponse = this.isJsonContentType(connection) ? this.getJsonError(connectionErrorText) : null;
        ErrorDescriptionResponse errorDescriptionResponse2 = errorDescriptionResponse;
        if (errorDescriptionResponse2 == null) {
            LOG.debug("Request: " + connection.getRequestMethod() + " " + connection.getURL() + " : Unable to parse JSON error");
            errorDescriptionResponse2 = Unit.INSTANCE;
        }
        throw switch (connection.getResponseCode()) {
            case 401 -> new InvalidTokenException();
            case 400, 402, 403 -> errorDescriptionResponse == null ? (Exception)new AuthenticationException("Request response: " + connectionErrorText, null, 2, null) : (errorDescriptionResponse.isInvalidToken() ? (Exception)new InvalidTokenException() : (errorDescriptionResponse.isInvalidGrant() ? (Exception)new BadUserCredentialsException() : (Exception)new AuthenticationException("Request response: " + connectionErrorText, null, 2, null)));
            default -> {
                Object v2 = errorDescriptionResponse;
                if (v2 == null || (v2 = ((ErrorDescriptionResponse)v2).getError()) == null) {
                    v2 = connectionErrorText;
                }
                yield (Throwable)new HttpRequests.HttpStatusException(statusLine + " - " + (String)v2, connection.getResponseCode(), connection.getURL().toString());
            }
        };
    }

    private final ErrorDescriptionResponse getJsonError(String text) {
        ErrorDescriptionResponse errorDescriptionResponse;
        try {
            ApiContentHelper this_$iv = ApiContentHelper.INSTANCE;
            boolean $i$f$fromJson = false;
            errorDescriptionResponse = ApiContentHelper.fromJson(text, ErrorDescriptionResponse.class);
        }
        catch (ApiJsonException jse) {
            errorDescriptionResponse = null;
        }
        return errorDescriptionResponse;
    }

    private static final Object execute$lambda$1(Request $request, RequestExecutor this$0, ProgressIndicator $indicator, HttpRequests.Request it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        URLConnection uRLConnection = it.getConnection();
        Intrinsics.checkNotNull((Object)uRLConnection, (String)"null cannot be cast to non-null type java.net.HttpURLConnection");
        HttpURLConnection connection = (HttpURLConnection)uRLConnection;
        if ($request instanceof Request.WithBody) {
            LOG.debug("Request: " + connection.getRequestMethod() + " " + connection.getURL() + " with body:\n" + (((Request.WithBody)$request).getDontLogBody() ? "<hidden>" : ((Request.WithBody)$request).getBody()) + " : Connected");
            String string = ((Request.WithBody)$request).getBody();
            if (string != null) {
                String body = string;
                boolean bl = false;
                it.write(body);
            }
        } else {
            LOG.debug("Request: " + connection.getRequestMethod() + " " + connection.getURL() + " : Connected");
        }
        this$0.checkResponseCode(connection);
        ProgressIndicator progressIndicator = $indicator;
        if (progressIndicator != null) {
            progressIndicator.checkCanceled();
        }
        Object result = $request.extractResult(this$0.createResponse(it, $indicator));
        LOG.debug("Request: " + connection.getRequestMethod() + " " + connection.getURL() + " : Result extracted");
        this$0.checkResponseError(result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final String checkResponseCode$getErrorText(HttpURLConnection connection) {
        String string;
        InputStream inputStream = connection.getErrorStream();
        if (inputStream == null) {
            return "";
        }
        InputStream errorStream = inputStream;
        InputStream stream = Intrinsics.areEqual((Object)connection.getContentEncoding(), (Object)"gzip") ? (InputStream)new GZIPInputStream(errorStream) : errorStream;
        Closeable closeable = new InputStreamReader(stream, Charsets.UTF_8);
        Throwable throwable = null;
        try {
            InputStreamReader it = (InputStreamReader)closeable;
            boolean bl = false;
            string = TextStreamsKt.readText((Reader)it);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return string;
    }

    public /* synthetic */ RequestExecutor(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(RequestExecutor.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/jpa/jpb/model/core/http/request/RequestExecutor$Companion;", "", "<init>", "()V", "encodeUserSecret", "", "user", "secret", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.javaee.jpa.jpb.model.core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String encodeUserSecret(@NotNull String user, @NotNull String secret) {
            Intrinsics.checkNotNullParameter((Object)user, (String)"user");
            Intrinsics.checkNotNullParameter((Object)secret, (String)"secret");
            Base64.Encoder encoder = Base64.getEncoder();
            String string = user + ":" + secret;
            Charset charset = Charset.defaultCharset();
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"defaultCharset(...)");
            byte[] byArray = string.getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            String string2 = encoder.encodeToString(byArray);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"encodeToString(...)");
            return string2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0019\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J+\u0010\b\u001a\u0002H\t\"\u0004\b\u0000\u0010\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\t0\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016\u00a2\u0006\u0002\u0010\u000eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/jpa/jpb/model/core/http/request/RequestExecutor$WithBasicAuth;", "Lcom/intellij/jpa/jpb/model/core/http/request/RequestExecutor;", "client", "", "secret", "", "<init>", "(Ljava/lang/String;[C)V", "execute", "R", "request", "Lcom/intellij/jpa/jpb/model/core/http/request/Request;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "(Lcom/intellij/jpa/jpb/model/core/http/request/Request;Lcom/intellij/openapi/progress/ProgressIndicator;)Ljava/lang/Object;", "intellij.javaee.jpa.jpb.model.core"})
    public static final class WithBasicAuth
    extends RequestExecutor {
        @NotNull
        private final String client;
        @NotNull
        private final char[] secret;

        public WithBasicAuth(@NotNull String client, @NotNull char[] secret) {
            Intrinsics.checkNotNullParameter((Object)client, (String)"client");
            Intrinsics.checkNotNullParameter((Object)secret, (String)"secret");
            super(null);
            this.client = client;
            this.secret = secret;
        }

        @Override
        public <R> R execute(@NotNull Request<? extends R> request, @Nullable ProgressIndicator indicator) {
            Intrinsics.checkNotNullParameter(request, (String)"request");
            RequestBuilder requestBuilder = this.createRequestBuilder(request).tuner(arg_0 -> WithBasicAuth.execute$lambda$1(request, this, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)requestBuilder, (String)"tuner(...)");
            return this.execute(requestBuilder, request, indicator);
        }

        private static final void execute$lambda$1$lambda$0(Function2 $tmp0, Object p0, Object p1) {
            $tmp0.invoke(p0, p1);
        }

        private static final void execute$lambda$1(Request $request, WithBasicAuth this$0, URLConnection connection) {
            Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
            $request.getHeaders().forEach((arg_0, arg_1) -> WithBasicAuth.execute$lambda$1$lambda$0((Function2)new Function2<String, String, Unit>((Object)connection){

                public final void invoke(String p0, String p1) {
                    ((URLConnection)this.receiver).addRequestProperty(p0, p1);
                }
            }, arg_0, arg_1));
            connection.addRequestProperty("Authorization", "Basic " + Companion.encodeUserSecret(this$0.client, new String(this$0.secret)));
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J+\u0010\u0004\u001a\u0002H\u0005\"\u0004\b\u0000\u0010\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00050\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0016\u00a2\u0006\u0002\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/intellij/jpa/jpb/model/core/http/request/RequestExecutor$WithNoAuth;", "Lcom/intellij/jpa/jpb/model/core/http/request/RequestExecutor;", "<init>", "()V", "execute", "R", "request", "Lcom/intellij/jpa/jpb/model/core/http/request/Request;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "(Lcom/intellij/jpa/jpb/model/core/http/request/Request;Lcom/intellij/openapi/progress/ProgressIndicator;)Ljava/lang/Object;", "intellij.javaee.jpa.jpb.model.core"})
    public static final class WithNoAuth
    extends RequestExecutor {
        @NotNull
        public static final WithNoAuth INSTANCE = new WithNoAuth();

        private WithNoAuth() {
            super(null);
        }

        @Override
        public <R> R execute(@NotNull Request<? extends R> request, @Nullable ProgressIndicator indicator) {
            block0: {
                Intrinsics.checkNotNullParameter(request, (String)"request");
                ProgressIndicator progressIndicator = indicator;
                if (progressIndicator == null) break block0;
                progressIndicator.checkCanceled();
            }
            return this.execute(this.createRequestBuilder(request), request, indicator);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J+\u0010\f\u001a\u0002H\r\"\u0004\b\u0000\u0010\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\r0\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016\u00a2\u0006\u0002\u0010\u0012R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000b\u00a8\u0006\u0013"}, d2={"Lcom/intellij/jpa/jpb/model/core/http/request/RequestExecutor$WithTokenAuth;", "Lcom/intellij/jpa/jpb/model/core/http/request/RequestExecutor;", "token", "", "accessTokenRefresher", "Ljava/util/function/Supplier;", "<init>", "(Ljava/lang/String;Ljava/util/function/Supplier;)V", "getToken", "()Ljava/lang/String;", "setToken", "(Ljava/lang/String;)V", "execute", "R", "request", "Lcom/intellij/jpa/jpb/model/core/http/request/Request;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "(Lcom/intellij/jpa/jpb/model/core/http/request/Request;Lcom/intellij/openapi/progress/ProgressIndicator;)Ljava/lang/Object;", "intellij.javaee.jpa.jpb.model.core"})
    public static final class WithTokenAuth
    extends RequestExecutor {
        @NotNull
        private final Supplier<String> accessTokenRefresher;
        @NotNull
        private volatile String token;

        public WithTokenAuth(@Nullable String token, @NotNull Supplier<String> accessTokenRefresher) {
            Intrinsics.checkNotNullParameter(accessTokenRefresher, (String)"accessTokenRefresher");
            super(null);
            this.accessTokenRefresher = accessTokenRefresher;
            String string = token;
            if (string == null) {
                String string2 = this.accessTokenRefresher.get();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"get(...)");
                string = string2;
            }
            this.token = string;
        }

        @NotNull
        public final String getToken() {
            return this.token;
        }

        public final void setToken(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.token = string;
        }

        @Override
        public <R> R execute(@NotNull Request<? extends R> request, @Nullable ProgressIndicator indicator) {
            R r;
            Intrinsics.checkNotNullParameter(request, (String)"request");
            ProgressIndicator progressIndicator = indicator;
            if (progressIndicator != null) {
                progressIndicator.checkCanceled();
            }
            try {
                RequestBuilder requestBuilder = this.createRequestBuilder(request).tuner(arg_0 -> WithTokenAuth.execute$lambda$1(request, this, arg_0));
                Intrinsics.checkNotNullExpressionValue((Object)requestBuilder, (String)"tuner(...)");
                r = this.execute(requestBuilder, request, indicator);
            }
            catch (InvalidTokenException e) {
                this.token = this.accessTokenRefresher.get();
                r = this.execute(request, indicator);
            }
            return r;
        }

        private static final void execute$lambda$1$lambda$0(Function2 $tmp0, Object p0, Object p1) {
            $tmp0.invoke(p0, p1);
        }

        private static final void execute$lambda$1(Request $request, WithTokenAuth this$0, URLConnection connection) {
            Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
            $request.getHeaders().forEach((arg_0, arg_1) -> WithTokenAuth.execute$lambda$1$lambda$0((Function2)new Function2<String, String, Unit>((Object)connection){

                public final void invoke(String p0, String p1) {
                    ((URLConnection)this.receiver).addRequestProperty(p0, p1);
                }
            }, arg_0, arg_1));
            connection.addRequestProperty("Authorization", "Bearer " + this$0.token);
        }
    }
}

