/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.jpb.model.core.model;

import com.google.common.base.Splitter;
import com.intellij.jpa.jpb.model.core.model.DataStore;
import com.intellij.jpa.jpb.model.core.model.dbprop.DbProperties;
import com.intellij.jpa.jpb.model.core.model.dbtype.DbType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractRdbmsStore
implements DataStore {
    public static final Splitter NAMES_SPLITTER = Splitter.on((String)",").omitEmptyStrings().trimResults();
    protected String name;
    protected DbProperties dbProperties;

    public AbstractRdbmsStore(@Nullable String name) {
        this.name = StringUtil.notNullize((String)name);
    }

    public AbstractRdbmsStore(@NotNull Project project, @NotNull DbType dbType) {
        if (project == null) {
            AbstractRdbmsStore.$$$reportNull$$$0(0);
        }
        if (dbType == null) {
            AbstractRdbmsStore.$$$reportNull$$$0(1);
        }
        this(project.getName());
        this.dbProperties = DbProperties.create(dbType, project.getName());
    }

    public String getDescription() {
        return this.name + this.getLocationString();
    }

    @NotNull
    public String getLocationString() {
        String url;
        String string = url = this.dbProperties != null ? this.dbProperties.getUrl() : null;
        return url != null ? " (" + (String)(url.length() <= 50 ? url : url.substring(0, 50) + "...") + ")" : "";
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public DbProperties getDbProperties() {
        return this.dbProperties;
    }

    public void setDbProperties(DbProperties dbProperties) {
        this.dbProperties = dbProperties;
    }

    public abstract String getId();

    public DataStore clone() {
        try {
            return (DataStore)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractRdbmsStore dataStore = (AbstractRdbmsStore)o;
        return Objects.equals(this.name, dataStore.getName()) && Objects.equals(this.dbProperties, dataStore.getDbProperties());
    }

    public int hashCode() {
        return Objects.hash(this.name, this.dbProperties);
    }

    public String toString() {
        return this.getDescription();
    }

    public boolean isValid() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "dbType";
                break;
            }
        }
        objectArray[1] = "com/intellij/jpa/jpb/model/core/model/AbstractRdbmsStore";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

