/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.jpb.model.core.module;

import com.intellij.jpa.jpb.model.core.module.HModule;
import com.intellij.jpa.jpb.model.core.module.HModuleKt;
import com.intellij.jpa.jpb.model.core.util.SourcesUtils;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopeUtil;
import com.intellij.psi.search.SearchScope;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0016\u0010\u0005\u001a\u0004\u0018\u00010\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000e0\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0010R\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000e0\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0010R\u001a\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000e0\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0010R\u0014\u0010\u0017\u001a\u00020\u00188VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006\u001b"}, d2={"Lcom/intellij/jpa/jpb/model/core/module/GradleHModule;", "Lcom/intellij/jpa/jpb/model/core/module/HModule;", "rootModule", "Lcom/intellij/openapi/module/Module;", "mainModule", "testModule", "<init>", "(Lcom/intellij/openapi/module/Module;Lcom/intellij/openapi/module/Module;Lcom/intellij/openapi/module/Module;)V", "getRootModule", "()Lcom/intellij/openapi/module/Module;", "getMainModule", "getTestModule", "sourceRoots", "", "Lcom/intellij/psi/PsiDirectory;", "getSourceRoots", "()Ljava/util/List;", "resourceRoots", "getResourceRoots", "testSourceRoots", "getTestSourceRoots", "testResourceRoots", "getTestResourceRoots", "librariesSearchScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "getLibrariesSearchScope", "()Lcom/intellij/psi/search/GlobalSearchScope;", "intellij.javaee.jpa.jpb.model.core"})
public final class GradleHModule
implements HModule {
    @NotNull
    private final Module rootModule;
    @Nullable
    private final Module mainModule;
    @Nullable
    private final Module testModule;

    public GradleHModule(@NotNull Module rootModule, @Nullable Module mainModule, @Nullable Module testModule) {
        Intrinsics.checkNotNullParameter((Object)rootModule, (String)"rootModule");
        this.rootModule = rootModule;
        this.mainModule = mainModule;
        this.testModule = testModule;
    }

    @Override
    @NotNull
    public Module getRootModule() {
        return this.rootModule;
    }

    @Override
    @Nullable
    public Module getMainModule() {
        return this.mainModule;
    }

    @Override
    @Nullable
    public Module getTestModule() {
        return this.testModule;
    }

    @Override
    @NotNull
    public List<PsiDirectory> getSourceRoots() {
        Module module = this.getMainModule();
        if (module == null) {
            return CollectionsKt.emptyList();
        }
        Module mainIdeaModule = module;
        List<VirtualFile> list = SourcesUtils.INSTANCE.getSourceRoots(mainIdeaModule, false);
        Project project = mainIdeaModule.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        return HModuleKt.access$toPsiDirectories(list, project);
    }

    @Override
    @NotNull
    public List<PsiDirectory> getResourceRoots() {
        Module module = this.getMainModule();
        if (module == null) {
            return CollectionsKt.emptyList();
        }
        Module mainIdeaModule = module;
        List<VirtualFile> list = SourcesUtils.INSTANCE.getResourceRoots(mainIdeaModule, false);
        Project project = mainIdeaModule.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        return HModuleKt.access$toPsiDirectories(list, project);
    }

    @Override
    @NotNull
    public List<PsiDirectory> getTestSourceRoots() {
        Module module = this.getTestModule();
        if (module == null) {
            return CollectionsKt.emptyList();
        }
        Module testIdeaModule = module;
        List<VirtualFile> list = SourcesUtils.INSTANCE.getSourceRoots(testIdeaModule, true);
        Project project = testIdeaModule.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        return HModuleKt.access$toPsiDirectories(list, project);
    }

    @Override
    @NotNull
    public List<PsiDirectory> getTestResourceRoots() {
        Module module = this.getTestModule();
        if (module == null) {
            return CollectionsKt.emptyList();
        }
        Module testIdeaModule = module;
        List<VirtualFile> list = SourcesUtils.INSTANCE.getResourceRoots(testIdeaModule, true);
        Project project = testIdeaModule.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        return HModuleKt.access$toPsiDirectories(list, project);
    }

    @Override
    @NotNull
    public GlobalSearchScope getLibrariesSearchScope() {
        Module module = this.getMainModule();
        if (module == null) {
            GlobalSearchScope globalSearchScope = GlobalSearchScope.EMPTY_SCOPE;
            Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"EMPTY_SCOPE");
            return globalSearchScope;
        }
        Module mainModule = module;
        GlobalSearchScope globalSearchScope = GlobalSearchScopeUtil.toGlobalSearchScope((SearchScope)((SearchScope)mainModule.getModuleWithLibrariesScope().intersectWith(GlobalSearchScope.notScope((GlobalSearchScope)mainModule.getModuleScope()))), (Project)mainModule.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"toGlobalSearchScope(...)");
        return globalSearchScope;
    }
}

