/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.jpb.model.core.util;

import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiManager;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresWriteLock;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;

public class DirectoryUtil {
    @NotNull
    public static PsiDirectory findOrCreatePackageDirectory(@NotNull PsiDirectory sourceRoot, @NotNull String packageFqn) {
        if (sourceRoot == null) {
            DirectoryUtil.$$$reportNull$$$0(0);
        }
        if (packageFqn == null) {
            DirectoryUtil.$$$reportNull$$$0(1);
        }
        if (StringUtils.isBlank((CharSequence)packageFqn)) {
            PsiDirectory psiDirectory = sourceRoot;
            if (psiDirectory == null) {
                DirectoryUtil.$$$reportNull$$$0(2);
            }
            return psiDirectory;
        }
        PsiDirectory psiDirectory = (PsiDirectory)WriteCommandAction.runWriteCommandAction((Project)sourceRoot.getProject(), () -> DirectoryUtil.findOrCreatePackageDirectoryWriteLockAware(sourceRoot, packageFqn));
        if (psiDirectory == null) {
            DirectoryUtil.$$$reportNull$$$0(3);
        }
        return psiDirectory;
    }

    @NotNull
    @RequiresWriteLock
    public static PsiDirectory findOrCreatePackageDirectoryWriteLockAware(@NotNull PsiDirectory sourceRoot, @NotNull String packageFqn) {
        if (sourceRoot == null) {
            DirectoryUtil.$$$reportNull$$$0(4);
        }
        if (packageFqn == null) {
            DirectoryUtil.$$$reportNull$$$0(5);
        }
        ThreadingAssertions.assertWriteAccess();
        List<String> parts = Arrays.stream(packageFqn.split("\\.")).filter(StringUtils::isNotBlank).toList();
        PsiDirectory directory = sourceRoot;
        for (String part : parts) {
            PsiDirectory subdirectory = directory.findSubdirectory(part);
            if (subdirectory == null) {
                subdirectory = directory.createSubdirectory(part);
            }
            directory = subdirectory;
        }
        PsiDirectory psiDirectory = directory;
        if (psiDirectory == null) {
            DirectoryUtil.$$$reportNull$$$0(6);
        }
        return psiDirectory;
    }

    @Nullable
    public static PsiDirectory findResourcesForModule(Project project, Module module) {
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        Optional<PsiDirectory> resourcesDir = ModuleRootManager.getInstance((Module)module).getSourceRoots(JavaModuleSourceRootTypes.RESOURCES).stream().map(arg_0 -> ((PsiManager)psiManager).findDirectory(arg_0)).filter(Objects::nonNull).findFirst();
        return resourcesDir.orElse(null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceRoot";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageFqn";
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jpa/jpb/model/core/util/DirectoryUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jpa/jpb/model/core/util/DirectoryUtil";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "findOrCreatePackageDirectory";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "findOrCreatePackageDirectoryWriteLockAware";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findOrCreatePackageDirectory";
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findOrCreatePackageDirectoryWriteLockAware";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 6 -> new IllegalStateException(string);
        };
    }
}

