/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.jpb.model.liquibase.ns;

import com.intellij.jpa.jpb.model.backend.ed.JavaEntityWriter;
import com.intellij.jpa.jpb.model.config.CustomStrategyConfig;
import com.intellij.jpa.jpb.model.config.CustomStrategyState;
import com.intellij.jpa.jpb.model.core.pg.PgKeepClassMembers;
import com.intellij.jpa.jpb.model.liquibase.ns.PhysicalNamingStrategy;
import com.intellij.jpa.jpb.model.liquibase.ns.PhysicalNamingStrategyStandardImpl;
import com.intellij.jpa.jpb.model.service.ScriptService;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.GlobalSearchScope;
import java.io.Serializable;
import java.lang.reflect.Method;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00172\u00020\u00012\u00020\u0002:\u0001\u0017B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0014\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\r\u001a\u0004\u0018\u00010\fH\u0016J\u0014\u0010\u000e\u001a\u0004\u0018\u00010\f2\b\u0010\r\u001a\u0004\u0018\u00010\fH\u0016J\u0014\u0010\u000f\u001a\u0004\u0018\u00010\f2\b\u0010\r\u001a\u0004\u0018\u00010\fH\u0016J\u0012\u0010\u0010\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\fH\u0016J\u0014\u0010\u0011\u001a\u0004\u0018\u00010\f2\b\u0010\r\u001a\u0004\u0018\u00010\fH\u0016J\u001c\u0010\u0012\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0013\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\fH\u0002J\u0010\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\fR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/jpa/jpb/model/liquibase/ns/CustomPhysicalNamingStrategy;", "Lcom/intellij/jpa/jpb/model/liquibase/ns/PhysicalNamingStrategy;", "Ljava/io/Serializable;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "compiledStrategy", "", "toCatalogName", "", "name", "toSchemaName", "toTableName", "toSequenceName", "toColumnName", "apply", "methodName", "setStrategyFqn", "", "fqn", "Companion", "intellij.javaee.jpa.jpb.model"})
public final class CustomPhysicalNamingStrategy
implements PhysicalNamingStrategy,
Serializable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @Nullable
    private Object compiledStrategy;
    @NotNull
    private static final Logger log;

    public CustomPhysicalNamingStrategy(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @Override
    @Nullable
    public String toCatalogName(@Nullable String name) {
        return this.apply("toCatalogName", name);
    }

    @Override
    @Nullable
    public String toSchemaName(@Nullable String name) {
        return this.apply("toSchemaName", name);
    }

    @Override
    @Nullable
    public String toTableName(@Nullable String name) {
        return this.apply("toTableName", name);
    }

    @Override
    @NotNull
    public String toSequenceName(@Nullable String name) {
        String string = this.apply("toSequenceName", name);
        if (string == null) {
            string = "";
        }
        return string;
    }

    @Override
    @Nullable
    public String toColumnName(@Nullable String name) {
        return this.apply("toColumnName", name);
    }

    private final String apply(String methodName, String name) {
        String string;
        if (this.compiledStrategy == null) {
            PgKeepClassMembers pgKeepClassMembers = CustomStrategyConfig.Companion.getInstance(this.project);
            this.setStrategyFqn(pgKeepClassMembers != null && (pgKeepClassMembers = ((CustomStrategyConfig)pgKeepClassMembers).getState()) != null ? ((CustomStrategyState)pgKeepClassMembers).getCustomNamingStrategyFqn() : null);
        }
        if (name == null || this.compiledStrategy == null) {
            return name;
        }
        try {
            Object object = this.compiledStrategy;
            Intrinsics.checkNotNull((Object)object);
            Object[] objectArray = new Class[]{String.class};
            Method method = object.getClass().getMethod(methodName, (Class<?>[])objectArray);
            objectArray = new Object[]{name};
            Object object2 = method.invoke(this.compiledStrategy, objectArray);
            string = object2 != null ? object2.toString() : null;
        }
        catch (Exception e) {
            if (e instanceof ControlFlowException) {
                throw e;
            }
            log.error("Cannot evaluate custom naming strategy method", (Throwable)e);
            string = name;
        }
        return string;
    }

    public final boolean setStrategyFqn(@Nullable String fqn) {
        boolean bl;
        if (fqn == null) {
            this.compiledStrategy = null;
            return true;
        }
        try {
            PsiClass psiClass = JavaPsiFacade.getInstance((Project)this.project).findClass(fqn, GlobalSearchScope.projectScope((Project)this.project));
            Intrinsics.checkNotNull((Object)psiClass);
            PsiClass strategyClass = psiClass;
            String scriptText = StringsKt.trimIndent((String)("\n                import org.hibernate.boot.model.naming.Identifier;\n                \n                public class Wrapper {\n                    var inner = new " + strategyClass.getName() + "();\n                \tString toCatalogName(String logicalName) { \n                        return inner.toPhysicalCatalogName(Identifier.toIdentifier(logicalName), null)?.getText();\n                    }\n                \tString toSchemaName(String logicalName) { \n                        return inner.toPhysicalSchemaName(Identifier.toIdentifier(logicalName), null)?.getText();\n                    }\n                \tString toTableName(String logicalName) { \n                        return inner.toPhysicalTableName(Identifier.toIdentifier(logicalName), null)?.getText();\n                    }\n                \tString toSequenceName(String logicalName) { \n                        return inner.toPhysicalSequenceName(Identifier.toIdentifier(logicalName), null)?.getText();\n                    }\n                \tString toColumnName(String logicalName) { \n                        return inner.toPhysicalColumnName(Identifier.toIdentifier(logicalName), null)?.getText();\n                    }\n                }\n                return new Wrapper();\n            "));
            this.compiledStrategy = ScriptService.Companion.getInstance(this.project).evaluateScript(strategyClass, scriptText);
            bl = true;
        }
        catch (Exception e) {
            if (e instanceof ControlFlowException) {
                throw e;
            }
            log.error("Cannot compile custom naming strategy class", (Throwable)e);
            this.compiledStrategy = PhysicalNamingStrategyStandardImpl.INSTANCE;
            bl = false;
        }
        return bl;
    }

    static {
        Logger logger = Logger.getInstance(JavaEntityWriter.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        log = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007R\u0013\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/jpa/jpb/model/liquibase/ns/CustomPhysicalNamingStrategy$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/jpa/jpb/model/liquibase/ns/CustomPhysicalNamingStrategy;", "project", "Lcom/intellij/openapi/project/Project;", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.javaee.jpa.jpb.model"})
    @SourceDebugExtension(value={"SMAP\nCustomPhysicalNamingStrategy.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CustomPhysicalNamingStrategy.kt\ncom/intellij/jpa/jpb/model/liquibase/ns/CustomPhysicalNamingStrategy$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,102:1\n31#2,2:103\n*S KotlinDebug\n*F\n+ 1 CustomPhysicalNamingStrategy.kt\ncom/intellij/jpa/jpb/model/liquibase/ns/CustomPhysicalNamingStrategy$Companion\n*L\n19#1:103,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final CustomPhysicalNamingStrategy getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<CustomPhysicalNamingStrategy> serviceClass$iv = CustomPhysicalNamingStrategy.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (CustomPhysicalNamingStrategy)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

