/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.jpb.model.model;

import com.intellij.jpa.jpb.model.backend.ed.annotation.Annotation;
import com.intellij.openapi.util.NlsSafe;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0010\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B'\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0013\u0010\u0015\u001a\u00020\u00072\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u000e\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u001bR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR \u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0012\"\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001c"}, d2={"Lcom/intellij/jpa/jpb/model/model/EntityGraph;", "", "value", "", "attributePaths", "", "isLoad", "", "<init>", "(Ljava/lang/String;Ljava/util/List;Z)V", "getValue", "()Ljava/lang/String;", "setValue", "(Ljava/lang/String;)V", "getAttributePaths", "()Ljava/util/List;", "setAttributePaths", "(Ljava/util/List;)V", "()Z", "setLoad", "(Z)V", "equals", "other", "hashCode", "", "toAnnotation", "strategy", "Lcom/intellij/jpa/jpb/model/backend/ed/annotation/Annotation$GenerationStrategy;", "intellij.javaee.jpa.jpb.model"})
public final class EntityGraph {
    @NotNull
    private String value;
    @NotNull
    private List<String> attributePaths;
    private boolean isLoad;

    public EntityGraph(@NlsSafe @NotNull String value, @NotNull List<String> attributePaths, boolean isLoad) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter(attributePaths, (String)"attributePaths");
        this.value = value;
        this.attributePaths = attributePaths;
        this.isLoad = isLoad;
    }

    @NotNull
    public final String getValue() {
        return this.value;
    }

    public final void setValue(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.value = string;
    }

    @NotNull
    public final List<String> getAttributePaths() {
        return this.attributePaths;
    }

    public final void setAttributePaths(@NotNull List<String> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.attributePaths = list;
    }

    public final boolean isLoad() {
        return this.isLoad;
    }

    public final void setLoad(boolean bl) {
        this.isLoad = bl;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type com.intellij.jpa.jpb.model.model.EntityGraph");
        EntityGraph cfr_ignored_0 = (EntityGraph)other;
        if (!Intrinsics.areEqual((Object)this.value, (Object)((EntityGraph)other).value)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.attributePaths, ((EntityGraph)other).attributePaths)) {
            return false;
        }
        return this.isLoad == ((EntityGraph)other).isLoad;
    }

    public int hashCode() {
        int result = this.value.hashCode();
        result = 31 * result + ((Object)this.attributePaths).hashCode();
        result = 31 * result + Boolean.hashCode(this.isLoad);
        return result;
    }

    @NotNull
    public final String toAnnotation(@NotNull Annotation.GenerationStrategy strategy) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)((Object)strategy), (String)"strategy");
        String valueText = ((CharSequence)this.value).length() > 0 ? "value = \"" + this.value + "\"" : "";
        if (!((Collection)this.attributePaths).isEmpty()) {
            String startToken = strategy.getStartArrayToken();
            String endToken = strategy.getEndArrayToken();
            object = "attributePaths = " + startToken + CollectionsKt.joinToString$default((Iterable)this.attributePaths, null, null, null, (int)0, null, EntityGraph::toAnnotation$lambda$0, (int)31, null) + endToken;
        } else {
            object = "";
        }
        String pathsText = object;
        String typeText = this.isLoad ? ", type = org.springframework.data.jpa.repository.EntityGraph.EntityGraphType.LOAD" : "";
        return "@org.springframework.data.jpa.repository.EntityGraph(" + valueText + pathsText + typeText + ")";
    }

    private static final CharSequence toAnnotation$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return "\"" + it + "\"";
    }
}

