/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.jpb.model.model;

import com.intellij.jpa.jpb.model.model.ClassModel;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0096\u0002J\b\u0010\u0015\u001a\u00020\u0016H\u0016R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0002\u001a\t\u0018\u00010\u0003\u00a2\u0006\u0002\b\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u000e\u00a8\u0006\u0017"}, d2={"Lcom/intellij/jpa/jpb/model/model/ExistingClassModel;", "Lcom/intellij/jpa/jpb/model/model/ClassModel;", "psiClass", "Lcom/intellij/psi/PsiClass;", "<init>", "(Lcom/intellij/psi/PsiClass;)V", "psiClassSP", "Lcom/intellij/psi/SmartPsiElementPointer;", "Lorg/jetbrains/annotations/Nullable;", "getPsiClass", "()Lcom/intellij/psi/PsiClass;", "className", "", "getClassName", "()Ljava/lang/String;", "packageName", "getPackageName", "equals", "", "other", "", "hashCode", "", "intellij.javaee.jpa.jpb.model"})
public class ExistingClassModel
implements ClassModel {
    @NotNull
    private final SmartPsiElementPointer<PsiClass> psiClassSP;
    @NotNull
    private final String className;

    public ExistingClassModel(@NotNull PsiClass psiClass) {
        Intrinsics.checkNotNullParameter((Object)psiClass, (String)"psiClass");
        SmartPsiElementPointer smartPsiElementPointer = SmartPointerManager.createPointer((PsiElement)((PsiElement)psiClass));
        Intrinsics.checkNotNullExpressionValue((Object)smartPsiElementPointer, (String)"createPointer(...)");
        this.psiClassSP = smartPsiElementPointer;
        String string = psiClass.getName();
        Intrinsics.checkNotNull((Object)string);
        this.className = string;
    }

    @Nullable
    public final PsiClass getPsiClass() {
        return (PsiClass)this.psiClassSP.getElement();
    }

    @Override
    @NotNull
    public String getClassName() {
        return this.className;
    }

    @Override
    @NotNull
    public String getPackageName() {
        JavaDirectoryService javaDirectoryService = JavaDirectoryService.getInstance();
        PsiClass psiClass = this.getPsiClass();
        Intrinsics.checkNotNull((Object)psiClass);
        PsiPackage psiPackage = javaDirectoryService.getPackage(psiClass.getContainingFile().getContainingDirectory());
        String string = psiPackage != null ? psiPackage.getQualifiedName() : null;
        Intrinsics.checkNotNull((Object)string);
        return string;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ExistingClassModel)) {
            return false;
        }
        Boolean bl = new EqualsBuilder().append((Object)this.getClassName(), (Object)((ExistingClassModel)other).getClassName()).build();
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"build(...)");
        return bl;
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{this.getPsiClass(), this.getClassName()};
        return Objects.hash(objectArray);
    }
}

