/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.jpb.model.model;

import com.google.common.base.Preconditions;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nullable;

public class Sort
implements Iterable<Order>,
Serializable {
    private static final long serialVersionUID = 5737186511678863905L;
    private static final Sort UNSORTED = Sort.by(new Order[0]);
    public static final Direction DEFAULT_DIRECTION = Direction.ASC;
    private final List<Order> orders;

    protected Sort(List<Order> orders) {
        this.orders = orders;
    }

    private Sort(Direction direction, List<String> properties) {
        if (properties == null || properties.isEmpty()) {
            throw new IllegalArgumentException("You have to provide at least one property to sort by!");
        }
        this.orders = ContainerUtil.map(properties, it -> new Order(direction, (String)it));
    }

    public static Sort by(String ... properties) {
        Preconditions.checkNotNull((Object)properties, (Object)"Properties must not be null!");
        return properties.length == 0 ? Sort.unsorted() : new Sort(DEFAULT_DIRECTION, Arrays.asList(properties));
    }

    public static Sort by(List<Order> orders) {
        Preconditions.checkNotNull(orders, (Object)"Orders must not be null!");
        return orders.isEmpty() ? Sort.unsorted() : new Sort(orders);
    }

    public static Sort by(Order ... orders) {
        Preconditions.checkNotNull((Object)orders, (Object)"Orders must not be null!");
        return new Sort(Arrays.asList(orders));
    }

    public static Sort by(Direction direction, String ... properties) {
        Preconditions.checkNotNull((Object)((Object)direction), (Object)"Direction must not be null!");
        Preconditions.checkNotNull((Object)properties, (Object)"Properties must not be null!");
        Preconditions.checkState((properties.length > 0 ? 1 : 0) != 0, (Object)"At least one property must be given!");
        return Sort.by(ContainerUtil.map((Object[])properties, it -> new Order(direction, (String)it)));
    }

    public static Sort unsorted() {
        return UNSORTED;
    }

    public Sort descending() {
        return this.withDirection(Direction.DESC);
    }

    public Sort ascending() {
        return this.withDirection(Direction.ASC);
    }

    public boolean isSorted() {
        return !this.orders.isEmpty();
    }

    public boolean isUnsorted() {
        return !this.isSorted();
    }

    public Sort and(Sort sort) {
        Preconditions.checkNotNull((Object)sort, (Object)"Sort must not be null!");
        ArrayList<Order> these = new ArrayList<Order>(this.orders);
        for (Order order : sort) {
            these.add(order);
        }
        return Sort.by(these);
    }

    @Nullable
    public Order getOrderFor(String property) {
        for (Order order : this) {
            if (!order.getProperty().equals(property)) continue;
            return order;
        }
        return null;
    }

    @Override
    public Iterator<Order> iterator() {
        return this.orders.iterator();
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Sort)) {
            return false;
        }
        Sort that = (Sort)obj;
        return this.orders.equals(that.orders);
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.orders.hashCode();
        return result;
    }

    public String toString() {
        return this.orders.isEmpty() ? "UNSORTED" : StreamEx.of(this.orders).joining((CharSequence)",");
    }

    private Sort withDirection(Direction direction) {
        return Sort.by(ContainerUtil.map(this.orders, it -> new Order(direction, it.getProperty())));
    }

    public static enum Direction {
        ASC,
        DESC;


        public boolean isAscending() {
            return this.equals((Object)ASC);
        }

        public boolean isDescending() {
            return this.equals((Object)DESC);
        }

        public static Direction fromString(String value) {
            try {
                return Direction.valueOf(value.toUpperCase(Locale.US));
            }
            catch (Exception e) {
                throw new IllegalArgumentException(String.format("Invalid value '%s' for orders given! Has to be either 'desc' or 'asc' (case insensitive).", value), e);
            }
        }

        public static Optional<Direction> fromOptionalString(String value) {
            try {
                return Optional.of(Direction.fromString(value));
            }
            catch (IllegalArgumentException e) {
                return Optional.empty();
            }
        }
    }

    public static class Order
    implements Serializable {
        private static final long serialVersionUID = 1522511010900108987L;
        private static final boolean DEFAULT_IGNORE_CASE = false;
        private static final NullHandling DEFAULT_NULL_HANDLING = NullHandling.NATIVE;
        private final Direction direction;
        private final String property;
        private final boolean ignoreCase;
        private final NullHandling nullHandling;

        public Order(@Nullable Direction direction, String property) {
            this(direction, property, false, DEFAULT_NULL_HANDLING);
        }

        public Order(@Nullable Direction direction, String property, NullHandling nullHandlingHint) {
            this(direction, property, false, nullHandlingHint);
        }

        public static Order by(String property) {
            return new Order(DEFAULT_DIRECTION, property);
        }

        public static Order asc(String property) {
            return new Order(Direction.ASC, property, DEFAULT_NULL_HANDLING);
        }

        public static Order desc(String property) {
            return new Order(Direction.DESC, property, DEFAULT_NULL_HANDLING);
        }

        private Order(@Nullable Direction direction, String property, boolean ignoreCase, NullHandling nullHandling) {
            if (StringUtil.isEmptyOrSpaces((String)property)) {
                throw new IllegalArgumentException("Property must not null or empty!");
            }
            this.direction = direction == null ? DEFAULT_DIRECTION : direction;
            this.property = property;
            this.ignoreCase = ignoreCase;
            this.nullHandling = nullHandling;
        }

        public Direction getDirection() {
            return this.direction;
        }

        public String getProperty() {
            return this.property;
        }

        public boolean isAscending() {
            return this.direction.isAscending();
        }

        public boolean isDescending() {
            return this.direction.isDescending();
        }

        public boolean isIgnoreCase() {
            return this.ignoreCase;
        }

        public Order with(Direction direction) {
            return new Order(direction, this.property, this.ignoreCase, this.nullHandling);
        }

        public Order withProperty(String property) {
            return new Order(this.direction, property, this.ignoreCase, this.nullHandling);
        }

        public Sort withProperties(String ... properties) {
            return Sort.by(this.direction, properties);
        }

        public Order ignoreCase() {
            return new Order(this.direction, this.property, true, this.nullHandling);
        }

        public Order with(NullHandling nullHandling) {
            return new Order(this.direction, this.property, this.ignoreCase, nullHandling);
        }

        public Order nullsFirst() {
            return this.with(NullHandling.NULLS_FIRST);
        }

        public Order nullsLast() {
            return this.with(NullHandling.NULLS_LAST);
        }

        public Order nullsNative() {
            return this.with(NullHandling.NATIVE);
        }

        public NullHandling getNullHandling() {
            return this.nullHandling;
        }

        public int hashCode() {
            int result = 17;
            result = 31 * result + this.direction.hashCode();
            result = 31 * result + this.property.hashCode();
            result = 31 * result + (this.ignoreCase ? 1 : 0);
            result = 31 * result + this.nullHandling.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Order)) {
                return false;
            }
            Order that = (Order)obj;
            return this.direction.equals((Object)that.direction) && this.property.equals(that.property) && this.ignoreCase == that.ignoreCase && this.nullHandling.equals((Object)that.nullHandling);
        }

        public String toString() {
            Object result = String.format("%s: %s", new Object[]{this.property, this.direction});
            if (!NullHandling.NATIVE.equals((Object)this.nullHandling)) {
                result = (String)result + ", " + this.nullHandling;
            }
            if (this.ignoreCase) {
                result = (String)result + ", ignoring case";
            }
            return result;
        }
    }

    public static enum NullHandling {
        NATIVE,
        NULLS_FIRST,
        NULLS_LAST;

    }
}

