/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.jpb.model.reference.provider;

import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.icons.AllIcons;
import com.intellij.jpa.jpb.model.complition.ClassPropertyCompletionHelper;
import com.intellij.jpa.jpb.model.complition.JpbLookupElements;
import com.intellij.jpa.jpb.model.core.msg.JpaModelBundle;
import com.intellij.jpa.jpb.model.liquibase.ns.PhysicalNamingStrategy;
import com.intellij.jpa.jpb.model.model.EntityAttribute;
import com.intellij.jpa.jpb.model.service.JpabReferenceManager;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiReferenceBase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B+\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0002\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\n\u0010\u0015\u001a\u0004\u0018\u00010\u0002H\u0016J\u0013\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0016\u00a2\u0006\u0002\u0010\u0019J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0006\u001a\u00020\u0005H\u0014J\b\u0010\u001c\u001a\u00020\u0005H\u0016J\b\u0010\u001d\u001a\u00020\u001bH\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/jpa/jpb/model/reference/provider/TableColumnNameReference;", "Lcom/intellij/psi/PsiReferenceBase;", "Lcom/intellij/psi/PsiElement;", "Lcom/intellij/codeInsight/daemon/EmptyResolveMessageProvider;", "tableName", "", "columnName", "attributeValue", "textRange", "Lcom/intellij/openapi/util/TextRange;", "<init>", "(Ljava/lang/String;Ljava/lang/String;Lcom/intellij/psi/PsiElement;Lcom/intellij/openapi/util/TextRange;)V", "getTableName", "()Ljava/lang/String;", "getColumnName", "project", "Lcom/intellij/openapi/project/Project;", "getProject", "()Lcom/intellij/openapi/project/Project;", "referenceManager", "Lcom/intellij/jpa/jpb/model/service/JpabReferenceManager;", "resolve", "getVariants", "", "", "()[Ljava/lang/Object;", "filterColumnName", "", "getUnresolvedMessagePattern", "isSoft", "intellij.javaee.jpa.jpb.model"})
@SourceDebugExtension(value={"SMAP\nTableColumnNameReference.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TableColumnNameReference.kt\ncom/intellij/jpa/jpb/model/reference/provider/TableColumnNameReference\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,79:1\n37#2,2:80\n*S KotlinDebug\n*F\n+ 1 TableColumnNameReference.kt\ncom/intellij/jpa/jpb/model/reference/provider/TableColumnNameReference\n*L\n71#1:80,2\n*E\n"})
public class TableColumnNameReference
extends PsiReferenceBase<PsiElement>
implements EmptyResolveMessageProvider {
    @NotNull
    private final String tableName;
    @Nullable
    private final String columnName;
    @NotNull
    private final Project project;
    @NotNull
    private final JpabReferenceManager referenceManager;

    public TableColumnNameReference(@NotNull String tableName, @Nullable String columnName, @NotNull PsiElement attributeValue, @NotNull TextRange textRange) {
        Intrinsics.checkNotNullParameter((Object)tableName, (String)"tableName");
        Intrinsics.checkNotNullParameter((Object)attributeValue, (String)"attributeValue");
        Intrinsics.checkNotNullParameter((Object)textRange, (String)"textRange");
        super(attributeValue, textRange);
        this.tableName = tableName;
        this.columnName = columnName;
        Project project = attributeValue.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        this.project = project;
        this.referenceManager = JpabReferenceManager.Companion.getInstance(this.project);
    }

    public /* synthetic */ TableColumnNameReference(String string, String string2, PsiElement psiElement, TextRange textRange, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            textRange = ElementManipulators.getValueTextRange((PsiElement)psiElement);
        }
        this(string, string2, psiElement, textRange);
    }

    @NotNull
    public final String getTableName() {
        return this.tableName;
    }

    @Nullable
    public final String getColumnName() {
        return this.columnName;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @Nullable
    public PsiElement resolve() {
        try {
            CharSequence charSequence = this.columnName;
            if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
                return null;
            }
            return (PsiElement)this.referenceManager.findAttributeMember(this.tableName, this.columnName);
        }
        catch (Exception e) {
            return null;
        }
    }

    @NotNull
    public Object[] getVariants() {
        List<EntityAttribute> list;
        try {
            list = this.referenceManager.getTableAttributes(this.tableName);
        }
        catch (Exception e) {
            if (e instanceof ControlFlowException) {
                throw e;
            }
            return new Object[0];
        }
        List<EntityAttribute> tableAttributes = list;
        List variants = new ArrayList();
        PhysicalNamingStrategy namingStrategy = PhysicalNamingStrategy.Companion.getInstance(this.project);
        for (EntityAttribute attr : tableAttributes) {
            String string;
            String attrColumn = attr.getColumn();
            CharSequence charSequence = attrColumn;
            if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) continue;
            String string2 = namingStrategy.toColumnName(attrColumn);
            Intrinsics.checkNotNull((Object)string2);
            attrColumn = string2;
            if (!this.filterColumnName(attrColumn)) continue;
            PsiMember member = this.referenceManager.getAttributeMember(attr);
            if (member != null) {
                String string3 = ClassPropertyCompletionHelper.getFieldType(member);
                Intrinsics.checkNotNull((Object)string3);
                string = string3;
            } else {
                string = "<unknown type>";
            }
            String typeText = string;
            LookupElementBuilder lookupElementBuilder = JpbLookupElements.element(attrColumn, typeText).withPsiElement(attr.getPsiElement()).withIcon(AllIcons.Javaee.PersistenceEntity).withCaseSensitivity(false);
            Intrinsics.checkNotNullExpressionValue((Object)lookupElementBuilder, (String)"withCaseSensitivity(...)");
            LookupElement element = (LookupElement)lookupElementBuilder;
            variants.add(element);
        }
        Collection $this$toTypedArray$iv = variants;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new Object[0]);
    }

    protected boolean filterColumnName(@NotNull String columnName) {
        Intrinsics.checkNotNullParameter((Object)columnName, (String)"columnName");
        return true;
    }

    @NotNull
    public String getUnresolvedMessagePattern() {
        Object[] objectArray = new Object[]{this.columnName};
        String string = JpaModelBundle.message("inspection.message.unknown.column", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    public boolean isSoft() {
        return true;
    }
}

