/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.jpb.model.service;

import com.google.common.base.Strings;
import com.intellij.jpa.jpb.model.backend.ed.EntityDesignHelper;
import com.intellij.jpa.jpb.model.backend.ed.indexing.EntitySearch;
import com.intellij.jpa.jpb.model.core.CacheKeyStore;
import com.intellij.jpa.jpb.model.core.model.dbtype.DbType;
import com.intellij.jpa.jpb.model.core.msg.JpaModelBundle;
import com.intellij.jpa.jpb.model.core.notifydialog.HNotificationManager;
import com.intellij.jpa.jpb.model.core.util.RecursionGuard;
import com.intellij.jpa.jpb.model.liquibase.ns.PhysicalNamingStrategy;
import com.intellij.jpa.jpb.model.model.AttributeOverride;
import com.intellij.jpa.jpb.model.model.BaseEntity;
import com.intellij.jpa.jpb.model.model.CachedEntityAttributeModel;
import com.intellij.jpa.jpb.model.model.CollectionTable;
import com.intellij.jpa.jpb.model.model.CollectionTableAttribute;
import com.intellij.jpa.jpb.model.model.Datatype;
import com.intellij.jpa.jpb.model.model.Datatypes;
import com.intellij.jpa.jpb.model.model.DbIdentifierHelper;
import com.intellij.jpa.jpb.model.model.Entity;
import com.intellij.jpa.jpb.model.model.EntityAttribute;
import com.intellij.jpa.jpb.model.model.EntityAttributeModel;
import com.intellij.jpa.jpb.model.model.EntityAttributePsi;
import com.intellij.jpa.jpb.model.model.EntityPsi;
import com.intellij.jpa.jpb.model.model.EnumType;
import com.intellij.jpa.jpb.model.model.JoinTableAttribute;
import com.intellij.jpa.jpb.model.model.MapDatatype;
import com.intellij.jpa.jpb.model.model.MapKeyColumn;
import com.intellij.jpa.jpb.model.model.OrderColumn;
import com.intellij.jpa.jpb.model.model.SoftDeleteModel;
import com.intellij.jpa.jpb.model.model.UnknownDatatype;
import com.intellij.jpa.jpb.model.model.audit.AuditEntity;
import com.intellij.jpa.jpb.model.model.audit.RevAttribute;
import com.intellij.jpa.jpb.model.model.audit.RevTypeAttribute;
import com.intellij.jpa.jpb.model.model.audit.SetOrdinalAttribute;
import com.intellij.jpa.jpb.model.reference.PossiblyPkTableEntityAttribute;
import com.intellij.jpa.jpb.model.reference.TableAttributesInfo;
import com.intellij.jpa.jpb.model.util.AttributeUtil;
import com.intellij.jpa.jpb.model.util.EntityUtil;
import com.intellij.jpa.jpb.model.util.JpaUtils;
import com.intellij.jpa.jpb.model.util.SCollectionUtilKt;
import com.intellij.jpa.jpb.model.util.annotation.AnnotationDefaults;
import com.intellij.jpa.jpb.model.util.annotation.JoinColumn;
import com.intellij.jpa.jpb.model.util.annotation.JoinTable;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
public final class JpabGeneratorManager {
    private static final Logger log = Logger.getInstance(JpabGeneratorManager.class);
    private final Project project;
    private final EntityDesignHelper entityDesignHelper;
    private final EntitySearch entitySearch;

    public JpabGeneratorManager(Project project) {
        this.project = project;
        this.entityDesignHelper = EntityDesignHelper.getInstance(project);
        this.entitySearch = EntitySearch.getInstance(project);
    }

    public PhysicalNamingStrategy getNamingStrategy() {
        return PhysicalNamingStrategy.getInstance(this.project);
    }

    public static JpabGeneratorManager getInstance(Project project) {
        return (JpabGeneratorManager)project.getService(JpabGeneratorManager.class);
    }

    public List<EntityAttribute> getTableAttributes(@NotNull Entity entity, @Nullable DbType dbType) {
        if (entity == null) {
            JpabGeneratorManager.$$$reportNull$$$0(0);
        }
        if (entity instanceof EntityPsi) {
            PsiClass entityClass = ((EntityPsi)entity).getPsiClass();
            String entityFqn = entityClass.getQualifiedName();
            if (StringUtil.isEmpty((String)entityFqn)) {
                return Collections.emptyList();
            }
            String dbTypeId = dbType != null ? dbType.getId() : "null";
            Key key = CacheKeyStore.getInstance(this.project).getKey("LiquibaseGeneratorManager#getTableAttributes:" + entityFqn + ";dbType=" + dbTypeId);
            return (List)CachedValuesManager.getManager((Project)this.project).getCachedValue((UserDataHolder)entityClass, key, () -> {
                List<EntityAttribute> result = this.getNoCacheTableAttributes(entity, dbType);
                return CachedValueProvider.Result.create(result, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
            }, false);
        }
        return this.getNoCacheTableAttributes(entity, dbType);
    }

    @NotNull
    private List<EntityAttribute> getNoCacheTableAttributes(Entity entity, @Nullable DbType dbType) {
        Entity.InheritanceType inheritanceType;
        ArrayList<EntityAttribute> attributes = new ArrayList<EntityAttribute>(this.getAttributesForTable_(entity));
        SoftDeleteModel softDeleteModel = entity.getSoftDelete();
        if (softDeleteModel != null && EntityDesignHelper.getPersistentParent(entity) == null) {
            attributes.add(0, EntityDesignHelper.softDeleteAttribute(softDeleteModel));
        }
        if (this.discriminatorToCreate(entity, attributes)) {
            EntityAttribute idAttr = JpabGeneratorManager.findIdAttr(attributes);
            if (idAttr != null && attributes.indexOf(idAttr) == 0) {
                attributes.add(1, this.discriminatorAttribute(entity));
            } else {
                attributes.add(this.discriminatorAttribute(entity));
            }
        }
        if (((inheritanceType = EntityDesignHelper.getInheritanceType(entity)) == Entity.InheritanceType.JOINED || inheritanceType == Entity.InheritanceType.TABLE_PER_CLASS) && EntityDesignHelper.getPersistentParent(entity) != null) {
            List<String> primaryKeyReferencedColumnNames = EntityDesignHelper.getPrimaryKeyJoinColumnName(entity);
            String primaryKeyReferencedColumnName = primaryKeyReferencedColumnNames.isEmpty() ? null : primaryKeyReferencedColumnNames.get(0);
            EntityAttribute idAttribute = EntityDesignHelper.getAttributeByColumn(entity, primaryKeyReferencedColumnName, entity.getInheritedAttributes());
            if (idAttribute == null && !(idAttribute = entity.getIdAttribute()).compareColumn(primaryKeyReferencedColumnName)) {
                CachedEntityAttributeModel copyIdAttribute = new CachedEntityAttributeModel();
                copyIdAttribute.copyFromWithMemberReference(idAttribute);
                copyIdAttribute.setColumn(primaryKeyReferencedColumnName);
                idAttribute = copyIdAttribute;
            }
            if (idAttribute.getType() instanceof Entity && idAttribute.isEmbedded()) {
                attributes.addAll(0, JpabGeneratorManager.processEmbeddedAttrs(this.entityDesignHelper.fetchEmbeddedAttributes(idAttribute), primaryKeyReferencedColumnNames));
            } else {
                attributes.add(0, idAttribute);
            }
            if (entity instanceof AuditEntity) {
                attributes.add(0, new RevAttribute(this.project));
            }
        }
        this.addTimeZoneColumnAttributes(attributes, dbType);
        JpabGeneratorManager.removeDuplicateColumnsByName(attributes);
        ArrayList<EntityAttribute> arrayList = attributes;
        if (arrayList == null) {
            JpabGeneratorManager.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    private void addTimeZoneColumnAttributes(List<EntityAttribute> attributes, @Nullable DbType dbType) {
        if (!JpaUtils.isHibernate6Project(this.project, attributes.stream().findFirst().map(EntityAttribute::getPsiElement).map(ModuleUtilCore::findModuleForPsiElement).orElse(null)) || dbType == null) {
            return;
        }
        for (int i = 0; i < attributes.size(); ++i) {
            EntityAttribute attribute = attributes.get(i);
            EntityAttribute.TimeZoneStorageType timeZoneStorageType = attribute.getTimeZoneStorageType();
            if (timeZoneStorageType != EntityAttribute.TimeZoneStorageType.COLUMN && (timeZoneStorageType != EntityAttribute.TimeZoneStorageType.AUTO || dbType.hasNativeTimeZoneSupport())) continue;
            Object timeZoneColumn = attribute.getTimeZoneColumn();
            if (Strings.isNullOrEmpty((String)timeZoneColumn)) {
                timeZoneColumn = attribute.getColumn() + "_tz";
            }
            attributes.add(++i, new CachedEntityAttributeModel((String)timeZoneColumn, Datatypes.BasicDatatype.Integer, EntityAttribute.MappingType.DATATYPE, (String)timeZoneColumn));
        }
    }

    private List<EntityAttribute> getAttributesForTable_(Entity entity) {
        boolean bl;
        ArrayList<EntityAttribute> attributes = new ArrayList<EntityAttribute>(this.getMappedSuperClassAndOwnerAttributes(entity));
        List<Entity> childHierarchyEntities = this.entityDesignHelper.getChildEntitiesSingleTableStrategy(entity);
        for (Entity entity2 : childHierarchyEntities) {
            attributes.addAll(entity2.getAttributes());
        }
        LinkedHashMap<String, EntityDesignHelper.AttributeOverrideStore> embeddedAttributes = new LinkedHashMap<String, EntityDesignHelper.AttributeOverrideStore>();
        for (Entity hierarchyEntity : childHierarchyEntities) {
            if (hierarchyEntity instanceof BaseEntity) continue;
            embeddedAttributes.putAll(this.entityDesignHelper.fetchEmbeddedAttributes(hierarchyEntity));
        }
        attributes.addAll(JpabGeneratorManager.processEmbeddedAttrs(embeddedAttributes, List.of()));
        attributes.addAll(this.fetchCompKeyAttributesWithChildren(entity));
        attributes.removeIf(curAttr -> {
            EntityAttribute.Cardinality attrCardinality = curAttr.getCardinality();
            return curAttr.isEmbedded() || curAttr.getMappingType() == EntityAttribute.MappingType.EMBEDDED || curAttr.getMappingType() == EntityAttribute.MappingType.ELEMENT_COLLECTION || curAttr.isCardinalityMany() || Strings.isNullOrEmpty((String)curAttr.getColumn()) || curAttr.isMapsId() || attrCardinality == EntityAttribute.Cardinality.ONE_TO_ONE && curAttr.getMappedBy() != null || (attrCardinality == EntityAttribute.Cardinality.ONE_TO_ONE || attrCardinality == EntityAttribute.Cardinality.MANY_TO_ONE) && curAttr.getJoinTable() != JoinTable.NULL_ANNOTATION;
        });
        boolean bl2 = true;
        while (bl) {
            bl = SCollectionUtilKt.removeFirstIf(attributes, curAttr -> !curAttr.getJoinColumns().isEmpty() && ContainerUtil.and(curAttr.getJoinColumns().keySet(), joinColumnName -> ContainerUtil.exists((Iterable)attributes, attr -> attr != curAttr && joinColumnName.equals(attr.getColumn()))));
        }
        EntityAttribute idAttr = JpabGeneratorManager.findIdAttr(attributes);
        if (idAttr != null && attributes.indexOf(idAttr) != 0) {
            attributes.remove(idAttr);
            attributes.add(0, idAttr);
        }
        attributes.addAll(this.getUnidirectionalO2MAttributes(entity));
        return attributes;
    }

    private static void removeDuplicateColumnsByName(List<EntityAttribute> attributes) {
        HashSet existColumns = new HashSet();
        attributes.removeIf(curAttr -> {
            String currColumnName = curAttr.getColumn();
            boolean toRemove = StringUtil.isEmpty((String)currColumnName) || existColumns.stream().anyMatch(s -> s.equalsIgnoreCase(currColumnName));
            existColumns.add(currColumnName);
            return toRemove;
        });
    }

    public List<EntityAttribute> getMappedSuperClassAndOwnerAttributes(Entity entity) {
        ArrayList<EntityAttribute> attributes = new ArrayList<EntityAttribute>();
        attributes.addAll(EntityDesignHelper.getMappedSuperClassAttributes(entity));
        attributes.addAll(EntityDesignHelper.getAttributesUseFromTablePerClass(entity));
        LinkedHashMap<String, EntityDesignHelper.AttributeOverrideStore> embeddedAttributes = new LinkedHashMap<String, EntityDesignHelper.AttributeOverrideStore>();
        for (EntityAttribute mscAttr : attributes) {
            if (!mscAttr.isEmbedded()) continue;
            embeddedAttributes.putAll(this.entityDesignHelper.fetchEmbeddedAttributes(mscAttr));
        }
        attributes.addAll(JpabGeneratorManager.processEmbeddedAttrs(embeddedAttributes, List.of()));
        JpabGeneratorManager.processOneToOneMapsIdAttribute(attributes);
        return attributes;
    }

    private static void processOneToOneMapsIdAttribute(List<EntityAttribute> attributes) {
        Pair<EntityAttribute, String> overriddenIdAttrColumnNameViaMapsId = JpabGeneratorManager.getOverriddenIdAttrColumnNameViaMapsId(attributes);
        if (overriddenIdAttrColumnNameViaMapsId == null) {
            return;
        }
        EntityAttribute idAttr = (EntityAttribute)overriddenIdAttrColumnNameViaMapsId.first;
        String columnName = (String)overriddenIdAttrColumnNameViaMapsId.second;
        int idAttrIdx = attributes.indexOf(idAttr);
        if (idAttrIdx == -1) {
            return;
        }
        CachedEntityAttributeModel newIdAttr = new CachedEntityAttributeModel();
        newIdAttr.copyFromWithMemberReference(idAttr);
        newIdAttr.setColumn(columnName);
        attributes.set(idAttrIdx, newIdAttr);
    }

    @Nullable
    public static Pair<EntityAttribute, String> getOverriddenIdAttrColumnNameViaMapsId(List<EntityAttribute> attributes) {
        return EntityDesignHelper.getOverriddenIdAttrColumnNameViaMapsId(attributes);
    }

    public Collection<? extends EntityAttribute> getUnidirectionalO2MAttributes(Entity entity) {
        ArrayList<EntityAttributeModel> result = new ArrayList<EntityAttributeModel>();
        Collection<UnidirectionalAttributeInfo> unidirectionalO2MAttributes = JpabGeneratorManager.getAllUnidirectionalO2MAttributes(this.project);
        for (UnidirectionalAttributeInfo attributeInfo : unidirectionalO2MAttributes) {
            OrderColumn orderColumn;
            EntityAttribute attribute = attributeInfo.attribute;
            if (!Objects.equals(attribute.getType().getFqn(), entity.getFqn())) continue;
            if (StringUtil.isEmpty((String)attribute.getMappedBy()) && StringUtil.isNotEmpty((String)attribute.getColumn())) {
                String columnName = attribute.getColumn();
                Entity scopeEntity = attributeInfo.entity;
                String attrName = StringUtil.decapitalize((String)scopeEntity.getClassName());
                CachedEntityAttributeModel assAttr = new CachedEntityAttributeModel(attrName, scopeEntity, EntityAttribute.MappingType.ASSOCIATION, columnName, EntityAttribute.Cardinality.MANY_TO_ONE);
                assAttr.setMandatory(attribute.isMandatory());
                assAttr.setUnique(attribute.isUnique());
                assAttr.setUpdatable(attribute.isUpdatable());
                assAttr.setColumnDefinition(attribute.getColumnDefinition());
                result.add(assAttr);
            }
            if ((orderColumn = attribute.getOrderColumn()) == null) continue;
            EntityAttributeModel orderColumnAttr = new EntityAttributeModel();
            orderColumn.initAttribute(orderColumnAttr);
            result.add(orderColumnAttr);
        }
        return result;
    }

    public static Collection<UnidirectionalAttributeInfo> getAllUnidirectionalO2MAttributes(Project project) {
        return (Collection)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, () -> {
            EntitySearch entitySearch = EntitySearch.getInstance(project);
            List<Entity> projectEntities = entitySearch.getProjectWrapEntities();
            ArrayList<UnidirectionalAttributeInfo> result = new ArrayList<UnidirectionalAttributeInfo>();
            block0: for (Entity scopeEntity : projectEntities) {
                for (EntityAttribute attribute : scopeEntity.getAttributes()) {
                    OrderColumn orderColumn;
                    if (attribute.getCardinality() != EntityAttribute.Cardinality.ONE_TO_MANY) continue;
                    if (scopeEntity.isMappedSuperclass() && entitySearch.getChildEntities(scopeEntity.getFqn(), EntitySearch.SearchScope.ALL, true).stream().noneMatch(EntityUtil::isPersistentEntity)) continue block0;
                    boolean isOwningSide = StringUtil.isEmpty((String)attribute.getMappedBy());
                    if (isOwningSide && StringUtil.isNotEmpty((String)attribute.getColumn())) {
                        result.add(new UnidirectionalAttributeInfo(scopeEntity, attribute));
                        continue;
                    }
                    if (isOwningSide || (orderColumn = attribute.getOrderColumn()) == null) continue;
                    result.add(new UnidirectionalAttributeInfo(scopeEntity, attribute));
                }
            }
            return CachedValueProvider.Result.create(result, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        });
    }

    private static List<? extends EntityAttribute> processEmbeddedAttrs(Map<String, EntityDesignHelper.AttributeOverrideStore> embeddedAttributes, List<String> newColumnNames) {
        if (!newColumnNames.isEmpty() && embeddedAttributes.size() != newColumnNames.size()) {
            throw new IllegalArgumentException("Embedded attributes size " + embeddedAttributes.keySet() + " doesn't correspond to new column names size " + newColumnNames);
        }
        Iterator<String> newColumnNamesIterator = newColumnNames.iterator();
        return ContainerUtil.map(embeddedAttributes.entrySet(), entry -> {
            CachedEntityAttributeModel attribute = new CachedEntityAttributeModel();
            EntityDesignHelper.AttributeOverrideStore attributeOverrideStore = (EntityDesignHelper.AttributeOverrideStore)entry.getValue();
            attribute.copyFromWithMemberReference(attributeOverrideStore.getAttribute());
            attribute.setNaturalId(attributeOverrideStore.isNaturalId());
            attribute.setColumn(newColumnNames.isEmpty() ? (String)entry.getKey() : (String)newColumnNamesIterator.next());
            AttributeOverride attributeOverride = attributeOverrideStore.getAttributeOverride();
            if (attributeOverride != null) {
                attribute.setMandatory(!attributeOverride.isNullable());
                attribute.setUnique(attributeOverride.isUnique());
                attribute.setLength(String.valueOf(attributeOverride.getLength()));
                attribute.setColumnDefinition(attributeOverride.getColumnDefinition());
                attribute.setPrecision(attributeOverride.getPrecision());
                attribute.setScale(attributeOverride.getScale());
            } else {
                attribute.setMandatory(attributeOverrideStore.getAttribute().isNotNullColumn(true));
            }
            return attribute;
        });
    }

    private List<EntityAttribute> fetchCompKeyAttributesWithChildren(Entity entity) {
        List<Entity> childHierarchyEntities = this.getChildEntitiesHierarchyWithSingleTableStrategy(entity);
        ArrayList<EntityAttribute> compKeyAttributes = new ArrayList<EntityAttribute>(EntityDesignHelper.fetchCompKeyAttributes(entity));
        for (Entity hierarchyEntity : childHierarchyEntities) {
            if (hierarchyEntity instanceof BaseEntity) continue;
            compKeyAttributes.addAll(EntityDesignHelper.fetchCompKeyAttributes(hierarchyEntity));
        }
        return compKeyAttributes;
    }

    public List<Entity> getChildEntitiesHierarchyWithSingleTableStrategy(Entity root) {
        List childrenEntities = ContainerUtil.map(this.entitySearch.getChildEntities(root.getFqn(), EntitySearch.SearchScope.ALL, true), EntityPsi::getInstance);
        ArrayList<Entity> hierarchyEntities = new ArrayList<Entity>();
        for (Entity childEntity : childrenEntities) {
            if (EntityDesignHelper.getInheritanceType(childEntity) != Entity.InheritanceType.SINGLE_TABLE || childEntity.isMappedSuperclass() && !EntityDesignHelper.existPersistentChild(childEntity, this.project) || hierarchyEntities.contains(childEntity) || root.equals(childEntity)) continue;
            hierarchyEntities.add(childEntity);
        }
        return hierarchyEntities;
    }

    private static EntityAttribute findIdAttr(List<EntityAttribute> attributes) {
        return StreamEx.of(attributes).findFirst(EntityAttribute::isId).orElse(null);
    }

    public boolean discriminatorToCreate(Entity entity, List<EntityAttribute> attributesForTable) {
        String actualDiscriminatorColumnName;
        String discriminatorColumnName = entity.getDiscriminatorColumnName();
        String string = actualDiscriminatorColumnName = StringUtils.isBlank((CharSequence)discriminatorColumnName) ? "DTYPE" : discriminatorColumnName;
        if (ContainerUtil.exists(attributesForTable, attr -> attr.compareColumn(actualDiscriminatorColumnName))) {
            return false;
        }
        return EntityDesignHelper.mustHaveDiscriminator(entity, this.project);
    }

    public EntityAttribute discriminatorAttribute(Entity entity) {
        String discriminatorColumnName = this.getDiscriminatorColumnName(entity);
        boolean hasSameColumn = ContainerUtil.or(entity.getAllAttributes(), attribute -> attribute.compareColumn(discriminatorColumnName) && (attribute.isUpdatable() || attribute.isInsertable()));
        if (hasSameColumn) {
            String message = JpaModelBundle.message("ExistingColumnNameValidator.discriminatorNameNotUnique", discriminatorColumnName, entity.getFqn());
            HNotificationManager.getInstance(this.project).showNotification(JpaModelBundle.message("AttributePropertiesPanel.warning.caption", new Object[0]), message, NotificationType.WARNING);
            throw new IllegalStateException(message);
        }
        Datatype type = entity.getDiscriminatorType() != null ? entity.getDiscriminatorType().getDatatype() : AnnotationDefaults.DISCRIMINATOR_COLUMN_TYPE;
        CachedEntityAttributeModel attribute2 = new CachedEntityAttributeModel("discriminator", type, EntityAttribute.MappingType.DATATYPE, discriminatorColumnName);
        if (entity.getDiscriminatorType() == Entity.DiscriminatorType.CHAR) {
            attribute2.setLength("1");
        } else {
            attribute2.setLength(entity.getDiscriminatorLength());
        }
        return attribute2;
    }

    @NotNull
    public String getDiscriminatorColumnName(Entity entity) {
        String column = entity.getDiscriminatorColumnName();
        if (Strings.isNullOrEmpty((String)column)) {
            column = "DTYPE";
        }
        String string = column;
        if (string == null) {
            JpabGeneratorManager.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Nullable
    public EntityAttribute findAttributeByColumnName(@Nullable Entity entity, Collection<EntityAttribute> tableAttributes, String columnName) {
        Set attributeOverrides = entity == null ? Collections.emptySet() : entity.getAttributeOverrides();
        PhysicalNamingStrategy namingStrategy = this.getNamingStrategy();
        for (EntityAttribute attribute : tableAttributes) {
            AttributeOverride columnOverridden = StreamEx.of(attributeOverrides).findFirst(attributeOverride -> Objects.equals(attributeOverride.getName(), attribute.getName())).orElse(null);
            if (!(columnOverridden != null && StringUtil.isNotEmpty((String)columnOverridden.getColumn()) ? DbIdentifierHelper.compareIdentifier(columnName, namingStrategy.toColumnName(columnOverridden.getColumn())) : DbIdentifierHelper.compareIdentifier(columnName, namingStrategy.toColumnName(attribute.getColumn())))) continue;
            return attribute;
        }
        return null;
    }

    public Map<String, JoinTableAttribute> getJoinTables(Collection<? extends Entity> entities, boolean includeAudit) {
        Map<String, JoinTableAttribute> allJoinTables = JpabGeneratorManager.getAllJoinTables(this.project, includeAudit);
        if (allJoinTables.isEmpty()) {
            return allJoinTables;
        }
        Set entityFqns = StreamEx.of(entities).map(Datatype::getFqn).toSet();
        return ((StreamEx)StreamEx.of(allJoinTables.entrySet()).filter(joinTableEntry -> {
            Entity jtEntity = ((JoinTableAttribute)joinTableEntry.getValue()).getEntity();
            return entityFqns.contains(jtEntity.getFqn());
        })).toMap(Map.Entry::getKey, Map.Entry::getValue);
    }

    public static Map<String, JoinTableAttribute> getAllJoinTables(Project project, boolean includeAudit) {
        String keyValue = "LiquibaseGenerator#allJoinTables#" + includeAudit;
        Key key = CacheKeyStore.getInstance(project).getKey(keyValue);
        return (Map)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, key, () -> {
            HashMap<String, JoinTableAttribute> map = new HashMap<String, JoinTableAttribute>();
            List<Entity> allWrapEntities = EntitySearch.getInstance(project).getAllWrapEntities();
            for (Entity e : allWrapEntities) {
                AuditEntity auditEntity;
                if (!e.isPersistentEntity()) continue;
                JpabGeneratorManager.collectJoinTables(map, e, e.getAllAttributes(), new RecursionGuard());
                if (!(e instanceof EntityPsi)) continue;
                EntityPsi entityPsi = (EntityPsi)e;
                if (!includeAudit || (auditEntity = AuditEntity.Companion.getInstance(entityPsi)) == null) continue;
                JpabGeneratorManager.collectJoinTables(map, auditEntity, auditEntity.getAllAttributes(), new RecursionGuard());
            }
            return CachedValueProvider.Result.create(map, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        }, false);
    }

    private static void collectJoinTables(Map<String, JoinTableAttribute> map, Entity ownerEntity, List<EntityAttribute> attributes, RecursionGuard recursionGuard) {
        for (EntityAttribute attribute : attributes) {
            boolean isOneToMany;
            if (attribute.getType(ownerEntity) instanceof UnknownDatatype) continue;
            JoinTable attrJoinTable = attribute.getJoinTable(ownerEntity);
            if (attrJoinTable == JoinTable.NULL_ANNOTATION) {
                Datatype attrType;
                if (!attribute.isEmbedded() || !((attrType = attribute.getType(ownerEntity)) instanceof Entity) || !((Entity)attrType).isEmbeddable()) continue;
                recursionGuard.runWithAssertionNoRecursion(attrType, () -> JpabGeneratorManager.collectJoinTables(map, ownerEntity, ((Entity)attrType).getAllAttributes(), recursionGuard));
                continue;
            }
            String attrJoinTableName = attrJoinTable.getName();
            JoinTableAttribute existingJT = map.entrySet().stream().filter(jtn -> StringUtil.equalsIgnoreCase((CharSequence)((CharSequence)jtn.getKey()), (CharSequence)attrJoinTableName)).findFirst().map(Map.Entry::getValue).orElse(null);
            if (existingJT != null && !existingJT.getEntity().isExtends(ownerEntity)) continue;
            EntityAttribute.Cardinality cardinality = attribute.getCardinality();
            boolean bl = isOneToMany = cardinality == EntityAttribute.Cardinality.ONE_TO_MANY;
            if (!isOneToMany && cardinality != EntityAttribute.Cardinality.MANY_TO_MANY && cardinality != EntityAttribute.Cardinality.ONE_TO_ONE && cardinality != EntityAttribute.Cardinality.MANY_TO_ONE) continue;
            JoinTableAttribute joinTableAttribute = new JoinTableAttribute(ownerEntity, attribute, isOneToMany);
            map.put(attrJoinTableName, joinTableAttribute);
        }
    }

    public List<CollectionTableAttribute> getCollectionTables(Collection<? extends Entity> entities) {
        ArrayList<CollectionTableAttribute> result = new ArrayList<CollectionTableAttribute>();
        for (Entity entity : entities) {
            if (!entity.isPersistentEntity()) continue;
            JpabGeneratorManager.collectCollectionTables(result, entity, entity.getAllAttributes());
        }
        return result;
    }

    private static void collectCollectionTables(List<CollectionTableAttribute> result, Entity ownerEntity, List<EntityAttribute> attributes) {
        for (EntityAttribute attribute : attributes) {
            CollectionTable collectionTable = attribute.getCollectionTable(ownerEntity);
            if (collectionTable == null || attribute.getMappingType() != EntityAttribute.MappingType.ELEMENT_COLLECTION) {
                Datatype attrType;
                if (!attribute.isEmbedded() || !((attrType = attribute.getType(ownerEntity)) instanceof Entity) || !((Entity)attrType).isEmbeddable()) continue;
                JpabGeneratorManager.collectCollectionTables(result, ownerEntity, ((Entity)attrType).getAllAttributes());
                continue;
            }
            String collectionTableName = collectionTable.getName();
            if (!result.stream().noneMatch(cta -> cta.getTableName().equalsIgnoreCase(collectionTableName))) continue;
            result.add(new CollectionTableAttribute(collectionTableName, ownerEntity, attribute));
        }
    }

    @Nullable
    public JoinTableAttribute findJoinTableAttribute(String tableName, List<Entity> projectEntities, boolean includeAudit) {
        Map<String, JoinTableAttribute> joinTables = this.getJoinTables(projectEntities, includeAudit);
        PhysicalNamingStrategy namingStrategy = this.getNamingStrategy();
        return StreamEx.of(joinTables.entrySet()).findFirst(entry -> namingStrategy.compareLogicalWithPhysicalTableNames((String)entry.getKey(), tableName)).map(Map.Entry::getValue).orElse(null);
    }

    @Nullable
    public CollectionTableAttribute findCollectionTableAttribute(String tableName, List<Entity> projectEntities) {
        PhysicalNamingStrategy namingStrategy = this.getNamingStrategy();
        return StreamEx.of(this.getCollectionTables(projectEntities)).findFirst(tableAttr -> namingStrategy.compareLogicalWithPhysicalTableNames(tableAttr.getTableName(), tableName)).orElse(null);
    }

    public List<EntityAttribute> getCollectionTableAttributes(CollectionTableAttribute tableAttribute, Project project) {
        SoftDeleteModel softDeleteModel;
        Entity entity = tableAttribute.getEntity();
        List<EntityAttribute> entityIdAttrs = entity.getIdAttributes();
        if (entityIdAttrs.isEmpty()) {
            return Collections.emptyList();
        }
        EntityAttribute attribute = tableAttribute.getAttribute();
        CollectionTable collectionTable = attribute.getCollectionTable(entity);
        if (collectionTable == null) {
            throw new IllegalStateException("CollectionTable is null for " + entity.getClassName() + "#" + attribute.getName() + " attribute");
        }
        Datatype attrType = attribute.getType();
        ArrayList<PossiblyPkTableEntityAttribute> joinColumnAttrs = new ArrayList<PossiblyPkTableEntityAttribute>();
        Collection<PossiblyPkTableEntityAttribute> compKeyAttrs = JpabGeneratorManager.createJoinTableAttributes(collectionTable.getName(), entityIdAttrs, collectionTable.getJoinColumns());
        OrderColumn orderColumn = attribute.getOrderColumn();
        if (compKeyAttrs.isEmpty()) {
            PossiblyPkTableEntityAttribute joinColumnAttr = new PossiblyPkTableEntityAttribute();
            joinColumnAttr.copyFromWithMemberReference(entityIdAttrs.get(0));
            joinColumnAttr.setUnique(false);
            joinColumnAttr.setOwnerEntityClass(entity.getPsiClass());
            joinColumnAttr.setColumn(collectionTable.getJoinColumns().get(0).getName());
            joinColumnAttr.setMandatory(true);
            joinColumnAttr.setPkAttribute(orderColumn != null);
            joinColumnAttrs.add(joinColumnAttr);
        } else {
            for (PossiblyPkTableEntityAttribute compKeyAttr : compKeyAttrs) {
                compKeyAttr.setOwnerEntityClass(entity.getPsiClass());
                compKeyAttr.setMandatory(true);
                joinColumnAttrs.add(compKeyAttr);
            }
        }
        ArrayList<EntityAttribute> result = new ArrayList<EntityAttribute>(joinColumnAttrs);
        if (attrType instanceof Entity) {
            if (!((Entity)attrType).isEmbeddable()) {
                log.warn("Incorrect attribute type for element collection attribute - " + entity.getClassName() + "#" + attribute.getName() + ". " + attrType.getFqn() + " no Embeddable entity!");
                return result;
            }
            Map<String, EntityDesignHelper.AttributeOverrideStore> embeddedAttributes = EntityDesignHelper.getInstance(project).fetchEmbeddedAttributes(attribute);
            for (Map.Entry<String, EntityDesignHelper.AttributeOverrideStore> entry : embeddedAttributes.entrySet()) {
                CachedEntityAttributeModel embAttr = new CachedEntityAttributeModel();
                embAttr.copyFromWithMemberReference(entry.getValue().getAttribute());
                embAttr.setColumn(entry.getKey());
                result.add(embAttr);
            }
        } else if (attrType instanceof MapDatatype) {
            result.addAll(this.collectMapElementCollectionAttrs(attribute, (MapDatatype)attrType, joinColumnAttrs));
        } else {
            EntityAttributeModel targetAttribute = new EntityAttributeModel();
            targetAttribute.copyFromWithMemberReference(attribute);
            targetAttribute.setType(attrType);
            if (attrType instanceof EnumType) {
                targetAttribute.setMappingType(EntityAttribute.MappingType.ENUM);
            } else {
                targetAttribute.setMappingType(EntityAttribute.MappingType.DATATYPE);
            }
            if (StringUtil.isEmpty((String)targetAttribute.getColumn())) {
                targetAttribute.setColumn(attribute.getColumn());
            }
            result.add(targetAttribute);
        }
        if (entity instanceof AuditEntity) {
            Entity entityType;
            if (attrType instanceof Entity && (entityType = (Entity)attrType).isEmbeddable()) {
                result.add(new RevTypeAttribute(project, true));
                result.add(new SetOrdinalAttribute());
            } else {
                result.add(new RevTypeAttribute(project, false));
            }
        }
        if (orderColumn != null) {
            JpabGeneratorManager.addOrderColumn(result, orderColumn);
        }
        if ((softDeleteModel = attribute.getSoftDelete()) != null) {
            result.add(0, EntityDesignHelper.softDeleteAttribute(softDeleteModel));
        }
        return result;
    }

    public List<EntityAttribute> getJoinTableAttributes(@NotNull JoinTableAttribute joinTableAttribute) {
        boolean isPkInverseAttr;
        boolean isJoinAttrPk;
        if (joinTableAttribute == null) {
            JpabGeneratorManager.$$$reportNull$$$0(3);
        }
        EntityAttribute jtAttribute = joinTableAttribute.getAttribute();
        Entity jtEntity = joinTableAttribute.getEntity();
        JoinTable joinTable = jtAttribute.getJoinTable(jtEntity);
        List<EntityAttribute> idAttributes = jtEntity.getIdAttributes();
        if (idAttributes.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<EntityAttribute> result = new ArrayList<EntityAttribute>();
        List<JoinColumn> joinColumns = joinTable.getJoinColumns();
        Collection<PossiblyPkTableEntityAttribute> compKeyAttrs = JpabGeneratorManager.createJoinTableAttributes(jtEntity.getName(), idAttributes, joinColumns);
        MapKeyColumn mapKeyColumn = jtAttribute.getMapKeyColumn();
        if (mapKeyColumn != null) {
            Datatype mapKeyType = jtAttribute.getMapKeyType();
            if (mapKeyType instanceof Entity) {
                Entity entity = (Entity)mapKeyType;
                if (entity.isEmbeddable()) {
                    entity.getAttributes().forEach(it -> {
                        PossiblyPkTableEntityAttribute entityAttribute = new PossiblyPkTableEntityAttribute((EntityAttribute)it);
                        entityAttribute.setPkAttribute(true);
                        entityAttribute.setMandatory(true);
                        result.add(entityAttribute);
                    });
                } else {
                    EntityAttribute refEntityIdAttribute = entity.getIdAttribute();
                    PossiblyPkTableEntityAttribute joinAttr = new PossiblyPkTableEntityAttribute();
                    joinAttr.copyFromWithMemberReference(refEntityIdAttribute);
                    joinAttr.setOwnerEntityClass(entity.getPsiClass());
                    JpabGeneratorManager.copyMapKeyColumnToAttribute(refEntityIdAttribute.getType(), mapKeyColumn, joinAttr);
                    joinAttr.setPkAttribute(true);
                    result.add(joinAttr);
                }
            } else {
                PossiblyPkTableEntityAttribute mapKeyAttribute = new PossiblyPkTableEntityAttribute();
                JpabGeneratorManager.copyMapKeyColumnToAttribute(mapKeyType, mapKeyColumn, mapKeyAttribute);
                mapKeyAttribute.setPkAttribute(true);
                result.add(mapKeyAttribute);
            }
        }
        Datatypes.CollectionDatatype collectionType = jtAttribute.getCollectionType();
        OrderColumn orderColumn = jtAttribute.getOrderColumn();
        boolean isPkCollectionType = collectionType == Datatypes.CollectionDatatype.Set || collectionType == Datatypes.CollectionDatatype.Map || orderColumn != null;
        EntityAttribute.Cardinality jtAttributeCardinality = jtAttribute.getCardinality();
        boolean isAnyToOneAttr = jtAttributeCardinality == EntityAttribute.Cardinality.ONE_TO_ONE || jtAttributeCardinality == EntityAttribute.Cardinality.MANY_TO_ONE;
        boolean bl = isJoinAttrPk = isPkCollectionType || collectionType == null && isAnyToOneAttr;
        if (!compKeyAttrs.isEmpty()) {
            compKeyAttrs.forEach(it -> {
                if (it != null) {
                    it.setPkAttribute(isJoinAttrPk);
                }
            });
            result.addAll(compKeyAttrs);
        } else if (!joinColumns.isEmpty()) {
            PossiblyPkTableEntityAttribute joinAttr = new PossiblyPkTableEntityAttribute();
            joinAttr.copyFromWithMemberReference(idAttributes.get(0));
            joinAttr.setOwnerEntityClass(jtEntity.getPsiClass());
            String joinColumnName = DbIdentifierHelper.trimEscapeQuotes(joinColumns.get(0).getName(), false);
            if (StringUtil.isEmpty((String)joinColumnName)) {
                throw new IllegalArgumentException("Join column from '" + joinTable.getName() + "' join table is empty.\nEntity Attribute: " + jtEntity.getClassName() + "#" + jtAttribute.getName());
            }
            joinAttr.setColumn(joinColumnName);
            joinAttr.setMandatory(true);
            joinAttr.setPkAttribute(isJoinAttrPk);
            joinAttr.setGeneratedStrategy(EntityAttribute.GeneratedStrategy.IDENTITY);
            result.add(joinAttr);
        }
        List<JoinColumn> inverseJoinColumns = joinTable.getInverseJoinColumns();
        Datatype inverseTypeEntity = jtAttribute.isGenericType() && jtAttribute instanceof EntityAttributePsi && jtEntity instanceof EntityPsi ? AttributeUtil.getResolvedGenericAttrType(((EntityPsi)jtEntity).getPsiClass(), ((EntityAttributePsi)jtAttribute).getMember()) : jtAttribute.getType();
        List<EntityAttribute> inverseEntityIdAttrs = inverseTypeEntity instanceof Entity ? ((Entity)inverseTypeEntity).getIdAttributes() : Collections.emptyList();
        compKeyAttrs = JpabGeneratorManager.createJoinTableAttributes(jtAttribute.getName(), inverseEntityIdAttrs, inverseJoinColumns);
        boolean bl2 = isPkInverseAttr = mapKeyColumn == null && orderColumn == null;
        if (!compKeyAttrs.isEmpty()) {
            compKeyAttrs.forEach(it -> {
                if (it != null) {
                    it.setPkAttribute(isPkInverseAttr && isPkCollectionType);
                }
            });
            result.addAll(JpabGeneratorManager.setUniqueCompKeyAttrs(compKeyAttrs, joinTableAttribute));
        } else if (!inverseJoinColumns.isEmpty() && !inverseEntityIdAttrs.isEmpty()) {
            String inverseJoinColumnName;
            PossiblyPkTableEntityAttribute inverseJoinAttr = new PossiblyPkTableEntityAttribute();
            inverseJoinAttr.copyFromWithMemberReference(inverseEntityIdAttrs.get(0));
            if (inverseTypeEntity instanceof Entity) {
                inverseJoinAttr.setOwnerEntityClass(((Entity)inverseTypeEntity).getPsiClass());
            }
            if (StringUtil.isEmpty((String)(inverseJoinColumnName = DbIdentifierHelper.trimEscapeQuotes(inverseJoinColumns.get(0).getName(), false)))) {
                throw new IllegalArgumentException("Inverse join column from '" + joinTable.getName() + "' join table is empty.\nEntity Attribute: " + jtEntity.getClassName() + "#" + jtAttribute.getName());
            }
            inverseJoinAttr.setColumn(inverseJoinColumnName);
            inverseJoinAttr.setMandatory(!isAnyToOneAttr);
            inverseJoinAttr.setUnique(joinTableAttribute.isOneToMany());
            inverseJoinAttr.setPkAttribute(isPkInverseAttr && isPkCollectionType);
            inverseJoinAttr.setGeneratedStrategy(EntityAttribute.GeneratedStrategy.IDENTITY);
            result.add(inverseJoinAttr);
        }
        if (orderColumn != null) {
            JpabGeneratorManager.addOrderColumn(result, orderColumn);
        }
        if (jtEntity instanceof AuditEntity) {
            result.add(new RevTypeAttribute(this.project, false));
        }
        result.sort(Comparator.comparing(EntityAttribute::getColumn));
        result.forEach(attr -> {
            if (attr instanceof EntityAttributeModel && jtAttributeCardinality == EntityAttribute.Cardinality.MANY_TO_MANY) {
                ((EntityAttributeModel)attr).setUnique(false);
            }
        });
        SoftDeleteModel softDeleteModel = jtAttribute.getSoftDelete();
        if (softDeleteModel != null) {
            result.add(0, EntityDesignHelper.softDeleteAttribute(softDeleteModel));
        }
        return result;
    }

    @Nullable
    public TableAttributesInfo getJoinOrCollectionTableAttributesInfo(@NotNull String tableName, List<Entity> entities, boolean includeAudit) {
        JoinTableAttribute joinTableAttribute;
        if (tableName == null) {
            JpabGeneratorManager.$$$reportNull$$$0(4);
        }
        if ((joinTableAttribute = this.findJoinTableAttribute(tableName, entities, includeAudit)) != null) {
            return new TableAttributesInfo(null, this.getJoinTableAttributes(joinTableAttribute));
        }
        CollectionTableAttribute collectionTableAttribute = this.findCollectionTableAttribute(tableName, entities);
        if (collectionTableAttribute != null) {
            return new TableAttributesInfo(null, this.getCollectionTableAttributes(collectionTableAttribute, this.project));
        }
        return null;
    }

    public List<EntityAttribute> getJoinOrCollectionTableAttributes(String tableName, boolean includeAudit) {
        if (tableName.isEmpty()) {
            return Collections.emptyList();
        }
        List<Entity> entities = this.entitySearch.getAllWrapEntities();
        TableAttributesInfo attributesInfo = this.getJoinOrCollectionTableAttributesInfo(tableName, entities, includeAudit);
        if (attributesInfo == null) {
            return Collections.emptyList();
        }
        return attributesInfo.getAttributes();
    }

    public List<String> getJoinOrCollectionTableColumnNames(String tableName) {
        ArrayList<String> result = new ArrayList<String>();
        PhysicalNamingStrategy namingStrategy = this.getNamingStrategy();
        for (EntityAttribute attribute : this.getJoinOrCollectionTableAttributes(tableName, true)) {
            String attrColumnName = attribute.getColumn();
            if (StringUtil.isEmpty((String)attrColumnName)) continue;
            String columnName = namingStrategy.toColumnName(attrColumnName);
            result.add(columnName);
        }
        return result;
    }

    private static void addOrderColumn(List<EntityAttribute> result, OrderColumn orderColumn) {
        PossiblyPkTableEntityAttribute orderColumnAttr = new PossiblyPkTableEntityAttribute();
        orderColumn.initAttribute(orderColumnAttr);
        orderColumnAttr.setPkAttribute(true);
        result.add(orderColumnAttr);
    }

    private static Collection<PossiblyPkTableEntityAttribute> setUniqueCompKeyAttrs(Collection<PossiblyPkTableEntityAttribute> compKeyAttrs, JoinTableAttribute joinTableAttribute) {
        for (EntityAttributeModel entityAttributeModel : compKeyAttrs) {
            entityAttributeModel.setUnique(joinTableAttribute.isOneToMany());
        }
        return compKeyAttrs;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Collection<PossiblyPkTableEntityAttribute> createJoinTableAttributes(String ownerName, List<EntityAttribute> idAttributes, List<JoinColumn> joinColumns) {
        List<EntityAttribute> compositionIdAttributes;
        if (idAttributes.isEmpty()) {
            return Collections.emptyList();
        }
        if (idAttributes.size() == 1) {
            Datatype idAttrType = idAttributes.get(0).getType();
            if (!(idAttrType instanceof Entity)) return Collections.emptyList();
            compositionIdAttributes = ((Entity)idAttrType).getAttributes();
        } else {
            compositionIdAttributes = idAttributes;
        }
        ArrayList<PossiblyPkTableEntityAttribute> result = new ArrayList<PossiblyPkTableEntityAttribute>();
        for (EntityAttribute embAttr : compositionIdAttributes) {
            Object columnName;
            String embAttrColumnName = idAttributes.size() == 1 ? embAttr.getEmbeddedColumnName(idAttributes.get(0)) : embAttr.getDdlManipulationColumn();
            if (StringUtils.isBlank((CharSequence)embAttrColumnName)) continue;
            JoinColumn foundJoinColumn = StreamEx.of(joinColumns).findFirst(joinColumn -> DbIdentifierHelper.compareIdentifier(joinColumn.getReferencedColumnName(), embAttrColumnName)).orElse(null);
            if (foundJoinColumn != null) {
                columnName = DbIdentifierHelper.trimEscapeQuotes(foundJoinColumn.getName(), false);
            } else {
                if (embAttr instanceof RevAttribute) continue;
                columnName = ownerName + "_" + embAttrColumnName;
            }
            PossiblyPkTableEntityAttribute joinAttr = new PossiblyPkTableEntityAttribute();
            joinAttr.copyFromWithMemberReference(embAttr);
            joinAttr.setColumnPhysical((String)columnName);
            joinAttr.setMandatory(true);
            result.add(joinAttr);
        }
        return result;
    }

    private List<EntityAttribute> collectMapElementCollectionAttrs(EntityAttribute attribute, MapDatatype attrType, List<PossiblyPkTableEntityAttribute> joinColumnAttrs) {
        ArrayList<EntityAttribute> result = new ArrayList<EntityAttribute>();
        Datatype valueType = attrType.getValueType();
        if (valueType instanceof Entity && ((Entity)valueType).isEmbeddable()) {
            JpabGeneratorManager.collectCollectionTableEmbeddedAttrs(result, (Entity)valueType, false);
        } else {
            EntityAttributeModel mapValueAttribute = new EntityAttributeModel(attribute);
            mapValueAttribute.setType(valueType);
            if (valueType instanceof EnumType) {
                mapValueAttribute.setMappingType(EntityAttribute.MappingType.ENUM);
                if (mapValueAttribute.getEnumType() == null) {
                    mapValueAttribute.setEnumType(EntityAttribute.EnumType.ORDINAL);
                }
            } else {
                mapValueAttribute.setMappingType(EntityAttribute.MappingType.DATATYPE);
            }
            if (StringUtil.isEmpty((String)mapValueAttribute.getColumn())) {
                mapValueAttribute.setColumn(attribute.getColumn());
            }
            result.add(mapValueAttribute);
        }
        Datatype mapKeyType = attrType.getKeyType();
        if (mapKeyType instanceof Entity && ((Entity)mapKeyType).isEmbeddable()) {
            JpabGeneratorManager.collectCollectionTableEmbeddedAttrs(result, (Entity)mapKeyType, true);
            joinColumnAttrs.forEach(a -> a.setPkAttribute(true));
        } else {
            MapKeyColumn mapKeyColumn = attribute.getMapKeyColumn();
            if (mapKeyColumn != null) {
                PossiblyPkTableEntityAttribute mapKeyAttribute = new PossiblyPkTableEntityAttribute();
                JpabGeneratorManager.copyMapKeyColumnToAttribute(mapKeyType, mapKeyColumn, mapKeyAttribute);
                result.add(mapKeyAttribute);
                mapKeyAttribute.setPkAttribute(true);
                joinColumnAttrs.forEach(a -> a.setPkAttribute(true));
            }
        }
        return result;
    }

    private static void copyMapKeyColumnToAttribute(Datatype mapKeyType, MapKeyColumn mapKeyColumn, EntityAttributeModel mapKeyAttribute) {
        mapKeyAttribute.setName(mapKeyColumn.getName());
        mapKeyAttribute.setType(mapKeyType);
        if (mapKeyType instanceof Entity) {
            mapKeyAttribute.setMappingType(EntityAttribute.MappingType.ASSOCIATION);
        } else if (mapKeyType instanceof EnumType) {
            mapKeyAttribute.setMappingType(EntityAttribute.MappingType.ENUM);
            mapKeyAttribute.setEnumType(mapKeyColumn.getEnumType());
        } else {
            mapKeyAttribute.setMappingType(EntityAttribute.MappingType.DATATYPE);
        }
        mapKeyAttribute.setColumnPhysical(mapKeyColumn.getName());
        mapKeyAttribute.setUnique(mapKeyColumn.isUnique());
        mapKeyAttribute.setMandatory(!mapKeyColumn.isNullable());
        mapKeyAttribute.setColumnDefinition(mapKeyColumn.getColumnDefinition());
        mapKeyAttribute.setLength(mapKeyColumn.getColumnDefinition());
        mapKeyAttribute.setLength(String.valueOf(mapKeyColumn.getLength()));
        mapKeyAttribute.setPrecision(mapKeyColumn.getPrecision());
        mapKeyAttribute.setScale(mapKeyColumn.getScale());
    }

    private static void collectCollectionTableEmbeddedAttrs(List<EntityAttribute> result, Entity embEntity, boolean isKeyValue) {
        for (EntityAttribute embAttr : embEntity.getAttributes()) {
            PossiblyPkTableEntityAttribute copyEmbAttr = new PossiblyPkTableEntityAttribute();
            copyEmbAttr.copyFrom(embAttr);
            copyEmbAttr.setColumnPhysical(embAttr.getColumn());
            if (isKeyValue) {
                copyEmbAttr.setMandatory(true);
                copyEmbAttr.setPkAttribute(true);
            }
            result.add(copyEmbAttr);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entity";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jpa/jpb/model/service/JpabGeneratorManager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "joinTableAttribute";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tableName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jpa/jpb/model/service/JpabGeneratorManager";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getNoCacheTableAttributes";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDiscriminatorColumnName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getTableAttributes";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getJoinTableAttributes";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getJoinOrCollectionTableAttributesInfo";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }

    static class UnidirectionalAttributeInfo {
        private final Entity entity;
        private final EntityAttribute attribute;

        public UnidirectionalAttributeInfo(Entity entity, EntityAttribute attribute) {
            this.entity = entity;
            this.attribute = attribute;
        }
    }
}

