/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.jpb.model.ui.component;

import com.intellij.icons.AllIcons;
import com.intellij.jpa.jpb.model.ui.component.ChangeLogFileTextField;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.ex.FileLookup;
import com.intellij.openapi.fileChooser.ex.LocalFsFinder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.ui.TextBrowseFolderListener;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import javax.swing.Icon;
import javax.swing.JTextField;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000 \u00152\u00020\u0001:\u0002\u0014\u0015B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\n\u001a\u00020\u000bH\u0014J\b\u0010\f\u001a\u00020\rH\u0002J\u0012\u0010\u000e\u001a\u00020\r2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0005H\u0014J\u001c\u0010\u000e\u001a\u00020\r2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00052\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0014J\u0006\u0010\u0012\u001a\u00020\u0013R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/jpa/jpb/model/ui/component/AbstractProjectBrowseFileField;", "Lcom/intellij/openapi/ui/TextFieldWithBrowseButton;", "myProject", "Lcom/intellij/openapi/project/Project;", "chooserChangeLogDescriptor", "Lcom/intellij/openapi/fileChooser/FileChooserDescriptor;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/fileChooser/FileChooserDescriptor;)V", "getMyProject", "()Lcom/intellij/openapi/project/Project;", "getDefaultIcon", "Ljavax/swing/Icon;", "safelyInit", "", "installPathCompletion", "fileChooserDescriptor", "parent", "Lcom/intellij/openapi/Disposable;", "createFileTextField", "Lcom/intellij/jpa/jpb/model/ui/component/ChangeLogFileTextField;", "ChangeLogBrowseFolderListener", "Companion", "intellij.javaee.jpa.jpb.model.ui"})
public abstract class AbstractProjectBrowseFileField
extends TextFieldWithBrowseButton {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project myProject;
    @NotNull
    private final FileChooserDescriptor chooserChangeLogDescriptor;

    public AbstractProjectBrowseFileField(@NotNull Project myProject, @NotNull FileChooserDescriptor chooserChangeLogDescriptor) {
        Intrinsics.checkNotNullParameter((Object)myProject, (String)"myProject");
        Intrinsics.checkNotNullParameter((Object)chooserChangeLogDescriptor, (String)"chooserChangeLogDescriptor");
        this.myProject = myProject;
        this.chooserChangeLogDescriptor = chooserChangeLogDescriptor;
        this.safelyInit();
    }

    @NotNull
    public final Project getMyProject() {
        return this.myProject;
    }

    @NotNull
    protected Icon getDefaultIcon() {
        Icon icon = AllIcons.General.OpenDiskHover;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"OpenDiskHover");
        return icon;
    }

    private final void safelyInit() {
        this.addBrowseFolderListener(new ChangeLogBrowseFolderListener(this.chooserChangeLogDescriptor));
        this.setButtonIcon(AllIcons.General.OpenDiskHover);
    }

    protected void installPathCompletion(@Nullable FileChooserDescriptor fileChooserDescriptor) {
    }

    protected void installPathCompletion(@Nullable FileChooserDescriptor fileChooserDescriptor, @Nullable Disposable parent) {
    }

    @NotNull
    public final ChangeLogFileTextField createFileTextField() {
        LocalFsFinder finder = new LocalFsFinder();
        Object object = ProjectUtil.guessProjectDir((Project)this.myProject);
        if (object == null || (object = object.getPath()) == null) {
            object = "";
        }
        finder.setBaseDir(new File((String)object));
        FileLookup.Finder finder2 = (FileLookup.Finder)finder;
        JTextField jTextField = this.getTextField();
        Intrinsics.checkNotNullExpressionValue((Object)jTextField, (String)"getTextField(...)");
        return new ChangeLogFileTextField(this.myProject, finder2, this.chooserChangeLogDescriptor, jTextField, this);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0014J\n\u0010\n\u001a\u0004\u0018\u00010\tH\u0014\u00a8\u0006\u000b"}, d2={"Lcom/intellij/jpa/jpb/model/ui/component/AbstractProjectBrowseFileField$ChangeLogBrowseFolderListener;", "Lcom/intellij/openapi/ui/TextBrowseFolderListener;", "chooserChangeLogDescriptor", "Lcom/intellij/openapi/fileChooser/FileChooserDescriptor;", "<init>", "(Lcom/intellij/jpa/jpb/model/ui/component/AbstractProjectBrowseFileField;Lcom/intellij/openapi/fileChooser/FileChooserDescriptor;)V", "chosenFileToResultingText", "", "chosenFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "getInitialFile", "intellij.javaee.jpa.jpb.model.ui"})
    @SourceDebugExtension(value={"SMAP\nAbstractProjectBrowseFileField.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractProjectBrowseFileField.kt\ncom/intellij/jpa/jpb/model/ui/component/AbstractProjectBrowseFileField$ChangeLogBrowseFolderListener\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,109:1\n1#2:110\n*E\n"})
    public final class ChangeLogBrowseFolderListener
    extends TextBrowseFolderListener {
        public ChangeLogBrowseFolderListener(FileChooserDescriptor chooserChangeLogDescriptor) {
            Intrinsics.checkNotNullParameter((Object)chooserChangeLogDescriptor, (String)"chooserChangeLogDescriptor");
            super(chooserChangeLogDescriptor, AbstractProjectBrowseFileField.this.getMyProject());
        }

        @NotNull
        protected String chosenFileToResultingText(@NotNull VirtualFile chosenFile) {
            String relativePath;
            String string;
            String string2;
            Intrinsics.checkNotNullParameter((Object)chosenFile, (String)"chosenFile");
            VirtualFile virtualFile = ProjectUtil.guessProjectDir((Project)AbstractProjectBrowseFileField.this.getMyProject());
            if (virtualFile != null) {
                VirtualFile it = virtualFile;
                boolean bl = false;
                string2 = VfsUtilCore.getRelativePath((VirtualFile)chosenFile, (VirtualFile)it);
            } else {
                string2 = null;
            }
            if ((string = (relativePath = string2)) == null) {
                String string3 = chosenFile.getPath();
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getPath(...)");
            }
            return string;
        }

        @Nullable
        protected VirtualFile getInitialFile() {
            VirtualFile virtualFile;
            String fieldText = null;
            String string = AbstractProjectBrowseFileField.this.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            fieldText = ((Object)StringsKt.trim((CharSequence)string)).toString();
            if (StringUtil.isEmptyOrSpaces((String)fieldText)) {
                return null;
            }
            fieldText = FileUtil.toSystemIndependentName((String)fieldText);
            VirtualFile virtualFile2 = ProjectUtil.guessProjectDir((Project)AbstractProjectBrowseFileField.this.getMyProject());
            if (virtualFile2 != null) {
                VirtualFile it = virtualFile2;
                boolean bl = false;
                virtualFile = VfsUtil.findRelativeFile((String)fieldText, (VirtualFile)it);
            } else {
                virtualFile = null;
            }
            return virtualFile;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005\u00a8\u0006\t"}, d2={"Lcom/intellij/jpa/jpb/model/ui/component/AbstractProjectBrowseFileField$Companion;", "", "<init>", "()V", "getAbsolutePath", "", "project", "Lcom/intellij/openapi/project/Project;", "path", "intellij.javaee.jpa.jpb.model.ui"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getAbsolutePath(@NotNull Project project, @NotNull String path) {
            Object object;
            block3: {
                block2: {
                    Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                    Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                    object = ProjectUtil.guessProjectDir((Project)project);
                    if (object == null) break block2;
                    VirtualFile it = object;
                    boolean bl = false;
                    File file = VfsUtil.virtualToIoFile((VirtualFile)it);
                    Intrinsics.checkNotNullExpressionValue((Object)file, (String)"virtualToIoFile(...)");
                    String absolutePath = FilesKt.resolve((File)file, (String)path).getAbsolutePath();
                    String string = FileUtil.toSystemIndependentName((String)absolutePath);
                    object = string;
                    if (string != null) break block3;
                }
                object = path;
            }
            return object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

