/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.jpb.model.ui.component;

import com.intellij.icons.AllIcons;
import com.intellij.jpa.jpb.model.config.DatabaseDriversConfigState;
import com.intellij.jpa.jpb.model.config.DbDriver;
import com.intellij.jpa.jpb.model.core.model.dbtype.DbType;
import com.intellij.jpa.jpb.model.core.msg.JpaModelBundle;
import com.intellij.jpa.jpb.model.core.notifydialog.HNotificationManager;
import com.intellij.jpa.jpb.model.dbdrivers.DatabaseArtifactsManager;
import com.intellij.jpa.jpb.model.ui.component.DbDriverProblemPanel;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.HTMLEditorKitBuilder;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import javax.swing.JEditorPane;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 \u00122\u00020\u0001:\u0002\u0012\u0013B\u001b\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/jpa/jpb/model/ui/component/DbDriverProblemPanel;", "Lcom/intellij/util/ui/components/BorderLayoutPanel;", "project", "Lcom/intellij/openapi/project/Project;", "withTopSeparator", "", "<init>", "(Lcom/intellij/openapi/project/Project;Z)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "artifactsManager", "Lcom/intellij/jpa/jpb/model/dbdrivers/DatabaseArtifactsManager;", "editorPanel", "Ljavax/swing/JEditorPane;", "dbType", "Lcom/intellij/jpa/jpb/model/core/model/dbtype/DbType;", "updatePanelState", "", "Companion", "MyHyperlinkListener", "intellij.javaee.jpa.jpb.model"})
@SourceDebugExtension(value={"SMAP\nDbDriverProblemPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DbDriverProblemPanel.kt\ncom/intellij/jpa/jpb/model/ui/component/DbDriverProblemPanel\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,126:1\n1#2:127\n*E\n"})
public final class DbDriverProblemPanel
extends BorderLayoutPanel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final DatabaseArtifactsManager artifactsManager;
    @NotNull
    private final JEditorPane editorPanel;
    private DbType dbType;
    @NotNull
    public static final String DOWNLOAD_LINK = "download";
    @NotNull
    public static final String SWITCH_TO_LINK = "switch-to";

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    public DbDriverProblemPanel(@NotNull Project project, boolean withTopSeparator) {
        void $this$_init__u24lambda_u241;
        Object $this$_init__u24lambda_u240;
        Object object;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.artifactsManager = DatabaseArtifactsManager.Companion.getInstance();
        if (withTopSeparator) {
            this.setBorder(JBUI.Borders.customLine((Color)JBColor.border(), (int)1, (int)0, (int)0, (int)0));
        }
        BorderLayoutPanel wrapPanel = new BorderLayoutPanel(10, 4);
        wrapPanel.setBorder((Border)JBUI.Borders.empty((int)4, (int)4, (int)0, (int)0));
        JBLabel jBLabel = object = new JBLabel();
        BorderLayoutPanel borderLayoutPanel = wrapPanel;
        boolean bl = false;
        $this$_init__u24lambda_u240.setIcon(AllIcons.General.Warning);
        borderLayoutPanel.addToLeft((Component)object);
        $this$_init__u24lambda_u240 = object = new JEditorPane();
        borderLayoutPanel = this;
        boolean bl2 = false;
        $this$_init__u24lambda_u241.setEditorKit(HTMLEditorKitBuilder.Companion.simple());
        $this$_init__u24lambda_u241.setEditable(false);
        $this$_init__u24lambda_u241.setOpaque(false);
        $this$_init__u24lambda_u241.setBorder(null);
        $this$_init__u24lambda_u241.setMargin((Insets)JBUI.emptyInsets());
        $this$_init__u24lambda_u241.addHyperlinkListener(new MyHyperlinkListener());
        borderLayoutPanel.editorPanel = object;
        wrapPanel.addToCenter((Component)this.editorPanel);
        this.addToLeft((Component)wrapPanel);
    }

    public /* synthetic */ DbDriverProblemPanel(Project project, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = true;
        }
        this(project, bl);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public final void updatePanelState(@NotNull DbType dbType) {
        Object v0;
        block4: {
            Intrinsics.checkNotNullParameter((Object)dbType, (String)"dbType");
            this.dbType = dbType;
            DatabaseDriversConfigState state = DatabaseDriversConfigState.Companion.getInstance();
            Iterable iterable = state.getDrivers();
            for (Object t : iterable) {
                DbDriver it = (DbDriver)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getId(), (Object)dbType.getDriverClass())) continue;
                v0 = t;
                break block4;
            }
            v0 = null;
        }
        DbDriver driverState = v0;
        List<File> classpathElements = driverState == null ? CollectionsKt.emptyList() : this.artifactsManager.getExistsClasspathElements(driverState);
        this.setVisible(classpathElements.isEmpty());
        if (!((Collection)classpathElements).isEmpty()) {
            return;
        }
        DatabaseArtifactsManager.ArtifactVersion latestArtifactVersion = this.artifactsManager.getLatestArtifactVersion(dbType);
        if (latestArtifactVersion != null && this.artifactsManager.isAllDownloaded(latestArtifactVersion)) {
            var6_4 = new Object[]{SWITCH_TO_LINK, latestArtifactVersion.getVersion()};
            this.editorPanel.setText(JpaModelBundle.message("no.driver.files.configured", var6_4));
        } else {
            var6_4 = new Object[]{DOWNLOAD_LINK};
            this.editorPanel.setText(JpaModelBundle.message("download.missing.driver.files", var6_4));
        }
    }

    @JvmOverloads
    public DbDriverProblemPanel(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this(project, false, 2, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/jpa/jpb/model/ui/component/DbDriverProblemPanel$Companion;", "", "<init>", "()V", "DOWNLOAD_LINK", "", "SWITCH_TO_LINK", "intellij.javaee.jpa.jpb.model"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/jpa/jpb/model/ui/component/DbDriverProblemPanel$MyHyperlinkListener;", "Ljavax/swing/event/HyperlinkListener;", "<init>", "(Lcom/intellij/jpa/jpb/model/ui/component/DbDriverProblemPanel;)V", "hyperlinkUpdate", "", "e", "Ljavax/swing/event/HyperlinkEvent;", "intellij.javaee.jpa.jpb.model"})
    public final class MyHyperlinkListener
    implements HyperlinkListener {
        @Override
        public void hyperlinkUpdate(@NotNull HyperlinkEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            if (!Intrinsics.areEqual((Object)e.getEventType(), (Object)HyperlinkEvent.EventType.ACTIVATED)) {
                return;
            }
            if (DbDriverProblemPanel.this.artifactsManager.getArtifacts().isEmpty()) {
                HNotificationManager.getInstance(DbDriverProblemPanel.this.getProject()).showNotification(JpaModelBundle.message("artifact.drivers.files.unload", new Object[0]), NotificationType.WARNING);
                return;
            }
            DatabaseArtifactsManager databaseArtifactsManager = DbDriverProblemPanel.this.artifactsManager;
            DbType dbType = DbDriverProblemPanel.this.dbType;
            if (dbType == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"dbType");
                dbType = null;
            }
            DatabaseArtifactsManager.ArtifactVersion artifactVersion = databaseArtifactsManager.getLatestArtifactVersion(dbType);
            if (artifactVersion == null) {
                return;
            }
            DatabaseArtifactsManager.ArtifactVersion latestArtifactVersion = artifactVersion;
            String linkDescription = e.getDescription();
            Function0 saveStateAndUpdatePanelAction = () -> MyHyperlinkListener.hyperlinkUpdate$lambda$0(DbDriverProblemPanel.this, latestArtifactVersion);
            if (Intrinsics.areEqual((Object)DbDriverProblemPanel.DOWNLOAD_LINK, (Object)linkDescription)) {
                Project project = DbDriverProblemPanel.this.getProject();
                String string = JpaModelBundle.message("dialog.title.downloading.driver.files", new Object[0]);
                new Task.Modal(DbDriverProblemPanel.this, latestArtifactVersion, (Function0<Unit>)saveStateAndUpdatePanelAction, project, string){
                    final /* synthetic */ DbDriverProblemPanel this$0;
                    final /* synthetic */ DatabaseArtifactsManager.ArtifactVersion $latestArtifactVersion;
                    final /* synthetic */ Function0<Unit> $saveStateAndUpdatePanelAction;
                    {
                        this.this$0 = $receiver;
                        this.$latestArtifactVersion = $latestArtifactVersion;
                        this.$saveStateAndUpdatePanelAction = $saveStateAndUpdatePanelAction;
                        super($super_call_param$1, $super_call_param$2, true);
                    }

                    public void run(ProgressIndicator indicator) {
                        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                        try {
                            DbDriverProblemPanel.access$getArtifactsManager$p(this.this$0).downloadArtifact(this.$latestArtifactVersion);
                            ApplicationManager.getApplication().invokeLater(() -> hyperlinkUpdate.1.run$lambda$0(this.$saveStateAndUpdatePanelAction));
                        }
                        catch (IOException e) {
                            HNotificationManager.getInstance(this.getProject()).showNotification(e.getMessage() + "\n " + JpaModelBundle.message("please.check.internet.connection", new Object[0]), NotificationType.WARNING);
                        }
                    }

                    private static final void run$lambda$0(Function0 $tmp0) {
                        $tmp0.invoke();
                    }
                }.queue();
                return;
            }
            saveStateAndUpdatePanelAction.invoke();
        }

        private static final Unit hyperlinkUpdate$lambda$0(DbDriverProblemPanel this$0, DatabaseArtifactsManager.ArtifactVersion $latestArtifactVersion) {
            DatabaseDriversConfigState databaseDriversConfigState = DatabaseDriversConfigState.Companion.getInstance();
            DbType dbType = this$0.dbType;
            if (dbType == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"dbType");
                dbType = null;
            }
            String string = dbType.getDriverClass();
            Intrinsics.checkNotNull((Object)string);
            DbDriver dbDriver = databaseDriversConfigState.getOrCreateDriver(string);
            dbDriver.setVersion($latestArtifactVersion.getVersion());
            DbType dbType2 = this$0.dbType;
            if (dbType2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"dbType");
                dbType2 = null;
            }
            this$0.updatePanelState(dbType2);
            return Unit.INSTANCE;
        }
    }
}

