/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.jpb.model.ui.entity;

import com.intellij.jpa.jpb.model.model.BaseEntity;
import com.intellij.jpa.jpb.model.model.Entity;
import com.intellij.jpa.jpb.model.util.JpaUiUtil;
import com.intellij.jpa.jpb.model.util.JpaUtils;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.ComboboxSpeedSearch;
import com.intellij.ui.FileColorManager;
import com.intellij.ui.SimpleTextAttributes;
import java.awt.event.ItemListener;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001dB\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001e\u0010\u0010\u001a\u00020\u00112\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00020\u000f2\b\b\u0002\u0010\u0012\u001a\u00020\nJ\u0010\u0010\u0013\u001a\u00020\u00112\b\u0010\u0014\u001a\u0004\u0018\u00010\u0002J\u0010\u0010\u0015\u001a\u00020\u00112\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017J\u000e\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u0017J\u000e\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u001cR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\u000b\"\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/jpa/jpb/model/ui/entity/JpaEntityComboBox;", "Lcom/intellij/openapi/ui/ComboBox;", "Lcom/intellij/jpa/jpb/model/model/Entity;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "isAvailableNull", "", "()Z", "setAvailableNull", "(Z)V", "entities", "", "setItems", "", "toSort", "selectEntity", "entity", "selectByFqn", "fqn", "", "sortEntitiesBySimilarity", "name", "addUniqueActionListener", "listener", "Ljava/awt/event/ItemListener;", "EntityFieldRender", "intellij.javaee.jpa.jpb.model"})
@SourceDebugExtension(value={"SMAP\nJpaEntityComboBox.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JpaEntityComboBox.kt\ncom/intellij/jpa/jpb/model/ui/entity/JpaEntityComboBox\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,107:1\n1863#2,2:108\n1062#2:111\n1863#2,2:112\n1#3:110\n12574#4,2:114\n1310#4,2:116\n*S KotlinDebug\n*F\n+ 1 JpaEntityComboBox.kt\ncom/intellij/jpa/jpb/model/ui/entity/JpaEntityComboBox\n*L\n39#1:108,2\n61#1:111\n67#1:112,2\n70#1:114,2\n78#1:116,2\n*E\n"})
public class JpaEntityComboBox
extends ComboBox<Entity> {
    @NotNull
    private final Project project;
    private boolean isAvailableNull;
    @NotNull
    private Collection<? extends Entity> entities;

    public JpaEntityComboBox(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.entities = CollectionsKt.emptyList();
        this.setRenderer((ListCellRenderer)((Object)new EntityFieldRender(this.project)));
        this.setKeySelectionManager(JpaEntityComboBox::_init_$lambda$0);
        ComboboxSpeedSearch.installOn((JComboBox)((JComboBox)((Object)this)));
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public final boolean isAvailableNull() {
        return this.isAvailableNull;
    }

    public final void setAvailableNull(boolean bl) {
        this.isAvailableNull = bl;
    }

    public final void setItems(@NotNull Collection<? extends Entity> entities, boolean toSort) {
        Collection collection;
        Intrinsics.checkNotNullParameter(entities, (String)"entities");
        this.removeAllItems();
        if (toSort) {
            Function1[] function1Array = new Function1[]{JpaEntityComboBox::setItems$lambda$1, JpaEntityComboBox::setItems$lambda$2, JpaEntityComboBox::setItems$lambda$3};
            collection = CollectionsKt.sortedWith((Iterable)entities, (Comparator)ComparisonsKt.compareBy((Function1[])function1Array));
        } else {
            collection = entities;
        }
        Collection processedEntities = collection;
        this.entities = processedEntities;
        if (this.isAvailableNull) {
            this.addItem(null);
        }
        Iterable $this$forEach$iv = processedEntities;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Entity it = (Entity)element$iv;
            boolean bl = false;
            it.toString();
            this.addItem(it);
        }
        this.setSelectedItem(null);
    }

    public static /* synthetic */ void setItems$default(JpaEntityComboBox jpaEntityComboBox, Collection collection, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: setItems");
        }
        if ((n & 2) != 0) {
            bl = true;
        }
        jpaEntityComboBox.setItems(collection, bl);
    }

    public final void selectEntity(@Nullable Entity entity) {
        if (Intrinsics.areEqual((Object)this.getSelectedItem(), (Object)entity)) {
            this.setSelectedItem(null);
        }
        this.setSelectedItem(entity);
    }

    public final void selectByFqn(@Nullable String fqn) {
        Entity entity;
        JpaEntityComboBox jpaEntityComboBox = this;
        if (fqn == null) {
            entity = null;
        } else {
            Object v2;
            JpaEntityComboBox jpaEntityComboBox2;
            block3: {
                Iterable iterable = this.entities;
                jpaEntityComboBox2 = jpaEntityComboBox;
                Iterable iterable2 = iterable;
                for (Object t : iterable2) {
                    Entity it = (Entity)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getFqn(), (Object)fqn)) continue;
                    v2 = t;
                    break block3;
                }
                v2 = null;
            }
            jpaEntityComboBox = jpaEntityComboBox2;
            entity = v2;
        }
        jpaEntityComboBox.selectEntity(entity);
    }

    public final void sortEntitiesBySimilarity(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        String[] nameParts = JpaUtils.CAMEL_CASE_PATTERN.split(name);
        Iterable $this$sortedByDescending$iv = this.entities;
        boolean $i$f$sortedByDescending = false;
        List sortedEntities = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(nameParts){
            final /* synthetic */ String[] $nameParts$inlined;
            {
                this.$nameParts$inlined = stringArray;
            }

            public final int compare(T a, T b) {
                boolean bl;
                String it;
                String element$iv;
                int n;
                Entity entity = (Entity)b;
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)this.$nameParts$inlined);
                String[] $this$count$iv = this.$nameParts$inlined;
                boolean $i$f$count = false;
                int count$iv = 0;
                int n2 = $this$count$iv.length;
                for (n = 0; n < n2; ++n) {
                    it = element$iv = $this$count$iv[n];
                    bl = false;
                    if (!entity.getNameParts().contains(it)) continue;
                    ++count$iv;
                }
                entity = (Entity)a;
                Comparable comparable = Integer.valueOf(count$iv);
                bl2 = false;
                Intrinsics.checkNotNull((Object)this.$nameParts$inlined);
                $this$count$iv = this.$nameParts$inlined;
                $i$f$count = false;
                count$iv = 0;
                n2 = $this$count$iv.length;
                for (n = 0; n < n2; ++n) {
                    it = element$iv = $this$count$iv[n];
                    bl = false;
                    if (!entity.getNameParts().contains(it)) continue;
                    ++count$iv;
                }
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)Integer.valueOf(count$iv));
            }
        });
        this.removeAllItems();
        Iterable $this$forEach$iv = sortedEntities;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Entity it = (Entity)element$iv;
            boolean bl = false;
            this.addItem(it);
        }
        if (!((Collection)sortedEntities).isEmpty()) {
            boolean bl;
            block4: {
                Set<String> firstItemNameParts = ((Entity)CollectionsKt.first((List)sortedEntities)).getNameParts();
                Intrinsics.checkNotNull((Object)nameParts);
                String[] $this$any$iv = nameParts;
                boolean $i$f$any = false;
                int n = $this$any$iv.length;
                for (int i = 0; i < n; ++i) {
                    String element$iv;
                    String it = element$iv = $this$any$iv[i];
                    boolean bl2 = false;
                    if (!firstItemNameParts.contains(it)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
            if (bl) {
                this.setSelectedIndex(0);
            }
        }
    }

    public final void addUniqueActionListener(@NotNull ItemListener listener) {
        Object object;
        block2: {
            Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
            Class<?> listenerClass = listener.getClass();
            ItemListener[] itemListenerArray = this.getItemListeners();
            Intrinsics.checkNotNullExpressionValue((Object)itemListenerArray, (String)"getItemListeners(...)");
            Object[] $this$firstOrNull$iv = itemListenerArray;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                ItemListener it = (ItemListener)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual(it.getClass(), listenerClass)) continue;
                object = element$iv;
                break block2;
            }
            object = null;
        }
        ItemListener existingListener = (ItemListener)object;
        if (existingListener != null) {
            this.removeItemListener(existingListener);
        }
        super.addItemListener(listener);
    }

    private static final int _init_$lambda$0(char c, ComboBoxModel comboBoxModel) {
        return -1;
    }

    private static final Comparable setItems$lambda$1(Entity it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Boolean.valueOf(it instanceof BaseEntity);
    }

    private static final Comparable setItems$lambda$2(Entity it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Boolean.valueOf(!it.isMappedSuperclass());
    }

    private static final Comparable setItems$lambda$3(Entity it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (Comparable)((Object)it.getClassName());
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J:\u0010\r\u001a\u00020\u000e2\u000e\u0010\u000f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015H\u0014R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0018\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\f\u00a8\u0006\u0017"}, d2={"Lcom/intellij/jpa/jpb/model/ui/entity/JpaEntityComboBox$EntityFieldRender;", "Lcom/intellij/ui/ColoredListCellRenderer;", "Lcom/intellij/jpa/jpb/model/model/Entity;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "colorManager", "Lcom/intellij/ui/FileColorManager;", "kotlin.jvm.PlatformType", "Lcom/intellij/ui/FileColorManager;", "customizeCellRenderer", "", "list", "Ljavax/swing/JList;", "value", "index", "", "selected", "", "hasFocus", "intellij.javaee.jpa.jpb.model"})
    public static final class EntityFieldRender
    extends ColoredListCellRenderer<Entity> {
        @NotNull
        private final Project project;
        private final FileColorManager colorManager;

        public EntityFieldRender(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            this.project = project;
            this.colorManager = FileColorManager.getInstance((Project)this.project);
        }

        @NotNull
        public final Project getProject() {
            return this.project;
        }

        protected void customizeCellRenderer(@NotNull JList<? extends Entity> list, @Nullable Entity value, int index, boolean selected, boolean hasFocus) {
            Intrinsics.checkNotNullParameter(list, (String)"list");
            if (value == null) {
                return;
            }
            this.append(value.getClassName());
            this.append(" " + value.getPackageName(), SimpleTextAttributes.GRAY_ATTRIBUTES);
            this.setIcon(JpaUiUtil.getIconForEntity(value));
            if (!selected && value instanceof BaseEntity) {
                this.setBackground(this.colorManager.getColor("Yellow"));
            }
        }
    }
}

