/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.jpb.model.ui.swing;

import com.intellij.jpa.jpb.model.ui.JpbColor;
import com.intellij.openapi.util.NlsContexts;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.swing.table.AbstractTableModel;
import one.util.streamex.IntStreamEx;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JpbAbstractTableModel<DataType>
extends AbstractTableModel {
    protected List<DataType> rawData;
    protected List<DataType> filteredData;
    protected List<DataType> data;
    protected List<ColumnMetaInfo<DataType, Object>> columnMetaInfo;
    protected Predicate<DataType> filter;
    protected Comparator<DataType> sorter;

    private JpbAbstractTableModel(List<DataType> data, Predicate<DataType> filter, Comparator<DataType> sorter) {
        this.rawData = data;
        this.filter = filter;
        this.sorter = sorter;
        this.filter();
        this.sort();
    }

    public JpbAbstractTableModel(@NotNull DataType[] data, @Nullable Predicate<DataType> filter, @Nullable Comparator<DataType> sorter) {
        if (data == null) {
            JpbAbstractTableModel.$$$reportNull$$$0(0);
        }
        this(StreamEx.of((Object[])data).toList(), filter, sorter);
    }

    public JpbAbstractTableModel(@NotNull DataType[] data) {
        if (data == null) {
            JpbAbstractTableModel.$$$reportNull$$$0(1);
        }
        this(data, null, null);
    }

    public JpbAbstractTableModel(@NotNull DataType[] data, @Nullable Predicate<DataType> filter) {
        if (data == null) {
            JpbAbstractTableModel.$$$reportNull$$$0(2);
        }
        this(data, filter, null);
    }

    public JpbAbstractTableModel(@NotNull DataType[] data, @Nullable Comparator<DataType> sorter) {
        if (data == null) {
            JpbAbstractTableModel.$$$reportNull$$$0(3);
        }
        this(data, null, sorter);
    }

    public JpbAbstractTableModel(@NotNull Collection<DataType> data, @Nullable Predicate<DataType> filter, @Nullable Comparator<DataType> sorter) {
        if (data == null) {
            JpbAbstractTableModel.$$$reportNull$$$0(4);
        }
        this((List<DataType>)new ArrayList<DataType>(data), filter, sorter);
    }

    public JpbAbstractTableModel(@NotNull Collection<DataType> data) {
        if (data == null) {
            JpbAbstractTableModel.$$$reportNull$$$0(5);
        }
        this(data, null, null);
    }

    public JpbAbstractTableModel(@NotNull Collection<DataType> data, @Nullable Predicate<DataType> filter) {
        if (data == null) {
            JpbAbstractTableModel.$$$reportNull$$$0(6);
        }
        this(data, filter, null);
    }

    public JpbAbstractTableModel(@NotNull Collection<DataType> data, @Nullable Comparator<DataType> sorter) {
        if (data == null) {
            JpbAbstractTableModel.$$$reportNull$$$0(7);
        }
        this(data, null, sorter);
    }

    public JpbAbstractTableModel() {
        this(new ArrayList(), (Predicate<DataType>)null, (Comparator<DataType>)null);
    }

    public void setData(@NotNull DataType[] data) {
        if (data == null) {
            JpbAbstractTableModel.$$$reportNull$$$0(8);
        }
        this.rawData = new ArrayList<DataType>(Arrays.asList(data));
        this.filter();
        this.sort();
        this.fireTableDataChanged();
    }

    public void setData(@NotNull Collection<DataType> data) {
        if (data == null) {
            JpbAbstractTableModel.$$$reportNull$$$0(9);
        }
        this.rawData = new ArrayList<DataType>(data);
        this.filter();
        this.sort();
        this.fireTableDataChanged();
    }

    @NotNull
    public List<DataType> getData() {
        List<DataType> list = this.data;
        if (list == null) {
            JpbAbstractTableModel.$$$reportNull$$$0(10);
        }
        return list;
    }

    public void setFilter(@Nullable Predicate<DataType> filter) {
        this.filter = filter;
        this.filter();
        this.sort();
        this.fireTableDataChanged();
    }

    public void setSorter(@Nullable Comparator<DataType> sorter) {
        this.sorter = sorter;
        this.filter();
        this.sort();
        this.fireTableDataChanged();
    }

    public void addRow(@NotNull DataType newData) {
        if (newData == null) {
            JpbAbstractTableModel.$$$reportNull$$$0(11);
        }
        this.rawData.add(newData);
        if (this.filter != null && this.filter.test(newData)) {
            this.filteredData.add(newData);
        }
        this.sort();
        this.fireTableDataChanged();
    }

    public void addRow(int index, @NotNull DataType newData) {
        if (newData == null) {
            JpbAbstractTableModel.$$$reportNull$$$0(12);
        }
        this.rawData.add(index, newData);
        if (this.filter != null && this.filter.test(newData)) {
            this.filteredData.add(newData);
        }
        this.sort();
        this.fireTableDataChanged();
    }

    public void addRowAt(int index, @NotNull DataType newData) {
        if (newData == null) {
            JpbAbstractTableModel.$$$reportNull$$$0(13);
        }
        this.rawData.add(index, newData);
        if (this.filter != null && this.filter.test(newData)) {
            this.filteredData.add(newData);
        }
        this.sort();
        this.fireTableDataChanged();
    }

    @NotNull
    public DataType removeRow(int rowNum) {
        DataType removed;
        if (this.filter != null) {
            removed = this.filteredData.remove(rowNum);
            this.rawData.remove(removed);
        } else {
            removed = this.rawData.remove(rowNum);
        }
        this.fireTableRowsDeleted(rowNum, rowNum);
        DataType DataType = removed;
        if (DataType == null) {
            JpbAbstractTableModel.$$$reportNull$$$0(14);
        }
        return DataType;
    }

    @NotNull
    public List<DataType> removeRows(int ... rowNumbers) {
        List list = IntStreamEx.of((int[])rowNumbers).sorted(Comparator.reverseOrder()).mapToObj(this::removeRow).toImmutableList();
        if (list == null) {
            JpbAbstractTableModel.$$$reportNull$$$0(15);
        }
        return list;
    }

    public void removeAll() {
        if (this.rawData.isEmpty()) {
            return;
        }
        int last = this.rawData.size() - 1;
        if (this.filter != null) {
            this.filteredData.clear();
        } else {
            this.rawData.clear();
        }
        this.fireTableRowsDeleted(0, last);
    }

    @Override
    public int getRowCount() {
        return this.data.size();
    }

    @Override
    public int getColumnCount() {
        this.checkColumnMetaInfo();
        return this.columnMetaInfo.size();
    }

    @Override
    @Nullable
    public Object getValueAt(int rowIndex, int columnIndex) {
        this.checkColumnMetaInfo();
        return this.columnMetaInfo.get(columnIndex).getValue(this.data.get(rowIndex));
    }

    @Override
    public void setValueAt(@Nullable Object aValue, int rowIndex, int columnIndex) {
        this.checkColumnMetaInfo();
        if (rowIndex < this.getRowCount() && columnIndex < this.getColumnCount()) {
            this.columnMetaInfo.get(columnIndex).setValue(this.data.get(rowIndex), aValue);
            this.fireTableCellUpdated(rowIndex, columnIndex);
        }
    }

    @Override
    @NotNull
    public String getColumnName(int column) {
        this.checkColumnMetaInfo();
        String string = this.columnMetaInfo.get(column).getColumnName();
        if (string == null) {
            JpbAbstractTableModel.$$$reportNull$$$0(16);
        }
        return string;
    }

    @Override
    @NotNull
    public Class<?> getColumnClass(int columnIndex) {
        this.checkColumnMetaInfo();
        Class<Object> clazz = this.columnMetaInfo.get(columnIndex).getValueClass();
        if (clazz == null) {
            JpbAbstractTableModel.$$$reportNull$$$0(17);
        }
        return clazz;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        this.checkColumnMetaInfo();
        return this.columnMetaInfo.get(columnIndex).isEditable();
    }

    @NotNull
    public List<ColumnMetaInfo<DataType, Object>> getColumnMetaInfo() {
        this.checkColumnMetaInfo();
        List<ColumnMetaInfo<DataType, Object>> list = this.columnMetaInfo;
        if (list == null) {
            JpbAbstractTableModel.$$$reportNull$$$0(18);
        }
        return list;
    }

    @NotNull
    public Color getRowColor(int rowIndex) {
        Color color = this.getRowColor(this.getData().get(rowIndex));
        if (color == null) {
            JpbAbstractTableModel.$$$reportNull$$$0(19);
        }
        return color;
    }

    @NotNull
    public Color getRowColor(@NotNull DataType rowData) {
        if (rowData == null) {
            JpbAbstractTableModel.$$$reportNull$$$0(20);
        }
        Color color = JpbColor.BLACK;
        if (color == null) {
            JpbAbstractTableModel.$$$reportNull$$$0(21);
        }
        return color;
    }

    public void forceUpdate() {
        this.fireTableDataChanged();
    }

    protected void init() {
        this.columnMetaInfo = this.createColumnMetaInfo();
    }

    protected abstract List<ColumnMetaInfo<DataType, ?>> createColumnMetaInfo();

    private void filter() {
        if (this.filter != null) {
            this.filteredData = ((StreamEx)StreamEx.of(this.rawData).filter(this.filter)).toList();
            this.data = this.filteredData;
        } else {
            this.data = Collections.unmodifiableList(this.rawData);
        }
    }

    private void sort() {
        if (this.sorter != null) {
            this.rawData.sort(this.sorter);
            if (this.filteredData != null) {
                this.filteredData.sort(this.sorter);
            }
        }
    }

    private void checkColumnMetaInfo() {
        if (this.columnMetaInfo == null) {
            throw new NullPointerException("columnMetaInfo is null. Did you forget to call init()?");
        }
    }

    public List<DataType> getRawData() {
        return this.rawData;
    }

    public int indexOf(DataType dataType) {
        return this.rawData.indexOf(dataType);
    }

    public int size() {
        return this.rawData.size();
    }

    public boolean isFirst(DataType dataType) {
        return this.indexOf(dataType) == 0;
    }

    public boolean isLast(DataType dataType) {
        return this.indexOf(dataType) == this.rawData.size() - 1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 10, 14, 15, 16, 17, 18, 19, 21 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 10: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jpa/jpb/model/ui/swing/JpbAbstractTableModel";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newData";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rowData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jpa/jpb/model/ui/swing/JpbAbstractTableModel";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getData";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "removeRow";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "removeRows";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getColumnName";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getColumnClass";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getColumnMetaInfo";
                break;
            }
            case 19: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getRowColor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setData";
                break;
            }
            case 10: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: {
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addRow";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "addRowAt";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getRowColor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 10, 14, 15, 16, 17, 18, 19, 21 -> new IllegalStateException(string);
        };
    }

    public static class ColumnMetaInfo<RowType, Value> {
        private final @NlsContexts.ColumnName String columnName;
        private final Function<RowType, Value> valueGetter;
        private final Class<Value> valueClass;
        private Comparator<Value> comparator;

        public ColumnMetaInfo(@NlsContexts.ColumnName String columnName, Function<RowType, Value> valueGetter, Class<Value> valueClass) {
            this.columnName = columnName;
            this.valueGetter = valueGetter;
            this.valueClass = valueClass;
            this.comparator = null;
        }

        public ColumnMetaInfo(@NlsContexts.ColumnName String columnName, Function<RowType, Value> valueGetter, Class<Value> valueClass, Comparator<Value> comparator) {
            this(columnName, valueGetter, valueClass);
            this.comparator = comparator;
        }

        @NlsContexts.ColumnName
        public String getColumnName() {
            return this.columnName;
        }

        public Value getValue(RowType rowObj) {
            return this.valueGetter.apply(rowObj);
        }

        public void setValue(RowType rowObj, Value value) {
            throw new UnsupportedOperationException("Use EditableColumnMetaInfo instead ColumnMetaInfo if you need to change the value");
        }

        public Class<Value> getValueClass() {
            return this.valueClass;
        }

        public boolean isEditable() {
            return false;
        }

        @Nullable
        public Comparator<Value> getComparator() {
            return this.comparator;
        }

        public boolean isColumnSortAvailable() {
            return this.comparator != null;
        }
    }

    public static class EditableColumnMetaInfo<RowType, Value>
    extends ColumnMetaInfo<RowType, Value> {
        private BiConsumer<RowType, Value> valueSetter;

        public EditableColumnMetaInfo(@NlsContexts.ColumnName String columnName, Function<RowType, Value> valueGetter, BiConsumer<RowType, Value> valueSetter, Class<Value> valueClass) {
            super(columnName, valueGetter, valueClass);
            this.valueSetter = valueSetter;
        }

        public EditableColumnMetaInfo(@NlsContexts.ColumnName String columnName, Function<RowType, Value> valueGetter, BiConsumer<RowType, Value> valueSetter, Class<Value> valueClass, Comparator<Value> comparator) {
            super(columnName, valueGetter, valueClass, comparator);
            this.valueSetter = valueSetter;
        }

        @Override
        public void setValue(RowType rowObj, Value value) {
            this.valueSetter.accept(rowObj, value);
        }

        @Override
        public boolean isEditable() {
            return true;
        }
    }
}

