/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.jpb.model.util;

import com.intellij.java.library.JavaLibraryUtil;
import com.intellij.jpa.jpb.model.backend.ed.annotation.attr.JpaEntityAnnotation;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0007J\u001c\u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0007J\u001c\u0010\u000e\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0007J$\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/jpa/jpb/model/util/DependenciesUtils;", "", "<init>", "()V", "JAKARTA_ENTITY_FQN", "", "JAVAX_ENTITY_FQN", "isJpaProject", "", "project", "Lcom/intellij/openapi/project/Project;", "module", "Lcom/intellij/openapi/module/Module;", "isHibernateProject", "isEclipseLink", "hasClassInLibraries", "fqn", "intellij.javaee.jpa.jpb.model"})
public final class DependenciesUtils {
    @NotNull
    public static final DependenciesUtils INSTANCE = new DependenciesUtils();
    @NotNull
    private static final String JAKARTA_ENTITY_FQN = "jakarta.persistence." + JpaEntityAnnotation.Entity;
    @NotNull
    private static final String JAVAX_ENTITY_FQN = "javax.persistence." + JpaEntityAnnotation.Entity;

    private DependenciesUtils() {
    }

    @RequiresReadLock
    public final boolean isJpaProject(@NotNull Project project, @Nullable Module module) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return this.hasClassInLibraries(JAKARTA_ENTITY_FQN, project, module) || this.hasClassInLibraries(JAVAX_ENTITY_FQN, project, module);
    }

    public static /* synthetic */ boolean isJpaProject$default(DependenciesUtils dependenciesUtils, Project project, Module module, int n, Object object) {
        if ((n & 2) != 0) {
            module = null;
        }
        return dependenciesUtils.isJpaProject(project, module);
    }

    @RequiresReadLock
    public final boolean isHibernateProject(@NotNull Project project, @Nullable Module module) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return this.hasClassInLibraries("org.hibernate.jpa.HibernatePersistenceProvider", project, module);
    }

    public static /* synthetic */ boolean isHibernateProject$default(DependenciesUtils dependenciesUtils, Project project, Module module, int n, Object object) {
        if ((n & 2) != 0) {
            module = null;
        }
        return dependenciesUtils.isHibernateProject(project, module);
    }

    @RequiresReadLock
    public final boolean isEclipseLink(@NotNull Project project, @Nullable Module module) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return this.hasClassInLibraries("org.eclipse.persistence.jpa.PersistenceProvider", project, module);
    }

    public static /* synthetic */ boolean isEclipseLink$default(DependenciesUtils dependenciesUtils, Project project, Module module, int n, Object object) {
        if ((n & 2) != 0) {
            module = null;
        }
        return dependenciesUtils.isEclipseLink(project, module);
    }

    private final boolean hasClassInLibraries(String fqn, Project project, Module module) {
        return module != null && !module.isDisposed() ? JavaLibraryUtil.hasLibraryClass((Module)module, (String)fqn) : JavaLibraryUtil.hasLibraryClass((Project)project, (String)fqn);
    }

    static /* synthetic */ boolean hasClassInLibraries$default(DependenciesUtils dependenciesUtils, String string, Project project, Module module, int n, Object object) {
        if ((n & 4) != 0) {
            module = null;
        }
        return dependenciesUtils.hasClassInLibraries(string, project, module);
    }
}

