/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.jpb.model.util;

import com.intellij.jpa.jpb.model.action.creation.EventDataProviderEP;
import com.intellij.jpa.jpb.model.core.model.AbstractRdbmsStore;
import com.intellij.jpa.jpb.model.core.model.dbtype.DbType;
import com.intellij.jpa.jpb.model.core.util.Fqn;
import com.intellij.jpa.jpb.model.model.Datatype;
import com.intellij.jpa.jpb.model.model.EntityAttribute;
import com.intellij.jpa.jpb.model.model.EntityAttributeModel;
import com.intellij.jpa.jpb.model.model.EnumType;
import com.intellij.jpa.jpb.model.model.SourceLanguage;
import com.intellij.jpa.jpb.model.orm.ep.OrmProvider;
import com.intellij.jpa.jpb.model.orm.ep.OrmSearcher;
import com.intellij.jpa.jpb.model.orm.ep.OrmUnitsProvider;
import com.intellij.jpa.jpb.model.orm.jpa.JpaOrmFramework;
import com.intellij.jpa.jpb.model.orm.model.OrmEntity;
import com.intellij.jpa.jpb.model.orm.model.OrmEntityAttribute;
import com.intellij.jpa.jpb.model.orm.model.OrmFramework;
import com.intellij.jpa.jpb.model.orm.model.OrmUnit;
import com.intellij.jpa.jpb.model.orm.toolwindow.structure.OrmStructurePanel;
import com.intellij.jpa.jpb.model.reference.TemplateHelper;
import com.intellij.jpa.jpb.model.util.PsiUtilsKt;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiType;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.ui.content.Content;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002,-B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0010\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J-\u0010\u0012\u001a\u0004\u0018\u0001H\u0013\"\b\b\u0000\u0010\u0013*\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00130\u00162\u0006\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\u0002\u0010\u0019J\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0017\u001a\u00020\u0018J\u001c\u0010\u001b\u001a\u0010\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u001e\u0018\u00010\u001c2\u0006\u0010\u001f\u001a\u00020 J\u0018\u0010!\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\"\u001a\u00020#J\u0010\u0010$\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001f\u001a\u00020 J\u001e\u0010%\u001a\u00020\u00052\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+\u00a8\u0006."}, d2={"Lcom/intellij/jpa/jpb/model/util/OrmUtil;", "", "<init>", "()V", "selectInStructure", "", "psiElement", "Lcom/intellij/psi/PsiElement;", "getActiveOrmContentPanel", "Lcom/intellij/jpa/jpb/model/orm/toolwindow/structure/OrmStructurePanel;", "project", "Lcom/intellij/openapi/project/Project;", "isOrmFrameworkCompatibleWithDataStore", "", "ormFramework", "Lcom/intellij/jpa/jpb/model/orm/model/OrmFramework;", "dataStore", "Lcom/intellij/jpa/jpb/model/core/model/AbstractRdbmsStore;", "getOrmProviderByEvent", "T", "Lcom/intellij/jpa/jpb/model/orm/ep/OrmProvider;", "ep", "Lcom/intellij/openapi/extensions/ExtensionPointName;", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "(Lcom/intellij/openapi/extensions/ExtensionPointName;Lcom/intellij/openapi/actionSystem/AnActionEvent;)Lcom/intellij/jpa/jpb/model/orm/ep/OrmProvider;", "getOrmFrameworkByEvent", "getOrmUnitAndEntityForPsiFile", "Lkotlin/Pair;", "Lcom/intellij/jpa/jpb/model/orm/model/OrmUnit;", "Lcom/intellij/jpa/jpb/model/orm/model/OrmEntity;", "psiFile", "Lcom/intellij/psi/PsiFile;", "getOrmEntityForPsiClass", "psiClass", "Lcom/intellij/psi/PsiClass;", "getOrmUnitForPsiFile", "createEnumClassIfNeeded", "attribute", "Lcom/intellij/jpa/jpb/model/model/EntityAttributeModel;", "targetDirectory", "Lcom/intellij/psi/PsiDirectory;", "language", "Lcom/intellij/jpa/jpb/model/model/SourceLanguage;", "OrmPojoEntity", "OrmPojoEntityAttribute", "intellij.javaee.jpa.jpb.model"})
@SourceDebugExtension(value={"SMAP\nOrmUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OrmUtil.kt\ncom/intellij/jpa/jpb/model/util/OrmUtil\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,110:1\n1755#2,2:111\n1757#2:114\n295#2,2:115\n295#2,2:117\n1#3:113\n*S KotlinDebug\n*F\n+ 1 OrmUtil.kt\ncom/intellij/jpa/jpb/model/util/OrmUtil\n*L\n45#1:111,2\n45#1:114\n53#1:115,2\n68#1:117,2\n*E\n"})
public final class OrmUtil {
    @NotNull
    public static final OrmUtil INSTANCE = new OrmUtil();

    private OrmUtil() {
    }

    public final void selectInStructure(@NotNull PsiElement psiElement) {
        block0: {
            ToolWindow toolWindow;
            Intrinsics.checkNotNullParameter((Object)psiElement, (String)"psiElement");
            Project project = psiElement.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            Project project2 = project;
            ToolWindow toolWindow2 = toolWindow = ToolWindowManager.Companion.getInstance(project2).getToolWindow("ORM");
            if (toolWindow2 == null) break block0;
            toolWindow2.activate(() -> OrmUtil.selectInStructure$lambda$0(project2, psiElement));
        }
    }

    @Nullable
    public final OrmStructurePanel getActiveOrmContentPanel(@NotNull Project project) {
        Content content;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ToolWindow window = ToolWindowManager.Companion.getInstance(project).getToolWindow("ORM");
        ToolWindow toolWindow = window;
        Content content2 = content = toolWindow != null && (toolWindow = toolWindow.getContentManager()) != null ? toolWindow.getContent(0) : null;
        JComponent jComponent = content2 != null ? content2.getComponent() : null;
        return jComponent instanceof OrmStructurePanel ? (OrmStructurePanel)((Object)jComponent) : null;
    }

    public final boolean isOrmFrameworkCompatibleWithDataStore(@NotNull OrmFramework ormFramework, @NotNull AbstractRdbmsStore dataStore) {
        boolean bl;
        block5: {
            Intrinsics.checkNotNullParameter((Object)ormFramework, (String)"ormFramework");
            Intrinsics.checkNotNullParameter((Object)dataStore, (String)"dataStore");
            Iterable $this$any$iv = ormFramework.getSupportedDbTypes();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    boolean bl2;
                    DbType dbType = (DbType)element$iv;
                    boolean bl3 = false;
                    if (dbType.getUrlPrefix() != null) {
                        String it;
                        boolean bl4 = false;
                        String string = dataStore.getDbProperties().getUrl();
                        bl2 = Intrinsics.areEqual((Object)(string != null ? Boolean.valueOf(StringsKt.startsWith$default((String)string, (String)it, (boolean)false, (int)2, null)) : null), (Object)true);
                    } else {
                        bl2 = false;
                    }
                    if (!bl2) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        return bl;
    }

    @Nullable
    public final <T extends OrmProvider> T getOrmProviderByEvent(@NotNull ExtensionPointName<T> ep, @NotNull AnActionEvent event) {
        Object v1;
        block2: {
            Intrinsics.checkNotNullParameter(ep, (String)"ep");
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Project project = event.getProject();
            if (project == null) {
                return null;
            }
            Project project2 = project;
            OrmFramework ormFramework = this.getOrmFrameworkByEvent(event);
            Iterable $this$firstOrNull$iv = ep.getExtensionList();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                OrmProvider it = (OrmProvider)element$iv;
                boolean bl = false;
                if (!(Intrinsics.areEqual((Object)it.getFramework(), (Object)ormFramework) && it.isFrameworkPresent(project2))) continue;
                v1 = element$iv;
                break block2;
            }
            v1 = null;
        }
        return (T)((OrmProvider)v1);
    }

    @Nullable
    public final OrmFramework getOrmFrameworkByEvent(@NotNull AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        return EventDataProviderEP.Companion.getAGGREGATOR().getOrmFramework(event);
    }

    @Nullable
    public final Pair<OrmUnit, OrmEntity> getOrmUnitAndEntityForPsiFile(@NotNull PsiFile psiFile) {
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        VirtualFile virtualFile = psiFile.getVirtualFile();
        return (Pair)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.flatMapIterable((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)OrmUnitsProvider.Companion.getEP_NAME().getExtensionList()), arg_0 -> OrmUtil.getOrmUnitAndEntityForPsiFile$lambda$4(psiFile, arg_0)), arg_0 -> OrmUtil.getOrmUnitAndEntityForPsiFile$lambda$6(psiFile, arg_0)), arg_0 -> OrmUtil.getOrmUnitAndEntityForPsiFile$lambda$8(virtualFile, arg_0)));
    }

    @Nullable
    public final OrmEntity getOrmEntityForPsiClass(@NotNull OrmFramework ormFramework, @NotNull PsiClass psiClass) {
        Intrinsics.checkNotNullParameter((Object)ormFramework, (String)"ormFramework");
        Intrinsics.checkNotNullParameter((Object)psiClass, (String)"psiClass");
        return OrmSearcher.Companion.getForFramework(ormFramework).findEntityForClass(psiClass);
    }

    @Nullable
    public final OrmUnit getOrmUnitForPsiFile(@NotNull PsiFile psiFile) {
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        Pair<OrmUnit, OrmEntity> pair = this.getOrmUnitAndEntityForPsiFile(psiFile);
        return pair != null ? (OrmUnit)pair.getFirst() : null;
    }

    public final void createEnumClassIfNeeded(@NotNull EntityAttributeModel attribute, @NotNull PsiDirectory targetDirectory, @NotNull SourceLanguage language) {
        block4: {
            PsiClass existingClass;
            Intrinsics.checkNotNullParameter((Object)attribute, (String)"attribute");
            Intrinsics.checkNotNullParameter((Object)targetDirectory, (String)"targetDirectory");
            Intrinsics.checkNotNullParameter((Object)((Object)language), (String)"language");
            if (attribute.getMappingType() != EntityAttribute.MappingType.ENUM || !(attribute.getType() instanceof EnumType)) break block4;
            Project project = targetDirectory.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            Project project2 = project;
            String string = attribute.getType().getFqn();
            if (string != null) {
                String it = string;
                boolean bl = false;
                v2 = Fqn.Companion.ofFullName(it).toPsiClass(project2);
            } else {
                v2 = existingClass = null;
            }
            if (existingClass == null) {
                Language language2 = language.getLanguage();
                Intrinsics.checkNotNullExpressionValue((Object)language2, (String)"getLanguage(...)");
                TemplateHelper templateHelper = (TemplateHelper)TemplateHelper.Companion.getInstance(project2, language2);
                if (templateHelper != null) {
                    Datatype datatype = attribute.getType();
                    Intrinsics.checkNotNull((Object)datatype, (String)"null cannot be cast to non-null type com.intellij.jpa.jpb.model.model.EnumType");
                    templateHelper.createEnumClass(targetDirectory, (EnumType)datatype, language);
                }
            }
        }
    }

    private static final void selectInStructure$lambda$0(Project $project, PsiElement $psiElement) {
        block0: {
            OrmStructurePanel ormStructurePanel = INSTANCE.getActiveOrmContentPanel($project);
            if (ormStructurePanel == null) break block0;
            ormStructurePanel.selectInStructure($psiElement);
        }
    }

    private static final boolean getOrmUnitAndEntityForPsiFile$lambda$4(PsiFile $psiFile, OrmUnitsProvider provider2) {
        Intrinsics.checkNotNullParameter((Object)provider2, (String)"provider");
        Project project = $psiFile.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        return provider2.isFrameworkPresent(project);
    }

    private static final Iterable getOrmUnitAndEntityForPsiFile$lambda$6(PsiFile $psiFile, OrmUnitsProvider provider2) {
        Object object;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)provider2, (String)"provider");
                object = PsiUtilsKt.module($psiFile);
                if (object == null) break block2;
                Module it = object;
                boolean bl = false;
                List<OrmUnit> list = provider2.getUnits(it);
                object = list;
                if (list != null) break block3;
            }
            Project project = $psiFile.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            object = provider2.getUnits(project);
        }
        return (Iterable)object;
    }

    private static final Pair getOrmUnitAndEntityForPsiFile$lambda$8(VirtualFile $virtualFile, OrmUnit unit) {
        Object v1;
        block2: {
            Intrinsics.checkNotNullParameter((Object)unit, (String)"unit");
            Iterable $this$firstOrNull$iv = unit.getEntities();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                OrmEntity it = (OrmEntity)element$iv;
                boolean bl = false;
                PsiClass psiClass = it.getClassPsiPointer();
                if (!Intrinsics.areEqual(psiClass != null && (psiClass = (PsiClass)psiClass.getElement()) != null && (psiClass = psiClass.getContainingFile()) != null ? psiClass.getVirtualFile() : null, (Object)$virtualFile)) continue;
                v1 = element$iv;
                break block2;
            }
            v1 = null;
        }
        OrmEntity ormEntity = v1;
        if (ormEntity == null) {
            return null;
        }
        OrmEntity entity = ormEntity;
        return TuplesKt.to((Object)unit, (Object)entity);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00030\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0017"}, d2={"Lcom/intellij/jpa/jpb/model/util/OrmUtil$OrmPojoEntity;", "Lcom/intellij/jpa/jpb/model/orm/model/OrmEntity;", "psiClass", "Lcom/intellij/psi/PsiClass;", "<init>", "(Lcom/intellij/psi/PsiClass;)V", "ormFramework", "Lcom/intellij/jpa/jpb/model/orm/model/OrmFramework;", "getOrmFramework", "()Lcom/intellij/jpa/jpb/model/orm/model/OrmFramework;", "name", "", "getName", "()Ljava/lang/String;", "classPsiPointer", "Lcom/intellij/psi/SmartPsiElementPointer;", "getClassPsiPointer", "()Lcom/intellij/psi/SmartPsiElementPointer;", "attributes", "", "Lcom/intellij/jpa/jpb/model/orm/model/OrmEntityAttribute;", "getAttributes", "()Ljava/util/List;", "intellij.javaee.jpa.jpb.model"})
    @SourceDebugExtension(value={"SMAP\nOrmUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OrmUtil.kt\ncom/intellij/jpa/jpb/model/util/OrmUtil$OrmPojoEntity\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,110:1\n11165#2:111\n11500#2,3:112\n*S KotlinDebug\n*F\n+ 1 OrmUtil.kt\ncom/intellij/jpa/jpb/model/util/OrmUtil$OrmPojoEntity\n*L\n98#1:111\n98#1:112,3\n*E\n"})
    public static final class OrmPojoEntity
    implements OrmEntity {
        @NotNull
        private final OrmFramework ormFramework;
        @NotNull
        private final String name;
        @NotNull
        private final SmartPsiElementPointer<PsiClass> classPsiPointer;

        public OrmPojoEntity(@NotNull PsiClass psiClass) {
            Intrinsics.checkNotNullParameter((Object)psiClass, (String)"psiClass");
            this.ormFramework = JpaOrmFramework.INSTANCE;
            String string = psiClass.getName();
            Intrinsics.checkNotNull((Object)string);
            this.name = string;
            SmartPsiElementPointer smartPsiElementPointer = SmartPointerManager.createPointer((PsiElement)((PsiElement)psiClass));
            Intrinsics.checkNotNullExpressionValue((Object)smartPsiElementPointer, (String)"createPointer(...)");
            this.classPsiPointer = smartPsiElementPointer;
        }

        @Override
        @NotNull
        public OrmFramework getOrmFramework() {
            return this.ormFramework;
        }

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        @Override
        @NotNull
        public SmartPsiElementPointer<PsiClass> getClassPsiPointer() {
            return this.classPsiPointer;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public List<OrmEntityAttribute> getAttributes() {
            List list;
            PsiField[] psiFieldArray = (PsiField[])this.getClassPsiPointer().getElement();
            if (psiFieldArray != null && (psiFieldArray = psiFieldArray.getFields()) != null) {
                void $this$mapTo$iv$iv;
                PsiField[] $this$map$iv = psiFieldArray;
                boolean $i$f$map = false;
                PsiField[] psiFieldArray2 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList($this$map$iv.length);
                boolean $i$f$mapTo = false;
                int n = ((void)$this$mapTo$iv$iv).length;
                for (int i = 0; i < n; ++i) {
                    void it;
                    void item$iv$iv;
                    void var9_9 = item$iv$iv = $this$mapTo$iv$iv[i];
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)it);
                    collection.add(new OrmPojoEntityAttribute((PsiField)it));
                }
                list = (List)destination$iv$iv;
            } else {
                list = CollectionsKt.emptyList();
            }
            return list;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u0013X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0014R\u0016\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006\u001e"}, d2={"Lcom/intellij/jpa/jpb/model/util/OrmUtil$OrmPojoEntityAttribute;", "Lcom/intellij/jpa/jpb/model/orm/model/OrmEntityAttribute;", "psiField", "Lcom/intellij/psi/PsiField;", "<init>", "(Lcom/intellij/psi/PsiField;)V", "ormFramework", "Lcom/intellij/jpa/jpb/model/orm/model/OrmFramework;", "getOrmFramework", "()Lcom/intellij/jpa/jpb/model/orm/model/OrmFramework;", "name", "", "getName", "()Ljava/lang/String;", "typeFqn", "Lcom/intellij/jpa/jpb/model/core/util/Fqn;", "getTypeFqn", "()Lcom/intellij/jpa/jpb/model/core/util/Fqn;", "isId", "", "()Z", "associationCardinality", "Lcom/intellij/jpa/jpb/model/orm/model/OrmEntityAttribute$AssociationCardinality;", "getAssociationCardinality", "()Lcom/intellij/jpa/jpb/model/orm/model/OrmEntityAttribute$AssociationCardinality;", "psiMemberPointer", "Lcom/intellij/psi/SmartPsiElementPointer;", "Lcom/intellij/psi/PsiMember;", "getPsiMemberPointer", "()Lcom/intellij/psi/SmartPsiElementPointer;", "intellij.javaee.jpa.jpb.model"})
    public static final class OrmPojoEntityAttribute
    implements OrmEntityAttribute {
        @NotNull
        private final OrmFramework ormFramework;
        @NotNull
        private final String name;
        @NotNull
        private final Fqn typeFqn;
        private final boolean isId;
        @Nullable
        private final OrmEntityAttribute.AssociationCardinality associationCardinality;
        @NotNull
        private final SmartPsiElementPointer<PsiMember> psiMemberPointer;

        public OrmPojoEntityAttribute(@NotNull PsiField psiField) {
            Intrinsics.checkNotNullParameter((Object)psiField, (String)"psiField");
            this.ormFramework = JpaOrmFramework.INSTANCE;
            String string = psiField.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            this.name = string;
            PsiType psiType = psiField.getType();
            Intrinsics.checkNotNullExpressionValue((Object)psiType, (String)"getType(...)");
            this.typeFqn = Fqn.Companion.ofType$default(Fqn.Companion, psiType, null, null, 6, null);
            SmartPsiElementPointer smartPsiElementPointer = SmartPointerManager.createPointer((PsiElement)((PsiElement)psiField));
            Intrinsics.checkNotNullExpressionValue((Object)smartPsiElementPointer, (String)"createPointer(...)");
            this.psiMemberPointer = smartPsiElementPointer;
        }

        @Override
        @NotNull
        public OrmFramework getOrmFramework() {
            return this.ormFramework;
        }

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        @Override
        @NotNull
        public Fqn getTypeFqn() {
            return this.typeFqn;
        }

        @Override
        public boolean isId() {
            return this.isId;
        }

        @Override
        @Nullable
        public OrmEntityAttribute.AssociationCardinality getAssociationCardinality() {
            return this.associationCardinality;
        }

        @Override
        @NotNull
        public SmartPsiElementPointer<PsiMember> getPsiMemberPointer() {
            return this.psiMemberPointer;
        }
    }
}

