/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.jpb.model.util;

import com.intellij.lang.java.beans.PropertyKind;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.PropertyUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class StudioPropertyUtil {
    public static List<PsiMethod> getGetters(@NotNull PsiClass psiClass, String propertyName) {
        if (psiClass == null) {
            StudioPropertyUtil.$$$reportNull$$$0(0);
        }
        PsiManager psiManager = PsiManager.getInstance((Project)psiClass.getProject());
        List<PsiMethod> getters = PropertyUtil.getGetters((PsiClass)psiClass, (String)propertyName);
        if (getters.isEmpty()) {
            getters = StudioPropertyUtil.getNonJavaBeanGetters(psiClass, propertyName);
        }
        return (List)((StreamEx)StreamEx.of((Collection)getters).filter(getterMethod -> psiManager.areElementsEquivalent((PsiElement)psiClass, (PsiElement)getterMethod.getContainingClass()))).collect(Collectors.toList());
    }

    public static List<PsiMethod> getSetters(@NotNull PsiClass psiClass, String propertyName) {
        if (psiClass == null) {
            StudioPropertyUtil.$$$reportNull$$$0(1);
        }
        PsiManager psiManager = PsiManager.getInstance((Project)psiClass.getProject());
        if (propertyName == null) {
            return Collections.emptyList();
        }
        List<PsiMethod> setters = PropertyUtil.getSetters((PsiClass)psiClass, (String)propertyName);
        if (setters.isEmpty()) {
            setters = StudioPropertyUtil.getNonJavaBeanSetters(psiClass, propertyName);
        }
        return (List)((StreamEx)StreamEx.of((Collection)setters).filter(setterMethod -> psiManager.areElementsEquivalent((PsiElement)psiClass, (PsiElement)setterMethod.getContainingClass()))).collect(Collectors.toList());
    }

    public static void removeGetterMethods(PsiClass psiClass, String propertyName) {
        List<PsiMethod> getterMethods = StudioPropertyUtil.getGetters(psiClass, propertyName);
        for (PsiMethod getterMethod : getterMethods) {
            if (!getterMethod.isWritable()) continue;
            getterMethod.delete();
        }
    }

    public static void removeSetterMethods(PsiClass psiClass, String propertyName) {
        List<PsiMethod> setterMethods = StudioPropertyUtil.getSetters(psiClass, propertyName);
        for (PsiMethod setter : setterMethods) {
            if (!setter.isWritable()) continue;
            setter.delete();
        }
    }

    @NotNull
    private static List<PsiMethod> getNonJavaBeanGetters(@NotNull PsiClass psiClass, String propertyName) {
        if (psiClass == null) {
            StudioPropertyUtil.$$$reportNull$$$0(2);
        }
        String[] names = StudioPropertyUtil.suggestNonJavaBeanGetterNames(propertyName);
        ArrayList<PsiMethod> list = new ArrayList<PsiMethod>();
        for (String name : names) {
            PsiMethod[] psiMethods;
            for (PsiMethod method : psiMethods = psiClass.findMethodsByName(name, true)) {
                if (StudioPropertyUtil.filterMethods(method) || !PropertyUtil.isSimplePropertyGetter((PsiMethod)method)) continue;
                list.add(method);
            }
        }
        ArrayList<PsiMethod> arrayList = list;
        if (arrayList == null) {
            StudioPropertyUtil.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    @NotNull
    private static List<PsiMethod> getNonJavaBeanSetters(@NotNull PsiClass psiClass, String propertyName) {
        if (psiClass == null) {
            StudioPropertyUtil.$$$reportNull$$$0(4);
        }
        String setterName = StudioPropertyUtil.suggestNonJavaBeanSetterName(propertyName, PropertyKind.SETTER.prefix);
        PsiMethod[] psiMethods = psiClass.findMethodsByName(setterName, true);
        ArrayList<PsiMethod> list = new ArrayList<PsiMethod>(psiMethods.length);
        for (PsiMethod method : psiMethods) {
            if (StudioPropertyUtil.filterMethods(method) || !PropertyUtil.isSimplePropertySetter((PsiMethod)method)) continue;
            list.add(method);
        }
        ArrayList<PsiMethod> arrayList = list;
        if (arrayList == null) {
            StudioPropertyUtil.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    @NonNls
    private static String[] suggestNonJavaBeanGetterNames(@NotNull String propertyName) {
        if (propertyName == null) {
            StudioPropertyUtil.$$$reportNull$$$0(6);
        }
        String str = StringUtil.capitalize((String)StringUtil.sanitizeJavaIdentifier((String)propertyName));
        return new String[]{PropertyKind.BOOLEAN_GETTER.prefix + str, PropertyKind.GETTER.prefix + str};
    }

    public static String suggestNonJavaBeanSetterName(@NonNls @NotNull String propertyName, String setterPrefix) {
        if (propertyName == null) {
            StudioPropertyUtil.$$$reportNull$$$0(7);
        }
        String sanitizeJavaIdentifier = StringUtil.sanitizeJavaIdentifier((String)propertyName);
        if (StringUtil.isEmpty((String)setterPrefix)) {
            return sanitizeJavaIdentifier;
        }
        @NonNls StringBuilder name = new StringBuilder(StringUtil.capitalize((String)sanitizeJavaIdentifier));
        name.insert(0, setterPrefix);
        return name.toString();
    }

    private static boolean filterMethods(PsiMethod method) {
        if (method.hasModifierProperty("static") || !method.hasModifierProperty("public")) {
            return true;
        }
        PsiClass psiClass = method.getContainingClass();
        if (psiClass == null) {
            return false;
        }
        String className = psiClass.getQualifiedName();
        return "java.lang.Object".equals(className);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jpa/jpb/model/util/StudioPropertyUtil";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jpa/jpb/model/util/StudioPropertyUtil";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getNonJavaBeanGetters";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getNonJavaBeanSetters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getGetters";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getSetters";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getNonJavaBeanGetters";
                break;
            }
            case 3: 
            case 5: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getNonJavaBeanSetters";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "suggestNonJavaBeanGetterNames";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "suggestNonJavaBeanSetterName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 5 -> new IllegalStateException(string);
        };
    }
}

