/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.jpb.model.util.annotation;

import com.intellij.jpa.jpb.model.model.ForeignKeyModel;
import com.intellij.jpa.jpb.model.model.Index;
import com.intellij.jpa.jpb.model.util.annotation.Annotation;
import com.intellij.jpa.jpb.model.util.annotation.JoinColumn;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class JoinTable
implements Annotation {
    public static final JoinTable NULL_ANNOTATION = new JoinTable("NULL");
    private String name;
    private final List<JoinColumn> joinColumns = new ArrayList<JoinColumn>();
    private final List<JoinColumn> inverseJoinColumns = new ArrayList<JoinColumn>();
    private final List<Index> uniqueConstraints = new ArrayList<Index>();
    private ForeignKeyModel foreignKey = null;
    private ForeignKeyModel inverseForeignKey = null;

    public JoinTable() {
        this.joinColumns.add(new JoinColumn());
        this.inverseJoinColumns.add(new JoinColumn());
    }

    public JoinTable(String name) {
        this.name = name;
    }

    public JoinTable(String name, List<JoinColumn> joinColumns, List<JoinColumn> inverseJoinColumns) {
        this.name = name;
        this.setJoinColumns(joinColumns);
        this.setInverseJoinColumns(inverseJoinColumns);
    }

    public JoinTable copy() {
        if (this == NULL_ANNOTATION) {
            return this;
        }
        return new JoinTable(this.name, this.copyJoinColumns(this.joinColumns), this.copyJoinColumns(this.inverseJoinColumns));
    }

    private List<JoinColumn> copyJoinColumns(List<JoinColumn> joinColumns) {
        ArrayList<JoinColumn> result = new ArrayList<JoinColumn>();
        for (JoinColumn joinColumn : joinColumns) {
            result.add(joinColumn.copy());
        }
        return result;
    }

    public boolean isEmpty() {
        return this == NULL_ANNOTATION || StringUtils.isBlank((CharSequence)this.getName());
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (!Objects.equals(this.name, name)) {
            this.checkAvailableEditing();
            this.name = name;
        }
    }

    public static Map<String, String> getMapJoinColumns(List<JoinColumn> joinColumns) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        for (JoinColumn joinColumn : joinColumns) {
            result.put(joinColumn.getName(), joinColumn.getReferencedColumnName());
        }
        return result;
    }

    public Map<String, String> getMapJoinColumns() {
        return JoinTable.getMapJoinColumns(this.joinColumns);
    }

    public Map<String, String> getMapInverseJoinColumns() {
        return JoinTable.getMapJoinColumns(this.inverseJoinColumns);
    }

    public List<JoinColumn> getJoinColumns() {
        return this.joinColumns;
    }

    public void setJoinColumns(List<JoinColumn> joinColumns) {
        if (!Objects.equals(this.joinColumns, joinColumns)) {
            this.checkAvailableEditing();
            this.joinColumns.clear();
            this.joinColumns.addAll(joinColumns);
        }
    }

    @NotNull
    public JoinColumn getFirstJoinColumn() {
        if (this.joinColumns.isEmpty()) {
            JoinColumn joinColumn = JoinColumn.NULL_ANNOTATION;
            if (joinColumn == null) {
                JoinTable.$$$reportNull$$$0(0);
            }
            return joinColumn;
        }
        JoinColumn joinColumn = this.joinColumns.get(0);
        if (joinColumn == null) {
            JoinTable.$$$reportNull$$$0(1);
        }
        return joinColumn;
    }

    @NotNull
    public JoinColumn getFirstInverseJoinColumn() {
        if (this.inverseJoinColumns.isEmpty()) {
            JoinColumn joinColumn = JoinColumn.NULL_ANNOTATION;
            if (joinColumn == null) {
                JoinTable.$$$reportNull$$$0(2);
            }
            return joinColumn;
        }
        JoinColumn joinColumn = this.inverseJoinColumns.get(0);
        if (joinColumn == null) {
            JoinTable.$$$reportNull$$$0(3);
        }
        return joinColumn;
    }

    public List<Index> getUniqueConstraints() {
        return this.uniqueConstraints;
    }

    public void setUniqueConstraints(List<Index> uniqueConstraints) {
        if (!Objects.equals(this.uniqueConstraints, uniqueConstraints)) {
            this.checkAvailableEditing();
            this.uniqueConstraints.clear();
            this.uniqueConstraints.addAll(uniqueConstraints);
        }
    }

    public List<JoinColumn> getInverseJoinColumns() {
        return this.inverseJoinColumns;
    }

    public void setInverseJoinColumns(List<JoinColumn> inverseJoinColumns) {
        if (!Objects.equals(this.inverseJoinColumns, inverseJoinColumns)) {
            this.checkAvailableEditing();
            this.inverseJoinColumns.clear();
            this.inverseJoinColumns.addAll(inverseJoinColumns);
        }
    }

    public ForeignKeyModel getForeignKey() {
        return this.foreignKey;
    }

    public void setForeignKey(ForeignKeyModel foreignKey) {
        this.foreignKey = foreignKey;
    }

    public ForeignKeyModel getInverseForeignKey() {
        return this.inverseForeignKey;
    }

    public void setInverseForeignKey(ForeignKeyModel inverseForeignKey) {
        this.inverseForeignKey = inverseForeignKey;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JoinTable joinTable = (JoinTable)o;
        return Objects.equals(this.inverseJoinColumns, joinTable.inverseJoinColumns) && Objects.equals(this.joinColumns, joinTable.joinColumns) && Objects.equals(this.name, joinTable.name) && Objects.equals(this.foreignKey, joinTable.foreignKey) && Objects.equals(this.inverseForeignKey, joinTable.inverseForeignKey);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.joinColumns, this.inverseJoinColumns, this.foreignKey, this.inverseForeignKey);
    }

    public String toString() {
        return this.getClassName();
    }

    @Override
    public String getClassName() {
        return "JoinTable";
    }

    private void checkAvailableEditing() {
        if (this == NULL_ANNOTATION) {
            throw new UnsupportedOperationException("Unavailable edit JoinTable#NULL_ANNOTATION");
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/jpa/jpb/model/util/annotation/JoinTable";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFirstJoinColumn";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFirstInverseJoinColumn";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

