/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.binding;

import com.jgoodies.binding.beans.BeanAdapter;
import com.jgoodies.binding.beans.BeanUtils;
import com.jgoodies.binding.beans.Model;
import com.jgoodies.binding.internal.IPresentationModel;
import com.jgoodies.binding.value.AbstractValueModel;
import com.jgoodies.binding.value.AbstractWrappedValueModel;
import com.jgoodies.binding.value.BufferedValueModel;
import com.jgoodies.binding.value.DefaultComponentValueModel;
import com.jgoodies.binding.value.Trigger;
import com.jgoodies.binding.value.ValueHolder;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.common.base.Objects;
import com.jgoodies.common.base.Preconditions;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.util.HashMap;
import java.util.Map;

public class PresentationModel<B>
extends Model
implements IPresentationModel<B> {
    public static final String PROPERTY_BEFORE_BEAN = "beforeBean";
    public static final String PROPERTY_BEAN = "bean";
    public static final String PROPERTY_AFTER_BEAN = "afterBean";
    public static final String PROPERTY_TRIGGERCHANNEL = "triggerChannel";
    public static final String PROPERTY_BUFFERING = "buffering";
    public static final String PROPERTY_CHANGED = "changed";
    private final BeanAdapter<B> beanAdapter;
    private ValueModel triggerChannel;
    private final Map<String, WrappedBuffer> wrappedBuffers;
    private final PropertyChangeListener bufferingUpdateHandler;
    private boolean buffering = false;
    private final PropertyChangeListener changedUpdateHandler;
    private boolean changed = false;
    private final Map<String, AbstractWrappedValueModel> componentModels;
    private final Map<String, AbstractWrappedValueModel> bufferedComponentModels;

    public PresentationModel() {
        this((Object)null);
    }

    public PresentationModel(B bean) {
        this(new ValueHolder(bean, true));
    }

    public PresentationModel(B bean, ValueModel triggerChannel) {
        this(new ValueHolder(bean, true), triggerChannel);
    }

    public PresentationModel(ValueModel beanChannel) {
        this(beanChannel, (ValueModel)new Trigger());
    }

    public PresentationModel(ValueModel beanChannel, ValueModel triggerChannel) {
        this.beanAdapter = this.createBeanAdapter(beanChannel);
        this.triggerChannel = triggerChannel;
        this.wrappedBuffers = new HashMap<String, WrappedBuffer>();
        this.componentModels = new HashMap<String, AbstractWrappedValueModel>();
        this.bufferedComponentModels = new HashMap<String, AbstractWrappedValueModel>();
        this.bufferingUpdateHandler = new BufferingStateHandler();
        this.changed = false;
        this.changedUpdateHandler = new UpdateHandler();
        this.beanAdapter.addPropertyChangeListener(new BeanChangeHandler());
        this.observeChanged(this.beanAdapter, PROPERTY_CHANGED);
    }

    protected BeanAdapter<B> createBeanAdapter(ValueModel beanChannel) {
        return new BeanAdapter(beanChannel, true);
    }

    public ValueModel getBeanChannel() {
        return this.beanAdapter.getBeanChannel();
    }

    public B getBean() {
        return (B)this.getBeanChannel().getValue();
    }

    public void setBean(B newBean) {
        this.getBeanChannel().setValue(newBean);
    }

    protected void beforeBeanChange(B oldBean, B newBean) {
        this.firePropertyChange(PROPERTY_BEFORE_BEAN, oldBean, newBean, true);
    }

    protected void afterBeanChange(B oldBean, B newBean) {
        this.setChanged(false);
        this.firePropertyChange(PROPERTY_AFTER_BEAN, oldBean, newBean, true);
    }

    protected void onBeanChanging(B oldBean, B newBean) {
    }

    protected void onBeanChanged(B oldBean, B newBean) {
    }

    public Object getValue(String propertyName) {
        return this.beanAdapter.getValue(propertyName);
    }

    public void setValue(String propertyName, Object newValue) {
        this.beanAdapter.setValue(propertyName, newValue);
    }

    public void setVetoableValue(String propertyName, Object newValue) throws PropertyVetoException {
        this.beanAdapter.setVetoableValue(propertyName, newValue);
    }

    public Object getBufferedValue(String propertyName) {
        return this.getBufferedModel(propertyName).getValue();
    }

    public void setBufferedValue(String propertyName, Object newValue) {
        this.getBufferedModel(propertyName).setValue(newValue);
    }

    public AbstractValueModel getModel(String propertyName) {
        return this.beanAdapter.getValueModel(propertyName);
    }

    public AbstractValueModel getModel(String propertyName, String getterName, String setterName) {
        return this.beanAdapter.getValueModel(propertyName, getterName, setterName);
    }

    @Override
    public AbstractWrappedValueModel getComponentModel(String propertyName) {
        AbstractWrappedValueModel componentModel = this.componentModels.get(propertyName);
        if (componentModel == null) {
            AbstractValueModel model2 = this.getModel(propertyName);
            componentModel = new DefaultComponentValueModel(model2);
            this.componentModels.put(propertyName, componentModel);
        }
        return componentModel;
    }

    public void setComponentEnabled(String propertyName, boolean enabled) {
        this.getComponentModel(propertyName).setEnabled(enabled);
    }

    public void setComponentEditable(String propertyName, boolean editable) {
        this.getComponentModel(propertyName).setEditable(editable);
    }

    public void setComponentVisible(String propertyName, boolean visible) {
        this.getComponentModel(propertyName).setVisible(visible);
    }

    public BufferedValueModel getBufferedModel(String propertyName) {
        return this.getBufferedModel(propertyName, null, null);
    }

    public BufferedValueModel getBufferedModel(String propertyName, String getterName, String setterName) {
        WrappedBuffer wrappedBuffer = this.wrappedBuffers.get(propertyName);
        if (wrappedBuffer == null) {
            wrappedBuffer = new WrappedBuffer(this.buffer(this.getModel(propertyName, getterName, setterName)), getterName, setterName);
            this.wrappedBuffers.put(propertyName, wrappedBuffer);
        } else {
            Preconditions.checkArgument((Objects.equals((Object)getterName, (Object)wrappedBuffer.getterName) && Objects.equals((Object)setterName, (Object)wrappedBuffer.setterName) ? 1 : 0) != 0, (String)"You must not invoke this method twice with different getter and/or setter names.");
        }
        return wrappedBuffer.buffer;
    }

    public AbstractWrappedValueModel getBufferedComponentModel(String propertyName) {
        AbstractWrappedValueModel bufferedComponentModel = this.bufferedComponentModels.get(propertyName);
        if (bufferedComponentModel == null) {
            BufferedValueModel model2 = this.getBufferedModel(propertyName);
            bufferedComponentModel = new DefaultComponentValueModel(model2);
            this.bufferedComponentModels.put(propertyName, bufferedComponentModel);
        }
        return bufferedComponentModel;
    }

    private BufferedValueModel buffer(ValueModel valueModel) {
        BufferedValueModel bufferedModel = new BufferedValueModel(valueModel, this.getTriggerChannel());
        bufferedModel.addPropertyChangeListener(PROPERTY_BUFFERING, this.bufferingUpdateHandler);
        return bufferedModel;
    }

    public ValueModel getTriggerChannel() {
        return this.triggerChannel;
    }

    public void setTriggerChannel(ValueModel newTriggerChannel) {
        Preconditions.checkNotNull((Object)newTriggerChannel, (String)"The trigger channel must not be null.");
        ValueModel oldTriggerChannel = this.getTriggerChannel();
        this.triggerChannel = newTriggerChannel;
        for (WrappedBuffer wrappedBuffer : this.wrappedBuffers.values()) {
            wrappedBuffer.buffer.setTriggerChannel(this.triggerChannel);
        }
        this.firePropertyChange(PROPERTY_TRIGGERCHANNEL, oldTriggerChannel, newTriggerChannel);
    }

    public void triggerCommit() {
        if (Boolean.TRUE.equals(this.getTriggerChannel().getValue())) {
            this.getTriggerChannel().setValue(null);
        }
        this.getTriggerChannel().setValue(Boolean.TRUE);
    }

    public void triggerFlush() {
        if (Boolean.FALSE.equals(this.getTriggerChannel().getValue())) {
            this.getTriggerChannel().setValue(null);
        }
        this.getTriggerChannel().setValue(Boolean.FALSE);
    }

    public boolean isBuffering() {
        return this.buffering;
    }

    private void setBuffering(boolean newValue) {
        boolean oldValue = this.isBuffering();
        this.buffering = newValue;
        this.firePropertyChange(PROPERTY_BUFFERING, oldValue, newValue);
    }

    private void updateBufferingState(boolean latestBufferingStateChange) {
        if (this.buffering == latestBufferingStateChange) {
            return;
        }
        boolean nowBuffering = false;
        for (WrappedBuffer wrappedBuffer : this.wrappedBuffers.values()) {
            BufferedValueModel model2 = wrappedBuffer.buffer;
            boolean bl = nowBuffering = nowBuffering || model2.isBuffering();
            if (this.buffering || !nowBuffering) continue;
            this.setBuffering(true);
            return;
        }
        this.setBuffering(nowBuffering);
    }

    public boolean isChanged() {
        return this.changed;
    }

    public void resetChanged() {
        this.setChanged(false);
        this.beanAdapter.resetChanged();
    }

    protected void setChanged(boolean newValue) {
        boolean oldValue = this.isChanged();
        this.changed = newValue;
        this.firePropertyChange(PROPERTY_CHANGED, oldValue, newValue);
    }

    public void observeChanged(Object bean, String propertyName) {
        Preconditions.checkNotNull((Object)bean, (String)"The bean must not be null.");
        Preconditions.checkNotNull((Object)propertyName, (String)"The property name must not be null.");
        BeanUtils.addPropertyChangeListener(bean, propertyName, this.changedUpdateHandler);
    }

    public void observeChanged(ValueModel valueModel) {
        Preconditions.checkNotNull((Object)valueModel, (String)"The ValueModel must not be null.");
        valueModel.addValueChangeListener(this.changedUpdateHandler);
    }

    public void retractInterestFor(Object bean, String propertyName) {
        Preconditions.checkNotNull((Object)bean, (String)"The bean must not be null.");
        Preconditions.checkNotNull((Object)propertyName, (String)"The property name must not be null.");
        BeanUtils.removePropertyChangeListener(bean, propertyName, this.changedUpdateHandler);
    }

    public void retractInterestFor(ValueModel valueModel) {
        Preconditions.checkNotNull((Object)valueModel, (String)"The ValueModel must not be null.");
        valueModel.removeValueChangeListener(this.changedUpdateHandler);
    }

    public synchronized void addBeanPropertyChangeListener(PropertyChangeListener listener) {
        this.beanAdapter.addBeanPropertyChangeListener(listener);
    }

    public synchronized void removeBeanPropertyChangeListener(PropertyChangeListener listener) {
        this.beanAdapter.removeBeanPropertyChangeListener(listener);
    }

    public synchronized void addBeanPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.beanAdapter.addBeanPropertyChangeListener(propertyName, listener);
    }

    public synchronized void removeBeanPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.beanAdapter.removeBeanPropertyChangeListener(propertyName, listener);
    }

    public synchronized PropertyChangeListener[] getBeanPropertyChangeListeners() {
        return this.beanAdapter.getBeanPropertyChangeListeners();
    }

    public synchronized PropertyChangeListener[] getBeanPropertyChangeListeners(String propertyName) {
        return this.beanAdapter.getBeanPropertyChangeListeners(propertyName);
    }

    public void release() {
        this.beanAdapter.release();
    }

    private final class UpdateHandler
    implements PropertyChangeListener {
        private UpdateHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String propertyName = evt.getPropertyName();
            if (!PresentationModel.PROPERTY_CHANGED.equals(propertyName) || ((Boolean)evt.getNewValue()).booleanValue()) {
                PresentationModel.this.setChanged(true);
            }
        }
    }

    private final class BufferingStateHandler
    implements PropertyChangeListener {
        private BufferingStateHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            PresentationModel.this.updateBufferingState((Boolean)evt.getNewValue());
        }
    }

    private final class BeanChangeHandler
    implements PropertyChangeListener {
        private BeanChangeHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            Object oldBean = evt.getOldValue();
            Object newBean = evt.getNewValue();
            String propertyName = evt.getPropertyName();
            if (PresentationModel.PROPERTY_BEFORE_BEAN.equals(propertyName)) {
                PresentationModel.this.onBeanChanging(oldBean, newBean);
                PresentationModel.this.beforeBeanChange(oldBean, newBean);
            } else if (PresentationModel.PROPERTY_BEAN.equals(propertyName)) {
                PresentationModel.this.firePropertyChange(PresentationModel.PROPERTY_BEAN, oldBean, newBean, true);
            } else if (PresentationModel.PROPERTY_AFTER_BEAN.equals(propertyName)) {
                PresentationModel.this.afterBeanChange(oldBean, newBean);
                PresentationModel.this.onBeanChanged(oldBean, newBean);
            }
        }
    }

    private static final class WrappedBuffer {
        final BufferedValueModel buffer;
        final String getterName;
        final String setterName;

        WrappedBuffer(BufferedValueModel buffer, String getterName, String setterName) {
            this.buffer = buffer;
            this.getterName = getterName;
            this.setterName = setterName;
        }
    }
}

