/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.javaFX.css.refs;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPolyVariantReferenceBase;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.XmlRecursiveElementVisitor;
import com.intellij.psi.css.CssFileType;
import com.intellij.psi.css.CssIdSelector;
import com.intellij.psi.css.impl.stubs.index.CssIndexUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

class JavaFxCssIdSelectorReference
extends PsiPolyVariantReferenceBase<XmlAttributeValue> {
    JavaFxCssIdSelectorReference(@NotNull XmlAttributeValue value) {
        if (value == null) {
            JavaFxCssIdSelectorReference.$$$reportNull$$$0(0);
        }
        super((PsiElement)value, true);
    }

    public ResolveResult @NotNull [] multiResolve(boolean incompleteCode) {
        String fxId = ((XmlAttributeValue)this.myElement).getValue();
        if (StringUtil.isEmpty((String)fxId)) {
            if (ResolveResult.EMPTY_ARRAY == null) {
                JavaFxCssIdSelectorReference.$$$reportNull$$$0(1);
            }
            return ResolveResult.EMPTY_ARRAY;
        }
        Set<PsiFile> cssFiles = JavaFxCssIdSelectorReference.getImportedCssFiles(this.myElement);
        if (cssFiles.isEmpty()) {
            if (ResolveResult.EMPTY_ARRAY == null) {
                JavaFxCssIdSelectorReference.$$$reportNull$$$0(2);
            }
            return ResolveResult.EMPTY_ARRAY;
        }
        List virtualFiles = cssFiles.stream().map(PsiUtilCore::getVirtualFile).filter(Objects::nonNull).collect(Collectors.toList());
        Project project = ((XmlAttributeValue)this.myElement).getProject();
        GlobalSearchScope cssFilesScope = GlobalSearchScope.filesScope((Project)project, virtualFiles);
        ArrayList resolveResults = new ArrayList();
        CssIndexUtil.processIds((String)fxId, (Project)project, (GlobalSearchScope)cssFilesScope, (name, suffix) -> {
            if (suffix instanceof CssIdSelector) {
                resolveResults.add(new PsiElementResolveResult((PsiElement)suffix));
            }
            return true;
        });
        ResolveResult[] resolveResultArray = resolveResults.toArray(ResolveResult.EMPTY_ARRAY);
        if (resolveResultArray == null) {
            JavaFxCssIdSelectorReference.$$$reportNull$$$0(3);
        }
        return resolveResultArray;
    }

    private static Set<PsiFile> getImportedCssFiles(PsiElement element) {
        XmlTag start = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)element, XmlTag.class, (boolean)false);
        final HashSet<PsiFile> result = new HashSet<PsiFile>();
        for (XmlTag tag = start; tag != null; tag = tag.getParentTag()) {
            XmlTag[] subTags;
            XmlAttribute attribute = tag.getAttribute("stylesheets");
            if (attribute != null) {
                JavaFxCssIdSelectorReference.addImportedCssFiles(attribute, result);
            }
            for (XmlTag subTag : subTags = tag.findSubTags("stylesheets")) {
                subTag.accept((PsiElementVisitor)new XmlRecursiveElementVisitor(){

                    public void visitXmlAttribute(@NotNull XmlAttribute attribute) {
                        if (attribute == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        JavaFxCssIdSelectorReference.addImportedCssFiles(attribute, result);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attribute", "org/jetbrains/plugins/javaFX/css/refs/JavaFxCssIdSelectorReference$1", "visitXmlAttribute"));
                    }
                });
            }
        }
        return result;
    }

    private static void addImportedCssFiles(XmlAttribute attribute, Set<PsiFile> result) {
        XmlAttributeValue valueElement = attribute.getValueElement();
        if (valueElement != null) {
            PsiReference[] references;
            for (PsiReference reference : references = valueElement.getReferences()) {
                PsiFile file;
                PsiElement resolved = reference.resolve();
                if (!(resolved instanceof PsiFile) || (file = (PsiFile)resolved).getFileType() != CssFileType.INSTANCE) continue;
                result.add(file);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/javaFX/css/refs/JavaFxCssIdSelectorReference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/javaFX/css/refs/JavaFxCssIdSelectorReference";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolve";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3 -> new IllegalStateException(string);
        };
    }
}

