/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.css;

import com.intellij.FilePropertyPusherBase;
import com.intellij.ide.projectView.impl.ProjectRootsUtil;
import com.intellij.lang.css.CssDialect;
import com.intellij.lang.css.CssDialectMappings;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.impl.PushedFilePropertiesUpdater;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FilePropertyKey;
import com.intellij.psi.css.CssFileType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CssDialectPusher
extends FilePropertyPusherBase<String> {
    @NotNull
    public FilePropertyKey<String> getFilePropertyKey() {
        FilePropertyKey<String> filePropertyKey = CssDialectMappings.CSS_DIALECT_NAME_KEY;
        if (filePropertyKey == null) {
            CssDialectPusher.$$$reportNull$$$0(0);
        }
        return filePropertyKey;
    }

    public boolean pushDirectoriesOnly() {
        return false;
    }

    @NotNull
    public String getDefaultValue() {
        String string = CssDialect.CLASSIC.getName();
        if (string == null) {
            CssDialectPusher.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Nullable
    public String getImmediateValue(@NotNull Project project, @Nullable VirtualFile file) {
        if (project == null) {
            CssDialectPusher.$$$reportNull$$$0(2);
        }
        if (file != null && file.isDirectory()) {
            String immediateMapping = (String)CssDialectMappings.getInstance(project).getImmediateMapping(file);
            if (immediateMapping != null) {
                return immediateMapping;
            }
            if (ProjectRootsUtil.isModuleContentRoot((VirtualFile)file, (Project)project)) {
                String projectImmediateMapping = (String)CssDialectMappings.getInstance(project).getImmediateMapping(null);
                if (projectImmediateMapping != null) {
                    return null;
                }
                CssDialect defaultDialect = CssDialect.getDefaultDialect(ModuleUtilCore.findModuleForFile((VirtualFile)file, (Project)project));
                return defaultDialect != null ? defaultDialect.getName() : null;
            }
        }
        return (String)CssDialectMappings.getInstance(project).getImmediateMapping(file);
    }

    @Nullable
    public String getImmediateValue(@NotNull Module module) {
        if (module == null) {
            CssDialectPusher.$$$reportNull$$$0(3);
        }
        return null;
    }

    public boolean acceptsFile(@NotNull VirtualFile file, @NotNull Project project) {
        if (file == null) {
            CssDialectPusher.$$$reportNull$$$0(4);
        }
        if (project == null) {
            CssDialectPusher.$$$reportNull$$$0(5);
        }
        return CssFileType.INSTANCE.equals(FileTypeRegistry.getInstance().getFileTypeByFileName(file.getNameSequence()));
    }

    public boolean acceptsDirectory(@NotNull VirtualFile file, @NotNull Project project) {
        if (file == null) {
            CssDialectPusher.$$$reportNull$$$0(6);
        }
        if (project == null) {
            CssDialectPusher.$$$reportNull$$$0(7);
        }
        return true;
    }

    public void propertyChanged(@NotNull Project project, @NotNull VirtualFile fileOrDir, @NotNull String actualProperty) {
        if (project == null) {
            CssDialectPusher.$$$reportNull$$$0(8);
        }
        if (fileOrDir == null) {
            CssDialectPusher.$$$reportNull$$$0(9);
        }
        if (actualProperty == null) {
            CssDialectPusher.$$$reportNull$$$0(10);
        }
        PushedFilePropertiesUpdater.getInstance((Project)project).filePropertiesChanged(fileOrDir, file -> this.acceptsFile((VirtualFile)file, project));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4, 5, 6, 7, 8, 9, 10 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/css/CssDialectPusher";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileOrDir";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actualProperty";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilePropertyKey";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultValue";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/css/CssDialectPusher";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getImmediateValue";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "acceptsFile";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "acceptsDirectory";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "propertyChanged";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4, 5, 6, 7, 8, 9, 10 -> new IllegalArgumentException(string);
        };
    }
}

