/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.view;

import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.dashboard.RunDashboardCustomizer;
import com.intellij.execution.dashboard.RunDashboardNode;
import com.intellij.execution.dashboard.RunDashboardRunConfigurationNode;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.icons.AllIcons;
import com.intellij.ide.dnd.DnDEvent;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.impl.AbstractProjectViewPane;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.javaee.appServers.deployment.DeploymentModel;
import com.intellij.javaee.appServers.deployment.DeploymentSettings;
import com.intellij.javaee.appServers.deployment.DeploymentStatus;
import com.intellij.javaee.appServers.ex.openapi.ex.DeploymentManagerEx;
import com.intellij.javaee.appServers.run.configuration.CommonModel;
import com.intellij.javaee.appServers.run.configuration.CommonStrategy;
import com.intellij.javaee.appServers.serverInstances.J2EEServerInstance;
import com.intellij.javaee.view.AppServersViewBundle;
import com.intellij.javaee.view.ArtifactUtils;
import com.intellij.javaee.view.ServerProcessState;
import com.intellij.javaee.view.ServersConfigManager;
import com.intellij.javaee.view.tool.action.DeploymentWorker;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import com.intellij.packaging.elements.PackagingElementType;
import com.intellij.packaging.impl.artifacts.ArtifactUtil;
import com.intellij.packaging.impl.artifacts.DefaultPackagingElementResolvingContext;
import com.intellij.packaging.impl.artifacts.PackagingElementPath;
import com.intellij.packaging.impl.artifacts.PackagingElementProcessor;
import com.intellij.packaging.impl.elements.ProductionModuleOutputElementType;
import com.intellij.packaging.impl.elements.ProductionModuleOutputPackagingElement;
import com.intellij.remoteServer.impl.runtime.ui.tree.DeploymentNode;
import com.intellij.remoteServer.impl.runtime.ui.tree.ServerNode;
import com.intellij.remoteServer.impl.runtime.ui.tree.ServersTreeStructure;
import com.intellij.ui.IconManager;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.icons.RowIcon;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.UIUtil;
import java.awt.datatransfer.Transferable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import javax.swing.Icon;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaeeRunDashboardCustomizer
extends RunDashboardCustomizer {
    private static final Logger LOG = Logger.getInstance(JavaeeRunDashboardCustomizer.class);

    public boolean isApplicable(@NotNull RunnerAndConfigurationSettings settings, @Nullable RunContentDescriptor descriptor) {
        if (settings == null) {
            JavaeeRunDashboardCustomizer.$$$reportNull$$$0(0);
        }
        return settings.getConfiguration() instanceof CommonStrategy;
    }

    public boolean updatePresentation(@NotNull PresentationData presentation, @NotNull RunDashboardRunConfigurationNode node) {
        CommonStrategy server;
        if (presentation == null) {
            JavaeeRunDashboardCustomizer.$$$reportNull$$$0(1);
        }
        if (node == null) {
            JavaeeRunDashboardCustomizer.$$$reportNull$$$0(2);
        }
        if ((server = (CommonStrategy)ObjectUtils.tryCast((Object)node.getConfigurationSettings().getConfiguration(), CommonStrategy.class)) == null) {
            return false;
        }
        JavaeeRunDashboardCustomizer.customizeServerPresentation(presentation, server);
        return true;
    }

    @Nullable
    public Collection<? extends AbstractTreeNode<?>> getChildren(@NotNull RunDashboardRunConfigurationNode node) {
        CommonStrategy server;
        if (node == null) {
            JavaeeRunDashboardCustomizer.$$$reportNull$$$0(3);
        }
        return (server = (CommonStrategy)ObjectUtils.tryCast((Object)node.getConfigurationSettings().getConfiguration(), CommonStrategy.class)) != null ? JavaeeRunDashboardCustomizer.getArtifacts(server) : null;
    }

    public boolean canDrop(@NotNull RunDashboardRunConfigurationNode node, @NotNull DnDEvent event) {
        CommonStrategy server;
        if (node == null) {
            JavaeeRunDashboardCustomizer.$$$reportNull$$$0(4);
        }
        if (event == null) {
            JavaeeRunDashboardCustomizer.$$$reportNull$$$0(5);
        }
        return (server = (CommonStrategy)ObjectUtils.tryCast((Object)node.getConfigurationSettings().getConfiguration(), CommonStrategy.class)) != null && server.getDeploymentSettings() != null && JavaeeRunDashboardCustomizer.findArtifactsToDrop(server, event) != null;
    }

    public void drop(@NotNull RunDashboardRunConfigurationNode node, @NotNull DnDEvent event) {
        CommonStrategy server;
        if (node == null) {
            JavaeeRunDashboardCustomizer.$$$reportNull$$$0(6);
        }
        if (event == null) {
            JavaeeRunDashboardCustomizer.$$$reportNull$$$0(7);
        }
        if ((server = (CommonStrategy)ObjectUtils.tryCast((Object)node.getConfigurationSettings().getConfiguration(), CommonStrategy.class)) == null) {
            return;
        }
        DeploymentSettings deploymentSettings = server.getDeploymentSettings();
        if (deploymentSettings == null) {
            return;
        }
        Collection<Artifact> artifacts = JavaeeRunDashboardCustomizer.findArtifactsToDrop(server, event);
        if (artifacts == null) {
            return;
        }
        for (Artifact artifact : artifacts) {
            deploymentSettings.getOrCreateModel(artifact);
        }
        ServersConfigManager.getInstance(server.getProject()).onDeploymentSettingsChanged(server);
    }

    private static Collection<Artifact> findArtifactsToDrop(CommonStrategy server, DnDEvent event) {
        TreeNode[] treeNodes = AbstractProjectViewPane.getTransferedTreeNodes((Transferable)event);
        if (treeNodes == null) {
            return null;
        }
        final HashSet<Module> draggedModules = new HashSet<Module>();
        for (TreeNode treeNode : treeNodes) {
            Object treeNodeObject;
            if (!(treeNode instanceof DefaultMutableTreeNode) || !((treeNodeObject = AbstractProjectViewPane.extractValueFromNode((Object)treeNode)) instanceof Module)) continue;
            draggedModules.add((Module)treeNodeObject);
        }
        if (draggedModules.isEmpty()) {
            return null;
        }
        Project project = server.getProject();
        LinkedHashSet<Artifact> allSupportedArtifacts = ArtifactUtils.getServerSupportedArtifacts(project, server);
        final HashSet<Artifact> artifactsToDrop = new HashSet<Artifact>();
        final DefaultPackagingElementResolvingContext context = new DefaultPackagingElementResolvingContext(project);
        for (final Artifact artifact : allSupportedArtifacts) {
            ArtifactUtil.processPackagingElements((PackagingElement)artifact.getRootElement(), (PackagingElementType)ProductionModuleOutputElementType.ELEMENT_TYPE, (PackagingElementProcessor)new PackagingElementProcessor<ProductionModuleOutputPackagingElement>(){

                public boolean process(@NotNull ProductionModuleOutputPackagingElement element, @NotNull PackagingElementPath path) {
                    Module artifactModule;
                    if (element == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (path == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    if (draggedModules.contains(artifactModule = element.findModule((PackagingElementResolvingContext)context))) {
                        artifactsToDrop.add(artifact);
                    }
                    return true;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "element";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "path";
                            break;
                        }
                    }
                    objectArray[1] = "com/intellij/javaee/view/JavaeeRunDashboardCustomizer$1";
                    objectArray[2] = "process";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            }, (PackagingElementResolvingContext)context, (boolean)false, (ArtifactType)artifact.getArtifactType());
        }
        return artifactsToDrop.isEmpty() ? null : artifactsToDrop;
    }

    private static Collection<? extends AbstractTreeNode<?>> getArtifacts(@NotNull CommonStrategy server) {
        if (server == null) {
            JavaeeRunDashboardCustomizer.$$$reportNull$$$0(8);
        }
        ArrayList<ArtifactNode> result = new ArrayList<ArtifactNode>();
        Project project = server.getProject();
        Collection deploymentModels = server.getDeploymentModels();
        for (DeploymentModel deploymentModel : deploymentModels) {
            result.add(new ArtifactNode(project, server, deploymentModel));
        }
        return result;
    }

    private static void customizeServerPresentation(@NotNull PresentationData presentation, @NotNull CommonStrategy server) {
        if (presentation == null) {
            JavaeeRunDashboardCustomizer.$$$reportNull$$$0(9);
        }
        if (server == null) {
            JavaeeRunDashboardCustomizer.$$$reportNull$$$0(10);
        }
        String place = server.isLocal() ? AppServersViewBundle.message("ServersTreeStructure.node.server.place.local", new Object[0]) : AppServersViewBundle.message("ServersTreeStructure.node.server.place.remote", new Object[0]);
        presentation.addText(" [" + place + "]", SimpleTextAttributes.GRAY_ATTRIBUTES);
        Icon itemIcon = server.getIcon();
        LOG.assertTrue(itemIcon != null, (Object)server.getType());
        ServerProcessState state = ServersConfigManager.getInstance(server.getProject()).getServerProcessState(server);
        Icon statusIcon = state.getIcon();
        presentation.setIcon(ServersTreeStructure.getServerNodeIcon((Icon)itemIcon, (Icon)statusIcon));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 1: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "server";
                break;
            }
        }
        objectArray2[1] = "com/intellij/javaee/view/JavaeeRunDashboardCustomizer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isApplicable";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "updatePresentation";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getChildren";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "canDrop";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "drop";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "getArtifacts";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "customizeServerPresentation";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class ArtifactNode
    extends AbstractTreeNode<DeploymentModel>
    implements DeploymentNode,
    RunDashboardNode {
        private final Project myProject;
        private final CommonStrategy myServer;
        private final DeploymentModel myDeploymentModel;
        private DeploymentStatus myDeploymentStatus;

        ArtifactNode(@NotNull Project project, @NotNull CommonStrategy server, @NotNull DeploymentModel deploymentModel) {
            if (project == null) {
                ArtifactNode.$$$reportNull$$$0(0);
            }
            if (server == null) {
                ArtifactNode.$$$reportNull$$$0(1);
            }
            if (deploymentModel == null) {
                ArtifactNode.$$$reportNull$$$0(2);
            }
            super(project, (Object)deploymentModel);
            this.myProject = project;
            this.myServer = server;
            this.myDeploymentModel = deploymentModel;
        }

        public String getDeploymentName() {
            return this.myDeploymentModel.getDeploymentSource().getPresentableName();
        }

        @NotNull
        public DeploymentModel getDeploymentModel() {
            DeploymentModel deploymentModel = this.myDeploymentModel;
            if (deploymentModel == null) {
                ArtifactNode.$$$reportNull$$$0(3);
            }
            return deploymentModel;
        }

        @NotNull
        public Collection<? extends AbstractTreeNode<?>> getChildren() {
            List list = Collections.emptyList();
            if (list == null) {
                ArtifactNode.$$$reportNull$$$0(4);
            }
            return list;
        }

        @NotNull
        public ServerNode getServerNode() {
            throw new UnsupportedOperationException("Artifact node hasn't server node in Run Dashboard/Services tool window");
        }

        public boolean isDeployActionVisible() {
            return true;
        }

        public boolean isDeployActionEnabled() {
            return ServersConfigManager.getInstance(this.myProject).isConnectedAndRunning(this.myServer) && this.myDeploymentModel.isValid();
        }

        public void deploy() {
            DeploymentWorker worker = new DeploymentWorker(this.myProject);
            J2EEServerInstance serverInstance = ServersConfigManager.getInstance(this.myProject).getServerInstance(this.myServer);
            if (serverInstance != null) {
                worker.addDeploymentItem(serverInstance, this.myDeploymentModel);
                worker.compileAndDeploy();
            }
        }

        public boolean isUndeployActionEnabled() {
            return ServersConfigManager.getInstance(this.myProject).isConnectedAndRunning(this.myServer) && (this.myDeploymentStatus == DeploymentStatus.DEPLOYED || this.myDeploymentStatus == DeploymentStatus.PREPARED);
        }

        public void undeploy() {
            J2EEServerInstance serverInstance = ServersConfigManager.getInstance(this.myProject).getServerInstance(this.myServer);
            if (serverInstance != null) {
                this.myServer.getDeploymentProvider().startUndeploy(serverInstance, this.myDeploymentModel);
            }
        }

        public Runnable getRemover() {
            return this::remove;
        }

        private void remove() {
            this.undeploy();
            DeploymentSettings deploymentSettings = this.myServer.getDeploymentSettings();
            if (deploymentSettings != null) {
                deploymentSettings.removeModel(this.getDeploymentModel());
            }
            ServersConfigManager.getInstance(this.myProject).onDeploymentSettingsChanged(this.myServer);
        }

        public boolean isDebugActionVisible() {
            return false;
        }

        public void deployWithDebug() {
        }

        public boolean isDeployed() {
            return this.myDeploymentStatus == DeploymentStatus.DEPLOYED;
        }

        protected void update(@NotNull PresentationData presentation) {
            if (presentation == null) {
                ArtifactNode.$$$reportNull$$$0(5);
            }
            this.myDeploymentStatus = DeploymentManagerEx.getInstanceEx((Project)this.myProject).getDeploymentStatus(this.myDeploymentModel, (CommonModel)this.myServer);
            boolean isValid = (Boolean)ReadAction.compute(() -> this.myDeploymentModel.isValid());
            if (!isValid) {
                presentation.setIcon(UIUtil.getBalloonErrorIcon());
                presentation.setPresentableText(AppServersViewBundle.message("ServersTreeStructure.node.artifact.invalid", new Object[0]));
                return;
            }
            String presentableName = this.myDeploymentModel.getDeploymentSource().getPresentableName();
            presentation.addText(presentableName, SimpleTextAttributes.REGULAR_ATTRIBUTES);
            if (this.myDeploymentStatus == DeploymentStatus.DEPLOYED) {
                boolean synced = ServersConfigManager.getInstance(this.myProject).isArtifactSynced(this.myServer, this.myDeploymentModel.getArtifact());
                String syncedMessage = AppServersViewBundle.message(synced ? "ServersTreeStructure.node.artifact.synced" : "ServersTreeStructure.node.artifact.unsynced", new Object[0]);
                presentation.addText(" [" + syncedMessage + "]", SimpleTextAttributes.GRAY_ATTRIBUTES);
            }
            RowIcon icon = IconManager.getInstance().createRowIcon(2);
            icon.setIcon(this.myDeploymentModel.getDeploymentSource().getIcon(), 0);
            Icon statusIcon = this.myDeploymentStatus == DeploymentStatus.PREPARED ? AllIcons.RunConfigurations.TestPaused : this.myDeploymentStatus.getIcon(null);
            icon.setIcon(statusIcon, 1);
            presentation.setIcon((Icon)icon);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "server";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "deploymentModel";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/javaee/view/JavaeeRunDashboardCustomizer$ArtifactNode";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "presentation";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/javaee/view/JavaeeRunDashboardCustomizer$ArtifactNode";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDeploymentModel";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildren";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 4 -> new IllegalStateException(string);
            };
        }
    }
}

