/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.data.blocking;

import com.intellij.codeInspection.blockingCallsDetection.BlockingMethodChecker;
import com.intellij.codeInspection.blockingCallsDetection.MethodContext;
import com.intellij.lang.jvm.JvmModifier;
import com.intellij.openapi.project.Project;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.spring.SpringLibraryUtil;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/spring/data/blocking/SpringDataBlockingMethodChecker;", "Lcom/intellij/codeInspection/blockingCallsDetection/BlockingMethodChecker;", "<init>", "()V", "BLOCKING_CRUD_REPOSITORY", "", "BLOCKING_JPA_REPOSITORY", "BLOCKING_METHODS", "", "isApplicable", "", "file", "Lcom/intellij/psi/PsiFile;", "isMethodBlocking", "context", "Lcom/intellij/codeInspection/blockingCallsDetection/MethodContext;", "hasAsyncReturnType", "method", "Lcom/intellij/psi/PsiMethod;", "intellij.spring.data"})
@SourceDebugExtension(value={"SMAP\nSpringDataBlockingMethodChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpringDataBlockingMethodChecker.kt\ncom/intellij/spring/data/blocking/SpringDataBlockingMethodChecker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,59:1\n1#2:60\n*E\n"})
public final class SpringDataBlockingMethodChecker
implements BlockingMethodChecker {
    @NotNull
    private final String BLOCKING_CRUD_REPOSITORY;
    @NotNull
    private final String BLOCKING_JPA_REPOSITORY;
    @NotNull
    private final Set<String> BLOCKING_METHODS;

    public SpringDataBlockingMethodChecker() {
        this.BLOCKING_CRUD_REPOSITORY = "org.springframework.data.repository.CrudRepository";
        this.BLOCKING_JPA_REPOSITORY = "org.springframework.data.jpa.repository.JpaRepository";
        Object[] objectArray = new String[]{"save", "saveAll", "flush", "saveAndFlush", "getById", "findById", "existsById", "findAll", "findAllById", "count", "deleteById", "delete", "deleteAllById", "deleteAll", "deleteAllInBatch"};
        this.BLOCKING_METHODS = SetsKt.setOf((Object[])objectArray);
    }

    public boolean isApplicable(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!SpringLibraryUtil.hasSpringLibrary((Project)file.getProject())) {
            return false;
        }
        JavaPsiFacade javaPsi = JavaPsiFacade.getInstance((Project)file.getProject());
        return javaPsi.findClass("org.springframework.data.repository.Repository", file.getResolveScope()) != null;
    }

    public boolean isMethodBlocking(@NotNull MethodContext context) {
        PsiClass containingClass;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        PsiMethod method = context.getElement();
        if (this.BLOCKING_METHODS.contains(method.getName())) {
            PsiClass psiClass = method.getContainingClass();
            String containingClass2 = psiClass != null ? psiClass.getQualifiedName() : null;
            return Intrinsics.areEqual((Object)containingClass2, (Object)this.BLOCKING_CRUD_REPOSITORY) || Intrinsics.areEqual((Object)containingClass2, (Object)this.BLOCKING_JPA_REPOSITORY);
        }
        if (method.hasModifier(JvmModifier.ABSTRACT) && (containingClass = method.getContainingClass()) != null && containingClass.isInterface()) {
            return InheritanceUtil.isInheritor((PsiClass)containingClass, (String)this.BLOCKING_CRUD_REPOSITORY) && !this.hasAsyncReturnType(method);
        }
        return false;
    }

    private final boolean hasAsyncReturnType(PsiMethod method) {
        PsiClass targetType;
        Object object;
        PsiType psiType = method.getReturnType();
        if (psiType == null) {
            return false;
        }
        PsiType returnType = psiType;
        PsiType psiType2 = GenericsUtil.eliminateWildcards((PsiType)returnType);
        if (psiType2 != null) {
            PsiType it = psiType2;
            boolean bl = false;
            PsiClassType psiClassType = it instanceof PsiClassType ? (PsiClassType)it : null;
            object = psiClassType != null ? psiClassType.resolve() : null;
        } else {
            object = null;
        }
        PsiClass psiClass = targetType = object;
        String qualifiedTypeName = psiClass != null ? psiClass.getQualifiedName() : null;
        return Intrinsics.areEqual((Object)qualifiedTypeName, (Object)"java.util.concurrent.CompletableFuture") || Intrinsics.areEqual((Object)qualifiedTypeName, (Object)"java.util.concurrent.Future") || Intrinsics.areEqual((Object)qualifiedTypeName, (Object)"org.springframework.util.concurrent.ListenableFuture");
    }
}

