/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.data.injectors.ql;

import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.jpa.DefaultQlModel;
import com.intellij.jpa.facet.JpaConfigurationModel;
import com.intellij.jpa.ql.QlFile;
import com.intellij.jpa.ql.model.QlModel;
import com.intellij.lang.Language;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.spring.data.injectors.SpringDataQLInjectorBase;
import com.intellij.spring.data.injectors.ql.SpringDataDomainModel;
import com.intellij.spring.data.jpa.ql.language.SpringDataQLLanguage;
import com.intellij.sql.psi.SqlLanguage;
import java.util.Set;
import kotlin.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UAnnotationUtils;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UastContextKt;

public final class SpringDataQLInjector
extends SpringDataQLInjectorBase {
    public static final Set<String> QUERY_ANNOTATIONS = Set.of("org.springframework.data.jpa.repository.Query");

    @Override
    protected boolean isSuitableForInjection(@NotNull PsiLanguageInjectionHost host) {
        if (host == null) {
            SpringDataQLInjector.$$$reportNull$$$0(0);
        }
        return SpringDataQLInjector.isQueryAnnotationHost((PsiElement)host);
    }

    @Override
    @NotNull
    protected Language getLanguageToInject(@NotNull PsiLanguageInjectionHost host) {
        if (host == null) {
            SpringDataQLInjector.$$$reportNull$$$0(1);
        }
        Object object = SpringDataQLInjector.isNativeQuery(host) ? SqlLanguage.INSTANCE : SpringDataQLLanguage.INSTANCE;
        if (object == null) {
            SpringDataQLInjector.$$$reportNull$$$0(2);
        }
        return object;
    }

    @Override
    protected void processInjection(@NotNull PsiLanguageInjectionHost host) {
        if (host == null) {
            SpringDataQLInjector.$$$reportNull$$$0(3);
        }
        host.putUserData(QlFile.PERSISTENCE_MODEL_KEY, (Object)SpringDataQLInjector.getQlModel((PsiElement)host));
    }

    private static boolean isQueryAnnotationHost(@NotNull PsiElement host) {
        String annotationParamName;
        Pair annotationEntry;
        if (host == null) {
            SpringDataQLInjector.$$$reportNull$$$0(4);
        }
        if (host instanceof PsiLanguageInjectionHost && (annotationEntry = UAnnotationUtils.getContainingUAnnotationEntry((UElement)UastContextKt.toUElement((PsiElement)host))) != null && ((annotationParamName = (String)annotationEntry.getSecond()) == null || "value".equals(annotationParamName) || "countQuery".equals(annotationParamName))) {
            UAnnotation annotation = (UAnnotation)annotationEntry.getFirst();
            return !host.getProject().isDefault() && SpringDataQLInjector.isQueryAnnotation(annotation);
        }
        return false;
    }

    private static boolean isQueryAnnotation(@NotNull UAnnotation psiAnnotation) {
        String name;
        if (psiAnnotation == null) {
            SpringDataQLInjector.$$$reportNull$$$0(5);
        }
        return (name = psiAnnotation.getQualifiedName()) != null && QUERY_ANNOTATIONS.contains(name);
    }

    private static boolean isNativeQuery(PsiLanguageInjectionHost host) {
        Pair annotationEntry = UAnnotationUtils.getContainingAnnotationEntry((UElement)UastContextKt.toUElement((PsiElement)host));
        if (annotationEntry == null) {
            return false;
        }
        PsiAnnotation annotation = (PsiAnnotation)annotationEntry.getFirst();
        if (annotation.getProject().isDefault()) {
            return false;
        }
        PsiAnnotationMemberValue nativeQueryMemberValue = annotation.findAttributeValue("nativeQuery");
        if (nativeQueryMemberValue == null) {
            return false;
        }
        Boolean value = (Boolean)JamCommonUtil.getObjectValue((PsiElement)nativeQueryMemberValue, Boolean.class);
        return value != null && value != false;
    }

    @NotNull
    private static QlModel getQlModel(PsiElement host) {
        PsiElement originalElement = host.getOriginalElement();
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)originalElement);
        if (module != null && JpaConfigurationModel.hasJpaSupport((Module)module)) {
            return new DefaultQlModel(false, module);
        }
        return new SpringDataDomainModel(originalElement);
    }

    static {
        SpringDataQLLanguage.INSTANCE.getDisplayName();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/data/injectors/ql/SpringDataQLInjector";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiAnnotation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/data/injectors/ql/SpringDataQLInjector";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguageToInject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isSuitableForInjection";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getLanguageToInject";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "processInjection";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isQueryAnnotationHost";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isQueryAnnotation";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

