/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.data.jdbc.orm.model;

import com.intellij.jpa.jpb.model.core.util.Fqn;
import com.intellij.jpa.jpb.model.orm.model.OrmEntity;
import com.intellij.jpa.jpb.model.orm.model.OrmEntityAttribute;
import com.intellij.jpa.jpb.model.orm.model.OrmFramework;
import com.intellij.jpa.jpb.model.util.PsiUtilsKt;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiType;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.spring.data.jdbc.orm.SpringDataJdbcOrmFramework;
import com.intellij.spring.data.jdbc.orm.model.SpringDataJdbcOrmEntityAttribute;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0096\u0002J\b\u0010\u001b\u001a\u00020\u001cH\u0016R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00030\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u001d"}, d2={"Lcom/intellij/spring/data/jdbc/orm/model/SpringDataJdbcOrmEntity;", "Lcom/intellij/jpa/jpb/model/orm/model/OrmEntity;", "psiClass", "Lcom/intellij/psi/PsiClass;", "<init>", "(Lcom/intellij/psi/PsiClass;)V", "ormFramework", "Lcom/intellij/jpa/jpb/model/orm/model/OrmFramework;", "getOrmFramework", "()Lcom/intellij/jpa/jpb/model/orm/model/OrmFramework;", "name", "", "getName", "()Ljava/lang/String;", "classPsiPointer", "Lcom/intellij/psi/SmartPsiElementPointer;", "getClassPsiPointer", "()Lcom/intellij/psi/SmartPsiElementPointer;", "attributes", "", "Lcom/intellij/jpa/jpb/model/orm/model/OrmEntityAttribute;", "getAttributes", "()Ljava/util/List;", "equals", "", "other", "", "hashCode", "", "intellij.spring.data"})
@SourceDebugExtension(value={"SMAP\nSpringDataJdbcOrmEntity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpringDataJdbcOrmEntity.kt\ncom/intellij/spring/data/jdbc/orm/model/SpringDataJdbcOrmEntity\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,72:1\n1#2:73\n*E\n"})
public final class SpringDataJdbcOrmEntity
implements OrmEntity {
    @NotNull
    private final OrmFramework ormFramework;
    @NotNull
    private final String name;
    @NotNull
    private final SmartPsiElementPointer<PsiClass> classPsiPointer;

    public SpringDataJdbcOrmEntity(@NotNull PsiClass psiClass) {
        Intrinsics.checkNotNullParameter((Object)psiClass, (String)"psiClass");
        this.ormFramework = SpringDataJdbcOrmFramework.INSTANCE;
        String string = psiClass.getName();
        if (string == null) {
            string = "";
        }
        this.name = string;
        SmartPsiElementPointer smartPsiElementPointer = SmartPointerManager.createPointer((PsiElement)((PsiElement)psiClass));
        Intrinsics.checkNotNullExpressionValue((Object)smartPsiElementPointer, (String)"createPointer(...)");
        this.classPsiPointer = smartPsiElementPointer;
    }

    @NotNull
    public OrmFramework getOrmFramework() {
        return this.ormFramework;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public SmartPsiElementPointer<PsiClass> getClassPsiPointer() {
        return this.classPsiPointer;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<OrmEntityAttribute> getAttributes() {
        PsiClass psiClass = (PsiClass)this.getClassPsiPointer().getElement();
        if (psiClass == null) {
            return CollectionsKt.emptyList();
        }
        PsiClass psiClass2 = psiClass;
        Map result = new LinkedHashMap();
        Set transientField = new LinkedHashSet();
        for (PsiField psiField : psiClass2.getAllFields()) {
            if (psiField.hasModifierProperty("static") || psiField.hasModifierProperty("transient") || psiField.hasAnnotation("org.springframework.data.annotation.Transient")) {
                String string = psiField.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                transientField.add(string);
                continue;
            }
            Map map = result;
            String string = psiField.getName();
            String string2 = psiField.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
            PsiType psiType = psiField.getType();
            Intrinsics.checkNotNullExpressionValue((Object)psiType, (String)"getType(...)");
            Fqn fqn = Fqn.Companion.ofType(psiType, (PsiElement)psiField, psiClass2);
            Intrinsics.checkNotNull((Object)psiField);
            SpringDataJdbcOrmEntityAttribute springDataJdbcOrmEntityAttribute = new SpringDataJdbcOrmEntityAttribute(string2, fqn, (PsiMember)psiField);
            map.put(string, springDataJdbcOrmEntityAttribute);
        }
        for (PsiField psiField : psiClass2.getAllMethods()) {
            PsiType methodType;
            String attributeName;
            String string;
            String methodName;
            Intrinsics.checkNotNullExpressionValue((Object)psiField.getName(), (String)"getName(...)");
            if (Intrinsics.areEqual((Object)methodName, (Object)"getClass") || !StringsKt.startsWith$default((String)methodName, (String)"get", (boolean)false, (int)2, null) || methodName.length() < 4) continue;
            Intrinsics.checkNotNull((Object)psiField);
            if (PsiUtilsKt.getType((PsiMember)((PsiMember)psiField)) == null) continue;
            Intrinsics.checkNotNullExpressionValue((Object)methodName.substring(3), (String)"substring(...)");
            if (((CharSequence)string).length() > 0) {
                void it;
                char c = string.charAt(0);
                StringBuilder stringBuilder = new StringBuilder();
                boolean bl = false;
                Locale locale = Locale.getDefault();
                Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
                StringBuilder stringBuilder2 = stringBuilder.append((Object)CharsKt.lowercase((char)it, (Locale)locale));
                String string3 = string;
                int n = 1;
                String string4 = string3.substring(n);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
                v8 = stringBuilder2.append(string4).toString();
            } else {
                v8 = attributeName = string;
            }
            if (transientField.contains(attributeName) || psiField.hasAnnotation("org.springframework.data.annotation.Transient")) {
                result.remove(attributeName);
                continue;
            }
            if (result.get(attributeName) != null) {
                PsiAnnotation[] psiAnnotationArray = psiField.getAnnotations();
                Intrinsics.checkNotNullExpressionValue((Object)psiAnnotationArray, (String)"getAnnotations(...)");
                if (!(!(((Object[])psiAnnotationArray).length == 0))) continue;
            }
            result.put(attributeName, new SpringDataJdbcOrmEntityAttribute(attributeName, Fqn.Companion.ofType(methodType, (PsiElement)psiField, psiClass2), (PsiMember)psiField));
        }
        return CollectionsKt.toList((Iterable)result.values());
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type com.intellij.spring.data.jdbc.orm.model.SpringDataJdbcOrmEntity");
        SpringDataJdbcOrmEntity cfr_ignored_0 = (SpringDataJdbcOrmEntity)other;
        return Intrinsics.areEqual(this.getClassPsiPointer(), ((SpringDataJdbcOrmEntity)other).getClassPsiPointer());
    }

    public int hashCode() {
        return this.getClassPsiPointer().hashCode();
    }
}

