/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.data.jpa.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.javaee.utils.persistence.data.inspections.TypeWrapper;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.spring.data.commons.inspections.SpringDataTypeWrapper;
import com.intellij.spring.data.commons.util.SpringDataUtil;
import com.intellij.spring.model.highlighting.jam.SpringUastInspectionBase;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UMethod;

public abstract class SpringDataRepositoriesInspection
extends SpringUastInspectionBase {
    public boolean isEnabledForModule(@Nullable Module module) {
        return super.isEnabledForModule(module) && SpringDataUtil.hasSpringDataSupport(module);
    }

    public ProblemDescriptor @Nullable [] checkClass(@NotNull UClass aClass, @NotNull InspectionManager manager, boolean isOnTheFly) {
        PsiElement sourcePsi;
        if (aClass == null) {
            SpringDataRepositoriesInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            SpringDataRepositoriesInspection.$$$reportNull$$$0(1);
        }
        if ((sourcePsi = aClass.getSourcePsi()) == null) {
            return null;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)sourcePsi);
        if (module == null) {
            return null;
        }
        if (!SpringDataUtil.isRepository(aClass.getJavaPsi())) {
            return null;
        }
        ProblemsHolder holder = new ProblemsHolder(manager, sourcePsi.getContainingFile(), isOnTheFly);
        this.checkRepositoryClass(aClass, holder, module);
        Pair<PsiClass, ? extends PsiType> typePair = SpringDataUtil.substituteRepositoryTypes(aClass.getJavaPsi());
        if (typePair != null) {
            for (UMethod psiMethod : aClass.getMethods()) {
                if (!SpringDataUtil.isQueryMethod(psiMethod.getJavaPsi()) || SpringDataUtil.isOverridenRepositoryMethod(module, psiMethod)) continue;
                this.checkRepositoryMethod(holder, aClass, psiMethod, module, typePair);
            }
        }
        return holder.getResultsArray();
    }

    protected void checkRepositoryClass(@NotNull UClass aClass, @NotNull ProblemsHolder holder, @NotNull Module module) {
        if (aClass == null) {
            SpringDataRepositoriesInspection.$$$reportNull$$$0(2);
        }
        if (holder == null) {
            SpringDataRepositoriesInspection.$$$reportNull$$$0(3);
        }
        if (module == null) {
            SpringDataRepositoriesInspection.$$$reportNull$$$0(4);
        }
    }

    protected void checkRepositoryMethod(@NotNull ProblemsHolder holder, UClass repositoryClass, @NotNull UMethod psiMethod, @NotNull Module module, @NotNull Pair<PsiClass, ? extends PsiType> typePair) {
        if (holder == null) {
            SpringDataRepositoriesInspection.$$$reportNull$$$0(5);
        }
        if (psiMethod == null) {
            SpringDataRepositoriesInspection.$$$reportNull$$$0(6);
        }
        if (module == null) {
            SpringDataRepositoriesInspection.$$$reportNull$$$0(7);
        }
        if (typePair == null) {
            SpringDataRepositoriesInspection.$$$reportNull$$$0(8);
        }
    }

    protected static boolean isReactiveRepository(UClass uClass) {
        PsiClass psiClass = uClass.getJavaPsi();
        for (TypeWrapper typeWrapper : SpringDataTypeWrapper.REACTIVE_ALL) {
            if (!InheritanceUtil.isInheritor((PsiClass)psiClass, (String)typeWrapper.repositoryClass)) continue;
            return true;
        }
        return false;
    }

    protected static boolean isImperativeReactiveRepository(UClass uClass) {
        List<String> allReactiveTypes = Arrays.asList(SpringDataTypeWrapper.REACTIVE.getAllSupportedTypes());
        UMethod[] methods = uClass.getMethods();
        if (methods.length == 0) {
            return false;
        }
        for (UMethod method : methods) {
            if (allReactiveTypes.contains(SpringDataRepositoriesInspection.getReturnTypeFQN(method))) continue;
            return false;
        }
        return true;
    }

    @Nullable
    private static String getReturnTypeFQN(UMethod method) {
        PsiType returnType = method.getReturnType();
        if (returnType instanceof PsiClassType) {
            PsiClass resolve = ((PsiClassType)returnType).resolve();
            return resolve != null ? resolve.getQualifiedName() : null;
        }
        return null;
    }

    protected static boolean isCoroutineRepository(UClass uClass) {
        PsiClass psiClass = uClass.getJavaPsi();
        return InheritanceUtil.isInheritor((PsiClass)psiClass, (String)"org.springframework.data.repository.kotlin.CoroutineCrudRepository");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiMethod";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typePair";
                break;
            }
        }
        objectArray2[1] = "com/intellij/spring/data/jpa/inspections/SpringDataRepositoriesInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "checkClass";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "checkRepositoryClass";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "checkRepositoryMethod";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

