/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.data.llm.associations;

import com.intellij.jpa.llm.domains.persistence.EntityProvider;
import com.intellij.jpa.model.annotations.mapping.EntityImpl;
import com.intellij.jpa.model.common.persistence.mapping.Entity;
import com.intellij.ml.llm.domains.DomainProvider;
import com.intellij.ml.llm.domains.DomainSearchScope;
import com.intellij.ml.llm.domains.associations.DomainAssociation;
import com.intellij.ml.llm.domains.associations.DomainAssociationDescriptor;
import com.intellij.ml.llm.domains.associations.DomainAssociationType;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import com.intellij.spring.data.commons.util.SpringDataUtil;
import com.intellij.spring.data.llm.SpringRepositoriesProvider;
import com.intellij.spring.model.SpringBeanPointer;
import java.util.Collections;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0002\u0012\u0004\u0012\u00020\u00030\u0007H\u0016J\"\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\t2\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u00022\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lcom/intellij/spring/data/llm/associations/SpringRepositoryAssociation;", "Lcom/intellij/ml/llm/domains/associations/DomainAssociation;", "Lcom/intellij/spring/model/SpringBeanPointer;", "Lcom/intellij/jpa/model/common/persistence/mapping/Entity;", "<init>", "()V", "getDescriptor", "Lcom/intellij/ml/llm/domains/associations/DomainAssociationDescriptor;", "fetch", "", "r", "scope", "Lcom/intellij/ml/llm/domains/DomainSearchScope;", "intellij.spring.data"})
public final class SpringRepositoryAssociation
implements DomainAssociation<SpringBeanPointer<?>, Entity> {
    @NotNull
    public DomainAssociationDescriptor<SpringBeanPointer<?>, Entity> getDescriptor() {
        return new DomainAssociationDescriptor(DomainProvider.Companion.find(SpringRepositoriesProvider.class), DomainProvider.Companion.find(EntityProvider.class), DomainAssociationType.Companion.getDEPENDS_ON());
    }

    @NotNull
    public Set<Entity> fetch(@NotNull SpringBeanPointer<?> r, @NotNull DomainSearchScope scope) {
        PsiClass entityClass;
        Intrinsics.checkNotNullParameter(r, (String)"r");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        PsiClass aClass = r.getBeanClass();
        if (aClass == null) {
            return SetsKt.emptySet();
        }
        Pair<PsiClass, ? extends PsiType> pair = SpringDataUtil.substituteRepositoryTypes(aClass);
        Object object = entityClass = pair != null ? (PsiClass)pair.first : null;
        if (entityClass == null) {
            return SetsKt.emptySet();
        }
        EntityImpl entity = (EntityImpl)EntityImpl.ENTITY_META.getJamElement((PsiModifierListOwner)entityClass);
        if (entity == null) {
            return SetsKt.emptySet();
        }
        Set<EntityImpl> set = Collections.singleton(entity);
        Intrinsics.checkNotNullExpressionValue(set, (String)"singleton(...)");
        return set;
    }
}

