/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.data.logical;

import com.intellij.ide.structureView.logical.PropertyElementProvider;
import com.intellij.jpa.jpb.model.orm.ep.OrmSearcher;
import com.intellij.jpa.jpb.model.orm.model.OrmEntity;
import com.intellij.jpa.jpb.model.repository.RepositorySearch;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.jam.stereotype.SpringRepository;
import com.intellij.spring.model.logical.SpringBeanLogicalModel;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\u000b2\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\r"}, d2={"Lcom/intellij/spring/data/logical/SpringRepositoryEntityPropertyProvider;", "Lcom/intellij/ide/structureView/logical/PropertyElementProvider;", "Lcom/intellij/spring/model/logical/SpringBeanLogicalModel;", "Lcom/intellij/jpa/jpb/model/orm/model/OrmEntity;", "<init>", "()V", "propertyName", "", "getPropertyName", "()Ljava/lang/String;", "getElements", "", "parent", "intellij.spring.data"})
public final class SpringRepositoryEntityPropertyProvider
implements PropertyElementProvider<SpringBeanLogicalModel, OrmEntity> {
    @NotNull
    private final String propertyName;

    public SpringRepositoryEntityPropertyProvider() {
        this.propertyName = "entity";
    }

    @NotNull
    public String getPropertyName() {
        return this.propertyName;
    }

    @NotNull
    public List<OrmEntity> getElements(@NotNull SpringBeanLogicalModel parent) {
        OrmEntity ormEntity;
        block4: {
            Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
            CommonSpringBean commonSpringBean = parent.getSpringBean();
            SpringRepository springRepository = commonSpringBean instanceof SpringRepository ? (SpringRepository)commonSpringBean : null;
            if (springRepository == null) {
                return CollectionsKt.emptyList();
            }
            SpringRepository repository = springRepository;
            PsiClass psiClass = repository.getPsiElement();
            Intrinsics.checkNotNullExpressionValue((Object)psiClass, (String)"getPsiElement(...)");
            PsiClass repositoryClass = psiClass;
            Project project = repositoryClass.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            PsiClass psiClass2 = RepositorySearch.Companion.getInstance(project).getDomainClass(repositoryClass);
            if (psiClass2 == null) {
                return CollectionsKt.emptyList();
            }
            PsiClass entityClass = psiClass2;
            Project project2 = repositoryClass.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
            for (OrmSearcher it : (Iterable)OrmSearcher.Companion.getAllForProject(project2)) {
                boolean bl = false;
                OrmEntity ormEntity2 = it.findEntityForClass(entityClass);
                if (ormEntity2 == null) continue;
                ormEntity = ormEntity2;
                break block4;
            }
            ormEntity = null;
        }
        if (ormEntity == null) {
            return CollectionsKt.emptyList();
        }
        OrmEntity ormEntity3 = ormEntity;
        return CollectionsKt.listOf(ormEntity3);
    }
}

