/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.beanValidation.highlighting.fixes;

import com.intellij.beanValidation.highlighting.fixes.BaseBVQuickFix;
import com.intellij.beanValidation.resources.BVBundle;
import com.intellij.beanValidation.resources.BVInspectionBundle;
import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class CreateEnumConstantFix
extends BaseBVQuickFix {
    @NotNull
    private final SmartPsiElementPointer<PsiClass> myEnumPointer;
    private final String myConstantName;

    public CreateEnumConstantFix(PsiClass psiClass, String val) {
        super(BVBundle.message("create.enum.constant", new Object[0]));
        this.myEnumPointer = SmartPointerManager.createPointer((PsiElement)psiClass);
        this.myConstantName = val;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        PsiClass psiClass;
        if (project == null) {
            CreateEnumConstantFix.$$$reportNull$$$0(0);
        }
        if (descriptor == null) {
            CreateEnumConstantFix.$$$reportNull$$$0(1);
        }
        if ((psiClass = (PsiClass)this.myEnumPointer.getElement()) == null) {
            return;
        }
        assert (psiClass.isEnum()) : "Must be enum";
        try {
            PsiEnumConstant enumConstant = JavaPsiFacade.getInstance((Project)psiClass.getProject()).getElementFactory().createEnumConstantFromText(this.myConstantName, null);
            psiClass.add((PsiElement)enumConstant);
        }
        catch (IncorrectOperationException incorrectOperationException) {
            // empty catch block
        }
    }

    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull ProblemDescriptor previewDescriptor) {
        if (project == null) {
            CreateEnumConstantFix.$$$reportNull$$$0(2);
        }
        if (previewDescriptor == null) {
            CreateEnumConstantFix.$$$reportNull$$$0(3);
        }
        return new IntentionPreviewInfo.Html(BVInspectionBundle.message("create.enum.constant", this.myConstantName, ((PsiClass)this.myEnumPointer.getElement()).getQualifiedName()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "previewDescriptor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/beanValidation/highlighting/fixes/CreateEnumConstantFix";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "applyFix";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "generatePreview";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

