/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.beanValidation.highlighting.fixes;

import com.intellij.beanValidation.highlighting.fixes.BaseBVQuickFix;
import com.intellij.beanValidation.resources.BVInspectionBundle;
import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import org.jetbrains.annotations.NotNull;

public class SwapMinMax
extends BaseBVQuickFix {
    private final SmartPsiElementPointer<PsiElement> minElementPointer;
    private final SmartPsiElementPointer<PsiElement> maxElementPointer;
    private final Integer myMin;
    private final Integer myMax;

    public SwapMinMax(PsiElement minElement, PsiElement maxElement, Integer min, Integer max) {
        super(BVInspectionBundle.message("swap.min.max", new Object[0]));
        this.minElementPointer = SmartPointerManager.createPointer((PsiElement)minElement);
        this.maxElementPointer = SmartPointerManager.createPointer((PsiElement)maxElement);
        this.myMin = min;
        this.myMax = max;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            SwapMinMax.$$$reportNull$$$0(0);
        }
        if (descriptor == null) {
            SwapMinMax.$$$reportNull$$$0(1);
        }
        PsiElement maxElement = this.maxElementPointer.getElement();
        PsiElement minElement = this.minElementPointer.getElement();
        if (maxElement == null || minElement == null) {
            return;
        }
        PsiElement maxCopy = maxElement.copy();
        PsiElement minCopy = minElement.copy();
        maxElement.replace(minCopy);
        minElement.replace(maxCopy);
    }

    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull ProblemDescriptor previewDescriptor) {
        if (project == null) {
            SwapMinMax.$$$reportNull$$$0(2);
        }
        if (previewDescriptor == null) {
            SwapMinMax.$$$reportNull$$$0(3);
        }
        return new IntentionPreviewInfo.Html(BVInspectionBundle.message("swap.min.max.quick.fix", this.myMax, this.myMin));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "previewDescriptor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/beanValidation/highlighting/fixes/SwapMinMax";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "applyFix";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "generatePreview";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

