/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.intellij.plugin.action.lombok;

import com.intellij.openapi.ui.Messages;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.refactoring.rename.RenameProcessor;
import de.plushnikov.intellij.plugin.LombokBundle;
import de.plushnikov.intellij.plugin.action.lombok.BaseLombokHandler;
import de.plushnikov.intellij.plugin.processor.LombokProcessorManager;
import de.plushnikov.intellij.plugin.processor.clazz.log.AbstractLogProcessor;
import java.util.Arrays;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public final class LombokLoggerHandler
extends BaseLombokHandler {
    @Override
    protected void processClass(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            LombokLoggerHandler.$$$reportNull$$$0(0);
        }
        LombokProcessorManager manager = LombokProcessorManager.getInstance();
        List<AbstractLogProcessor> logProcessors = Arrays.asList(manager.getCommonsLogProcessor(), manager.getJBossLogProcessor(), manager.getLog4jProcessor(), manager.getLog4j2Processor(), manager.getLogProcessor(), manager.getSlf4jProcessor(), manager.getXSlf4jProcessor(), manager.getFloggerProcessor(), manager.getCustomLogProcessor());
        String lombokLoggerName = AbstractLogProcessor.getLoggerName(psiClass);
        boolean lombokLoggerIsStatic = AbstractLogProcessor.isLoggerStatic(psiClass);
        for (AbstractLogProcessor logProcessor : logProcessors) {
            String loggerType = logProcessor.getLoggerType(psiClass);
            if (loggerType == null) continue;
            for (PsiField psiField : psiClass.getFields()) {
                if (!psiField.getType().equalsToText(loggerType) || !LombokLoggerHandler.checkLoggerField(psiField, lombokLoggerName, lombokLoggerIsStatic)) continue;
                LombokLoggerHandler.processLoggerField(psiField, psiClass, logProcessor, lombokLoggerName);
            }
        }
    }

    private static void processLoggerField(@NotNull PsiField psiField, @NotNull PsiClass psiClass, @NotNull AbstractLogProcessor logProcessor, @NotNull String lombokLoggerName) {
        if (psiField == null) {
            LombokLoggerHandler.$$$reportNull$$$0(1);
        }
        if (psiClass == null) {
            LombokLoggerHandler.$$$reportNull$$$0(2);
        }
        if (logProcessor == null) {
            LombokLoggerHandler.$$$reportNull$$$0(3);
        }
        if (lombokLoggerName == null) {
            LombokLoggerHandler.$$$reportNull$$$0(4);
        }
        if (!lombokLoggerName.equals(psiField.getName())) {
            RenameProcessor processor = new RenameProcessor(psiField.getProject(), (PsiElement)psiField, lombokLoggerName, false, false);
            processor.doRun();
        }
        LombokLoggerHandler.addAnnotation(psiClass, logProcessor.getSupportedAnnotationClasses()[0]);
        psiField.delete();
    }

    private static boolean checkLoggerField(@NotNull PsiField psiField, @NotNull String lombokLoggerName, boolean lombokLoggerIsStatic) {
        if (psiField == null) {
            LombokLoggerHandler.$$$reportNull$$$0(5);
        }
        if (lombokLoggerName == null) {
            LombokLoggerHandler.$$$reportNull$$$0(6);
        }
        if (!LombokLoggerHandler.isValidLoggerField(psiField, lombokLoggerName, lombokLoggerIsStatic)) {
            String messageText = LombokBundle.message("dialog.message.logger.field.s.not.private.sfinal.field.named.s.refactor.anyway", psiField.getName(), lombokLoggerIsStatic ? 1 : 0, lombokLoggerName);
            int result = Messages.showOkCancelDialog((String)messageText, (String)LombokBundle.message("dialog.title.attention", new Object[0]), (String)Messages.getOkButton(), (String)Messages.getCancelButton(), (Icon)Messages.getQuestionIcon());
            return 0 == result;
        }
        return true;
    }

    private static boolean isValidLoggerField(@NotNull PsiField psiField, @NotNull String lombokLoggerName, boolean lombokLoggerIsStatic) {
        if (psiField == null) {
            LombokLoggerHandler.$$$reportNull$$$0(7);
        }
        if (lombokLoggerName == null) {
            LombokLoggerHandler.$$$reportNull$$$0(8);
        }
        boolean isPrivate = psiField.hasModifierProperty("private");
        boolean isStatic = lombokLoggerIsStatic == psiField.hasModifierProperty("static");
        boolean isFinal = psiField.hasModifierProperty("final");
        boolean isProperlyNamed = lombokLoggerName.equals(psiField.getName());
        return isPrivate && isStatic && isFinal && isProperlyNamed;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 1: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiField";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logProcessor";
                break;
            }
            case 4: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lombokLoggerName";
                break;
            }
        }
        objectArray2[1] = "de/plushnikov/intellij/plugin/action/lombok/LombokLoggerHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "processClass";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "processLoggerField";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "checkLoggerField";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "isValidLoggerField";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

