/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.intellij.plugin.handler;

import com.intellij.codeInsight.daemon.JavaErrorBundle;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationParameterList;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNameValuePair;
import java.util.Arrays;
import java.util.Collection;
import java.util.regex.Pattern;

public final class OnXAnnotationHandler {
    private static final Pattern LOMBOK_ANY_ANNOTATION_REQUIRED = Pattern.compile(JavaErrorBundle.message((String)"incompatible.types", (Object[])new Object[]{"lombok.*AnyAnnotation\\[\\]", "__*"}));
    private static final Pattern CANNOT_RESOLVE_SYMBOL_UNDERSCORES_MESSAGE = Pattern.compile(JavaErrorBundle.message((String)"cannot.resolve.symbol", (Object[])new Object[]{"__*"}));
    private static final String ANNOTATION_TYPE_EXPECTED = JavaErrorBundle.message((String)"annotation.annotation.type.expected", (Object[])new Object[0]);
    private static final Collection<String> ONXABLE_ANNOTATIONS = Arrays.asList("lombok.Getter", "lombok.Setter", "lombok.With", "lombok.experimental.Wither", "lombok.NoArgsConstructor", "lombok.RequiredArgsConstructor", "lombok.AllArgsConstructor", "lombok.EqualsAndHashCode");
    private static final Collection<String> ONX_PARAMETERS = Arrays.asList("onConstructor", "onMethod", "onParam");

    public static boolean isOnXParameterAnnotation(HighlightInfo highlightInfo, PsiFile file) {
        String description = StringUtil.notNullize((String)highlightInfo.getDescription());
        if (!(ANNOTATION_TYPE_EXPECTED.equals(description) || CANNOT_RESOLVE_SYMBOL_UNDERSCORES_MESSAGE.matcher(description).matches() || LOMBOK_ANY_ANNOTATION_REQUIRED.matcher(description).matches())) {
            return false;
        }
        PsiElement highlightedElement = file.findElementAt(highlightInfo.getStartOffset());
        PsiNameValuePair nameValuePair = OnXAnnotationHandler.findContainingNameValuePair(highlightedElement);
        if (nameValuePair == null || !(nameValuePair.getContext() instanceof PsiAnnotationParameterList)) {
            return false;
        }
        String parameterName = nameValuePair.getName();
        if (null != parameterName && parameterName.contains("_")) {
            parameterName = parameterName.substring(0, parameterName.indexOf(95));
        }
        if (!ONX_PARAMETERS.contains(parameterName)) {
            return false;
        }
        PsiElement containingAnnotation = nameValuePair.getContext().getContext();
        return containingAnnotation instanceof PsiAnnotation && ONXABLE_ANNOTATIONS.contains(((PsiAnnotation)containingAnnotation).getQualifiedName());
    }

    private static PsiNameValuePair findContainingNameValuePair(PsiElement highlightedElement) {
        PsiElement nameValuePair;
        for (nameValuePair = highlightedElement; nameValuePair != null && !(nameValuePair instanceof PsiNameValuePair); nameValuePair = nameValuePair.getContext()) {
        }
        return (PsiNameValuePair)nameValuePair;
    }
}

