/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.intellij.plugin.inspection;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.RemoveAnnotationQuickFix;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.JavaPsiConstructorUtil;
import de.plushnikov.intellij.plugin.LombokBundle;
import de.plushnikov.intellij.plugin.inspection.LombokJavaInspectionBase;
import de.plushnikov.intellij.plugin.problem.LombokProblem;
import de.plushnikov.intellij.plugin.problem.LombokProblemInstance;
import de.plushnikov.intellij.plugin.processor.LombokProcessorManager;
import de.plushnikov.intellij.plugin.processor.Processor;
import de.plushnikov.intellij.plugin.processor.ValProcessor;
import de.plushnikov.intellij.plugin.psi.LombokLightMethodBuilder;
import de.plushnikov.intellij.plugin.quickfix.PsiQuickFixFactory;
import de.plushnikov.intellij.plugin.util.PsiAnnotationSearchUtil;
import java.util.Collection;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public final class LombokInspection
extends LombokJavaInspectionBase {
    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            LombokInspection.$$$reportNull$$$0(0);
        }
        return new LombokElementVisitor(holder);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "de/plushnikov/intellij/plugin/inspection/LombokInspection", "createVisitor"));
    }

    private static class LombokElementVisitor
    extends JavaElementVisitor {
        private static final ValProcessor valProcessor = new ValProcessor();
        private final ProblemsHolder holder;

        LombokElementVisitor(ProblemsHolder holder) {
            this.holder = holder;
        }

        public void visitLocalVariable(@NotNull PsiLocalVariable variable) {
            if (variable == null) {
                LombokElementVisitor.$$$reportNull$$$0(0);
            }
            super.visitLocalVariable(variable);
            valProcessor.verifyVariable(variable, this.holder);
        }

        public void visitParameter(@NotNull PsiParameter parameter) {
            if (parameter == null) {
                LombokElementVisitor.$$$reportNull$$$0(1);
            }
            super.visitParameter(parameter);
            valProcessor.verifyParameter(parameter, this.holder);
        }

        public void visitAnnotation(@NotNull PsiAnnotation annotation) {
            if (annotation == null) {
                LombokElementVisitor.$$$reportNull$$$0(2);
            }
            super.visitAnnotation(annotation);
            HashSet<LombokProblem> problems = new HashSet<LombokProblem>();
            for (Processor inspector : LombokProcessorManager.getProcessors(annotation)) {
                problems.addAll(inspector.verifyAnnotation(annotation));
            }
            LombokElementVisitor.doAdditionalVerifications(annotation, problems);
            for (LombokProblem problem : problems) {
                this.holder.registerProblem((PsiElement)annotation, problem.getMessage(), problem.getHighlightType(), problem.getQuickFixes());
            }
        }

        private static void doAdditionalVerifications(@NotNull PsiAnnotation annotation, @NotNull Collection<LombokProblem> problems) {
            if (annotation == null) {
                LombokElementVisitor.$$$reportNull$$$0(3);
            }
            if (problems == null) {
                LombokElementVisitor.$$$reportNull$$$0(4);
            }
            LombokElementVisitor.verifyBuilderDefault(annotation, problems);
            LombokElementVisitor.verifySneakyThrows(annotation, problems);
        }

        private static void verifyBuilderDefault(@NotNull PsiAnnotation annotation, @NotNull Collection<LombokProblem> problems) {
            PsiClass parentOfAnnotation;
            if (annotation == null) {
                LombokElementVisitor.$$$reportNull$$$0(5);
            }
            if (problems == null) {
                LombokElementVisitor.$$$reportNull$$$0(6);
            }
            if (annotation.hasQualifiedName("lombok.Builder.Default") && null != (parentOfAnnotation = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)annotation, PsiClass.class)) && !PsiAnnotationSearchUtil.isAnnotatedWith((PsiModifierListOwner)parentOfAnnotation, "lombok.Builder") && !PsiAnnotationSearchUtil.isAnnotatedWith((PsiModifierListOwner)parentOfAnnotation, "lombok.experimental.SuperBuilder")) {
                LombokProblemInstance problemInstance = new LombokProblemInstance(LombokBundle.message("inspection.message.builder.default.requires.builder.annotation", new Object[0]), ProblemHighlightType.GENERIC_ERROR);
                problemInstance.withLocalQuickFixes(() -> PsiQuickFixFactory.createAddAnnotationFix("lombok.Builder", (PsiModifierListOwner)parentOfAnnotation), () -> PsiQuickFixFactory.createAddAnnotationFix("lombok.experimental.SuperBuilder", (PsiModifierListOwner)parentOfAnnotation));
                problems.add(problemInstance);
            }
        }

        private static void verifySneakyThrows(@NotNull PsiAnnotation annotation, @NotNull Collection<LombokProblem> problems) {
            PsiMethodCallExpression thisOrSuperCallInConstructor;
            PsiMethod parentOfAnnotation;
            if (annotation == null) {
                LombokElementVisitor.$$$reportNull$$$0(7);
            }
            if (problems == null) {
                LombokElementVisitor.$$$reportNull$$$0(8);
            }
            if (annotation.hasQualifiedName("lombok.SneakyThrows") && null != (parentOfAnnotation = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)annotation, PsiMethod.class)) && parentOfAnnotation.isConstructor() && null != (thisOrSuperCallInConstructor = JavaPsiConstructorUtil.findThisOrSuperCallInConstructor((PsiMethod)parentOfAnnotation)) && parentOfAnnotation.getBody().getStatementCount() == 1) {
                LombokProblemInstance problemInstance = new LombokProblemInstance(LombokBundle.message("inspection.message.sneakythrows.calls.to.sibling.super.constructors.excluded", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
                problemInstance.withLocalQuickFixes(() -> new RemoveAnnotationQuickFix(annotation, (PsiModifierListOwner)parentOfAnnotation));
                problems.add(problemInstance);
            }
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression methodCall) {
            JavaResolveResult[] results;
            JavaResolveResult resolveResult;
            PsiElement resolved;
            if (methodCall == null) {
                LombokElementVisitor.$$$reportNull$$$0(9);
            }
            super.visitMethodCallExpression(methodCall);
            PsiExpressionList list = methodCall.getArgumentList();
            PsiReferenceExpression referenceToMethod = methodCall.getMethodExpression();
            boolean isThisOrSuper = referenceToMethod.getReferenceNameElement() instanceof PsiKeyword;
            int parameterCount = list.getExpressions().length;
            if (isThisOrSuper && parameterCount == 0 && (resolved = (resolveResult = (results = referenceToMethod.multiResolve(true)).length == 1 ? results[0] : JavaResolveResult.EMPTY).getElement()) instanceof LombokLightMethodBuilder && ((LombokLightMethodBuilder)resolved).getParameterList().getParameters().length != 0) {
                this.holder.registerProblem((PsiElement)methodCall, LombokBundle.message("inspection.message.default.constructor.doesn.t.exist", new Object[0]), ProblemHighlightType.ERROR, new LocalQuickFix[0]);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "variable";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameter";
                    break;
                }
                case 2: 
                case 3: 
                case 5: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "annotation";
                    break;
                }
                case 4: 
                case 6: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "problems";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "methodCall";
                    break;
                }
            }
            objectArray2[1] = "de/plushnikov/intellij/plugin/inspection/LombokInspection$LombokElementVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitLocalVariable";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitParameter";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitAnnotation";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "doAdditionalVerifications";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "verifyBuilderDefault";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "verifySneakyThrows";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitMethodCallExpression";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

