/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.intellij.plugin.processor.clazz;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import de.plushnikov.intellij.plugin.problem.ProblemProcessingSink;
import de.plushnikov.intellij.plugin.problem.ProblemSink;
import de.plushnikov.intellij.plugin.processor.LombokProcessorManager;
import de.plushnikov.intellij.plugin.processor.LombokPsiElementUsage;
import de.plushnikov.intellij.plugin.processor.clazz.AbstractClassProcessor;
import de.plushnikov.intellij.plugin.processor.clazz.EqualsAndHashCodeProcessor;
import de.plushnikov.intellij.plugin.processor.clazz.GetterProcessor;
import de.plushnikov.intellij.plugin.processor.clazz.SetterProcessor;
import de.plushnikov.intellij.plugin.processor.clazz.ToStringProcessor;
import de.plushnikov.intellij.plugin.processor.clazz.constructor.NoArgsConstructorProcessor;
import de.plushnikov.intellij.plugin.processor.clazz.constructor.RequiredArgsConstructorProcessor;
import de.plushnikov.intellij.plugin.util.PsiAnnotationSearchUtil;
import de.plushnikov.intellij.plugin.util.PsiAnnotationUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DataProcessor
extends AbstractClassProcessor {
    public DataProcessor() {
        super((Class<? extends PsiElement>)PsiMethod.class, "lombok.Data");
    }

    private static ToStringProcessor getToStringProcessor() {
        return LombokProcessorManager.getInstance().getToStringProcessor();
    }

    private static NoArgsConstructorProcessor getNoArgsConstructorProcessor() {
        return LombokProcessorManager.getInstance().getNoArgsConstructorProcessor();
    }

    private static GetterProcessor getGetterProcessor() {
        return LombokProcessorManager.getInstance().getGetterProcessor();
    }

    private static SetterProcessor getSetterProcessor() {
        return LombokProcessorManager.getInstance().getSetterProcessor();
    }

    private static EqualsAndHashCodeProcessor getEqualsAndHashCodeProcessor() {
        return LombokProcessorManager.getInstance().getEqualsAndHashCodeProcessor();
    }

    private static RequiredArgsConstructorProcessor getRequiredArgsConstructorProcessor() {
        return LombokProcessorManager.getInstance().getRequiredArgsConstructorProcessor();
    }

    @Override
    protected boolean possibleToGenerateElementNamed(@NotNull String nameHint, @NotNull PsiClass psiClass, @NotNull PsiAnnotation psiAnnotation) {
        if (nameHint == null) {
            DataProcessor.$$$reportNull$$$0(0);
        }
        if (psiClass == null) {
            DataProcessor.$$$reportNull$$$0(1);
        }
        if (psiAnnotation == null) {
            DataProcessor.$$$reportNull$$$0(2);
        }
        return nameHint.equals(DataProcessor.getStaticConstructorNameValue(psiAnnotation)) || DataProcessor.getNoArgsConstructorProcessor().possibleToGenerateElementNamed(nameHint, psiClass, psiAnnotation) || DataProcessor.getToStringProcessor().possibleToGenerateElementNamed(nameHint, psiClass, psiAnnotation) || DataProcessor.getEqualsAndHashCodeProcessor().possibleToGenerateElementNamed(nameHint, psiClass, psiAnnotation) || DataProcessor.getGetterProcessor().possibleToGenerateElementNamed(nameHint, psiClass, psiAnnotation) || DataProcessor.getSetterProcessor().possibleToGenerateElementNamed(nameHint, psiClass, psiAnnotation);
    }

    @Override
    protected Collection<String> getNamesOfPossibleGeneratedElements(@NotNull PsiClass psiClass, @NotNull PsiAnnotation psiAnnotation) {
        if (psiClass == null) {
            DataProcessor.$$$reportNull$$$0(3);
        }
        if (psiAnnotation == null) {
            DataProcessor.$$$reportNull$$$0(4);
        }
        ArrayList<String> result = new ArrayList<String>();
        String staticConstructorName = DataProcessor.getStaticConstructorNameValue(psiAnnotation);
        if (StringUtil.isNotEmpty((String)staticConstructorName)) {
            result.add(staticConstructorName);
        }
        result.addAll(DataProcessor.getNoArgsConstructorProcessor().getNamesOfPossibleGeneratedElements(psiClass, psiAnnotation));
        result.addAll(DataProcessor.getToStringProcessor().getNamesOfPossibleGeneratedElements(psiClass, psiAnnotation));
        result.addAll(DataProcessor.getEqualsAndHashCodeProcessor().getNamesOfPossibleGeneratedElements(psiClass, psiAnnotation));
        result.addAll(DataProcessor.getGetterProcessor().getNamesOfPossibleGeneratedElements(psiClass, psiAnnotation));
        result.addAll(DataProcessor.getSetterProcessor().getNamesOfPossibleGeneratedElements(psiClass, psiAnnotation));
        return result;
    }

    private static String getStaticConstructorNameValue(@NotNull PsiAnnotation psiAnnotation) {
        if (psiAnnotation == null) {
            DataProcessor.$$$reportNull$$$0(5);
        }
        return PsiAnnotationUtil.getStringAnnotationValue(psiAnnotation, "staticConstructor", "");
    }

    @Override
    protected boolean validate(@NotNull PsiAnnotation psiAnnotation, @NotNull PsiClass psiClass, @NotNull ProblemSink builder) {
        if (psiAnnotation == null) {
            DataProcessor.$$$reportNull$$$0(6);
        }
        if (psiClass == null) {
            DataProcessor.$$$reportNull$$$0(7);
        }
        if (builder == null) {
            DataProcessor.$$$reportNull$$$0(8);
        }
        DataProcessor.validateAnnotationOnRightType(psiClass, builder);
        if (builder.deepValidation()) {
            String staticName;
            boolean hasNoEqualsAndHashCodeAnnotation = PsiAnnotationSearchUtil.isNotAnnotatedWith((PsiModifierListOwner)psiClass, "lombok.EqualsAndHashCode");
            if (hasNoEqualsAndHashCodeAnnotation) {
                DataProcessor.getEqualsAndHashCodeProcessor().validateCallSuperParamExtern(psiAnnotation, psiClass, builder);
            }
            if (DataProcessor.shouldGenerateRequiredArgsConstructor(psiClass, staticName = DataProcessor.getStaticConstructorNameValue(psiAnnotation))) {
                DataProcessor.getRequiredArgsConstructorProcessor().validateBaseClassConstructor(psiClass, builder);
            }
        }
        return builder.success();
    }

    private static void validateAnnotationOnRightType(@NotNull PsiClass psiClass, @NotNull ProblemSink builder) {
        if (psiClass == null) {
            DataProcessor.$$$reportNull$$$0(9);
        }
        if (builder == null) {
            DataProcessor.$$$reportNull$$$0(10);
        }
        if (psiClass.isAnnotationType() || psiClass.isInterface() || psiClass.isEnum() || psiClass.isRecord()) {
            builder.addErrorMessage("inspection.message.data.only.supported.on.class.type", new Object[0]);
            builder.markFailed();
        }
    }

    @Override
    protected void generatePsiElements(@NotNull PsiClass psiClass, @NotNull PsiAnnotation psiAnnotation, @NotNull List<? super PsiElement> target, @Nullable String nameHint) {
        boolean hasConstructorWithoutParameters;
        if (psiClass == null) {
            DataProcessor.$$$reportNull$$$0(11);
        }
        if (psiAnnotation == null) {
            DataProcessor.$$$reportNull$$$0(12);
        }
        if (target == null) {
            DataProcessor.$$$reportNull$$$0(13);
        }
        if (PsiAnnotationSearchUtil.isNotAnnotatedWith((PsiModifierListOwner)psiClass, "lombok.Getter")) {
            target.addAll(DataProcessor.getGetterProcessor().createFieldGetters(psiClass, "public", nameHint));
        }
        if (PsiAnnotationSearchUtil.isNotAnnotatedWith((PsiModifierListOwner)psiClass, "lombok.Setter")) {
            target.addAll(DataProcessor.getSetterProcessor().createFieldSetters(psiClass, "public", nameHint));
        }
        if (PsiAnnotationSearchUtil.isNotAnnotatedWith((PsiModifierListOwner)psiClass, "lombok.EqualsAndHashCode") && DataProcessor.getEqualsAndHashCodeProcessor().noHintOrPossibleToGenerateElementNamed(nameHint, psiClass, psiAnnotation)) {
            target.addAll(DataProcessor.getEqualsAndHashCodeProcessor().createEqualAndHashCode(psiClass, psiAnnotation));
        }
        if (PsiAnnotationSearchUtil.isNotAnnotatedWith((PsiModifierListOwner)psiClass, "lombok.ToString") && DataProcessor.getToStringProcessor().noHintOrPossibleToGenerateElementNamed(nameHint, psiClass, psiAnnotation)) {
            target.addAll(DataProcessor.getToStringProcessor().createToStringMethod(psiClass, psiAnnotation));
        }
        String staticName = DataProcessor.getStaticConstructorNameValue(psiAnnotation);
        if (nameHint != null && !nameHint.equals(staticName) && !nameHint.equals(psiClass.getName())) {
            return;
        }
        if (DataProcessor.shouldGenerateRequiredArgsConstructor(psiClass, staticName)) {
            target.addAll(DataProcessor.getRequiredArgsConstructorProcessor().createRequiredArgsConstructor(psiClass, "public", psiAnnotation, staticName, true));
            hasConstructorWithoutParameters = DataProcessor.getRequiredArgsConstructorProcessor().getRequiredFields(psiClass).isEmpty();
        } else {
            hasConstructorWithoutParameters = false;
        }
        if (!hasConstructorWithoutParameters && this.shouldGenerateExtraNoArgsConstructor(psiClass)) {
            target.addAll(DataProcessor.getNoArgsConstructorProcessor().createNoArgsConstructor(psiClass, "private", psiAnnotation, true));
        }
    }

    private static boolean shouldGenerateRequiredArgsConstructor(@NotNull PsiClass psiClass, @Nullable String staticName) {
        if (psiClass == null) {
            DataProcessor.$$$reportNull$$$0(14);
        }
        boolean result = false;
        boolean notAnnotatedWith = PsiAnnotationSearchUtil.isNotAnnotatedWith((PsiModifierListOwner)psiClass, "lombok.NoArgsConstructor", "lombok.RequiredArgsConstructor", "lombok.AllArgsConstructor", "lombok.Builder", "lombok.experimental.SuperBuilder");
        if (notAnnotatedWith) {
            RequiredArgsConstructorProcessor requiredArgsConstructorProcessor = DataProcessor.getRequiredArgsConstructorProcessor();
            Collection<PsiField> requiredFields = requiredArgsConstructorProcessor.getRequiredFields(psiClass);
            result = requiredArgsConstructorProcessor.validateIsConstructorNotDefined(psiClass, staticName, requiredFields, new ProblemProcessingSink());
        }
        return result;
    }

    @Override
    public LombokPsiElementUsage checkFieldUsage(@NotNull PsiField psiField, @NotNull PsiAnnotation psiAnnotation) {
        if (psiField == null) {
            DataProcessor.$$$reportNull$$$0(15);
        }
        if (psiAnnotation == null) {
            DataProcessor.$$$reportNull$$$0(16);
        }
        return LombokPsiElementUsage.READ_WRITE;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameHint";
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 9: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiAnnotation";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiField";
                break;
            }
        }
        objectArray2[1] = "de/plushnikov/intellij/plugin/processor/clazz/DataProcessor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "possibleToGenerateElementNamed";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getNamesOfPossibleGeneratedElements";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getStaticConstructorNameValue";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "validate";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "validateAnnotationOnRightType";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "generatePsiElements";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "shouldGenerateRequiredArgsConstructor";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "checkFieldUsage";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

