/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.intellij.plugin.processor.clazz.constructor;

import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import de.plushnikov.intellij.plugin.problem.ProblemSink;
import de.plushnikov.intellij.plugin.processor.LombokPsiElementUsage;
import de.plushnikov.intellij.plugin.processor.clazz.constructor.AbstractConstructorClassProcessor;
import de.plushnikov.intellij.plugin.quickfix.PsiQuickFixFactory;
import de.plushnikov.intellij.plugin.util.LombokProcessorUtil;
import de.plushnikov.intellij.plugin.util.PsiAnnotationSearchUtil;
import de.plushnikov.intellij.plugin.util.PsiAnnotationUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class NoArgsConstructorProcessor
extends AbstractConstructorClassProcessor {
    public NoArgsConstructorProcessor() {
        super("lombok.NoArgsConstructor", PsiMethod.class);
    }

    @Override
    protected boolean validate(@NotNull PsiAnnotation psiAnnotation, @NotNull PsiClass psiClass, @NotNull ProblemSink problemSink) {
        boolean result;
        if (psiAnnotation == null) {
            NoArgsConstructorProcessor.$$$reportNull$$$0(0);
        }
        if (psiClass == null) {
            NoArgsConstructorProcessor.$$$reportNull$$$0(1);
        }
        if (problemSink == null) {
            NoArgsConstructorProcessor.$$$reportNull$$$0(2);
        }
        if ((result = super.validate(psiAnnotation, psiClass, problemSink)) && !NoArgsConstructorProcessor.isForceConstructor(psiAnnotation)) {
            Collection<PsiField> requiredFields;
            String staticConstructorName = this.getStaticConstructorName(psiAnnotation);
            result = this.validateIsConstructorNotDefined(psiClass, staticConstructorName, Collections.emptyList(), problemSink);
            if (problemSink.deepValidation() && !(requiredFields = this.getRequiredFields(psiClass, true)).isEmpty()) {
                problemSink.addErrorMessage("inspection.message.constructor.noargs.needs.to.be.forced", new Object[0]).withLocalQuickFixes(() -> PsiQuickFixFactory.createChangeAnnotationParameterFix(psiAnnotation, "force", "true"));
            }
        }
        return result;
    }

    @NotNull
    public Collection<PsiMethod> createNoArgsConstructor(@NotNull PsiClass psiClass, @NotNull String methodVisibility, @NotNull PsiAnnotation psiAnnotation) {
        if (psiClass == null) {
            NoArgsConstructorProcessor.$$$reportNull$$$0(3);
        }
        if (methodVisibility == null) {
            NoArgsConstructorProcessor.$$$reportNull$$$0(4);
        }
        if (psiAnnotation == null) {
            NoArgsConstructorProcessor.$$$reportNull$$$0(5);
        }
        boolean forceConstructorWithJavaDefaults = NoArgsConstructorProcessor.isForceConstructor(psiAnnotation);
        Collection<PsiMethod> collection = this.createNoArgsConstructor(psiClass, methodVisibility, psiAnnotation, forceConstructorWithJavaDefaults);
        if (collection == null) {
            NoArgsConstructorProcessor.$$$reportNull$$$0(6);
        }
        return collection;
    }

    @NotNull
    public Collection<PsiMethod> createNoArgsConstructor(@NotNull PsiClass psiClass, @NotNull String methodVisibility, @NotNull PsiAnnotation psiAnnotation, boolean withJavaDefaults) {
        if (psiClass == null) {
            NoArgsConstructorProcessor.$$$reportNull$$$0(7);
        }
        if (methodVisibility == null) {
            NoArgsConstructorProcessor.$$$reportNull$$$0(8);
        }
        if (psiAnnotation == null) {
            NoArgsConstructorProcessor.$$$reportNull$$$0(9);
        }
        Collection<PsiField> params = this.getConstructorFields(psiClass, withJavaDefaults);
        Collection<PsiMethod> collection = this.createConstructorMethod(psiClass, methodVisibility, psiAnnotation, withJavaDefaults, params);
        if (collection == null) {
            NoArgsConstructorProcessor.$$$reportNull$$$0(10);
        }
        return collection;
    }

    private static boolean isForceConstructor(@NotNull PsiAnnotation psiAnnotation) {
        if (psiAnnotation == null) {
            NoArgsConstructorProcessor.$$$reportNull$$$0(11);
        }
        return PsiAnnotationUtil.getBooleanAnnotationValue(psiAnnotation, "force", false);
    }

    @Override
    protected void generatePsiElements(@NotNull PsiClass psiClass, @NotNull PsiAnnotation psiAnnotation, @NotNull List<? super PsiElement> target, @Nullable String nameHint) {
        String methodVisibility;
        if (psiClass == null) {
            NoArgsConstructorProcessor.$$$reportNull$$$0(12);
        }
        if (psiAnnotation == null) {
            NoArgsConstructorProcessor.$$$reportNull$$$0(13);
        }
        if (target == null) {
            NoArgsConstructorProcessor.$$$reportNull$$$0(14);
        }
        if (null != (methodVisibility = LombokProcessorUtil.getAccessVisibility(psiAnnotation))) {
            target.addAll(this.createNoArgsConstructor(psiClass, methodVisibility, psiAnnotation));
        }
    }

    @Override
    public LombokPsiElementUsage checkFieldUsage(@NotNull PsiField psiField, @NotNull PsiAnnotation psiAnnotation) {
        boolean classAnnotatedWithValue;
        PsiClass containingClass;
        boolean forceConstructorWithJavaDefaults;
        if (psiField == null) {
            NoArgsConstructorProcessor.$$$reportNull$$$0(15);
        }
        if (psiAnnotation == null) {
            NoArgsConstructorProcessor.$$$reportNull$$$0(16);
        }
        if ((forceConstructorWithJavaDefaults = NoArgsConstructorProcessor.isForceConstructor(psiAnnotation)) && null != (containingClass = psiField.getContainingClass()) && NoArgsConstructorProcessor.isRequiredField(psiField, false, classAnnotatedWithValue = PsiAnnotationSearchUtil.isAnnotatedWith((PsiModifierListOwner)containingClass, "lombok.Value"))) {
            return LombokPsiElementUsage.WRITE;
        }
        return LombokPsiElementUsage.NONE;
    }

    @NotNull
    private Collection<PsiField> getConstructorFields(PsiClass containingClass, boolean forceConstructorWithJavaDefaults) {
        Collection<PsiField> params = forceConstructorWithJavaDefaults ? this.getRequiredFields(containingClass) : Collections.emptyList();
        List<PsiField> list = params;
        if (list == null) {
            NoArgsConstructorProcessor.$$$reportNull$$$0(17);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 10, 17 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiAnnotation";
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problemSink";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodVisibility";
                break;
            }
            case 6: 
            case 10: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "de/plushnikov/intellij/plugin/processor/clazz/constructor/NoArgsConstructorProcessor";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiField";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "de/plushnikov/intellij/plugin/processor/clazz/constructor/NoArgsConstructorProcessor";
                break;
            }
            case 6: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createNoArgsConstructor";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getConstructorFields";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "validate";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createNoArgsConstructor";
                break;
            }
            case 6: 
            case 10: 
            case 17: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isForceConstructor";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "generatePsiElements";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "checkFieldUsage";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 10, 17 -> new IllegalStateException(string);
        };
    }
}

