/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.intellij.plugin.processor.clazz.log;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiType;
import de.plushnikov.intellij.plugin.lombokconfig.ConfigDiscovery;
import de.plushnikov.intellij.plugin.lombokconfig.ConfigKey;
import de.plushnikov.intellij.plugin.problem.ProblemSink;
import de.plushnikov.intellij.plugin.processor.clazz.AbstractClassProcessor;
import de.plushnikov.intellij.plugin.psi.LombokLightFieldBuilder;
import de.plushnikov.intellij.plugin.util.PsiAnnotationUtil;
import de.plushnikov.intellij.plugin.util.PsiClassUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractLogProcessor
extends AbstractClassProcessor {
    AbstractLogProcessor(@NotNull String supportedAnnotationClass) {
        if (supportedAnnotationClass == null) {
            AbstractLogProcessor.$$$reportNull$$$0(0);
        }
        super((Class<? extends PsiElement>)PsiField.class, supportedAnnotationClass);
    }

    @Override
    protected Collection<String> getNamesOfPossibleGeneratedElements(@NotNull PsiClass psiClass, @NotNull PsiAnnotation psiAnnotation) {
        if (psiClass == null) {
            AbstractLogProcessor.$$$reportNull$$$0(1);
        }
        if (psiAnnotation == null) {
            AbstractLogProcessor.$$$reportNull$$$0(2);
        }
        return Collections.singleton(AbstractLogProcessor.getLoggerName(psiClass));
    }

    @NotNull
    public static String getLoggerName(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            AbstractLogProcessor.$$$reportNull$$$0(3);
        }
        String string = ConfigDiscovery.getInstance().getStringLombokConfigProperty(ConfigKey.LOG_FIELDNAME, psiClass);
        if (string == null) {
            AbstractLogProcessor.$$$reportNull$$$0(4);
        }
        return string;
    }

    public static boolean isLoggerStatic(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            AbstractLogProcessor.$$$reportNull$$$0(5);
        }
        return ConfigDiscovery.getInstance().getBooleanLombokConfigProperty(ConfigKey.LOG_FIELD_IS_STATIC, psiClass);
    }

    @Nullable
    public abstract String getLoggerType(@NotNull PsiClass var1);

    @NotNull
    abstract String getLoggerInitializer(@NotNull PsiClass var1);

    @NotNull
    abstract List<LoggerInitializerParameter> getLoggerInitializerParameters(@NotNull PsiClass var1, boolean var2);

    @Override
    protected boolean validate(@NotNull PsiAnnotation psiAnnotation, @NotNull PsiClass psiClass, @NotNull ProblemSink builder) {
        String loggerName;
        if (psiAnnotation == null) {
            AbstractLogProcessor.$$$reportNull$$$0(6);
        }
        if (psiClass == null) {
            AbstractLogProcessor.$$$reportNull$$$0(7);
        }
        if (builder == null) {
            AbstractLogProcessor.$$$reportNull$$$0(8);
        }
        boolean result = true;
        if (psiClass.isInterface() || psiClass.isAnnotationType()) {
            builder.addErrorMessage("inspection.message.s.legal.only.on.classes.enums", this.getSupportedAnnotationClasses()[0]);
            result = false;
        }
        if (result && AbstractLogProcessor.hasFieldByName(psiClass, loggerName = AbstractLogProcessor.getLoggerName(psiClass))) {
            builder.addErrorMessage("inspection.message.not.generating.field.s.field.with.same.name.already.exists", loggerName);
            result = false;
        }
        return result;
    }

    @Override
    protected void generatePsiElements(@NotNull PsiClass psiClass, @NotNull PsiAnnotation psiAnnotation, @NotNull List<? super PsiElement> target, @Nullable String nameHint) {
        if (psiClass == null) {
            AbstractLogProcessor.$$$reportNull$$$0(9);
        }
        if (psiAnnotation == null) {
            AbstractLogProcessor.$$$reportNull$$$0(10);
        }
        if (target == null) {
            AbstractLogProcessor.$$$reportNull$$$0(11);
        }
        target.add((PsiElement)this.createLoggerField(psiClass, psiAnnotation));
    }

    private LombokLightFieldBuilder createLoggerField(@NotNull PsiClass psiClass, @NotNull PsiAnnotation psiAnnotation) {
        if (psiClass == null) {
            AbstractLogProcessor.$$$reportNull$$$0(12);
        }
        if (psiAnnotation == null) {
            AbstractLogProcessor.$$$reportNull$$$0(13);
        }
        Project project = psiClass.getProject();
        PsiManager manager = psiClass.getContainingFile().getManager();
        PsiElementFactory psiElementFactory = JavaPsiFacade.getElementFactory((Project)project);
        String loggerType = this.getLoggerType(psiClass);
        if (loggerType == null) {
            throw new IllegalStateException("Invalid custom log declaration.");
        }
        PsiType psiLoggerType = psiElementFactory.createTypeFromText(loggerType, (PsiElement)psiClass);
        LombokLightFieldBuilder loggerField = new LombokLightFieldBuilder(manager, AbstractLogProcessor.getLoggerName(psiClass), psiLoggerType).withContainingClass(psiClass).withModifier("final").withModifier("private").withNavigationElement((PsiElement)psiAnnotation);
        if (AbstractLogProcessor.isLoggerStatic(psiClass)) {
            loggerField.withModifier("static");
        }
        String loggerInitializerParameters = this.createLoggerInitializeParameters(psiClass, psiAnnotation);
        String initializerText = String.format(this.getLoggerInitializer(psiClass), loggerInitializerParameters);
        PsiExpression initializer = psiElementFactory.createExpressionFromText(initializerText, (PsiElement)psiClass);
        loggerField.setInitializer(initializer);
        return loggerField;
    }

    @NotNull
    private String createLoggerInitializeParameters(@NotNull PsiClass psiClass, @NotNull PsiAnnotation psiAnnotation) {
        if (psiClass == null) {
            AbstractLogProcessor.$$$reportNull$$$0(14);
        }
        if (psiAnnotation == null) {
            AbstractLogProcessor.$$$reportNull$$$0(15);
        }
        StringBuilder parametersBuilder = new StringBuilder();
        String topic = PsiAnnotationUtil.getStringAnnotationValue(psiAnnotation, "topic", "");
        boolean topicPresent = !StringUtil.isEmptyOrSpaces((String)topic);
        List<LoggerInitializerParameter> loggerInitializerParameters = this.getLoggerInitializerParameters(psiClass, topicPresent);
        block6: for (LoggerInitializerParameter loggerInitializerParameter : loggerInitializerParameters) {
            if (parametersBuilder.length() > 0) {
                parametersBuilder.append(", ");
            }
            switch (loggerInitializerParameter) {
                case TYPE: {
                    parametersBuilder.append(psiClass.getName()).append(".class");
                    continue block6;
                }
                case NAME: {
                    parametersBuilder.append(psiClass.getName()).append(".class.getName()");
                    continue block6;
                }
                case TOPIC: {
                    if (!topicPresent) {
                        throw new IllegalStateException("Topic can never be a parameter when topic was not set.");
                    }
                    parametersBuilder.append('\"').append(StringUtil.escapeStringCharacters((String)topic)).append('\"');
                    continue block6;
                }
                case NULL: {
                    parametersBuilder.append("null");
                    continue block6;
                }
            }
            throw new IllegalStateException("Unexpected logger initializer parameter " + loggerInitializerParameter);
        }
        String string = parametersBuilder.toString();
        if (string == null) {
            AbstractLogProcessor.$$$reportNull$$$0(16);
        }
        return string;
    }

    private static boolean hasFieldByName(@NotNull PsiClass psiClass, @NotNull String fieldName) {
        if (psiClass == null) {
            AbstractLogProcessor.$$$reportNull$$$0(17);
        }
        if (fieldName == null) {
            AbstractLogProcessor.$$$reportNull$$$0(18);
        }
        Collection<PsiField> psiFields = PsiClassUtil.collectClassFieldsIntern(psiClass);
        for (PsiField psiField : psiFields) {
            if (!fieldName.equals(psiField.getName())) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 16 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "supportedAnnotationClass";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 12: 
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 2: 
            case 6: 
            case 10: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiAnnotation";
                break;
            }
            case 4: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "de/plushnikov/intellij/plugin/processor/clazz/log/AbstractLogProcessor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "de/plushnikov/intellij/plugin/processor/clazz/log/AbstractLogProcessor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getLoggerName";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createLoggerInitializeParameters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getNamesOfPossibleGeneratedElements";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getLoggerName";
                break;
            }
            case 4: 
            case 16: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isLoggerStatic";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "validate";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "generatePsiElements";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createLoggerField";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createLoggerInitializeParameters";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "hasFieldByName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 16 -> new IllegalStateException(string);
        };
    }

    static enum LoggerInitializerParameter {
        TYPE,
        NAME,
        TOPIC,
        NULL,
        UNKNOWN;


        @NotNull
        static LoggerInitializerParameter find(@NotNull String parameter) {
            if (parameter == null) {
                LoggerInitializerParameter.$$$reportNull$$$0(0);
            }
            LoggerInitializerParameter loggerInitializerParameter = switch (parameter) {
                case "TYPE" -> TYPE;
                case "NAME" -> NAME;
                case "TOPIC" -> TOPIC;
                case "NULL" -> NULL;
                default -> UNKNOWN;
            };
            if (loggerInitializerParameter == null) {
                LoggerInitializerParameter.$$$reportNull$$$0(1);
            }
            return loggerInitializerParameter;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameter";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "de/plushnikov/intellij/plugin/processor/clazz/log/AbstractLogProcessor$LoggerInitializerParameter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "de/plushnikov/intellij/plugin/processor/clazz/log/AbstractLogProcessor$LoggerInitializerParameter";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "find";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "find";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

