/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.intellij.plugin.processor.clazz.log;

import de.plushnikov.intellij.plugin.processor.clazz.log.AbstractLogProcessor;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class CustomLogParser {
    private static final Pattern PARAMETERS_PATTERN = Pattern.compile("(?:\\(([A-Z,]*)\\))");
    private static final Pattern DECLARATION_PATTERN = Pattern.compile("^(?:([^ ]+) )?([^(]+)\\.([^(]+)(" + PARAMETERS_PATTERN.pattern() + "+)$");

    private CustomLogParser() {
        throw new UnsupportedOperationException("Utility class");
    }

    @Nullable
    static String parseLoggerType(@NotNull String customDeclaration) {
        Matcher declarationMatcher;
        if (customDeclaration == null) {
            CustomLogParser.$$$reportNull$$$0(0);
        }
        if (!(declarationMatcher = DECLARATION_PATTERN.matcher(customDeclaration)).matches()) {
            return null;
        }
        String loggerType = declarationMatcher.group(1);
        if (loggerType == null) {
            loggerType = declarationMatcher.group(2);
        }
        return loggerType;
    }

    @Nullable
    static String parseLoggerInitializer(@NotNull String customDeclaration) {
        Matcher declarationMatcher;
        if (customDeclaration == null) {
            CustomLogParser.$$$reportNull$$$0(1);
        }
        if (!(declarationMatcher = DECLARATION_PATTERN.matcher(customDeclaration)).matches()) {
            return null;
        }
        return declarationMatcher.group(2) + "." + declarationMatcher.group(3) + "(%s)";
    }

    @Nullable
    static LoggerInitializerDeclaration parseInitializerParameters(@NotNull String customDeclaration) {
        Matcher declarationMatcher;
        if (customDeclaration == null) {
            CustomLogParser.$$$reportNull$$$0(2);
        }
        if (!(declarationMatcher = DECLARATION_PATTERN.matcher(customDeclaration)).matches()) {
            return null;
        }
        List<AbstractLogProcessor.LoggerInitializerParameter> withTopic = null;
        List<AbstractLogProcessor.LoggerInitializerParameter> withoutTopic = null;
        Matcher allParametersMatcher = PARAMETERS_PATTERN.matcher(declarationMatcher.group(4));
        while (allParametersMatcher.find()) {
            List<AbstractLogProcessor.LoggerInitializerParameter> splitParameters = CustomLogParser.splitParameters(allParametersMatcher.group(1));
            if (splitParameters.contains((Object)AbstractLogProcessor.LoggerInitializerParameter.UNKNOWN)) {
                return null;
            }
            if (splitParameters.contains((Object)AbstractLogProcessor.LoggerInitializerParameter.TOPIC)) {
                if (withTopic != null) {
                    return null;
                }
                withTopic = splitParameters;
                continue;
            }
            if (withoutTopic != null) {
                return null;
            }
            withoutTopic = splitParameters;
        }
        return new LoggerInitializerDeclaration(withTopic, withoutTopic);
    }

    @NotNull
    private static List<AbstractLogProcessor.LoggerInitializerParameter> splitParameters(@NotNull String parameters) {
        if (parameters == null) {
            CustomLogParser.$$$reportNull$$$0(3);
        }
        if (parameters.isEmpty()) {
            List<AbstractLogProcessor.LoggerInitializerParameter> list = Collections.emptyList();
            if (list == null) {
                CustomLogParser.$$$reportNull$$$0(4);
            }
            return list;
        }
        List<AbstractLogProcessor.LoggerInitializerParameter> list = Arrays.stream(parameters.split(",")).map(AbstractLogProcessor.LoggerInitializerParameter::find).collect(Collectors.toList());
        if (list == null) {
            CustomLogParser.$$$reportNull$$$0(5);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "customDeclaration";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "de/plushnikov/intellij/plugin/processor/clazz/log/CustomLogParser";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "de/plushnikov/intellij/plugin/processor/clazz/log/CustomLogParser";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "splitParameters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "parseLoggerType";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "parseLoggerInitializer";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "parseInitializerParameters";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "splitParameters";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5 -> new IllegalStateException(string);
        };
    }

    static class LoggerInitializerDeclaration {
        private final List<AbstractLogProcessor.LoggerInitializerParameter> withTopic;
        private final List<AbstractLogProcessor.LoggerInitializerParameter> withoutTopic;

        LoggerInitializerDeclaration(List<AbstractLogProcessor.LoggerInitializerParameter> withTopic, List<AbstractLogProcessor.LoggerInitializerParameter> withoutTopic) {
            this.withTopic = withTopic;
            this.withoutTopic = withoutTopic;
        }

        boolean hasWithTopic() {
            return this.withTopic != null;
        }

        boolean hasWithoutTopic() {
            return this.withoutTopic != null;
        }

        List<AbstractLogProcessor.LoggerInitializerParameter> get(boolean topicPresent) {
            return topicPresent ? this.withTopic : this.withoutTopic;
        }

        boolean has(boolean topicPresent) {
            return (topicPresent ? this.withTopic : this.withoutTopic) != null;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LoggerInitializerDeclaration that = (LoggerInitializerDeclaration)o;
            return Objects.equals(this.withTopic, that.withTopic) && Objects.equals(this.withoutTopic, that.withoutTopic);
        }

        public int hashCode() {
            return Objects.hash(this.withTopic, this.withoutTopic);
        }
    }
}

