/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.intellij.plugin.processor.field;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.util.containers.ContainerUtil;
import de.plushnikov.intellij.plugin.problem.ProblemSink;
import de.plushnikov.intellij.plugin.processor.LombokPsiElementUsage;
import de.plushnikov.intellij.plugin.processor.field.AbstractFieldProcessor;
import de.plushnikov.intellij.plugin.processor.field.AccessorsInfo;
import de.plushnikov.intellij.plugin.psi.LombokLightMethodBuilder;
import de.plushnikov.intellij.plugin.psi.LombokLightModifierList;
import de.plushnikov.intellij.plugin.quickfix.PsiQuickFixFactory;
import de.plushnikov.intellij.plugin.thirdparty.LombokCopyableAnnotations;
import de.plushnikov.intellij.plugin.thirdparty.LombokUtils;
import de.plushnikov.intellij.plugin.util.LombokProcessorUtil;
import de.plushnikov.intellij.plugin.util.PsiAnnotationSearchUtil;
import de.plushnikov.intellij.plugin.util.PsiAnnotationUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GetterFieldProcessor
extends AbstractFieldProcessor {
    public GetterFieldProcessor() {
        super((Class<? extends PsiElement>)PsiMethod.class, "lombok.Getter");
    }

    @Override
    protected Collection<String> getNamesOfPossibleGeneratedElements(@NotNull PsiClass psiClass, @NotNull PsiAnnotation psiAnnotation, @NotNull PsiField psiField) {
        if (psiClass == null) {
            GetterFieldProcessor.$$$reportNull$$$0(0);
        }
        if (psiAnnotation == null) {
            GetterFieldProcessor.$$$reportNull$$$0(1);
        }
        if (psiField == null) {
            GetterFieldProcessor.$$$reportNull$$$0(2);
        }
        AccessorsInfo accessorsInfo = AccessorsInfo.buildFor(psiField);
        String generatedElementName = LombokUtils.getGetterName(psiField, accessorsInfo);
        return Collections.singletonList(generatedElementName);
    }

    @Override
    protected void generatePsiElements(@NotNull PsiField psiField, @NotNull PsiAnnotation psiAnnotation, @NotNull List<? super PsiElement> target, @Nullable String nameHint) {
        if (psiField == null) {
            GetterFieldProcessor.$$$reportNull$$$0(3);
        }
        if (psiAnnotation == null) {
            GetterFieldProcessor.$$$reportNull$$$0(4);
        }
        if (target == null) {
            GetterFieldProcessor.$$$reportNull$$$0(5);
        }
        String methodVisibility = LombokProcessorUtil.getMethodModifier(psiAnnotation);
        PsiClass psiClass = psiField.getContainingClass();
        if (null != methodVisibility && null != psiClass) {
            ContainerUtil.addIfNotNull(target, (Object)GetterFieldProcessor.createGetterMethod(psiField, psiClass, methodVisibility, nameHint));
        }
    }

    @Override
    protected boolean validate(@NotNull PsiAnnotation psiAnnotation, @NotNull PsiField psiField, @NotNull ProblemSink builder) {
        String methodVisibility;
        if (psiAnnotation == null) {
            GetterFieldProcessor.$$$reportNull$$$0(6);
        }
        if (psiField == null) {
            GetterFieldProcessor.$$$reportNull$$$0(7);
        }
        if (builder == null) {
            GetterFieldProcessor.$$$reportNull$$$0(8);
        }
        boolean result = null != (methodVisibility = LombokProcessorUtil.getMethodModifier(psiAnnotation));
        boolean lazy = GetterFieldProcessor.isLazyGetter(psiAnnotation);
        if (null == methodVisibility && lazy) {
            builder.addWarningMessage("inspection.message.lazy.does.not.work.with.access.level.none", new Object[0]);
        }
        if (result && lazy) {
            if (!psiField.hasModifierProperty("final") || !psiField.hasModifierProperty("private")) {
                builder.addErrorMessage("inspection.message.lazy.requires.field.to.be.private.final", new Object[0]).withLocalQuickFixes(() -> PsiQuickFixFactory.createModifierListFix((PsiModifierListOwner)psiField, "private", true, false), () -> PsiQuickFixFactory.createModifierListFix((PsiModifierListOwner)psiField, "final", true, false));
                result = false;
            }
            if (!psiField.hasInitializer()) {
                builder.addErrorMessage("inspection.message.lazy.requires.field.initialization", new Object[0]);
                result = false;
            }
        }
        this.validateOnXAnnotations(psiAnnotation, psiField, builder, "onMethod");
        if (result) {
            result = this.validateExistingMethods(psiField, builder, true);
        }
        if (result) {
            result = GetterFieldProcessor.validateAccessorPrefix(psiField, builder);
        }
        return result;
    }

    private static boolean isLazyGetter(@NotNull PsiAnnotation psiAnnotation) {
        if (psiAnnotation == null) {
            GetterFieldProcessor.$$$reportNull$$$0(9);
        }
        return PsiAnnotationUtil.getBooleanAnnotationValue(psiAnnotation, "lazy", false);
    }

    private static boolean validateAccessorPrefix(@NotNull PsiField psiField, @NotNull ProblemSink builder) {
        if (psiField == null) {
            GetterFieldProcessor.$$$reportNull$$$0(10);
        }
        if (builder == null) {
            GetterFieldProcessor.$$$reportNull$$$0(11);
        }
        boolean result = true;
        if (AccessorsInfo.buildFor(psiField).isPrefixUnDefinedOrNotStartsWith(psiField.getName())) {
            builder.addWarningMessage("inspection.message.not.generating.getter.for.this.field", new Object[0]);
            result = false;
        }
        return result;
    }

    @Nullable
    @Contract(value="_,_,_,null -> !null")
    public static PsiMethod createGetterMethod(@NotNull PsiField psiField, @NotNull PsiClass psiClass, @NotNull String methodModifier, @Nullable String nameHint) {
        boolean isStatic;
        if (psiField == null) {
            GetterFieldProcessor.$$$reportNull$$$0(12);
        }
        if (psiClass == null) {
            GetterFieldProcessor.$$$reportNull$$$0(13);
        }
        if (methodModifier == null) {
            GetterFieldProcessor.$$$reportNull$$$0(14);
        }
        AccessorsInfo accessorsInfo = AccessorsInfo.buildFor(psiField);
        String methodName = LombokUtils.getGetterName(psiField, accessorsInfo);
        if (nameHint != null && !nameHint.equals(methodName)) {
            return null;
        }
        LombokLightMethodBuilder methodBuilder = new LombokLightMethodBuilder(psiField.getManager(), methodName).withMethodReturnType(psiField.getType()).withContainingClass(psiClass).withNavigationElement((PsiElement)psiField).withPureContract();
        if (StringUtil.isNotEmpty((String)methodModifier)) {
            methodBuilder.withModifier(methodModifier);
        }
        if (isStatic = psiField.hasModifierProperty("static")) {
            methodBuilder.withModifier("static");
        }
        if (accessorsInfo.isMakeFinal()) {
            methodBuilder.withModifier("final");
        }
        String blockText = String.format("return %s.%s;", isStatic ? psiClass.getName() : "this", psiField.getName());
        methodBuilder.withBodyText(blockText);
        LombokLightModifierList modifierList = methodBuilder.getModifierList();
        LombokCopyableAnnotations.copyCopyableAnnotations(psiField, modifierList, LombokCopyableAnnotations.BASE_COPYABLE);
        PsiAnnotation fieldGetterAnnotation = PsiAnnotationSearchUtil.findAnnotation((PsiModifierListOwner)psiField, "lombok.Getter");
        LombokCopyableAnnotations.copyOnXAnnotations(fieldGetterAnnotation, (PsiModifierList)modifierList, "onMethod");
        if (psiField.isDeprecated()) {
            modifierList.addAnnotation("java.lang.Deprecated");
        }
        return methodBuilder;
    }

    @Override
    public LombokPsiElementUsage checkFieldUsage(@NotNull PsiField psiField, @NotNull PsiAnnotation psiAnnotation) {
        if (psiField == null) {
            GetterFieldProcessor.$$$reportNull$$$0(15);
        }
        if (psiAnnotation == null) {
            GetterFieldProcessor.$$$reportNull$$$0(16);
        }
        return LombokPsiElementUsage.READ;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 9: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiAnnotation";
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 10: 
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiField";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodModifier";
                break;
            }
        }
        objectArray2[1] = "de/plushnikov/intellij/plugin/processor/field/GetterFieldProcessor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getNamesOfPossibleGeneratedElements";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "generatePsiElements";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "validate";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "isLazyGetter";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "validateAccessorPrefix";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "createGetterMethod";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "checkFieldUsage";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

