/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.intellij.plugin.processor.field;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.intellij.util.containers.ContainerUtil;
import de.plushnikov.intellij.plugin.problem.ProblemSink;
import de.plushnikov.intellij.plugin.processor.LombokPsiElementUsage;
import de.plushnikov.intellij.plugin.processor.field.AbstractFieldProcessor;
import de.plushnikov.intellij.plugin.processor.field.AccessorsInfo;
import de.plushnikov.intellij.plugin.psi.LombokLightMethodBuilder;
import de.plushnikov.intellij.plugin.psi.LombokLightModifierList;
import de.plushnikov.intellij.plugin.psi.LombokLightParameter;
import de.plushnikov.intellij.plugin.quickfix.PsiQuickFixFactory;
import de.plushnikov.intellij.plugin.thirdparty.LombokAddNullAnnotations;
import de.plushnikov.intellij.plugin.thirdparty.LombokCopyableAnnotations;
import de.plushnikov.intellij.plugin.thirdparty.LombokUtils;
import de.plushnikov.intellij.plugin.util.LombokProcessorUtil;
import de.plushnikov.intellij.plugin.util.PsiAnnotationSearchUtil;
import de.plushnikov.intellij.plugin.util.PsiClassUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SetterFieldProcessor
extends AbstractFieldProcessor {
    public SetterFieldProcessor() {
        super((Class<? extends PsiElement>)PsiMethod.class, "lombok.Setter");
    }

    @Override
    protected Collection<String> getNamesOfPossibleGeneratedElements(@NotNull PsiClass psiClass, @NotNull PsiAnnotation psiAnnotation, @NotNull PsiField psiField) {
        if (psiClass == null) {
            SetterFieldProcessor.$$$reportNull$$$0(0);
        }
        if (psiAnnotation == null) {
            SetterFieldProcessor.$$$reportNull$$$0(1);
        }
        if (psiField == null) {
            SetterFieldProcessor.$$$reportNull$$$0(2);
        }
        AccessorsInfo accessorsInfo = AccessorsInfo.buildFor(psiField);
        String generatedElementName = LombokUtils.getSetterName(psiField, accessorsInfo);
        return Collections.singletonList(generatedElementName);
    }

    @Override
    protected void generatePsiElements(@NotNull PsiField psiField, @NotNull PsiAnnotation psiAnnotation, @NotNull List<? super PsiElement> target, @Nullable String nameHint) {
        if (psiField == null) {
            SetterFieldProcessor.$$$reportNull$$$0(3);
        }
        if (psiAnnotation == null) {
            SetterFieldProcessor.$$$reportNull$$$0(4);
        }
        if (target == null) {
            SetterFieldProcessor.$$$reportNull$$$0(5);
        }
        String methodVisibility = LombokProcessorUtil.getMethodModifier(psiAnnotation);
        PsiClass psiClass = psiField.getContainingClass();
        if (methodVisibility != null && psiClass != null) {
            ContainerUtil.addIfNotNull(target, (Object)SetterFieldProcessor.createSetterMethod(psiField, psiClass, methodVisibility, nameHint));
        }
    }

    @Override
    protected boolean validate(@NotNull PsiAnnotation psiAnnotation, @NotNull PsiField psiField, @NotNull ProblemSink builder) {
        if (psiAnnotation == null) {
            SetterFieldProcessor.$$$reportNull$$$0(6);
        }
        if (psiField == null) {
            SetterFieldProcessor.$$$reportNull$$$0(7);
        }
        if (builder == null) {
            SetterFieldProcessor.$$$reportNull$$$0(8);
        }
        this.validateOnXAnnotations(psiAnnotation, psiField, builder, "onParam");
        boolean result = SetterFieldProcessor.validateFinalModifier(psiAnnotation, psiField, builder);
        if (result && (result = SetterFieldProcessor.validateVisibility(psiAnnotation)) && (result = this.validateExistingMethods(psiField, builder, false))) {
            result = SetterFieldProcessor.validateAccessorPrefix(psiField, builder);
        }
        return result;
    }

    private static boolean validateFinalModifier(@NotNull PsiAnnotation psiAnnotation, @NotNull PsiField psiField, @NotNull ProblemSink builder) {
        if (psiAnnotation == null) {
            SetterFieldProcessor.$$$reportNull$$$0(9);
        }
        if (psiField == null) {
            SetterFieldProcessor.$$$reportNull$$$0(10);
        }
        if (builder == null) {
            SetterFieldProcessor.$$$reportNull$$$0(11);
        }
        boolean result = true;
        if (psiField.hasModifierProperty("final") && null != LombokProcessorUtil.getMethodModifier(psiAnnotation)) {
            builder.addWarningMessage("inspection.message.not.generating.setter.for.this.field.setters", new Object[0]).withLocalQuickFixes(() -> PsiQuickFixFactory.createModifierListFix((PsiModifierListOwner)psiField, "final", false, false));
            result = false;
        }
        return result;
    }

    private static boolean validateVisibility(@NotNull PsiAnnotation psiAnnotation) {
        String methodVisibility;
        if (psiAnnotation == null) {
            SetterFieldProcessor.$$$reportNull$$$0(12);
        }
        return null != (methodVisibility = LombokProcessorUtil.getMethodModifier(psiAnnotation));
    }

    private static boolean validateAccessorPrefix(@NotNull PsiField psiField, @NotNull ProblemSink builder) {
        if (psiField == null) {
            SetterFieldProcessor.$$$reportNull$$$0(13);
        }
        if (builder == null) {
            SetterFieldProcessor.$$$reportNull$$$0(14);
        }
        boolean result = true;
        if (AccessorsInfo.buildFor(psiField).isPrefixUnDefinedOrNotStartsWith(psiField.getName())) {
            builder.addWarningMessage("inspection.message.not.generating.setter.for.this.field.it", new Object[0]);
            result = false;
        }
        return result;
    }

    public Collection<String> getAllSetterNames(@NotNull PsiField psiField, boolean isBoolean) {
        if (psiField == null) {
            SetterFieldProcessor.$$$reportNull$$$0(15);
        }
        AccessorsInfo accessorsInfo = AccessorsInfo.buildFor(psiField);
        return LombokUtils.toAllSetterNames(accessorsInfo, psiField.getName(), isBoolean);
    }

    @Contract(value="_,_,_,null -> !null")
    @Nullable
    public static PsiMethod createSetterMethod(@NotNull PsiField psiField, @NotNull PsiClass psiClass, @NotNull String methodModifier, @Nullable String nameHint) {
        LombokLightParameter setterParameter;
        boolean isStatic;
        if (psiField == null) {
            SetterFieldProcessor.$$$reportNull$$$0(16);
        }
        if (psiClass == null) {
            SetterFieldProcessor.$$$reportNull$$$0(17);
        }
        if (methodModifier == null) {
            SetterFieldProcessor.$$$reportNull$$$0(18);
        }
        String fieldName = psiField.getName();
        PsiType psiFieldType = psiField.getType();
        PsiAnnotation setterAnnotation = PsiAnnotationSearchUtil.findAnnotation((PsiModifierListOwner)psiField, "lombok.Setter");
        AccessorsInfo accessorsInfo = AccessorsInfo.buildFor(psiField);
        String methodName = LombokUtils.getSetterName(psiField, accessorsInfo);
        if (nameHint != null && !nameHint.equals(methodName)) {
            return null;
        }
        PsiType returnType = SetterFieldProcessor.getReturnType(psiField, accessorsInfo.isChain());
        LombokLightMethodBuilder methodBuilder = new LombokLightMethodBuilder(psiField.getManager(), methodName).withMethodReturnType(returnType).withContainingClass(psiClass).withParameter(fieldName, psiFieldType).withNavigationElement((PsiElement)psiField).withMutatesThisContract().withWriteAccess();
        if (StringUtil.isNotEmpty((String)methodModifier)) {
            methodBuilder.withModifier(methodModifier);
        }
        if (isStatic = psiField.hasModifierProperty("static")) {
            methodBuilder.withModifier("static");
        }
        if (accessorsInfo.isMakeFinal()) {
            methodBuilder.withModifier("final");
        }
        if (null != (setterParameter = methodBuilder.getParameterList().getParameter(0))) {
            LombokLightModifierList methodParameterModifierList = setterParameter.getModifierList();
            LombokCopyableAnnotations.copyCopyableAnnotations(psiField, methodParameterModifierList, LombokCopyableAnnotations.BASE_COPYABLE);
            LombokCopyableAnnotations.copyOnXAnnotations(setterAnnotation, (PsiModifierList)methodParameterModifierList, "onParam");
        }
        LombokLightModifierList modifierList = methodBuilder.getModifierList();
        LombokCopyableAnnotations.copyCopyableAnnotations(psiField, modifierList, LombokCopyableAnnotations.COPY_TO_SETTER);
        LombokCopyableAnnotations.copyOnXAnnotations(setterAnnotation, (PsiModifierList)modifierList, "onMethod");
        if (psiField.isDeprecated()) {
            modifierList.addAnnotation("java.lang.Deprecated");
        }
        String codeBlockText = SetterFieldProcessor.createCodeBlockText(psiField, psiClass, returnType, isStatic, (PsiParameter)setterParameter);
        methodBuilder.withBodyText(codeBlockText);
        if (!PsiTypes.voidType().equals((Object)returnType)) {
            LombokAddNullAnnotations.createRelevantNonNullAnnotation(psiClass, methodBuilder);
        }
        return methodBuilder;
    }

    @NotNull
    private static String createCodeBlockText(@NotNull PsiField psiField, @NotNull PsiClass psiClass, PsiType returnType, boolean isStatic, PsiParameter methodParameter) {
        if (psiField == null) {
            SetterFieldProcessor.$$$reportNull$$$0(19);
        }
        if (psiClass == null) {
            SetterFieldProcessor.$$$reportNull$$$0(20);
        }
        String thisOrClass = isStatic ? psiClass.getName() : "this";
        String blockText = String.format("%s.%s = %s; ", thisOrClass, psiField.getName(), methodParameter.getName());
        Object codeBlockText = blockText;
        if (!isStatic && !PsiTypes.voidType().equals((Object)returnType)) {
            codeBlockText = (String)codeBlockText + "return this;";
        }
        String string = codeBlockText;
        if (string == null) {
            SetterFieldProcessor.$$$reportNull$$$0(21);
        }
        return string;
    }

    private static PsiType getReturnType(@NotNull PsiField psiField, boolean isChained) {
        PsiClass fieldClass;
        if (psiField == null) {
            SetterFieldProcessor.$$$reportNull$$$0(22);
        }
        PsiPrimitiveType result = PsiTypes.voidType();
        if (!psiField.hasModifierProperty("static") && isChained && null != (fieldClass = psiField.getContainingClass())) {
            result = PsiClassUtil.getTypeWithGenerics(fieldClass);
        }
        return result;
    }

    @Override
    public LombokPsiElementUsage checkFieldUsage(@NotNull PsiField psiField, @NotNull PsiAnnotation psiAnnotation) {
        if (psiField == null) {
            SetterFieldProcessor.$$$reportNull$$$0(23);
        }
        if (psiAnnotation == null) {
            SetterFieldProcessor.$$$reportNull$$$0(24);
        }
        return LombokPsiElementUsage.WRITE;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 21 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 9: 
            case 12: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiAnnotation";
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 10: 
            case 13: 
            case 15: 
            case 16: 
            case 19: 
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiField";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 8: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodModifier";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "de/plushnikov/intellij/plugin/processor/field/SetterFieldProcessor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "de/plushnikov/intellij/plugin/processor/field/SetterFieldProcessor";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "createCodeBlockText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getNamesOfPossibleGeneratedElements";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "generatePsiElements";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "validate";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "validateFinalModifier";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "validateVisibility";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "validateAccessorPrefix";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getAllSetterNames";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createSetterMethod";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "createCodeBlockText";
                break;
            }
            case 21: {
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getReturnType";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "checkFieldUsage";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 21 -> new IllegalStateException(string);
        };
    }
}

